/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.graphics.Rect;
import android.transition.Transition;
import android.transition.TransitionValues;
import android.transition.VisibilityPropagation;
import android.view.ViewGroup;

public class SidePropagation
extends VisibilityPropagation {
    private static final String TAG = "SlidePropagation";
    private float mPropagationSpeed = 3.0f;
    private int mSide = 80;

    public void setSide(int side) {
        this.mSide = side;
    }

    public void setPropagationSpeed(float propagationSpeed) {
        if (propagationSpeed == 0.0f) {
            throw new IllegalArgumentException("propagationSpeed may not be 0");
        }
        this.mPropagationSpeed = propagationSpeed;
    }

    @Override
    public long getStartDelay(ViewGroup sceneRoot, Transition transition2, TransitionValues startValues, TransitionValues endValues) {
        int epicenterY;
        int epicenterX;
        TransitionValues positionValues;
        if (startValues == null && endValues == null) {
            return 0L;
        }
        int directionMultiplier = 1;
        Rect epicenter = transition2.getEpicenter();
        if (endValues == null || this.getViewVisibility(startValues) == 0) {
            positionValues = startValues;
            directionMultiplier = -1;
        } else {
            positionValues = endValues;
        }
        int viewCenterX = this.getViewX(positionValues);
        int viewCenterY = this.getViewY(positionValues);
        int[] loc = new int[2];
        sceneRoot.getLocationOnScreen(loc);
        int left = loc[0] + Math.round(sceneRoot.getTranslationX());
        int top = loc[1] + Math.round(sceneRoot.getTranslationY());
        int right = left + sceneRoot.getWidth();
        int bottom = top + sceneRoot.getHeight();
        if (epicenter != null) {
            epicenterX = epicenter.centerX();
            epicenterY = epicenter.centerY();
        } else {
            epicenterX = (left + right) / 2;
            epicenterY = (top + bottom) / 2;
        }
        float distance = this.distance(viewCenterX, viewCenterY, epicenterX, epicenterY, left, top, right, bottom);
        float maxDistance = this.getMaxDistance(sceneRoot);
        float distanceFraction = distance / maxDistance;
        long duration = transition2.getDuration();
        if (duration < 0L) {
            duration = 300L;
        }
        return Math.round((float)(duration * (long)directionMultiplier) / this.mPropagationSpeed * distanceFraction);
    }

    private int distance(int viewX, int viewY, int epicenterX, int epicenterY, int left, int top, int right, int bottom) {
        int distance = 0;
        switch (this.mSide) {
            case 3: {
                distance = right - viewX + Math.abs(epicenterY - viewY);
                break;
            }
            case 48: {
                distance = bottom - viewY + Math.abs(epicenterX - viewX);
                break;
            }
            case 5: {
                distance = viewX - left + Math.abs(epicenterY - viewY);
                break;
            }
            case 80: {
                distance = viewY - top + Math.abs(epicenterX - viewX);
            }
        }
        return distance;
    }

    private int getMaxDistance(ViewGroup sceneRoot) {
        switch (this.mSide) {
            case 3: 
            case 5: {
                return sceneRoot.getWidth();
            }
        }
        return sceneRoot.getHeight();
    }
}

