/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.method.NumberKeyListener;

public class DigitsKeyListener
extends NumberKeyListener {
    private char[] mAccepted;
    private boolean mSign;
    private boolean mDecimal;
    private static final int SIGN = 1;
    private static final int DECIMAL = 2;
    private static final char[][] CHARACTERS = new char[][]{{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'}, {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '+'}, {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '.'}, {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '+', '.'}};
    private static DigitsKeyListener[] sInstance = new DigitsKeyListener[4];

    @Override
    protected char[] getAcceptedChars() {
        return this.mAccepted;
    }

    private static boolean isSignChar(char c) {
        return c == '-' || c == '+';
    }

    private static boolean isDecimalPointChar(char c) {
        return c == '.';
    }

    public DigitsKeyListener() {
        this(false, false);
    }

    public DigitsKeyListener(boolean sign, boolean decimal) {
        this.mSign = sign;
        this.mDecimal = decimal;
        int kind = (sign ? 1 : 0) | (decimal ? 2 : 0);
        this.mAccepted = CHARACTERS[kind];
    }

    public static DigitsKeyListener getInstance() {
        return DigitsKeyListener.getInstance(false, false);
    }

    public static DigitsKeyListener getInstance(boolean sign, boolean decimal) {
        int kind = (sign ? 1 : 0) | (decimal ? 2 : 0);
        if (sInstance[kind] != null) {
            return sInstance[kind];
        }
        DigitsKeyListener.sInstance[kind] = new DigitsKeyListener(sign, decimal);
        return sInstance[kind];
    }

    public static DigitsKeyListener getInstance(String accepted) {
        DigitsKeyListener dim = new DigitsKeyListener();
        dim.mAccepted = new char[accepted.length()];
        accepted.getChars(0, accepted.length(), dim.mAccepted, 0);
        return dim;
    }

    @Override
    public int getInputType() {
        int contentType = 2;
        if (this.mSign) {
            contentType |= 0x1000;
        }
        if (this.mDecimal) {
            contentType |= 0x2000;
        }
        return contentType;
    }

    @Override
    public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
        char c;
        int i;
        CharSequence out = super.filter(source, start, end, dest, dstart, dend);
        if (!this.mSign && !this.mDecimal) {
            return out;
        }
        if (out != null) {
            source = out;
            start = 0;
            end = out.length();
        }
        int sign = -1;
        int decimal = -1;
        int dlen = dest.length();
        for (i = 0; i < dstart; ++i) {
            c = dest.charAt(i);
            if (DigitsKeyListener.isSignChar(c)) {
                sign = i;
                continue;
            }
            if (!DigitsKeyListener.isDecimalPointChar(c)) continue;
            decimal = i;
        }
        for (i = dend; i < dlen; ++i) {
            c = dest.charAt(i);
            if (DigitsKeyListener.isSignChar(c)) {
                return "";
            }
            if (!DigitsKeyListener.isDecimalPointChar(c)) continue;
            decimal = i;
        }
        SpannableStringBuilder stripped = null;
        for (int i2 = end - 1; i2 >= start; --i2) {
            char c2 = source.charAt(i2);
            boolean strip = false;
            if (DigitsKeyListener.isSignChar(c2)) {
                if (i2 != start || dstart != 0) {
                    strip = true;
                } else if (sign >= 0) {
                    strip = true;
                } else {
                    sign = i2;
                }
            } else if (DigitsKeyListener.isDecimalPointChar(c2)) {
                if (decimal >= 0) {
                    strip = true;
                } else {
                    decimal = i2;
                }
            }
            if (!strip) continue;
            if (end == start + 1) {
                return "";
            }
            if (stripped == null) {
                stripped = new SpannableStringBuilder(source, start, end);
            }
            stripped.delete(i2 - start, i2 + 1 - start);
        }
        if (stripped != null) {
            return stripped;
        }
        if (out != null) {
            return out;
        }
        return null;
    }
}

