/*
 * Decompiled with CFR 0.152.
 */
package android.net.nsd;

import android.content.Context;
import android.net.nsd.INsdManager;
import android.net.nsd.NsdServiceInfo;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.util.AsyncChannel;
import java.util.concurrent.CountDownLatch;

public class NsdManager {
    private static final String TAG = "NsdManager";
    INsdManager mService;
    public static final String ACTION_NSD_STATE_CHANGED = "android.net.nsd.STATE_CHANGED";
    public static final String EXTRA_NSD_STATE = "nsd_state";
    public static final int NSD_STATE_DISABLED = 1;
    public static final int NSD_STATE_ENABLED = 2;
    private static final int BASE = 393216;
    public static final int DISCOVER_SERVICES = 393217;
    public static final int DISCOVER_SERVICES_STARTED = 393218;
    public static final int DISCOVER_SERVICES_FAILED = 393219;
    public static final int SERVICE_FOUND = 393220;
    public static final int SERVICE_LOST = 393221;
    public static final int STOP_DISCOVERY = 393222;
    public static final int STOP_DISCOVERY_FAILED = 393223;
    public static final int STOP_DISCOVERY_SUCCEEDED = 393224;
    public static final int REGISTER_SERVICE = 393225;
    public static final int REGISTER_SERVICE_FAILED = 393226;
    public static final int REGISTER_SERVICE_SUCCEEDED = 393227;
    public static final int UNREGISTER_SERVICE = 393228;
    public static final int UNREGISTER_SERVICE_FAILED = 393229;
    public static final int UNREGISTER_SERVICE_SUCCEEDED = 393230;
    public static final int RESOLVE_SERVICE = 393234;
    public static final int RESOLVE_SERVICE_FAILED = 393235;
    public static final int RESOLVE_SERVICE_SUCCEEDED = 393236;
    public static final int ENABLE = 393240;
    public static final int DISABLE = 393241;
    public static final int NATIVE_DAEMON_EVENT = 393242;
    public static final int PROTOCOL_DNS_SD = 1;
    private Context mContext;
    private static final int INVALID_LISTENER_KEY = 0;
    private static final int BUSY_LISTENER_KEY = -1;
    private int mListenerKey = 1;
    private final SparseArray mListenerMap = new SparseArray();
    private final SparseArray<NsdServiceInfo> mServiceMap = new SparseArray();
    private final Object mMapLock = new Object();
    private final AsyncChannel mAsyncChannel = new AsyncChannel();
    private ServiceHandler mHandler;
    private final CountDownLatch mConnected = new CountDownLatch(1);
    public static final int FAILURE_INTERNAL_ERROR = 0;
    public static final int FAILURE_ALREADY_ACTIVE = 3;
    public static final int FAILURE_MAX_LIMIT = 4;

    public NsdManager(Context context, INsdManager service) {
        this.mService = service;
        this.mContext = context;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int putListener(Object listener, NsdServiceInfo s) {
        int key;
        if (listener == null) {
            return 0;
        }
        Object object = this.mMapLock;
        synchronized (object) {
            int valueIndex = this.mListenerMap.indexOfValue(listener);
            if (valueIndex != -1) {
                return -1;
            }
            do {
                ++this.mListenerKey;
            } while (key == 0);
            this.mListenerMap.put(key, listener);
            this.mServiceMap.put(key, s);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getListener(int key) {
        if (key == 0) {
            return null;
        }
        Object object = this.mMapLock;
        synchronized (object) {
            return this.mListenerMap.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NsdServiceInfo getNsdService(int key) {
        Object object = this.mMapLock;
        synchronized (object) {
            return this.mServiceMap.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeListener(int key) {
        if (key == 0) {
            return;
        }
        Object object = this.mMapLock;
        synchronized (object) {
            this.mListenerMap.remove(key);
            this.mServiceMap.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getListenerKey(Object listener) {
        Object object = this.mMapLock;
        synchronized (object) {
            int valueIndex = this.mListenerMap.indexOfValue(listener);
            if (valueIndex != -1) {
                return this.mListenerMap.keyAt(valueIndex);
            }
        }
        return 0;
    }

    private String getNsdServiceInfoType(NsdServiceInfo s) {
        if (s == null) {
            return "?";
        }
        return s.getServiceType();
    }

    private void init() {
        Messenger messenger = this.getMessenger();
        if (messenger == null) {
            throw new RuntimeException("Failed to initialize");
        }
        HandlerThread t = new HandlerThread(TAG);
        t.start();
        this.mHandler = new ServiceHandler(t.getLooper());
        this.mAsyncChannel.connect(this.mContext, (Handler)this.mHandler, messenger);
        try {
            this.mConnected.await();
        }
        catch (InterruptedException e) {
            Log.e(TAG, "interrupted wait at init");
        }
    }

    public void registerService(NsdServiceInfo serviceInfo, int protocolType, RegistrationListener listener) {
        if (TextUtils.isEmpty(serviceInfo.getServiceName()) || TextUtils.isEmpty(serviceInfo.getServiceType())) {
            throw new IllegalArgumentException("Service name or type cannot be empty");
        }
        if (serviceInfo.getPort() <= 0) {
            throw new IllegalArgumentException("Invalid port number");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        if (protocolType != 1) {
            throw new IllegalArgumentException("Unsupported protocol");
        }
        int key = this.putListener(listener, serviceInfo);
        if (key == -1) {
            throw new IllegalArgumentException("listener already in use");
        }
        this.mAsyncChannel.sendMessage(393225, 0, key, serviceInfo);
    }

    public void unregisterService(RegistrationListener listener) {
        int id2 = this.getListenerKey(listener);
        if (id2 == 0) {
            throw new IllegalArgumentException("listener not registered");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        this.mAsyncChannel.sendMessage(393228, 0, id2);
    }

    public void discoverServices(String serviceType, int protocolType, DiscoveryListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        if (TextUtils.isEmpty(serviceType)) {
            throw new IllegalArgumentException("Service type cannot be empty");
        }
        if (protocolType != 1) {
            throw new IllegalArgumentException("Unsupported protocol");
        }
        NsdServiceInfo s = new NsdServiceInfo();
        s.setServiceType(serviceType);
        int key = this.putListener(listener, s);
        if (key == -1) {
            throw new IllegalArgumentException("listener already in use");
        }
        this.mAsyncChannel.sendMessage(393217, 0, key, s);
    }

    public void stopServiceDiscovery(DiscoveryListener listener) {
        int id2 = this.getListenerKey(listener);
        if (id2 == 0) {
            throw new IllegalArgumentException("service discovery not active on listener");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        this.mAsyncChannel.sendMessage(393222, 0, id2);
    }

    public void resolveService(NsdServiceInfo serviceInfo, ResolveListener listener) {
        if (TextUtils.isEmpty(serviceInfo.getServiceName()) || TextUtils.isEmpty(serviceInfo.getServiceType())) {
            throw new IllegalArgumentException("Service name or type cannot be empty");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        int key = this.putListener(listener, serviceInfo);
        if (key == -1) {
            throw new IllegalArgumentException("listener already in use");
        }
        this.mAsyncChannel.sendMessage(393234, 0, key, serviceInfo);
    }

    public void setEnabled(boolean enabled) {
        try {
            this.mService.setEnabled(enabled);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private Messenger getMessenger() {
        try {
            return this.mService.getMessenger();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    private class ServiceHandler
    extends Handler {
        ServiceHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                case 69632: {
                    NsdManager.this.mAsyncChannel.sendMessage(69633);
                    return;
                }
                case 69634: {
                    NsdManager.this.mConnected.countDown();
                    return;
                }
                case 69636: {
                    Log.e(NsdManager.TAG, "Channel lost");
                    return;
                }
            }
            Object listener = NsdManager.this.getListener(message.arg2);
            if (listener == null) {
                Log.d(NsdManager.TAG, "Stale key " + message.arg2);
                return;
            }
            NsdServiceInfo ns = NsdManager.this.getNsdService(message.arg2);
            switch (message.what) {
                case 393218: {
                    String s = NsdManager.this.getNsdServiceInfoType((NsdServiceInfo)message.obj);
                    ((DiscoveryListener)listener).onDiscoveryStarted(s);
                    break;
                }
                case 393219: {
                    NsdManager.this.removeListener(message.arg2);
                    ((DiscoveryListener)listener).onStartDiscoveryFailed(NsdManager.this.getNsdServiceInfoType(ns), message.arg1);
                    break;
                }
                case 393220: {
                    ((DiscoveryListener)listener).onServiceFound((NsdServiceInfo)message.obj);
                    break;
                }
                case 393221: {
                    ((DiscoveryListener)listener).onServiceLost((NsdServiceInfo)message.obj);
                    break;
                }
                case 393223: {
                    NsdManager.this.removeListener(message.arg2);
                    ((DiscoveryListener)listener).onStopDiscoveryFailed(NsdManager.this.getNsdServiceInfoType(ns), message.arg1);
                    break;
                }
                case 393224: {
                    NsdManager.this.removeListener(message.arg2);
                    ((DiscoveryListener)listener).onDiscoveryStopped(NsdManager.this.getNsdServiceInfoType(ns));
                    break;
                }
                case 393226: {
                    NsdManager.this.removeListener(message.arg2);
                    ((RegistrationListener)listener).onRegistrationFailed(ns, message.arg1);
                    break;
                }
                case 393227: {
                    ((RegistrationListener)listener).onServiceRegistered((NsdServiceInfo)message.obj);
                    break;
                }
                case 393229: {
                    NsdManager.this.removeListener(message.arg2);
                    ((RegistrationListener)listener).onUnregistrationFailed(ns, message.arg1);
                    break;
                }
                case 393230: {
                    NsdManager.this.removeListener(message.arg2);
                    ((RegistrationListener)listener).onServiceUnregistered(ns);
                    break;
                }
                case 393235: {
                    NsdManager.this.removeListener(message.arg2);
                    ((ResolveListener)listener).onResolveFailed(ns, message.arg1);
                    break;
                }
                case 393236: {
                    NsdManager.this.removeListener(message.arg2);
                    ((ResolveListener)listener).onServiceResolved((NsdServiceInfo)message.obj);
                    break;
                }
                default: {
                    Log.d(NsdManager.TAG, "Ignored " + message);
                }
            }
        }
    }

    public static interface ResolveListener {
        public void onResolveFailed(NsdServiceInfo var1, int var2);

        public void onServiceResolved(NsdServiceInfo var1);
    }

    public static interface RegistrationListener {
        public void onRegistrationFailed(NsdServiceInfo var1, int var2);

        public void onUnregistrationFailed(NsdServiceInfo var1, int var2);

        public void onServiceRegistered(NsdServiceInfo var1);

        public void onServiceUnregistered(NsdServiceInfo var1);
    }

    public static interface DiscoveryListener {
        public void onStartDiscoveryFailed(String var1, int var2);

        public void onStopDiscoveryFailed(String var1, int var2);

        public void onDiscoveryStarted(String var1);

        public void onDiscoveryStopped(String var1);

        public void onServiceFound(NsdServiceInfo var1);

        public void onServiceLost(NsdServiceInfo var1);
    }
}

