/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.content.Intent;
import android.net.INetworkScoreCache;
import android.net.INetworkScoreService;
import android.net.NetworkKey;
import android.net.NetworkScorerAppManager;
import android.net.ScoredNetwork;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;

public class NetworkScoreManager {
    public static final String ACTION_CHANGE_ACTIVE = "android.net.scoring.CHANGE_ACTIVE";
    public static final String EXTRA_PACKAGE_NAME = "packageName";
    public static final String ACTION_SCORE_NETWORKS = "android.net.scoring.SCORE_NETWORKS";
    public static final String EXTRA_NETWORKS_TO_SCORE = "networksToScore";
    public static final String ACTION_CUSTOM_ENABLE = "android.net.scoring.CUSTOM_ENABLE";
    public static final String ACTION_SCORER_CHANGED = "android.net.scoring.SCORER_CHANGED";
    public static final String EXTRA_NEW_SCORER = "newScorer";
    private final Context mContext;
    private final INetworkScoreService mService;

    public NetworkScoreManager(Context context) {
        this.mContext = context;
        IBinder iBinder = ServiceManager.getService("network_score");
        this.mService = INetworkScoreService.Stub.asInterface(iBinder);
    }

    public String getActiveScorerPackage() {
        NetworkScorerAppManager.NetworkScorerAppData app = NetworkScorerAppManager.getActiveScorer(this.mContext);
        if (app == null) {
            return null;
        }
        return app.mPackageName;
    }

    public boolean updateScores(ScoredNetwork[] networks) throws SecurityException {
        try {
            return this.mService.updateScores(networks);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean clearScores() throws SecurityException {
        try {
            return this.mService.clearScores();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean setActiveScorer(String packageName) throws SecurityException {
        try {
            return this.mService.setActiveScorer(packageName);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public void disableScoring() throws SecurityException {
        try {
            this.mService.disableScoring();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public boolean requestScores(NetworkKey[] networks) throws SecurityException {
        String activeScorer = this.getActiveScorerPackage();
        if (activeScorer == null) {
            return false;
        }
        Intent intent = new Intent(ACTION_SCORE_NETWORKS);
        intent.setPackage(activeScorer);
        intent.setFlags(0x4000000);
        intent.putExtra(EXTRA_NETWORKS_TO_SCORE, networks);
        this.mContext.sendBroadcastAsUser(intent, UserHandle.OWNER, "android.permission.SCORE_NETWORKS");
        return true;
    }

    public void registerNetworkScoreCache(int networkType, INetworkScoreCache scoreCache) {
        try {
            this.mService.registerNetworkScoreCache(networkType, scoreCache);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }
}

