/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiopolicy;

import android.media.audiopolicy.AudioMix;
import android.media.audiopolicy.AudioPolicyConfig;
import android.os.Binder;
import android.os.IBinder;
import java.util.ArrayList;

public class AudioPolicy {
    private static final String TAG = "AudioPolicy";
    public static final int POLICY_STATUS_INVALID = 0;
    public static final int POLICY_STATUS_UNREGISTERED = 1;
    public static final int POLICY_STATUS_REGISTERED = 2;
    private int mStatus;
    private AudioPolicyStatusListener mStatusListener = null;
    private final IBinder mToken = new Binder();
    private AudioPolicyConfig mConfig;

    public IBinder token() {
        return this.mToken;
    }

    public AudioPolicyConfig getConfig() {
        return this.mConfig;
    }

    private AudioPolicy(AudioPolicyConfig config) {
        this.mConfig = config;
        this.mStatus = this.mConfig.mMixes.isEmpty() ? 0 : 1;
    }

    public int getStatus() {
        return this.mStatus;
    }

    void setStatusListener(AudioPolicyStatusListener l) {
        this.mStatusListener = l;
    }

    public String toString() {
        String textDump = new String("android.media.audiopolicy.AudioPolicy:\n");
        textDump = textDump + "config=" + this.mConfig.toString();
        return textDump;
    }

    public static abstract class AudioPolicyStatusListener {
        void onStatusChange() {
        }

        void onMixStateUpdate(AudioMix mix) {
        }
    }

    public static class Builder {
        private ArrayList<AudioMix> mMixes = new ArrayList();

        public Builder addMix(AudioMix mix) throws IllegalArgumentException {
            if (mix == null) {
                throw new IllegalArgumentException("Illegal null AudioMix argument");
            }
            this.mMixes.add(mix);
            return this;
        }

        public AudioPolicy build() {
            return new AudioPolicy(new AudioPolicyConfig(this.mMixes));
        }
    }
}

