/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.R;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.inputmethodservice.Keyboard;
import android.media.AudioManager;
import android.os.Handler;
import android.os.Message;
import android.provider.Settings;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.android.internal.R;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KeyboardView
extends View
implements View.OnClickListener {
    private static final boolean DEBUG = false;
    private static final int NOT_A_KEY = -1;
    private static final int[] KEY_DELETE = new int[]{-5};
    private static final int[] LONG_PRESSABLE_STATE_SET = new int[]{16843324};
    private Keyboard mKeyboard;
    private int mCurrentKeyIndex = -1;
    private int mLabelTextSize;
    private int mKeyTextSize;
    private int mKeyTextColor;
    private float mShadowRadius;
    private int mShadowColor;
    private float mBackgroundDimAmount;
    private TextView mPreviewText;
    private PopupWindow mPreviewPopup;
    private int mPreviewTextSizeLarge;
    private int mPreviewOffset;
    private int mPreviewHeight;
    private final int[] mCoordinates = new int[2];
    private PopupWindow mPopupKeyboard;
    private View mMiniKeyboardContainer;
    private KeyboardView mMiniKeyboard;
    private boolean mMiniKeyboardOnScreen;
    private View mPopupParent;
    private int mMiniKeyboardOffsetX;
    private int mMiniKeyboardOffsetY;
    private Map<Keyboard.Key, View> mMiniKeyboardCache;
    private Keyboard.Key[] mKeys;
    private OnKeyboardActionListener mKeyboardActionListener;
    private static final int MSG_SHOW_PREVIEW = 1;
    private static final int MSG_REMOVE_PREVIEW = 2;
    private static final int MSG_REPEAT = 3;
    private static final int MSG_LONGPRESS = 4;
    private static final int DELAY_BEFORE_PREVIEW = 0;
    private static final int DELAY_AFTER_PREVIEW = 70;
    private static final int DEBOUNCE_TIME = 70;
    private int mVerticalCorrection;
    private int mProximityThreshold;
    private boolean mPreviewCentered = false;
    private boolean mShowPreview = true;
    private boolean mShowTouchPoints = true;
    private int mPopupPreviewX;
    private int mPopupPreviewY;
    private int mLastX;
    private int mLastY;
    private int mStartX;
    private int mStartY;
    private boolean mProximityCorrectOn;
    private Paint mPaint;
    private Rect mPadding;
    private long mDownTime;
    private long mLastMoveTime;
    private int mLastKey;
    private int mLastCodeX;
    private int mLastCodeY;
    private int mCurrentKey = -1;
    private int mDownKey = -1;
    private long mLastKeyTime;
    private long mCurrentKeyTime;
    private int[] mKeyIndices = new int[12];
    private GestureDetector mGestureDetector;
    private int mPopupX;
    private int mPopupY;
    private int mRepeatKeyIndex = -1;
    private int mPopupLayout;
    private boolean mAbortKey;
    private Keyboard.Key mInvalidatedKey;
    private Rect mClipRegion = new Rect(0, 0, 0, 0);
    private boolean mPossiblePoly;
    private SwipeTracker mSwipeTracker = new SwipeTracker();
    private int mSwipeThreshold;
    private boolean mDisambiguateSwipe;
    private int mOldPointerCount = 1;
    private float mOldPointerX;
    private float mOldPointerY;
    private Drawable mKeyBackground;
    private static final int REPEAT_INTERVAL = 50;
    private static final int REPEAT_START_DELAY = 400;
    private static final int LONGPRESS_TIMEOUT = ViewConfiguration.getLongPressTimeout();
    private static int MAX_NEARBY_KEYS = 12;
    private int[] mDistances = new int[MAX_NEARBY_KEYS];
    private int mLastSentIndex;
    private int mTapCount;
    private long mLastTapTime;
    private boolean mInMultiTap;
    private static final int MULTITAP_INTERVAL = 800;
    private StringBuilder mPreviewLabel = new StringBuilder(1);
    private boolean mDrawPending;
    private Rect mDirtyRect = new Rect();
    private Bitmap mBuffer;
    private boolean mKeyboardChanged;
    private Canvas mCanvas;
    private AccessibilityManager mAccessibilityManager;
    private AudioManager mAudioManager;
    private boolean mHeadsetRequiredToHearPasswordsAnnounced;
    Handler mHandler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    KeyboardView.this.showKey(msg.arg1);
                    break;
                }
                case 2: {
                    KeyboardView.this.mPreviewText.setVisibility(4);
                    break;
                }
                case 3: {
                    if (!KeyboardView.this.repeatKey()) break;
                    Message repeat = Message.obtain((Handler)this, 3);
                    this.sendMessageDelayed(repeat, 50L);
                    break;
                }
                case 4: {
                    KeyboardView.this.openPopupIfRequired((MotionEvent)msg.obj);
                }
            }
        }
    };

    public KeyboardView(Context context, AttributeSet attrs) {
        this(context, attrs, 16844110);
    }

    public KeyboardView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public KeyboardView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.KeyboardView, defStyleAttr, defStyleRes);
        LayoutInflater inflate = (LayoutInflater)context.getSystemService("layout_inflater");
        int previewLayout = 0;
        boolean keyTextSize = false;
        int n = a.getIndexCount();
        block13: for (int i = 0; i < n; ++i) {
            int attr2 = a.getIndex(i);
            switch (attr2) {
                case 2: {
                    this.mKeyBackground = a.getDrawable(attr2);
                    continue block13;
                }
                case 9: {
                    this.mVerticalCorrection = a.getDimensionPixelOffset(attr2, 0);
                    continue block13;
                }
                case 6: {
                    previewLayout = a.getResourceId(attr2, 0);
                    continue block13;
                }
                case 7: {
                    this.mPreviewOffset = a.getDimensionPixelOffset(attr2, 0);
                    continue block13;
                }
                case 8: {
                    this.mPreviewHeight = a.getDimensionPixelSize(attr2, 80);
                    continue block13;
                }
                case 3: {
                    this.mKeyTextSize = a.getDimensionPixelSize(attr2, 18);
                    continue block13;
                }
                case 5: {
                    this.mKeyTextColor = a.getColor(attr2, -16777216);
                    continue block13;
                }
                case 4: {
                    this.mLabelTextSize = a.getDimensionPixelSize(attr2, 14);
                    continue block13;
                }
                case 10: {
                    this.mPopupLayout = a.getResourceId(attr2, 0);
                    continue block13;
                }
                case 0: {
                    this.mShadowColor = a.getColor(attr2, 0);
                    continue block13;
                }
                case 1: {
                    this.mShadowRadius = a.getFloat(attr2, 0.0f);
                }
            }
        }
        a = this.mContext.obtainStyledAttributes(R.styleable.Theme);
        this.mBackgroundDimAmount = a.getFloat(2, 0.5f);
        this.mPreviewPopup = new PopupWindow(context);
        if (previewLayout != 0) {
            this.mPreviewText = (TextView)inflate.inflate(previewLayout, null);
            this.mPreviewTextSizeLarge = (int)this.mPreviewText.getTextSize();
            this.mPreviewPopup.setContentView(this.mPreviewText);
            this.mPreviewPopup.setBackgroundDrawable(null);
        } else {
            this.mShowPreview = false;
        }
        this.mPreviewPopup.setTouchable(false);
        this.mPopupKeyboard = new PopupWindow(context);
        this.mPopupKeyboard.setBackgroundDrawable(null);
        this.mPopupParent = this;
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setTextSize((float)keyTextSize);
        this.mPaint.setTextAlign(Paint.Align.CENTER);
        this.mPaint.setAlpha(255);
        this.mPadding = new Rect(0, 0, 0, 0);
        this.mMiniKeyboardCache = new HashMap<Keyboard.Key, View>();
        this.mKeyBackground.getPadding(this.mPadding);
        this.mSwipeThreshold = (int)(500.0f * this.getResources().getDisplayMetrics().density);
        this.mDisambiguateSwipe = this.getResources().getBoolean(17956919);
        this.mAccessibilityManager = AccessibilityManager.getInstance(context);
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
        this.resetMultiTap();
        this.initGestureDetector();
    }

    private void initGestureDetector() {
        this.mGestureDetector = new GestureDetector(this.getContext(), new GestureDetector.SimpleOnGestureListener(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public boolean onFling(MotionEvent me1, MotionEvent me2, float velocityX, float velocityY) {
                boolean sendDownKey;
                block14: {
                    if (KeyboardView.this.mPossiblePoly) {
                        return false;
                    }
                    float absX = Math.abs(velocityX);
                    float absY = Math.abs(velocityY);
                    float deltaX = me2.getX() - me1.getX();
                    float deltaY = me2.getY() - me1.getY();
                    int travelX = KeyboardView.this.getWidth() / 2;
                    int travelY = KeyboardView.this.getHeight() / 2;
                    KeyboardView.this.mSwipeTracker.computeCurrentVelocity(1000);
                    float endingVelocityX = KeyboardView.this.mSwipeTracker.getXVelocity();
                    float endingVelocityY = KeyboardView.this.mSwipeTracker.getYVelocity();
                    sendDownKey = false;
                    if (velocityX > (float)KeyboardView.this.mSwipeThreshold && absY < absX && deltaX > (float)travelX) {
                        if (KeyboardView.this.mDisambiguateSwipe && endingVelocityX < velocityX / 4.0f) {
                            sendDownKey = true;
                            break block14;
                        } else {
                            KeyboardView.this.swipeRight();
                            return true;
                        }
                    }
                    if (velocityX < (float)(-KeyboardView.this.mSwipeThreshold) && absY < absX && deltaX < (float)(-travelX)) {
                        if (KeyboardView.this.mDisambiguateSwipe && endingVelocityX > velocityX / 4.0f) {
                            sendDownKey = true;
                            break block14;
                        } else {
                            KeyboardView.this.swipeLeft();
                            return true;
                        }
                    }
                    if (velocityY < (float)(-KeyboardView.this.mSwipeThreshold) && absX < absY && deltaY < (float)(-travelY)) {
                        if (KeyboardView.this.mDisambiguateSwipe && endingVelocityY > velocityY / 4.0f) {
                            sendDownKey = true;
                            break block14;
                        } else {
                            KeyboardView.this.swipeUp();
                            return true;
                        }
                    }
                    if (velocityY > (float)KeyboardView.this.mSwipeThreshold && absX < absY / 2.0f && deltaY > (float)travelY) {
                        if (KeyboardView.this.mDisambiguateSwipe && endingVelocityY < velocityY / 4.0f) {
                            sendDownKey = true;
                        } else {
                            KeyboardView.this.swipeDown();
                            return true;
                        }
                    }
                }
                if (sendDownKey) {
                    KeyboardView.this.detectAndSendKey(KeyboardView.this.mDownKey, KeyboardView.this.mStartX, KeyboardView.this.mStartY, me1.getEventTime());
                }
                return false;
            }
        });
        this.mGestureDetector.setIsLongpressEnabled(false);
    }

    public void setOnKeyboardActionListener(OnKeyboardActionListener listener) {
        this.mKeyboardActionListener = listener;
    }

    protected OnKeyboardActionListener getOnKeyboardActionListener() {
        return this.mKeyboardActionListener;
    }

    public void setKeyboard(Keyboard keyboard) {
        if (this.mKeyboard != null) {
            this.showPreview(-1);
        }
        this.removeMessages();
        this.mKeyboard = keyboard;
        List<Keyboard.Key> keys = this.mKeyboard.getKeys();
        this.mKeys = keys.toArray(new Keyboard.Key[keys.size()]);
        this.requestLayout();
        this.mKeyboardChanged = true;
        this.invalidateAllKeys();
        this.computeProximityThreshold(keyboard);
        this.mMiniKeyboardCache.clear();
        this.mAbortKey = true;
    }

    public Keyboard getKeyboard() {
        return this.mKeyboard;
    }

    public boolean setShifted(boolean shifted) {
        if (this.mKeyboard != null && this.mKeyboard.setShifted(shifted)) {
            this.invalidateAllKeys();
            return true;
        }
        return false;
    }

    public boolean isShifted() {
        if (this.mKeyboard != null) {
            return this.mKeyboard.isShifted();
        }
        return false;
    }

    public void setPreviewEnabled(boolean previewEnabled) {
        this.mShowPreview = previewEnabled;
    }

    public boolean isPreviewEnabled() {
        return this.mShowPreview;
    }

    public void setVerticalCorrection(int verticalOffset) {
    }

    public void setPopupParent(View v) {
        this.mPopupParent = v;
    }

    public void setPopupOffset(int x, int y) {
        this.mMiniKeyboardOffsetX = x;
        this.mMiniKeyboardOffsetY = y;
        if (this.mPreviewPopup.isShowing()) {
            this.mPreviewPopup.dismiss();
        }
    }

    public void setProximityCorrectionEnabled(boolean enabled) {
        this.mProximityCorrectOn = enabled;
    }

    public boolean isProximityCorrectionEnabled() {
        return this.mProximityCorrectOn;
    }

    @Override
    public void onClick(View v) {
        this.dismissPopupKeyboard();
    }

    private CharSequence adjustCase(CharSequence label) {
        if (this.mKeyboard.isShifted() && label != null && label.length() < 3 && Character.isLowerCase(label.charAt(0))) {
            label = label.toString().toUpperCase();
        }
        return label;
    }

    @Override
    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mKeyboard == null) {
            this.setMeasuredDimension(this.mPaddingLeft + this.mPaddingRight, this.mPaddingTop + this.mPaddingBottom);
        } else {
            int width = this.mKeyboard.getMinWidth() + this.mPaddingLeft + this.mPaddingRight;
            if (View.MeasureSpec.getSize(widthMeasureSpec) < width + 10) {
                width = View.MeasureSpec.getSize(widthMeasureSpec);
            }
            this.setMeasuredDimension(width, this.mKeyboard.getHeight() + this.mPaddingTop + this.mPaddingBottom);
        }
    }

    private void computeProximityThreshold(Keyboard keyboard) {
        if (keyboard == null) {
            return;
        }
        Keyboard.Key[] keys = this.mKeys;
        if (keys == null) {
            return;
        }
        int length = keys.length;
        int dimensionSum = 0;
        for (int i = 0; i < length; ++i) {
            Keyboard.Key key = keys[i];
            dimensionSum += Math.min(key.width, key.height) + key.gap;
        }
        if (dimensionSum < 0 || length == 0) {
            return;
        }
        this.mProximityThreshold = (int)((float)dimensionSum * 1.4f / (float)length);
        this.mProximityThreshold *= this.mProximityThreshold;
    }

    @Override
    public void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.mKeyboard != null) {
            this.mKeyboard.resize(w, h);
        }
        this.mBuffer = null;
    }

    @Override
    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mDrawPending || this.mBuffer == null || this.mKeyboardChanged) {
            this.onBufferDraw();
        }
        canvas.drawBitmap(this.mBuffer, 0.0f, 0.0f, null);
    }

    private void onBufferDraw() {
        if (this.mBuffer == null || this.mKeyboardChanged) {
            if (this.mBuffer == null || this.mKeyboardChanged && (this.mBuffer.getWidth() != this.getWidth() || this.mBuffer.getHeight() != this.getHeight())) {
                int width = Math.max(1, this.getWidth());
                int height = Math.max(1, this.getHeight());
                this.mBuffer = Bitmap.createBitmap(width, height, Bitmap.Config.ARGB_8888);
                this.mCanvas = new Canvas(this.mBuffer);
            }
            this.invalidateAllKeys();
            this.mKeyboardChanged = false;
        }
        Canvas canvas = this.mCanvas;
        canvas.clipRect(this.mDirtyRect, Region.Op.REPLACE);
        if (this.mKeyboard == null) {
            return;
        }
        Paint paint = this.mPaint;
        Drawable keyBackground = this.mKeyBackground;
        Rect clipRegion = this.mClipRegion;
        Rect padding = this.mPadding;
        int kbdPaddingLeft = this.mPaddingLeft;
        int kbdPaddingTop = this.mPaddingTop;
        Keyboard.Key[] keys = this.mKeys;
        Keyboard.Key invalidKey = this.mInvalidatedKey;
        paint.setColor(this.mKeyTextColor);
        boolean drawSingleKey = false;
        if (invalidKey != null && canvas.getClipBounds(clipRegion) && invalidKey.x + kbdPaddingLeft - 1 <= clipRegion.left && invalidKey.y + kbdPaddingTop - 1 <= clipRegion.top && invalidKey.x + invalidKey.width + kbdPaddingLeft + 1 >= clipRegion.right && invalidKey.y + invalidKey.height + kbdPaddingTop + 1 >= clipRegion.bottom) {
            drawSingleKey = true;
        }
        canvas.drawColor(0, PorterDuff.Mode.CLEAR);
        for (Keyboard.Key key : keys) {
            if (drawSingleKey && invalidKey != key) continue;
            int[] drawableState = key.getCurrentDrawableState();
            keyBackground.setState(drawableState);
            String label = key.label == null ? null : this.adjustCase(key.label).toString();
            Rect bounds = keyBackground.getBounds();
            if (key.width != bounds.right || key.height != bounds.bottom) {
                keyBackground.setBounds(0, 0, key.width, key.height);
            }
            canvas.translate(key.x + kbdPaddingLeft, key.y + kbdPaddingTop);
            keyBackground.draw(canvas);
            if (label != null) {
                if (label.length() > 1 && key.codes.length < 2) {
                    paint.setTextSize(this.mLabelTextSize);
                    paint.setTypeface(Typeface.DEFAULT_BOLD);
                } else {
                    paint.setTextSize(this.mKeyTextSize);
                    paint.setTypeface(Typeface.DEFAULT);
                }
                paint.setShadowLayer(this.mShadowRadius, 0.0f, 0.0f, this.mShadowColor);
                canvas.drawText(label, (key.width - padding.left - padding.right) / 2 + padding.left, (float)((key.height - padding.top - padding.bottom) / 2) + (paint.getTextSize() - paint.descent()) / 2.0f + (float)padding.top, paint);
                paint.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
            } else if (key.icon != null) {
                int drawableX = (key.width - padding.left - padding.right - key.icon.getIntrinsicWidth()) / 2 + padding.left;
                int drawableY = (key.height - padding.top - padding.bottom - key.icon.getIntrinsicHeight()) / 2 + padding.top;
                canvas.translate(drawableX, drawableY);
                key.icon.setBounds(0, 0, key.icon.getIntrinsicWidth(), key.icon.getIntrinsicHeight());
                key.icon.draw(canvas);
                canvas.translate(-drawableX, -drawableY);
            }
            canvas.translate(-key.x - kbdPaddingLeft, -key.y - kbdPaddingTop);
        }
        this.mInvalidatedKey = null;
        if (this.mMiniKeyboardOnScreen) {
            paint.setColor((int)(this.mBackgroundDimAmount * 255.0f) << 24);
            canvas.drawRect(0.0f, 0.0f, this.getWidth(), this.getHeight(), paint);
        }
        this.mDrawPending = false;
        this.mDirtyRect.setEmpty();
    }

    private int getKeyIndices(int x, int y, int[] allKeys) {
        Keyboard.Key[] keys = this.mKeys;
        int primaryIndex = -1;
        int closestKey = -1;
        int closestKeyDist = this.mProximityThreshold + 1;
        Arrays.fill(this.mDistances, Integer.MAX_VALUE);
        int[] nearestKeyIndices = this.mKeyboard.getNearestKeys(x, y);
        int keyCount = nearestKeyIndices.length;
        block0: for (int i = 0; i < keyCount; ++i) {
            Keyboard.Key key = keys[nearestKeyIndices[i]];
            int dist = 0;
            boolean isInside = key.isInside(x, y);
            if (isInside) {
                primaryIndex = nearestKeyIndices[i];
            }
            if ((!this.mProximityCorrectOn || (dist = key.squaredDistanceFrom(x, y)) >= this.mProximityThreshold) && !isInside || key.codes[0] <= 32) continue;
            int nCodes = key.codes.length;
            if (dist < closestKeyDist) {
                closestKeyDist = dist;
                closestKey = nearestKeyIndices[i];
            }
            if (allKeys == null) continue;
            for (int j = 0; j < this.mDistances.length; ++j) {
                if (this.mDistances[j] <= dist) continue;
                System.arraycopy(this.mDistances, j, this.mDistances, j + nCodes, this.mDistances.length - j - nCodes);
                System.arraycopy(allKeys, j, allKeys, j + nCodes, allKeys.length - j - nCodes);
                for (int c = 0; c < nCodes; ++c) {
                    allKeys[j + c] = key.codes[c];
                    this.mDistances[j + c] = dist;
                }
                continue block0;
            }
        }
        if (primaryIndex == -1) {
            primaryIndex = closestKey;
        }
        return primaryIndex;
    }

    private void detectAndSendKey(int index, int x, int y, long eventTime) {
        if (index != -1 && index < this.mKeys.length) {
            Keyboard.Key key = this.mKeys[index];
            if (key.text != null) {
                this.mKeyboardActionListener.onText(key.text);
                this.mKeyboardActionListener.onRelease(-1);
            } else {
                int code = key.codes[0];
                int[] codes = new int[MAX_NEARBY_KEYS];
                Arrays.fill(codes, -1);
                this.getKeyIndices(x, y, codes);
                if (this.mInMultiTap) {
                    if (this.mTapCount != -1) {
                        this.mKeyboardActionListener.onKey(-5, KEY_DELETE);
                    } else {
                        this.mTapCount = 0;
                    }
                    code = key.codes[this.mTapCount];
                }
                this.mKeyboardActionListener.onKey(code, codes);
                this.mKeyboardActionListener.onRelease(code);
            }
            this.mLastSentIndex = index;
            this.mLastTapTime = eventTime;
        }
    }

    private CharSequence getPreviewText(Keyboard.Key key) {
        if (this.mInMultiTap) {
            this.mPreviewLabel.setLength(0);
            this.mPreviewLabel.append((char)key.codes[this.mTapCount < 0 ? 0 : this.mTapCount]);
            return this.adjustCase(this.mPreviewLabel);
        }
        return this.adjustCase(key.label);
    }

    private void showPreview(int keyIndex) {
        int oldKeyIndex = this.mCurrentKeyIndex;
        PopupWindow previewPopup = this.mPreviewPopup;
        this.mCurrentKeyIndex = keyIndex;
        Keyboard.Key[] keys = this.mKeys;
        if (oldKeyIndex != this.mCurrentKeyIndex) {
            int keyCode;
            if (oldKeyIndex != -1 && keys.length > oldKeyIndex) {
                Keyboard.Key oldKey = keys[oldKeyIndex];
                oldKey.onReleased(this.mCurrentKeyIndex == -1);
                this.invalidateKey(oldKeyIndex);
                keyCode = oldKey.codes[0];
                this.sendAccessibilityEventForUnicodeCharacter(256, keyCode);
                this.sendAccessibilityEventForUnicodeCharacter(65536, keyCode);
            }
            if (this.mCurrentKeyIndex != -1 && keys.length > this.mCurrentKeyIndex) {
                Keyboard.Key newKey = keys[this.mCurrentKeyIndex];
                newKey.onPressed();
                this.invalidateKey(this.mCurrentKeyIndex);
                keyCode = newKey.codes[0];
                this.sendAccessibilityEventForUnicodeCharacter(128, keyCode);
                this.sendAccessibilityEventForUnicodeCharacter(32768, keyCode);
            }
        }
        if (oldKeyIndex != this.mCurrentKeyIndex && this.mShowPreview) {
            this.mHandler.removeMessages(1);
            if (previewPopup.isShowing() && keyIndex == -1) {
                this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(2), 70L);
            }
            if (keyIndex != -1) {
                if (previewPopup.isShowing() && this.mPreviewText.getVisibility() == 0) {
                    this.showKey(keyIndex);
                } else {
                    this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(1, keyIndex, 0), 0L);
                }
            }
        }
    }

    private void showKey(int keyIndex) {
        PopupWindow previewPopup = this.mPreviewPopup;
        Keyboard.Key[] keys = this.mKeys;
        if (keyIndex < 0 || keyIndex >= this.mKeys.length) {
            return;
        }
        Keyboard.Key key = keys[keyIndex];
        if (key.icon != null) {
            this.mPreviewText.setCompoundDrawables(null, null, null, key.iconPreview != null ? key.iconPreview : key.icon);
            this.mPreviewText.setText(null);
        } else {
            this.mPreviewText.setCompoundDrawables(null, null, null, null);
            this.mPreviewText.setText(this.getPreviewText(key));
            if (key.label.length() > 1 && key.codes.length < 2) {
                this.mPreviewText.setTextSize(0, this.mKeyTextSize);
                this.mPreviewText.setTypeface(Typeface.DEFAULT_BOLD);
            } else {
                this.mPreviewText.setTextSize(0, this.mPreviewTextSizeLarge);
                this.mPreviewText.setTypeface(Typeface.DEFAULT);
            }
        }
        this.mPreviewText.measure(View.MeasureSpec.makeMeasureSpec(0, 0), View.MeasureSpec.makeMeasureSpec(0, 0));
        int popupWidth = Math.max(this.mPreviewText.getMeasuredWidth(), key.width + this.mPreviewText.getPaddingLeft() + this.mPreviewText.getPaddingRight());
        int popupHeight = this.mPreviewHeight;
        ViewGroup.LayoutParams lp = this.mPreviewText.getLayoutParams();
        if (lp != null) {
            lp.width = popupWidth;
            lp.height = popupHeight;
        }
        if (!this.mPreviewCentered) {
            this.mPopupPreviewX = key.x - this.mPreviewText.getPaddingLeft() + this.mPaddingLeft;
            this.mPopupPreviewY = key.y - popupHeight + this.mPreviewOffset;
        } else {
            this.mPopupPreviewX = 160 - this.mPreviewText.getMeasuredWidth() / 2;
            this.mPopupPreviewY = -this.mPreviewText.getMeasuredHeight();
        }
        this.mHandler.removeMessages(2);
        this.getLocationInWindow(this.mCoordinates);
        this.mCoordinates[0] = this.mCoordinates[0] + this.mMiniKeyboardOffsetX;
        this.mCoordinates[1] = this.mCoordinates[1] + this.mMiniKeyboardOffsetY;
        this.mPreviewText.getBackground().setState(key.popupResId != 0 ? LONG_PRESSABLE_STATE_SET : EMPTY_STATE_SET);
        this.mPopupPreviewX += this.mCoordinates[0];
        this.mPopupPreviewY += this.mCoordinates[1];
        this.getLocationOnScreen(this.mCoordinates);
        if (this.mPopupPreviewY + this.mCoordinates[1] < 0) {
            this.mPopupPreviewX = key.x + key.width <= this.getWidth() / 2 ? (this.mPopupPreviewX += (int)((double)key.width * 2.5)) : (this.mPopupPreviewX -= (int)((double)key.width * 2.5));
            this.mPopupPreviewY += popupHeight;
        }
        if (previewPopup.isShowing()) {
            previewPopup.update(this.mPopupPreviewX, this.mPopupPreviewY, popupWidth, popupHeight);
        } else {
            previewPopup.setWidth(popupWidth);
            previewPopup.setHeight(popupHeight);
            previewPopup.showAtLocation(this.mPopupParent, 0, this.mPopupPreviewX, this.mPopupPreviewY);
        }
        this.mPreviewText.setVisibility(0);
    }

    private void sendAccessibilityEventForUnicodeCharacter(int eventType, int code) {
        if (this.mAccessibilityManager.isEnabled()) {
            boolean speakPassword;
            AccessibilityEvent event = AccessibilityEvent.obtain(eventType);
            this.onInitializeAccessibilityEvent(event);
            String text = null;
            boolean bl = speakPassword = Settings.Secure.getInt(this.mContext.getContentResolver(), "speak_password", 0) != 0;
            if (speakPassword || this.mAudioManager.isBluetoothA2dpOn() || this.mAudioManager.isWiredHeadsetOn()) {
                switch (code) {
                    case -6: {
                        text = this.mContext.getString(17040763);
                        break;
                    }
                    case -3: {
                        text = this.mContext.getString(17040764);
                        break;
                    }
                    case -5: {
                        text = this.mContext.getString(17040765);
                        break;
                    }
                    case -4: {
                        text = this.mContext.getString(17040766);
                        break;
                    }
                    case -2: {
                        text = this.mContext.getString(17040767);
                        break;
                    }
                    case -1: {
                        text = this.mContext.getString(17040768);
                        break;
                    }
                    case 10: {
                        text = this.mContext.getString(17040769);
                        break;
                    }
                    default: {
                        text = String.valueOf((char)code);
                        break;
                    }
                }
            } else if (!this.mHeadsetRequiredToHearPasswordsAnnounced) {
                if (eventType == 256) {
                    this.mHeadsetRequiredToHearPasswordsAnnounced = true;
                }
                text = this.mContext.getString(17040776);
            } else {
                text = this.mContext.getString(17040777);
            }
            event.getText().add(text);
            this.mAccessibilityManager.sendAccessibilityEvent(event);
        }
    }

    public void invalidateAllKeys() {
        this.mDirtyRect.union(0, 0, this.getWidth(), this.getHeight());
        this.mDrawPending = true;
        this.invalidate();
    }

    public void invalidateKey(int keyIndex) {
        Keyboard.Key key;
        if (this.mKeys == null) {
            return;
        }
        if (keyIndex < 0 || keyIndex >= this.mKeys.length) {
            return;
        }
        this.mInvalidatedKey = key = this.mKeys[keyIndex];
        this.mDirtyRect.union(key.x + this.mPaddingLeft, key.y + this.mPaddingTop, key.x + key.width + this.mPaddingLeft, key.y + key.height + this.mPaddingTop);
        this.onBufferDraw();
        this.invalidate(key.x + this.mPaddingLeft, key.y + this.mPaddingTop, key.x + key.width + this.mPaddingLeft, key.y + key.height + this.mPaddingTop);
    }

    private boolean openPopupIfRequired(MotionEvent me) {
        if (this.mPopupLayout == 0) {
            return false;
        }
        if (this.mCurrentKey < 0 || this.mCurrentKey >= this.mKeys.length) {
            return false;
        }
        Keyboard.Key popupKey = this.mKeys[this.mCurrentKey];
        boolean result = this.onLongPress(popupKey);
        if (result) {
            this.mAbortKey = true;
            this.showPreview(-1);
        }
        return result;
    }

    protected boolean onLongPress(Keyboard.Key popupKey) {
        int popupKeyboardId = popupKey.popupResId;
        if (popupKeyboardId != 0) {
            this.mMiniKeyboardContainer = this.mMiniKeyboardCache.get(popupKey);
            if (this.mMiniKeyboardContainer == null) {
                LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
                this.mMiniKeyboardContainer = inflater.inflate(this.mPopupLayout, null);
                this.mMiniKeyboard = (KeyboardView)this.mMiniKeyboardContainer.findViewById(16908326);
                View closeButton = this.mMiniKeyboardContainer.findViewById(16908327);
                if (closeButton != null) {
                    closeButton.setOnClickListener(this);
                }
                this.mMiniKeyboard.setOnKeyboardActionListener(new OnKeyboardActionListener(){

                    @Override
                    public void onKey(int primaryCode, int[] keyCodes) {
                        KeyboardView.this.mKeyboardActionListener.onKey(primaryCode, keyCodes);
                        KeyboardView.this.dismissPopupKeyboard();
                    }

                    @Override
                    public void onText(CharSequence text) {
                        KeyboardView.this.mKeyboardActionListener.onText(text);
                        KeyboardView.this.dismissPopupKeyboard();
                    }

                    @Override
                    public void swipeLeft() {
                    }

                    @Override
                    public void swipeRight() {
                    }

                    @Override
                    public void swipeUp() {
                    }

                    @Override
                    public void swipeDown() {
                    }

                    @Override
                    public void onPress(int primaryCode) {
                        KeyboardView.this.mKeyboardActionListener.onPress(primaryCode);
                    }

                    @Override
                    public void onRelease(int primaryCode) {
                        KeyboardView.this.mKeyboardActionListener.onRelease(primaryCode);
                    }
                });
                Keyboard keyboard = popupKey.popupCharacters != null ? new Keyboard(this.getContext(), popupKeyboardId, popupKey.popupCharacters, -1, this.getPaddingLeft() + this.getPaddingRight()) : new Keyboard(this.getContext(), popupKeyboardId);
                this.mMiniKeyboard.setKeyboard(keyboard);
                this.mMiniKeyboard.setPopupParent(this);
                this.mMiniKeyboardContainer.measure(View.MeasureSpec.makeMeasureSpec(this.getWidth(), Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec(this.getHeight(), Integer.MIN_VALUE));
                this.mMiniKeyboardCache.put(popupKey, this.mMiniKeyboardContainer);
            } else {
                this.mMiniKeyboard = (KeyboardView)this.mMiniKeyboardContainer.findViewById(16908326);
            }
            this.getLocationInWindow(this.mCoordinates);
            this.mPopupX = popupKey.x + this.mPaddingLeft;
            this.mPopupY = popupKey.y + this.mPaddingTop;
            this.mPopupX = this.mPopupX + popupKey.width - this.mMiniKeyboardContainer.getMeasuredWidth();
            this.mPopupY -= this.mMiniKeyboardContainer.getMeasuredHeight();
            int x = this.mPopupX + this.mMiniKeyboardContainer.getPaddingRight() + this.mCoordinates[0];
            int y = this.mPopupY + this.mMiniKeyboardContainer.getPaddingBottom() + this.mCoordinates[1];
            this.mMiniKeyboard.setPopupOffset(x < 0 ? 0 : x, y);
            this.mMiniKeyboard.setShifted(this.isShifted());
            this.mPopupKeyboard.setContentView(this.mMiniKeyboardContainer);
            this.mPopupKeyboard.setWidth(this.mMiniKeyboardContainer.getMeasuredWidth());
            this.mPopupKeyboard.setHeight(this.mMiniKeyboardContainer.getMeasuredHeight());
            this.mPopupKeyboard.showAtLocation(this, 0, x, y);
            this.mMiniKeyboardOnScreen = true;
            this.invalidateAllKeys();
            return true;
        }
        return false;
    }

    @Override
    public boolean onHoverEvent(MotionEvent event) {
        if (this.mAccessibilityManager.isTouchExplorationEnabled() && event.getPointerCount() == 1) {
            int action = event.getAction();
            switch (action) {
                case 9: {
                    event.setAction(0);
                    break;
                }
                case 7: {
                    event.setAction(2);
                    break;
                }
                case 10: {
                    event.setAction(1);
                }
            }
            return this.onTouchEvent(event);
        }
        return true;
    }

    @Override
    public boolean onTouchEvent(MotionEvent me) {
        int pointerCount = me.getPointerCount();
        int action = me.getAction();
        boolean result = false;
        long now = me.getEventTime();
        if (pointerCount != this.mOldPointerCount) {
            if (pointerCount == 1) {
                MotionEvent down = MotionEvent.obtain(now, now, 0, me.getX(), me.getY(), me.getMetaState());
                result = this.onModifiedTouchEvent(down, false);
                down.recycle();
                if (action == 1) {
                    result = this.onModifiedTouchEvent(me, true);
                }
            } else {
                MotionEvent up = MotionEvent.obtain(now, now, 1, this.mOldPointerX, this.mOldPointerY, me.getMetaState());
                result = this.onModifiedTouchEvent(up, true);
                up.recycle();
            }
        } else if (pointerCount == 1) {
            result = this.onModifiedTouchEvent(me, false);
            this.mOldPointerX = me.getX();
            this.mOldPointerY = me.getY();
        } else {
            result = true;
        }
        this.mOldPointerCount = pointerCount;
        return result;
    }

    private boolean onModifiedTouchEvent(MotionEvent me, boolean possiblePoly) {
        int touchX = (int)me.getX() - this.mPaddingLeft;
        int touchY = (int)me.getY() - this.mPaddingTop;
        if (touchY >= -this.mVerticalCorrection) {
            touchY += this.mVerticalCorrection;
        }
        int action = me.getAction();
        long eventTime = me.getEventTime();
        int keyIndex = this.getKeyIndices(touchX, touchY, null);
        this.mPossiblePoly = possiblePoly;
        if (action == 0) {
            this.mSwipeTracker.clear();
        }
        this.mSwipeTracker.addMovement(me);
        if (this.mAbortKey && action != 0 && action != 3) {
            return true;
        }
        if (this.mGestureDetector.onTouchEvent(me)) {
            this.showPreview(-1);
            this.mHandler.removeMessages(3);
            this.mHandler.removeMessages(4);
            return true;
        }
        if (this.mMiniKeyboardOnScreen && action != 3) {
            return true;
        }
        switch (action) {
            case 0: {
                Message msg;
                this.mAbortKey = false;
                this.mStartX = touchX;
                this.mStartY = touchY;
                this.mLastCodeX = touchX;
                this.mLastCodeY = touchY;
                this.mLastKeyTime = 0L;
                this.mCurrentKeyTime = 0L;
                this.mLastKey = -1;
                this.mCurrentKey = keyIndex;
                this.mDownKey = keyIndex;
                this.mLastMoveTime = this.mDownTime = me.getEventTime();
                this.checkMultiTap(eventTime, keyIndex);
                this.mKeyboardActionListener.onPress(keyIndex != -1 ? this.mKeys[keyIndex].codes[0] : 0);
                if (this.mCurrentKey >= 0 && this.mKeys[this.mCurrentKey].repeatable) {
                    this.mRepeatKeyIndex = this.mCurrentKey;
                    msg = this.mHandler.obtainMessage(3);
                    this.mHandler.sendMessageDelayed(msg, 400L);
                    this.repeatKey();
                    if (this.mAbortKey) {
                        this.mRepeatKeyIndex = -1;
                        break;
                    }
                }
                if (this.mCurrentKey != -1) {
                    msg = this.mHandler.obtainMessage(4, me);
                    this.mHandler.sendMessageDelayed(msg, LONGPRESS_TIMEOUT);
                }
                this.showPreview(keyIndex);
                break;
            }
            case 2: {
                boolean continueLongPress = false;
                if (keyIndex != -1) {
                    if (this.mCurrentKey == -1) {
                        this.mCurrentKey = keyIndex;
                        this.mCurrentKeyTime = eventTime - this.mDownTime;
                    } else if (keyIndex == this.mCurrentKey) {
                        this.mCurrentKeyTime += eventTime - this.mLastMoveTime;
                        continueLongPress = true;
                    } else if (this.mRepeatKeyIndex == -1) {
                        this.resetMultiTap();
                        this.mLastKey = this.mCurrentKey;
                        this.mLastCodeX = this.mLastX;
                        this.mLastCodeY = this.mLastY;
                        this.mLastKeyTime = this.mCurrentKeyTime + eventTime - this.mLastMoveTime;
                        this.mCurrentKey = keyIndex;
                        this.mCurrentKeyTime = 0L;
                    }
                }
                if (!continueLongPress) {
                    this.mHandler.removeMessages(4);
                    if (keyIndex != -1) {
                        Message msg = this.mHandler.obtainMessage(4, me);
                        this.mHandler.sendMessageDelayed(msg, LONGPRESS_TIMEOUT);
                    }
                }
                this.showPreview(this.mCurrentKey);
                this.mLastMoveTime = eventTime;
                break;
            }
            case 1: {
                this.removeMessages();
                if (keyIndex == this.mCurrentKey) {
                    this.mCurrentKeyTime += eventTime - this.mLastMoveTime;
                } else {
                    this.resetMultiTap();
                    this.mLastKey = this.mCurrentKey;
                    this.mLastKeyTime = this.mCurrentKeyTime + eventTime - this.mLastMoveTime;
                    this.mCurrentKey = keyIndex;
                    this.mCurrentKeyTime = 0L;
                }
                if (this.mCurrentKeyTime < this.mLastKeyTime && this.mCurrentKeyTime < 70L && this.mLastKey != -1) {
                    this.mCurrentKey = this.mLastKey;
                    touchX = this.mLastCodeX;
                    touchY = this.mLastCodeY;
                }
                this.showPreview(-1);
                Arrays.fill(this.mKeyIndices, -1);
                if (this.mRepeatKeyIndex == -1 && !this.mMiniKeyboardOnScreen && !this.mAbortKey) {
                    this.detectAndSendKey(this.mCurrentKey, touchX, touchY, eventTime);
                }
                this.invalidateKey(keyIndex);
                this.mRepeatKeyIndex = -1;
                break;
            }
            case 3: {
                this.removeMessages();
                this.dismissPopupKeyboard();
                this.mAbortKey = true;
                this.showPreview(-1);
                this.invalidateKey(this.mCurrentKey);
            }
        }
        this.mLastX = touchX;
        this.mLastY = touchY;
        return true;
    }

    private boolean repeatKey() {
        Keyboard.Key key = this.mKeys[this.mRepeatKeyIndex];
        this.detectAndSendKey(this.mCurrentKey, key.x, key.y, this.mLastTapTime);
        return true;
    }

    protected void swipeRight() {
        this.mKeyboardActionListener.swipeRight();
    }

    protected void swipeLeft() {
        this.mKeyboardActionListener.swipeLeft();
    }

    protected void swipeUp() {
        this.mKeyboardActionListener.swipeUp();
    }

    protected void swipeDown() {
        this.mKeyboardActionListener.swipeDown();
    }

    public void closing() {
        if (this.mPreviewPopup.isShowing()) {
            this.mPreviewPopup.dismiss();
        }
        this.removeMessages();
        this.dismissPopupKeyboard();
        this.mBuffer = null;
        this.mCanvas = null;
        this.mMiniKeyboardCache.clear();
    }

    private void removeMessages() {
        this.mHandler.removeMessages(3);
        this.mHandler.removeMessages(4);
        this.mHandler.removeMessages(1);
    }

    @Override
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.closing();
    }

    private void dismissPopupKeyboard() {
        if (this.mPopupKeyboard.isShowing()) {
            this.mPopupKeyboard.dismiss();
            this.mMiniKeyboardOnScreen = false;
            this.invalidateAllKeys();
        }
    }

    public boolean handleBack() {
        if (this.mPopupKeyboard.isShowing()) {
            this.dismissPopupKeyboard();
            return true;
        }
        return false;
    }

    private void resetMultiTap() {
        this.mLastSentIndex = -1;
        this.mTapCount = 0;
        this.mLastTapTime = -1L;
        this.mInMultiTap = false;
    }

    private void checkMultiTap(long eventTime, int keyIndex) {
        if (keyIndex == -1) {
            return;
        }
        Keyboard.Key key = this.mKeys[keyIndex];
        if (key.codes.length > 1) {
            this.mInMultiTap = true;
            if (eventTime < this.mLastTapTime + 800L && keyIndex == this.mLastSentIndex) {
                this.mTapCount = (this.mTapCount + 1) % key.codes.length;
                return;
            }
            this.mTapCount = -1;
            return;
        }
        if (eventTime > this.mLastTapTime + 800L || keyIndex != this.mLastSentIndex) {
            this.resetMultiTap();
        }
    }

    private static class SwipeTracker {
        static final int NUM_PAST = 4;
        static final int LONGEST_PAST_TIME = 200;
        final float[] mPastX = new float[4];
        final float[] mPastY = new float[4];
        final long[] mPastTime = new long[4];
        float mYVelocity;
        float mXVelocity;

        private SwipeTracker() {
        }

        public void clear() {
            this.mPastTime[0] = 0L;
        }

        public void addMovement(MotionEvent ev) {
            long time = ev.getEventTime();
            int N = ev.getHistorySize();
            for (int i = 0; i < N; ++i) {
                this.addPoint(ev.getHistoricalX(i), ev.getHistoricalY(i), ev.getHistoricalEventTime(i));
            }
            this.addPoint(ev.getX(), ev.getY(), time);
        }

        private void addPoint(float x, float y, long time) {
            int i;
            int drop = -1;
            long[] pastTime = this.mPastTime;
            for (i = 0; i < 4 && pastTime[i] != 0L; ++i) {
                if (pastTime[i] >= time - 200L) continue;
                drop = i;
            }
            if (i == 4 && drop < 0) {
                drop = 0;
            }
            if (drop == i) {
                --drop;
            }
            float[] pastX = this.mPastX;
            float[] pastY = this.mPastY;
            if (drop >= 0) {
                int start = drop + 1;
                int count = 4 - drop - 1;
                System.arraycopy(pastX, start, pastX, 0, count);
                System.arraycopy(pastY, start, pastY, 0, count);
                System.arraycopy(pastTime, start, pastTime, 0, count);
                i -= drop + 1;
            }
            pastX[i] = x;
            pastY[i] = y;
            pastTime[i] = time;
            if (++i < 4) {
                pastTime[i] = 0L;
            }
        }

        public void computeCurrentVelocity(int units) {
            this.computeCurrentVelocity(units, Float.MAX_VALUE);
        }

        public void computeCurrentVelocity(int units, float maxVelocity) {
            int N;
            float[] pastX = this.mPastX;
            float[] pastY = this.mPastY;
            long[] pastTime = this.mPastTime;
            float oldestX = pastX[0];
            float oldestY = pastY[0];
            long oldestTime = pastTime[0];
            float accumX = 0.0f;
            float accumY = 0.0f;
            for (N = 0; N < 4 && pastTime[N] != 0L; ++N) {
            }
            for (int i = 1; i < N; ++i) {
                int dur = (int)(pastTime[i] - oldestTime);
                if (dur == 0) continue;
                float dist = pastX[i] - oldestX;
                float vel = dist / (float)dur * (float)units;
                accumX = accumX == 0.0f ? vel : (accumX + vel) * 0.5f;
                dist = pastY[i] - oldestY;
                vel = dist / (float)dur * (float)units;
                accumY = accumY == 0.0f ? vel : (accumY + vel) * 0.5f;
            }
            this.mXVelocity = accumX < 0.0f ? Math.max(accumX, -maxVelocity) : Math.min(accumX, maxVelocity);
            this.mYVelocity = accumY < 0.0f ? Math.max(accumY, -maxVelocity) : Math.min(accumY, maxVelocity);
        }

        public float getXVelocity() {
            return this.mXVelocity;
        }

        public float getYVelocity() {
            return this.mYVelocity;
        }
    }

    public static interface OnKeyboardActionListener {
        public void onPress(int var1);

        public void onRelease(int var1);

        public void onKey(int var1, int[] var2);

        public void onText(CharSequence var1);

        public void swipeLeft();

        public void swipeRight();

        public void swipeDown();

        public void swipeUp();
    }
}

