/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.graphics.ImageFormat;
import android.graphics.PixelFormat;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.params.HighSpeedVideoConfiguration;
import android.hardware.camera2.params.StreamConfiguration;
import android.hardware.camera2.params.StreamConfigurationDuration;
import android.hardware.camera2.utils.HashCodeHelpers;
import android.media.ImageReader;
import android.media.MediaCodec;
import android.media.MediaRecorder;
import android.renderscript.Allocation;
import android.util.Range;
import android.util.Size;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.java.Objects;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;

public class StreamConfigurationMap {
    private static final String TAG = "StreamConfigurationMap";
    private static final int HAL_PIXEL_FORMAT_BLOB = 33;
    private static final int HAL_PIXEL_FORMAT_IMPLEMENTATION_DEFINED = 34;
    private static final int HAL_PIXEL_FORMAT_RAW_OPAQUE = 36;
    private static final int DURATION_MIN_FRAME = 0;
    private static final int DURATION_STALL = 1;
    private final StreamConfiguration[] mConfigurations;
    private final StreamConfigurationDuration[] mMinFrameDurations;
    private final StreamConfigurationDuration[] mStallDurations;
    private final HighSpeedVideoConfiguration[] mHighSpeedVideoConfigurations;
    private final HashMap<Integer, Integer> mOutputFormats = new HashMap();
    private final HashMap<Integer, Integer> mInputFormats = new HashMap();
    private final HashMap<Size, Integer> mHighSpeedVideoSizeMap = new HashMap();
    private final HashMap<Range<Integer>, Integer> mHighSpeedVideoFpsRangeMap = new HashMap();

    public StreamConfigurationMap(StreamConfiguration[] configurations, StreamConfigurationDuration[] minFrameDurations, StreamConfigurationDuration[] stallDurations, HighSpeedVideoConfiguration[] highSpeedVideoConfigurations) {
        this.mConfigurations = Preconditions.checkArrayElementsNotNull(configurations, "configurations");
        this.mMinFrameDurations = Preconditions.checkArrayElementsNotNull(minFrameDurations, "minFrameDurations");
        this.mStallDurations = Preconditions.checkArrayElementsNotNull(stallDurations, "stallDurations");
        this.mHighSpeedVideoConfigurations = highSpeedVideoConfigurations == null ? new HighSpeedVideoConfiguration[0] : Preconditions.checkArrayElementsNotNull(highSpeedVideoConfigurations, "highSpeedVideoConfigurations");
        for (StreamConfiguration streamConfiguration : configurations) {
            HashMap<Integer, Integer> map = streamConfiguration.isOutput() ? this.mOutputFormats : this.mInputFormats;
            Integer count = map.get(streamConfiguration.getFormat());
            if (count == null) {
                count = 0;
            }
            count = count + 1;
            map.put(streamConfiguration.getFormat(), count);
        }
        if (!this.mOutputFormats.containsKey(34)) {
            throw new AssertionError((Object)"At least one stream configuration for IMPLEMENTATION_DEFINED must exist");
        }
        for (HighSpeedVideoConfiguration highSpeedVideoConfiguration : this.mHighSpeedVideoConfigurations) {
            Size size = highSpeedVideoConfiguration.getSize();
            Range<Integer> fpsRange = highSpeedVideoConfiguration.getFpsRange();
            Integer fpsRangeCount = this.mHighSpeedVideoSizeMap.get(size);
            if (fpsRangeCount == null) {
                fpsRangeCount = 0;
            }
            this.mHighSpeedVideoSizeMap.put(size, fpsRangeCount + 1);
            Integer sizeCount = this.mHighSpeedVideoFpsRangeMap.get(fpsRange);
            if (sizeCount == null) {
                sizeCount = 0;
            }
            this.mHighSpeedVideoFpsRangeMap.put(fpsRange, sizeCount + 1);
        }
    }

    public int[] getOutputFormats() {
        return this.getPublicFormats(true);
    }

    public int[] getInputFormats() {
        return this.getPublicFormats(false);
    }

    public Size[] getInputSizes(int format) {
        return this.getPublicFormatSizes(format, false);
    }

    public boolean isOutputSupportedFor(int format) {
        StreamConfigurationMap.checkArgumentFormat(format);
        format = StreamConfigurationMap.imageFormatToInternal(format);
        return this.getFormatsMap(true).containsKey(format);
    }

    public static <T> boolean isOutputSupportedFor(Class<T> klass) {
        Preconditions.checkNotNull(klass, "klass must not be null");
        if (klass == ImageReader.class) {
            return true;
        }
        if (klass == MediaRecorder.class) {
            return true;
        }
        if (klass == MediaCodec.class) {
            return true;
        }
        if (klass == Allocation.class) {
            return true;
        }
        if (klass == SurfaceHolder.class) {
            return true;
        }
        return klass == SurfaceTexture.class;
    }

    public boolean isOutputSupportedFor(Surface surface) {
        Preconditions.checkNotNull(surface, "surface must not be null");
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public <T> Size[] getOutputSizes(Class<T> klass) {
        if (ImageReader.class.isAssignableFrom(klass)) {
            return new Size[0];
        }
        if (!StreamConfigurationMap.isOutputSupportedFor(klass)) {
            return null;
        }
        return this.getInternalFormatSizes(34, true);
    }

    public Size[] getOutputSizes(int format) {
        return this.getPublicFormatSizes(format, true);
    }

    public Size[] getHighSpeedVideoSizes() {
        Set<Size> keySet = this.mHighSpeedVideoSizeMap.keySet();
        return keySet.toArray(new Size[keySet.size()]);
    }

    public Range<Integer>[] getHighSpeedVideoFpsRangesFor(Size size) {
        Integer fpsRangeCount = this.mHighSpeedVideoSizeMap.get(size);
        if (fpsRangeCount == null || fpsRangeCount == 0) {
            throw new IllegalArgumentException(String.format("Size %s does not support high speed video recording", size));
        }
        Range[] fpsRanges = new Range[fpsRangeCount.intValue()];
        int i = 0;
        for (HighSpeedVideoConfiguration config : this.mHighSpeedVideoConfigurations) {
            if (!size.equals(config.getSize())) continue;
            fpsRanges[i++] = config.getFpsRange();
        }
        return fpsRanges;
    }

    public Range<Integer>[] getHighSpeedVideoFpsRanges() {
        Set<Range<Integer>> keySet = this.mHighSpeedVideoFpsRangeMap.keySet();
        return keySet.toArray(new Range[keySet.size()]);
    }

    public Size[] getHighSpeedVideoSizesFor(Range<Integer> fpsRange) {
        Integer sizeCount = this.mHighSpeedVideoFpsRangeMap.get(fpsRange);
        if (sizeCount == null || sizeCount == 0) {
            throw new IllegalArgumentException(String.format("FpsRange %s does not support high speed video recording", fpsRange));
        }
        Size[] sizes = new Size[sizeCount.intValue()];
        int i = 0;
        for (HighSpeedVideoConfiguration config : this.mHighSpeedVideoConfigurations) {
            if (!fpsRange.equals(config.getFpsRange())) continue;
            sizes[i++] = config.getSize();
        }
        return sizes;
    }

    public long getOutputMinFrameDuration(int format, Size size) {
        Preconditions.checkNotNull(size, "size must not be null");
        this.checkArgumentFormatSupported(format, true);
        return this.getInternalFormatDuration(StreamConfigurationMap.imageFormatToInternal(format), size, 0);
    }

    public <T> long getOutputMinFrameDuration(Class<T> klass, Size size) {
        if (!StreamConfigurationMap.isOutputSupportedFor(klass)) {
            throw new IllegalArgumentException("klass was not supported");
        }
        return this.getInternalFormatDuration(34, size, 0);
    }

    public long getOutputStallDuration(int format, Size size) {
        this.checkArgumentFormatSupported(format, true);
        return this.getInternalFormatDuration(StreamConfigurationMap.imageFormatToInternal(format), size, 1);
    }

    public <T> long getOutputStallDuration(Class<T> klass, Size size) {
        if (!StreamConfigurationMap.isOutputSupportedFor(klass)) {
            throw new IllegalArgumentException("klass was not supported");
        }
        return this.getInternalFormatDuration(34, size, 1);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof StreamConfigurationMap) {
            StreamConfigurationMap other = (StreamConfigurationMap)obj;
            return Arrays.equals(this.mConfigurations, other.mConfigurations) && Arrays.equals(this.mMinFrameDurations, other.mMinFrameDurations) && Arrays.equals(this.mStallDurations, other.mStallDurations) && Arrays.equals(this.mHighSpeedVideoConfigurations, other.mHighSpeedVideoConfigurations);
        }
        return false;
    }

    public int hashCode() {
        return HashCodeHelpers.hashCode(this.mConfigurations, this.mMinFrameDurations, this.mStallDurations, this.mHighSpeedVideoConfigurations);
    }

    private int checkArgumentFormatSupported(int format, boolean output) {
        StreamConfigurationMap.checkArgumentFormat(format);
        int[] formats = output ? this.getOutputFormats() : this.getInputFormats();
        for (int i = 0; i < formats.length; ++i) {
            if (format != formats[i]) continue;
            return format;
        }
        throw new IllegalArgumentException(String.format("format %x is not supported by this stream configuration map", format));
    }

    static int checkArgumentFormatInternal(int format) {
        switch (format) {
            case 33: 
            case 34: 
            case 36: {
                return format;
            }
            case 256: {
                throw new IllegalArgumentException("ImageFormat.JPEG is an unknown internal format");
            }
        }
        return StreamConfigurationMap.checkArgumentFormat(format);
    }

    static int checkArgumentFormat(int format) {
        if (!ImageFormat.isPublicFormat(format) && !PixelFormat.isPublicFormat(format)) {
            throw new IllegalArgumentException(String.format("format 0x%x was not defined in either ImageFormat or PixelFormat", format));
        }
        return format;
    }

    static int imageFormatToPublic(int format) {
        switch (format) {
            case 33: {
                return 256;
            }
            case 256: {
                throw new IllegalArgumentException("ImageFormat.JPEG is an unknown internal format");
            }
            case 34: {
                throw new IllegalArgumentException("IMPLEMENTATION_DEFINED must not leak to public API");
            }
        }
        return format;
    }

    static int[] imageFormatToPublic(int[] formats) {
        if (formats == null) {
            return null;
        }
        for (int i = 0; i < formats.length; ++i) {
            formats[i] = StreamConfigurationMap.imageFormatToPublic(formats[i]);
        }
        return formats;
    }

    static int imageFormatToInternal(int format) {
        switch (format) {
            case 256: {
                return 33;
            }
            case 34: {
                throw new IllegalArgumentException("IMPLEMENTATION_DEFINED is not allowed via public API");
            }
        }
        return format;
    }

    public static int[] imageFormatToInternal(int[] formats) {
        if (formats == null) {
            return null;
        }
        for (int i = 0; i < formats.length; ++i) {
            formats[i] = StreamConfigurationMap.imageFormatToInternal(formats[i]);
        }
        return formats;
    }

    private Size[] getPublicFormatSizes(int format, boolean output) {
        try {
            this.checkArgumentFormatSupported(format, output);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        format = StreamConfigurationMap.imageFormatToInternal(format);
        return this.getInternalFormatSizes(format, output);
    }

    private Size[] getInternalFormatSizes(int format, boolean output) {
        HashMap<Integer, Integer> formatsMap = this.getFormatsMap(output);
        Integer sizesCount = formatsMap.get(format);
        if (sizesCount == null) {
            throw new IllegalArgumentException("format not available");
        }
        int len = sizesCount;
        Size[] sizes = new Size[len];
        int sizeIndex = 0;
        for (StreamConfiguration config : this.mConfigurations) {
            if (config.getFormat() != format || config.isOutput() != output) continue;
            sizes[sizeIndex++] = config.getSize();
        }
        if (sizeIndex != len) {
            throw new AssertionError((Object)("Too few sizes (expected " + len + ", actual " + sizeIndex + ")"));
        }
        return sizes;
    }

    private int[] getPublicFormats(boolean output) {
        int[] formats = new int[this.getPublicFormatCount(output)];
        int i = 0;
        for (int format : this.getFormatsMap(output).keySet()) {
            if (format == 34) continue;
            formats[i++] = format;
        }
        if (formats.length != i) {
            throw new AssertionError((Object)("Too few formats " + i + ", expected " + formats.length));
        }
        return StreamConfigurationMap.imageFormatToPublic(formats);
    }

    private HashMap<Integer, Integer> getFormatsMap(boolean output) {
        return output ? this.mOutputFormats : this.mInputFormats;
    }

    private long getInternalFormatDuration(int format, Size size, int duration) {
        StreamConfigurationDuration[] durations;
        if (!StreamConfigurationMap.arrayContains(this.getInternalFormatSizes(format, true), size)) {
            throw new IllegalArgumentException("size was not supported");
        }
        for (StreamConfigurationDuration configurationDuration : durations = this.getDurations(duration)) {
            if (configurationDuration.getFormat() != format || configurationDuration.getWidth() != size.getWidth() || configurationDuration.getHeight() != size.getHeight()) continue;
            return configurationDuration.getDuration();
        }
        return 0L;
    }

    private StreamConfigurationDuration[] getDurations(int duration) {
        switch (duration) {
            case 0: {
                return this.mMinFrameDurations;
            }
            case 1: {
                return this.mStallDurations;
            }
        }
        throw new IllegalArgumentException("duration was invalid");
    }

    private int getPublicFormatCount(boolean output) {
        HashMap<Integer, Integer> formatsMap = this.getFormatsMap(output);
        int size = formatsMap.size();
        if (formatsMap.containsKey(34)) {
            --size;
        }
        return size;
    }

    private static <T> boolean arrayContains(T[] array2, T element) {
        if (array2 == null) {
            return false;
        }
        for (T el : array2) {
            if (!Objects.equals(el, element)) continue;
            return true;
        }
        return false;
    }
}

