/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.content.Context;
import android.hardware.CameraInfo;
import android.hardware.ICameraService;
import android.hardware.ICameraServiceListener;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.ICameraDeviceUser;
import android.hardware.camera2.impl.CameraDeviceImpl;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.legacy.CameraDeviceUserShim;
import android.hardware.camera2.legacy.LegacyMetadataMapper;
import android.hardware.camera2.utils.BinderHolder;
import android.hardware.camera2.utils.CameraRuntimeException;
import android.hardware.camera2.utils.CameraServiceBinderDecorator;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.ArrayMap;
import android.util.Log;
import java.util.ArrayList;

public class CameraManager {
    private static final String TAG = "CameraManager";
    private final boolean DEBUG;
    private static final String CAMERA_SERVICE_BINDER_NAME = "media.camera";
    private static final int USE_CALLING_UID = -1;
    private static final int API_VERSION_1 = 1;
    private static final int API_VERSION_2 = 2;
    private ICameraService mCameraService;
    private ArrayList<String> mDeviceIdList;
    private final ArrayMap<AvailabilityCallback, Handler> mCallbackMap = new ArrayMap();
    private final Context mContext;
    private final Object mLock = new Object();
    private final CameraServiceListener mServiceListener = new CameraServiceListener();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CameraManager(Context context) {
        this.DEBUG = Log.isLoggable(TAG, 3);
        Object object = this.mLock;
        synchronized (object) {
            this.mContext = context;
            this.connectCameraServiceLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getCameraIdList() throws CameraAccessException {
        Object object = this.mLock;
        synchronized (object) {
            return this.getOrCreateDeviceIdListLocked().toArray(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAvailabilityCallback(AvailabilityCallback callback, Handler handler) {
        if (handler == null) {
            Looper looper = Looper.myLooper();
            if (looper == null) {
                throw new IllegalArgumentException("No handler given, and current thread has no looper!");
            }
            handler = new Handler(looper);
        }
        Object object = this.mLock;
        synchronized (object) {
            Handler oldHandler = this.mCallbackMap.put(callback, handler);
            if (oldHandler == null) {
                this.mServiceListener.updateCallbackLocked(callback, handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAvailabilityCallback(AvailabilityCallback callback) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCallbackMap.remove(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CameraCharacteristics getCameraCharacteristics(String cameraId) throws CameraAccessException {
        CameraCharacteristics characteristics = null;
        Object object = this.mLock;
        synchronized (object) {
            if (!this.getOrCreateDeviceIdListLocked().contains(cameraId)) {
                throw new IllegalArgumentException(String.format("Camera id %s does not match any currently connected camera device", cameraId));
            }
            int id2 = Integer.valueOf(cameraId);
            ICameraService cameraService = this.getCameraServiceLocked();
            if (cameraService == null) {
                throw new CameraAccessException(2, "Camera service is currently unavailable");
            }
            try {
                if (!this.supportsCamera2ApiLocked(cameraId)) {
                    String[] outParameters = new String[1];
                    cameraService.getLegacyParameters(id2, outParameters);
                    String parameters = outParameters[0];
                    CameraInfo info = new CameraInfo();
                    cameraService.getCameraInfo(id2, info);
                    characteristics = LegacyMetadataMapper.createCharacteristics(parameters, info);
                } else {
                    CameraMetadataNative info = new CameraMetadataNative();
                    cameraService.getCameraCharacteristics(id2, info);
                    characteristics = new CameraCharacteristics(info);
                }
            }
            catch (CameraRuntimeException e) {
                throw e.asChecked();
            }
            catch (RemoteException e) {
                throw new CameraAccessException(2, "Camera service is currently unavailable", e);
            }
        }
        return characteristics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CameraDevice openCameraDeviceUserAsync(String cameraId, CameraDevice.StateCallback callback, Handler handler) throws CameraAccessException {
        CameraCharacteristics characteristics = this.getCameraCharacteristics(cameraId);
        CameraDeviceImpl device = null;
        try {
            Object object = this.mLock;
            synchronized (object) {
                ICameraDeviceUser cameraUser = null;
                CameraDeviceImpl deviceImpl = new CameraDeviceImpl(cameraId, callback, handler, characteristics);
                BinderHolder holder = new BinderHolder();
                CameraDeviceImpl.CameraDeviceCallbacks callbacks = deviceImpl.getCallbacks();
                int id2 = Integer.parseInt(cameraId);
                try {
                    if (this.supportsCamera2ApiLocked(cameraId)) {
                        ICameraService cameraService = this.getCameraServiceLocked();
                        if (cameraService == null) {
                            throw new CameraRuntimeException(2, "Camera service is currently unavailable");
                        }
                        cameraService.connectDevice(callbacks, id2, this.mContext.getPackageName(), -1, holder);
                        cameraUser = ICameraDeviceUser.Stub.asInterface(holder.getBinder());
                    } else {
                        Log.i(TAG, "Using legacy camera HAL.");
                        cameraUser = CameraDeviceUserShim.connectBinderShim(callbacks, id2);
                    }
                }
                catch (CameraRuntimeException e) {
                    if (e.getReason() == 1000) {
                        throw new AssertionError((Object)"Should've gone down the shim path");
                    }
                    if (e.getReason() == 4 || e.getReason() == 5 || e.getReason() == 1 || e.getReason() == 2 || e.getReason() == 3) {
                        deviceImpl.setRemoteFailure(e);
                        if (e.getReason() == 1 || e.getReason() == 2) {
                            throw e.asChecked();
                        }
                    }
                    throw e;
                }
                catch (RemoteException e) {
                    CameraRuntimeException ce = new CameraRuntimeException(2, "Camera service is currently unavailable", e);
                    deviceImpl.setRemoteFailure(ce);
                    throw ce.asChecked();
                }
                deviceImpl.setRemoteDevice(cameraUser);
                device = deviceImpl;
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Expected cameraId to be numeric, but it was: " + cameraId);
        }
        catch (CameraRuntimeException e) {
            throw e.asChecked();
        }
        return device;
    }

    public void openCamera(String cameraId, CameraDevice.StateCallback callback, Handler handler) throws CameraAccessException {
        if (cameraId == null) {
            throw new IllegalArgumentException("cameraId was null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback was null");
        }
        if (handler == null) {
            if (Looper.myLooper() != null) {
                handler = new Handler();
            } else {
                throw new IllegalArgumentException("Looper doesn't exist in the calling thread");
            }
        }
        this.openCameraDeviceUserAsync(cameraId, callback, handler);
    }

    private ArrayList<String> getOrCreateDeviceIdListLocked() throws CameraAccessException {
        if (this.mDeviceIdList == null) {
            int numCameras = 0;
            ICameraService cameraService = this.getCameraServiceLocked();
            ArrayList<String> deviceIdList = new ArrayList<String>();
            if (cameraService == null) {
                return deviceIdList;
            }
            try {
                numCameras = cameraService.getNumberOfCameras();
            }
            catch (CameraRuntimeException e) {
                throw e.asChecked();
            }
            catch (RemoteException e) {
                return deviceIdList;
            }
            CameraMetadataNative info = new CameraMetadataNative();
            for (int i = 0; i < numCameras; ++i) {
                boolean isDeviceSupported = false;
                try {
                    cameraService.getCameraCharacteristics(i, info);
                    if (info.isEmpty()) {
                        throw new AssertionError((Object)"Expected to get non-empty characteristics");
                    }
                    isDeviceSupported = true;
                }
                catch (IllegalArgumentException e) {
                }
                catch (CameraRuntimeException e) {
                    if (e.getReason() != 2) {
                        throw e.asChecked();
                    }
                }
                catch (RemoteException e) {
                    deviceIdList.clear();
                    return deviceIdList;
                }
                if (isDeviceSupported) {
                    deviceIdList.add(String.valueOf(i));
                    continue;
                }
                Log.w(TAG, "Error querying camera device " + i + " for listing.");
            }
            this.mDeviceIdList = deviceIdList;
        }
        return this.mDeviceIdList;
    }

    private void handleRecoverableSetupErrors(CameraRuntimeException e, String msg) {
        int problem = e.getReason();
        switch (problem) {
            case 2: {
                String errorMsg = CameraAccessException.getDefaultMessage(problem);
                Log.w(TAG, msg + ": " + errorMsg);
                break;
            }
            default: {
                throw new IllegalStateException(msg, e.asChecked());
            }
        }
    }

    private boolean supportsCamera2ApiLocked(String cameraId) {
        return this.supportsCameraApiLocked(cameraId, 2);
    }

    private boolean supportsCameraApiLocked(String cameraId, int apiVersion) {
        int id2 = Integer.parseInt(cameraId);
        try {
            ICameraService cameraService = this.getCameraServiceLocked();
            if (cameraService == null) {
                return false;
            }
            int res = cameraService.supportsCameraApi(id2, apiVersion);
            if (res != 0) {
                throw new AssertionError((Object)("Unexpected value " + res));
            }
            return true;
        }
        catch (CameraRuntimeException e) {
            if (e.getReason() != 1000) {
                throw e;
            }
        }
        catch (RemoteException e) {
            // empty catch block
        }
        return false;
    }

    private void connectCameraServiceLocked() {
        this.mCameraService = null;
        IBinder cameraServiceBinder = ServiceManager.getService(CAMERA_SERVICE_BINDER_NAME);
        if (cameraServiceBinder == null) {
            return;
        }
        try {
            cameraServiceBinder.linkToDeath(new CameraServiceDeathListener(), 0);
        }
        catch (RemoteException e) {
            return;
        }
        ICameraService cameraServiceRaw = ICameraService.Stub.asInterface(cameraServiceBinder);
        ICameraService cameraService = CameraServiceBinderDecorator.newInstance(cameraServiceRaw);
        try {
            CameraServiceBinderDecorator.throwOnError(CameraMetadataNative.nativeSetupGlobalVendorTagDescriptor());
        }
        catch (CameraRuntimeException e) {
            this.handleRecoverableSetupErrors(e, "Failed to set up vendor tags");
        }
        try {
            cameraService.addListener(this.mServiceListener);
            this.mCameraService = cameraService;
        }
        catch (CameraRuntimeException e) {
            throw new IllegalStateException("Failed to register a camera service listener", e.asChecked());
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    private ICameraService getCameraServiceLocked() {
        if (this.mCameraService == null) {
            Log.i(TAG, "getCameraServiceLocked: Reconnecting to camera service");
            this.connectCameraServiceLocked();
            if (this.mCameraService == null) {
                Log.e(TAG, "Camera service is unavailable");
            }
        }
        return this.mCameraService;
    }

    private class CameraServiceListener
    extends ICameraServiceListener.Stub {
        public static final int STATUS_NOT_PRESENT = 0;
        public static final int STATUS_PRESENT = 1;
        public static final int STATUS_ENUMERATING = 2;
        public static final int STATUS_NOT_AVAILABLE = Integer.MIN_VALUE;
        private final ArrayMap<String, Integer> mDeviceStatus = new ArrayMap();
        private static final String TAG = "CameraServiceListener";

        private CameraServiceListener() {
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        private boolean isAvailable(int status) {
            switch (status) {
                case 1: {
                    return true;
                }
            }
            return false;
        }

        private boolean validStatus(int status) {
            switch (status) {
                case -2147483648: 
                case 0: 
                case 1: 
                case 2: {
                    return true;
                }
            }
            return false;
        }

        private void postSingleUpdate(final AvailabilityCallback callback, Handler handler, final String id2, int status) {
            if (this.isAvailable(status)) {
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onCameraAvailable(id2);
                    }
                });
            } else {
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onCameraUnavailable(id2);
                    }
                });
            }
        }

        public void updateCallbackLocked(AvailabilityCallback callback, Handler handler) {
            for (int i = 0; i < this.mDeviceStatus.size(); ++i) {
                String id2 = this.mDeviceStatus.keyAt(i);
                Integer status = this.mDeviceStatus.valueAt(i);
                this.postSingleUpdate(callback, handler, id2, status);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onStatusChanged(int status, int cameraId) throws RemoteException {
            Object object = CameraManager.this.mLock;
            synchronized (object) {
                this.onStatusChangedLocked(status, String.valueOf(cameraId));
            }
        }

        public void onStatusChangedLocked(int status, String id2) {
            if (CameraManager.this.DEBUG) {
                Log.v(TAG, String.format("Camera id %s has status changed to 0x%x", id2, status));
            }
            if (!this.validStatus(status)) {
                Log.e(TAG, String.format("Ignoring invalid device %s status 0x%x", id2, status));
                return;
            }
            Integer oldStatus = this.mDeviceStatus.put(id2, status);
            if (oldStatus != null && oldStatus == status) {
                if (CameraManager.this.DEBUG) {
                    Log.v(TAG, String.format("Device status changed to 0x%x, which is what it already was", status));
                }
                return;
            }
            if (oldStatus != null && this.isAvailable(status) == this.isAvailable(oldStatus)) {
                if (CameraManager.this.DEBUG) {
                    Log.v(TAG, String.format("Device status was previously available (%d),  and is now again available (%d)so no new client visible update will be sent", this.isAvailable(status), this.isAvailable(status)));
                }
                return;
            }
            int callbackCount = CameraManager.this.mCallbackMap.size();
            for (int i = 0; i < callbackCount; ++i) {
                Handler handler = (Handler)CameraManager.this.mCallbackMap.valueAt(i);
                AvailabilityCallback callback = (AvailabilityCallback)CameraManager.this.mCallbackMap.keyAt(i);
                this.postSingleUpdate(callback, handler, id2, status);
            }
        }
    }

    private class CameraServiceDeathListener
    implements IBinder.DeathRecipient {
        private CameraServiceDeathListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Object object = CameraManager.this.mLock;
            synchronized (object) {
                CameraManager.this.mCameraService = null;
                for (String cameraId : CameraManager.this.mDeviceIdList) {
                    CameraManager.this.mServiceListener.onStatusChangedLocked(1, cameraId);
                }
            }
        }
    }

    public static abstract class AvailabilityListener
    extends AvailabilityCallback {
    }

    public static abstract class AvailabilityCallback {
        public void onCameraAvailable(String cameraId) {
        }

        public void onCameraUnavailable(String cameraId) {
        }
    }
}

