/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

public class Sensor {
    public static final int TYPE_ACCELEROMETER = 1;
    public static final String STRING_TYPE_ACCELEROMETER = "android.sensor.accelerometer";
    public static final int TYPE_MAGNETIC_FIELD = 2;
    public static final String STRING_TYPE_MAGNETIC_FIELD = "android.sensor.magnetic_field";
    @Deprecated
    public static final int TYPE_ORIENTATION = 3;
    @Deprecated
    public static final String STRING_TYPE_ORIENTATION = "android.sensor.orientation";
    public static final int TYPE_GYROSCOPE = 4;
    public static final String STRING_TYPE_GYROSCOPE = "android.sensor.gyroscope";
    public static final int TYPE_LIGHT = 5;
    public static final String STRING_TYPE_LIGHT = "android.sensor.light";
    public static final int TYPE_PRESSURE = 6;
    public static final String STRING_TYPE_PRESSURE = "android.sensor.pressure";
    @Deprecated
    public static final int TYPE_TEMPERATURE = 7;
    @Deprecated
    public static final String STRING_TYPE_TEMPERATURE = "android.sensor.temperature";
    public static final int TYPE_PROXIMITY = 8;
    public static final String STRING_TYPE_PROXIMITY = "android.sensor.proximity";
    public static final int TYPE_GRAVITY = 9;
    public static final String STRING_TYPE_GRAVITY = "android.sensor.gravity";
    public static final int TYPE_LINEAR_ACCELERATION = 10;
    public static final String STRING_TYPE_LINEAR_ACCELERATION = "android.sensor.linear_acceleration";
    public static final int TYPE_ROTATION_VECTOR = 11;
    public static final String STRING_TYPE_ROTATION_VECTOR = "android.sensor.rotation_vector";
    public static final int TYPE_RELATIVE_HUMIDITY = 12;
    public static final String STRING_TYPE_RELATIVE_HUMIDITY = "android.sensor.relative_humidity";
    public static final int TYPE_AMBIENT_TEMPERATURE = 13;
    public static final String STRING_TYPE_AMBIENT_TEMPERATURE = "android.sensor.ambient_temperature";
    public static final int TYPE_MAGNETIC_FIELD_UNCALIBRATED = 14;
    public static final String STRING_TYPE_MAGNETIC_FIELD_UNCALIBRATED = "android.sensor.magnetic_field_uncalibrated";
    public static final int TYPE_GAME_ROTATION_VECTOR = 15;
    public static final String STRING_TYPE_GAME_ROTATION_VECTOR = "android.sensor.game_rotation_vector";
    public static final int TYPE_GYROSCOPE_UNCALIBRATED = 16;
    public static final String STRING_TYPE_GYROSCOPE_UNCALIBRATED = "android.sensor.gyroscope_uncalibrated";
    public static final int TYPE_SIGNIFICANT_MOTION = 17;
    public static final String STRING_TYPE_SIGNIFICANT_MOTION = "android.sensor.significant_motion";
    public static final int TYPE_STEP_DETECTOR = 18;
    public static final String STRING_TYPE_STEP_DETECTOR = "android.sensor.step_detector";
    public static final int TYPE_STEP_COUNTER = 19;
    public static final String STRING_TYPE_STEP_COUNTER = "android.sensor.step_counter";
    public static final int TYPE_GEOMAGNETIC_ROTATION_VECTOR = 20;
    public static final String STRING_TYPE_GEOMAGNETIC_ROTATION_VECTOR = "android.sensor.geomagnetic_rotation_vector";
    public static final int TYPE_HEART_RATE = 21;
    public static final String STRING_TYPE_HEART_RATE = "android.sensor.heart_rate";
    public static final int TYPE_TILT_DETECTOR = 22;
    public static final String SENSOR_STRING_TYPE_TILT_DETECTOR = "android.sensor.tilt_detector";
    public static final int TYPE_WAKE_GESTURE = 23;
    public static final String STRING_TYPE_WAKE_GESTURE = "android.sensor.wake_gesture";
    public static final int TYPE_GLANCE_GESTURE = 24;
    public static final String STRING_TYPE_GLANCE_GESTURE = "android.sensor.glance_gesture";
    public static final int TYPE_PICK_UP_GESTURE = 25;
    public static final String STRING_TYPE_PICK_UP_GESTURE = "android.sensor.pick_up_gesture";
    public static final int TYPE_ALL = -1;
    private static final int SENSOR_FLAG_WAKE_UP_SENSOR = 1;
    public static final int REPORTING_MODE_CONTINUOUS = 0;
    public static final int REPORTING_MODE_ON_CHANGE = 1;
    public static final int REPORTING_MODE_ONE_SHOT = 2;
    public static final int REPORTING_MODE_SPECIAL_TRIGGER = 3;
    private static final int REPORTING_MODE_MASK = 14;
    private static final int REPORTING_MODE_SHIFT = 1;
    private static final int[] sSensorReportingModes = new int[]{0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 5, 3, 3, 6, 4, 6, 1, 1, 1, 5, 1, 1, 1, 1, 1};
    private String mName;
    private String mVendor;
    private int mVersion;
    private int mHandle;
    private int mType;
    private float mMaxRange;
    private float mResolution;
    private float mPower;
    private int mMinDelay;
    private int mFifoReservedEventCount;
    private int mFifoMaxEventCount;
    private String mStringType;
    private String mRequiredPermission;
    private int mMaxDelay;
    private int mFlags;

    public int getReportingMode() {
        return (this.mFlags & 0xE) >> 1;
    }

    static int getMaxLengthValuesArray(Sensor sensor, int sdkLevel) {
        if (sensor.mType == 11 && sdkLevel <= 17) {
            return 3;
        }
        int offset = sensor.mType;
        if (offset >= sSensorReportingModes.length) {
            return 16;
        }
        return sSensorReportingModes[offset];
    }

    Sensor() {
    }

    public String getName() {
        return this.mName;
    }

    public String getVendor() {
        return this.mVendor;
    }

    public int getType() {
        return this.mType;
    }

    public int getVersion() {
        return this.mVersion;
    }

    public float getMaximumRange() {
        return this.mMaxRange;
    }

    public float getResolution() {
        return this.mResolution;
    }

    public float getPower() {
        return this.mPower;
    }

    public int getMinDelay() {
        return this.mMinDelay;
    }

    public int getFifoReservedEventCount() {
        return this.mFifoReservedEventCount;
    }

    public int getFifoMaxEventCount() {
        return this.mFifoMaxEventCount;
    }

    public String getStringType() {
        return this.mStringType;
    }

    public String getRequiredPermission() {
        return this.mRequiredPermission;
    }

    public int getHandle() {
        return this.mHandle;
    }

    public int getMaxDelay() {
        return this.mMaxDelay;
    }

    public boolean isWakeUpSensor() {
        return (this.mFlags & 1) != 0;
    }

    void setRange(float max, float res) {
        this.mMaxRange = max;
        this.mResolution = res;
    }

    public String toString() {
        return "{Sensor name=\"" + this.mName + "\", vendor=\"" + this.mVendor + "\", version=" + this.mVersion + ", type=" + this.mType + ", maxRange=" + this.mMaxRange + ", resolution=" + this.mResolution + ", power=" + this.mPower + ", minDelay=" + this.mMinDelay + "}";
    }
}

