/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Paint_Delegate;
import android.graphics.RectF;
import com.android.layoutlib.bridge.Bridge;
import com.ibm.icu.lang.UScriptRun;
import com.ibm.icu.text.Bidi;
import com.ibm.icu.text.BidiRun;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class BidiRenderer {
    private final Graphics2D mGraphics;
    private final Paint_Delegate mPaint;
    private char[] mText;
    private List<Font> mFonts;
    private RectF mBounds;
    private float mBaseline;

    public BidiRenderer(Graphics2D graphics, Paint_Delegate paint, char[] text) {
        assert (paint != null);
        this.mGraphics = graphics;
        this.mPaint = paint;
        this.mText = text;
        this.mFonts = new ArrayList<Font>(paint.getFonts().size());
        for (Paint_Delegate.FontInfo fontInfo : paint.getFonts()) {
            if (fontInfo == null) {
                this.mFonts.add(null);
                continue;
            }
            this.mFonts.add(fontInfo.mFont);
        }
        this.mBounds = new RectF();
    }

    public BidiRenderer setRenderLocation(float x, float y) {
        this.mBounds = new RectF(x, y, x, y);
        this.mBaseline = y;
        return this;
    }

    public RectF renderText(int start, int limit, int bidiFlags, float[] advances, int advancesIndex, boolean draw) {
        Bidi bidi = new Bidi(this.mText, start, null, 0, limit - start, BidiRenderer.getIcuFlags(bidiFlags));
        for (int i = 0; i < bidi.countRuns(); ++i) {
            BidiRun visualRun = bidi.getVisualRun(i);
            boolean isRtl = visualRun.getDirection() == 1;
            this.renderText(visualRun.getStart(), visualRun.getLimit(), isRtl, advances, advancesIndex, draw);
        }
        return this.mBounds;
    }

    public RectF renderText(int start, int limit, boolean isRtl, float[] advances, int advancesIndex, boolean draw) {
        for (ScriptRun run : BidiRenderer.getScriptRuns(this.mText, start, limit, isRtl, this.mFonts)) {
            int flag = 6;
            this.renderScript(run.start, run.limit, run.font, flag |= isRtl ? 1 : 0, advances, advancesIndex, draw);
            advancesIndex += run.limit - run.start;
        }
        return this.mBounds;
    }

    private void renderScript(int start, int limit, Font preferredFont, int flag, float[] advances, int advancesIndex, boolean draw) {
        if (this.mFonts.size() == 0 || preferredFont == null) {
            return;
        }
        while (start < limit) {
            boolean foundFont = false;
            int canDisplayUpTo = preferredFont.canDisplayUpTo(this.mText, start, limit);
            if (canDisplayUpTo == -1) {
                this.render(start, limit, preferredFont, flag, advances, advancesIndex, draw);
                return;
            }
            if (canDisplayUpTo > start) {
                this.render(start, canDisplayUpTo, preferredFont, flag, advances, advancesIndex, draw);
                advancesIndex += canDisplayUpTo - start;
                start = canDisplayUpTo;
            }
            int charCount = Character.isHighSurrogate(this.mText[start]) ? 2 : 1;
            for (Font font : this.mFonts) {
                if (font == null) {
                    BidiRenderer.logFontWarning();
                    continue;
                }
                canDisplayUpTo = font.canDisplayUpTo(this.mText, start, start + charCount);
                if (canDisplayUpTo != -1) continue;
                this.render(start, start + charCount, font, flag, advances, advancesIndex, draw);
                start += charCount;
                advancesIndex += charCount;
                foundFont = true;
                break;
            }
            if (foundFont) continue;
            this.render(start, start + charCount, preferredFont, flag, advances, advancesIndex, draw);
            start += charCount;
            advancesIndex += charCount;
        }
    }

    private static void logFontWarning() {
        Bridge.getLog().fidelityWarning("broken", "Some fonts could not be loaded. The rendering may not be perfect. Try running the IDE with JRE 7.", null, null);
    }

    private void render(int start, int limit, Font font, int flag, float[] advances, int advancesIndex, boolean draw) {
        FontRenderContext frc;
        if (this.mGraphics != null) {
            frc = this.mGraphics.getFontRenderContext();
        } else {
            frc = Toolkit.getDefaultToolkit().getFontMetrics(font).getFontRenderContext();
            frc = new FontRenderContext(font.getTransform(), this.mPaint.isAntiAliased(), frc.usesFractionalMetrics());
        }
        GlyphVector gv = font.layoutGlyphVector(frc, this.mText, start, limit, flag);
        int ng = gv.getNumGlyphs();
        int[] ci = gv.getGlyphCharIndices(0, ng, null);
        if (advances != null) {
            for (int i = 0; i < ng; ++i) {
                int adv_idx;
                int n = adv_idx = advancesIndex + ci[i];
                advances[n] = advances[n] + gv.getGlyphMetrics(i).getAdvanceX();
            }
        }
        if (draw && this.mGraphics != null) {
            this.mGraphics.drawGlyphVector(gv, this.mBounds.right, this.mBaseline);
        }
        Rectangle2D awtBounds = gv.getLogicalBounds();
        RectF bounds = BidiRenderer.awtRectToAndroidRect(awtBounds, this.mBounds.right, this.mBaseline);
        if (Math.abs(this.mBounds.right - this.mBounds.left) == 0.0f) {
            this.mBounds = bounds;
        } else {
            this.mBounds.union(bounds);
        }
    }

    private static RectF awtRectToAndroidRect(Rectangle2D awtRec, float offsetX, float offsetY) {
        float left = (float)awtRec.getX();
        float top = (float)awtRec.getY();
        float right = (float)((double)left + awtRec.getWidth());
        float bottom = (float)((double)top + awtRec.getHeight());
        RectF androidRect = new RectF(left, top, right, bottom);
        androidRect.offset(offsetX, offsetY);
        return androidRect;
    }

    static List<ScriptRun> getScriptRuns(char[] text, int start, int limit, boolean isRtl, List<Font> fonts) {
        LinkedList<ScriptRun> scriptRuns = new LinkedList<ScriptRun>();
        int count = limit - start;
        UScriptRun uScriptRun = new UScriptRun(text, start, count);
        while (uScriptRun.next()) {
            int scriptStart = uScriptRun.getScriptStart();
            int scriptLimit = uScriptRun.getScriptLimit();
            ScriptRun run = new ScriptRun(scriptStart, scriptLimit, isRtl);
            run.scriptCode = uScriptRun.getScriptCode();
            BidiRenderer.setScriptFont(text, run, fonts);
            scriptRuns.add(run);
        }
        return scriptRuns;
    }

    private static void setScriptFont(char[] text, ScriptRun run, List<Font> fonts) {
        for (Font font : fonts) {
            if (font == null) {
                BidiRenderer.logFontWarning();
                continue;
            }
            if (font.canDisplayUpTo(text, run.start, run.limit) != -1) continue;
            run.font = font;
            return;
        }
        run.font = fonts.get(0);
    }

    private static int getIcuFlags(int bidiFlag) {
        switch (bidiFlag) {
            case 0: 
            case 4: {
                return 0;
            }
            case 1: 
            case 5: {
                return 1;
            }
            case 2: {
                return 126;
            }
            case 3: {
                return 127;
            }
        }
        assert (false);
        return 126;
    }

    private static class ScriptRun {
        int start;
        int limit;
        boolean isRtl;
        int scriptCode;
        Font font;

        public ScriptRun(int start, int limit, boolean isRtl) {
            this.start = start;
            this.limit = limit;
            this.isRtl = isRtl;
            this.scriptCode = -1;
        }
    }
}

