/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.BridgeTypedArray;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.TypedValue;
import com.android.annotations.Nullable;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.layoutlib.bridge.impl.RenderSessionImpl;
import com.android.resources.ResourceType;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;

public class Resources_Theme_Delegate {
    private static final DelegateManager<Resources_Theme_Delegate> sManager = new DelegateManager<Resources_Theme_Delegate>(Resources_Theme_Delegate.class);

    public static DelegateManager<Resources_Theme_Delegate> getDelegateManager() {
        return sManager;
    }

    @LayoutlibDelegate
    static TypedArray obtainStyledAttributes(Resources thisResources, Resources.Theme thisTheme, int[] attrs) {
        boolean changed = Resources_Theme_Delegate.setupResources(thisTheme);
        BridgeTypedArray ta = RenderSessionImpl.getCurrentContext().obtainStyledAttributes(attrs);
        ta.setTheme(thisTheme);
        Resources_Theme_Delegate.restoreResources(changed);
        return ta;
    }

    @LayoutlibDelegate
    static TypedArray obtainStyledAttributes(Resources thisResources, Resources.Theme thisTheme, int resid, int[] attrs) throws Resources.NotFoundException {
        boolean changed = Resources_Theme_Delegate.setupResources(thisTheme);
        BridgeTypedArray ta = RenderSessionImpl.getCurrentContext().obtainStyledAttributes(resid, attrs);
        ta.setTheme(thisTheme);
        Resources_Theme_Delegate.restoreResources(changed);
        return ta;
    }

    @LayoutlibDelegate
    static TypedArray obtainStyledAttributes(Resources thisResources, Resources.Theme thisTheme, AttributeSet set, int[] attrs, int defStyleAttr, int defStyleRes) {
        boolean changed = Resources_Theme_Delegate.setupResources(thisTheme);
        BridgeTypedArray ta = RenderSessionImpl.getCurrentContext().obtainStyledAttributes(set, attrs, defStyleAttr, defStyleRes);
        ta.setTheme(thisTheme);
        Resources_Theme_Delegate.restoreResources(changed);
        return ta;
    }

    @LayoutlibDelegate
    static boolean resolveAttribute(Resources thisResources, Resources.Theme thisTheme, int resid, TypedValue outValue, boolean resolveRefs) {
        boolean changed = Resources_Theme_Delegate.setupResources(thisTheme);
        boolean found = RenderSessionImpl.getCurrentContext().resolveThemeAttribute(resid, outValue, resolveRefs);
        Resources_Theme_Delegate.restoreResources(changed);
        return found;
    }

    @LayoutlibDelegate
    static TypedArray resolveAttributes(Resources thisResources, Resources.Theme thisTheme, int[] values, int[] attrs) {
        return null;
    }

    private static boolean setupResources(Resources.Theme thisTheme) {
        String[] appliedStyles = thisTheme.getKey().split(" ");
        boolean changed = false;
        for (String s : appliedStyles) {
            int styleId;
            StyleResourceValue style2;
            if (s.isEmpty()) continue;
            boolean force = false;
            if (s.charAt(s.length() - 1) == '!') {
                force = true;
                s = s.substring(0, s.length() - 1);
            }
            if ((style2 = Resources_Theme_Delegate.resolveStyle(styleId = Integer.parseInt(s, 16))) == null) continue;
            RenderSessionImpl.getCurrentContext().getRenderResources().applyStyle(style2, force);
            changed = true;
        }
        return changed;
    }

    private static void restoreResources(boolean changed) {
        if (changed) {
            RenderSessionImpl.getCurrentContext().getRenderResources().clearStyles();
        }
    }

    @Nullable
    private static StyleResourceValue resolveStyle(int nativeResid) {
        if (nativeResid == 0) {
            return null;
        }
        BridgeContext context = RenderSessionImpl.getCurrentContext();
        ResourceReference theme = context.resolveId(nativeResid);
        if (theme.isFramework()) {
            return (StyleResourceValue)context.getRenderResources().getFrameworkResource(ResourceType.STYLE, theme.getName());
        }
        return (StyleResourceValue)context.getRenderResources().getProjectResource(ResourceType.STYLE, theme.getName());
    }
}

