/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.BridgeTypedArray;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.android.ide.common.rendering.api.IProjectCallback;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.BridgeXmlBlockParser;
import com.android.layoutlib.bridge.impl.ParserFactory;
import com.android.layoutlib.bridge.impl.ResourceHelper;
import com.android.resources.ResourceType;
import com.android.util.Pair;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class BridgeResources
extends Resources {
    private BridgeContext mContext;
    private IProjectCallback mProjectCallback;
    private boolean[] mPlatformResourceFlag = new boolean[1];
    private TypedValue mTmpValue = new TypedValue();

    public static Resources initSystem(BridgeContext context, AssetManager assets, DisplayMetrics metrics, Configuration config, IProjectCallback projectCallback) {
        Resources.mSystem = new BridgeResources(context, assets, metrics, config, projectCallback);
        return Resources.mSystem;
    }

    public static void disposeSystem() {
        if (Resources.mSystem instanceof BridgeResources) {
            ((BridgeResources)Resources.mSystem).mContext = null;
            ((BridgeResources)Resources.mSystem).mProjectCallback = null;
        }
        Resources.mSystem = null;
    }

    private BridgeResources(BridgeContext context, AssetManager assets, DisplayMetrics metrics, Configuration config, IProjectCallback projectCallback) {
        super(assets, metrics, config);
        this.mContext = context;
        this.mProjectCallback = projectCallback;
    }

    public BridgeTypedArray newTypeArray(int numEntries, boolean platformFile) {
        return new BridgeTypedArray(this, this.mContext, numEntries, platformFile);
    }

    private Pair<String, ResourceValue> getResourceValue(int id2, boolean[] platformResFlag_out) {
        Pair resourceInfo = Bridge.resolveResourceId(id2);
        if (resourceInfo != null) {
            platformResFlag_out[0] = true;
            String attributeName = (String)resourceInfo.getSecond();
            return Pair.of((Object)attributeName, (Object)this.mContext.getRenderResources().getFrameworkResource((ResourceType)resourceInfo.getFirst(), attributeName));
        }
        if (this.mProjectCallback != null && (resourceInfo = this.mProjectCallback.resolveResourceId(id2)) != null) {
            platformResFlag_out[0] = false;
            String attributeName = (String)resourceInfo.getSecond();
            return Pair.of((Object)attributeName, (Object)this.mContext.getRenderResources().getProjectResource((ResourceType)resourceInfo.getFirst(), attributeName));
        }
        return null;
    }

    @Override
    public Drawable getDrawable(int id2) throws Resources.NotFoundException {
        return this.getDrawable(id2, null);
    }

    @Override
    public Drawable getDrawable(int id2, Resources.Theme theme) {
        Pair<String, ResourceValue> value = this.getResourceValue(id2, this.mPlatformResourceFlag);
        if (value != null) {
            return ResourceHelper.getDrawable((ResourceValue)value.getSecond(), this.mContext, theme);
        }
        this.throwException(id2);
        return null;
    }

    @Override
    public int getColor(int id2) throws Resources.NotFoundException {
        Pair<String, ResourceValue> value = this.getResourceValue(id2, this.mPlatformResourceFlag);
        if (value != null) {
            try {
                return ResourceHelper.getColor(((ResourceValue)value.getSecond()).getValue());
            }
            catch (NumberFormatException e) {
                Bridge.getLog().error("resources.format", e.getMessage(), (Throwable)e, null);
                return 0;
            }
        }
        this.throwException(id2);
        return 0;
    }

    @Override
    public ColorStateList getColorStateList(int id2) throws Resources.NotFoundException {
        ColorStateList stateList;
        Pair<String, ResourceValue> resValue = this.getResourceValue(id2, this.mPlatformResourceFlag);
        if (resValue != null && (stateList = ResourceHelper.getColorStateList((ResourceValue)resValue.getSecond(), this.mContext)) != null) {
            return stateList;
        }
        this.throwException(id2);
        return null;
    }

    @Override
    public CharSequence getText(int id2) throws Resources.NotFoundException {
        Pair<String, ResourceValue> value = this.getResourceValue(id2, this.mPlatformResourceFlag);
        if (value != null) {
            String v;
            ResourceValue resValue = (ResourceValue)value.getSecond();
            assert (resValue != null);
            if (resValue != null && (v = resValue.getValue()) != null) {
                return v;
            }
        }
        this.throwException(id2);
        return null;
    }

    @Override
    public XmlResourceParser getLayout(int id2) throws Resources.NotFoundException {
        Pair<String, ResourceValue> v = this.getResourceValue(id2, this.mPlatformResourceFlag);
        if (v != null) {
            ResourceValue value = (ResourceValue)v.getSecond();
            Object parser = null;
            try {
                File xml2;
                if (!this.mPlatformResourceFlag[0]) {
                    parser = this.mProjectCallback.getParser(value);
                }
                if (parser == null && (xml2 = new File(value.getValue())).isFile()) {
                    parser = ParserFactory.create(xml2);
                }
                if (parser != null) {
                    return new BridgeXmlBlockParser((XmlPullParser)parser, this.mContext, this.mPlatformResourceFlag[0]);
                }
            }
            catch (XmlPullParserException e) {
                Bridge.getLog().error("broken", "Failed to configure parser for " + value.getValue(), (Throwable)e, null);
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
        }
        this.throwException(id2);
        return null;
    }

    @Override
    public XmlResourceParser getAnimation(int id2) throws Resources.NotFoundException {
        Pair<String, ResourceValue> v = this.getResourceValue(id2, this.mPlatformResourceFlag);
        if (v != null) {
            ResourceValue value = (ResourceValue)v.getSecond();
            XmlPullParser parser = null;
            try {
                File xml2 = new File(value.getValue());
                if (xml2.isFile()) {
                    parser = ParserFactory.create(xml2);
                    return new BridgeXmlBlockParser(parser, this.mContext, this.mPlatformResourceFlag[0]);
                }
            }
            catch (XmlPullParserException e) {
                Bridge.getLog().error("broken", "Failed to configure parser for " + value.getValue(), (Throwable)e, null);
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
        }
        this.throwException(id2);
        return null;
    }

    @Override
    public TypedArray obtainAttributes(AttributeSet set, int[] attrs) {
        return this.mContext.obtainStyledAttributes(set, attrs);
    }

    @Override
    public TypedArray obtainTypedArray(int id2) throws Resources.NotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getDimension(int id2) throws Resources.NotFoundException {
        Pair<String, ResourceValue> value = this.getResourceValue(id2, this.mPlatformResourceFlag);
        if (value != null) {
            String v;
            ResourceValue resValue = (ResourceValue)value.getSecond();
            assert (resValue != null);
            if (resValue != null && (v = resValue.getValue()) != null) {
                if (v.equals("match_parent") || v.equals("fill_parent")) {
                    return -1.0f;
                }
                if (v.equals("wrap_content")) {
                    return -2.0f;
                }
                if (ResourceHelper.parseFloatAttribute((String)value.getFirst(), v, this.mTmpValue, true) && this.mTmpValue.type == 5) {
                    return this.mTmpValue.getDimension(this.getDisplayMetrics());
                }
            }
        }
        this.throwException(id2);
        return 0.0f;
    }

    @Override
    public int getDimensionPixelOffset(int id2) throws Resources.NotFoundException {
        Pair<String, ResourceValue> value = this.getResourceValue(id2, this.mPlatformResourceFlag);
        if (value != null) {
            String v;
            ResourceValue resValue = (ResourceValue)value.getSecond();
            assert (resValue != null);
            if (resValue != null && (v = resValue.getValue()) != null && ResourceHelper.parseFloatAttribute((String)value.getFirst(), v, this.mTmpValue, true) && this.mTmpValue.type == 5) {
                return TypedValue.complexToDimensionPixelOffset(this.mTmpValue.data, this.getDisplayMetrics());
            }
        }
        this.throwException(id2);
        return 0;
    }

    @Override
    public int getDimensionPixelSize(int id2) throws Resources.NotFoundException {
        Pair<String, ResourceValue> value = this.getResourceValue(id2, this.mPlatformResourceFlag);
        if (value != null) {
            String v;
            ResourceValue resValue = (ResourceValue)value.getSecond();
            assert (resValue != null);
            if (resValue != null && (v = resValue.getValue()) != null && ResourceHelper.parseFloatAttribute((String)value.getFirst(), v, this.mTmpValue, true) && this.mTmpValue.type == 5) {
                return TypedValue.complexToDimensionPixelSize(this.mTmpValue.data, this.getDisplayMetrics());
            }
        }
        this.throwException(id2);
        return 0;
    }

    @Override
    public int getInteger(int id2) throws Resources.NotFoundException {
        Pair<String, ResourceValue> value = this.getResourceValue(id2, this.mPlatformResourceFlag);
        if (value != null) {
            String v;
            ResourceValue resValue = (ResourceValue)value.getSecond();
            assert (resValue != null);
            if (resValue != null && (v = resValue.getValue()) != null) {
                int radix = 10;
                if (v.startsWith("0x")) {
                    v = v.substring(2);
                    radix = 16;
                }
                try {
                    return Integer.parseInt(v, radix);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        this.throwException(id2);
        return 0;
    }

    @Override
    public boolean getBoolean(int id2) throws Resources.NotFoundException {
        Pair<String, ResourceValue> value = this.getResourceValue(id2, this.mPlatformResourceFlag);
        if (value != null) {
            String v;
            ResourceValue resValue = (ResourceValue)value.getSecond();
            assert (resValue != null);
            if (resValue != null && (v = resValue.getValue()) != null) {
                return Boolean.parseBoolean(v);
            }
        }
        this.throwException(id2);
        return false;
    }

    @Override
    public String getResourceEntryName(int resid) throws Resources.NotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getResourceName(int resid) throws Resources.NotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getResourceTypeName(int resid) throws Resources.NotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getString(int id2, Object ... formatArgs) throws Resources.NotFoundException {
        String s = this.getString(id2);
        if (s != null) {
            return String.format(s, formatArgs);
        }
        this.throwException(id2);
        return null;
    }

    @Override
    public String getString(int id2) throws Resources.NotFoundException {
        Pair<String, ResourceValue> value = this.getResourceValue(id2, this.mPlatformResourceFlag);
        if (value != null && ((ResourceValue)value.getSecond()).getValue() != null) {
            return ((ResourceValue)value.getSecond()).getValue();
        }
        this.throwException(id2);
        return null;
    }

    @Override
    public void getValue(int id2, TypedValue outValue, boolean resolveRefs) throws Resources.NotFoundException {
        String v;
        Pair<String, ResourceValue> value = this.getResourceValue(id2, this.mPlatformResourceFlag);
        if (value != null && (v = ((ResourceValue)value.getSecond()).getValue()) != null) {
            if (ResourceHelper.parseFloatAttribute((String)value.getFirst(), v, outValue, false)) {
                return;
            }
            outValue.type = 3;
            outValue.string = v;
            return;
        }
        this.throwException(id2);
    }

    @Override
    public void getValue(String name, TypedValue outValue, boolean resolveRefs) throws Resources.NotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public XmlResourceParser getXml(int id2) throws Resources.NotFoundException {
        File f;
        String v;
        Pair<String, ResourceValue> value = this.getResourceValue(id2, this.mPlatformResourceFlag);
        if (value != null && (v = ((ResourceValue)value.getSecond()).getValue()) != null && (f = new File(v)).isFile()) {
            try {
                XmlPullParser parser = ParserFactory.create(f);
                return new BridgeXmlBlockParser(parser, this.mContext, this.mPlatformResourceFlag[0]);
            }
            catch (XmlPullParserException e) {
                Resources.NotFoundException newE = new Resources.NotFoundException();
                newE.initCause(e);
                throw newE;
            }
            catch (FileNotFoundException e) {
                Resources.NotFoundException newE = new Resources.NotFoundException();
                newE.initCause(e);
                throw newE;
            }
        }
        this.throwException(id2);
        return null;
    }

    @Override
    public XmlResourceParser loadXmlResourceParser(String file, int id2, int assetCookie, String type) throws Resources.NotFoundException {
        this.getResourceValue(id2, this.mPlatformResourceFlag);
        File f = new File(file);
        try {
            XmlPullParser parser = ParserFactory.create(f);
            return new BridgeXmlBlockParser(parser, this.mContext, this.mPlatformResourceFlag[0]);
        }
        catch (XmlPullParserException e) {
            Resources.NotFoundException newE = new Resources.NotFoundException();
            newE.initCause(e);
            throw newE;
        }
        catch (FileNotFoundException e) {
            Resources.NotFoundException newE = new Resources.NotFoundException();
            newE.initCause(e);
            throw newE;
        }
    }

    @Override
    public InputStream openRawResource(int id2) throws Resources.NotFoundException {
        File f;
        String path;
        Pair<String, ResourceValue> value = this.getResourceValue(id2, this.mPlatformResourceFlag);
        if (value != null && (path = ((ResourceValue)value.getSecond()).getValue()) != null && (f = new File(path)).isFile()) {
            try {
                if (path.toLowerCase().endsWith(".9.png")) {
                    return new NinePatchInputStream(f);
                }
                return new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                Resources.NotFoundException newE = new Resources.NotFoundException();
                newE.initCause(e);
                throw newE;
            }
        }
        this.throwException(id2);
        return null;
    }

    @Override
    public InputStream openRawResource(int id2, TypedValue value) throws Resources.NotFoundException {
        this.getValue(id2, value, true);
        String path = value.string.toString();
        File f = new File(path);
        if (f.isFile()) {
            try {
                if (path.toLowerCase().endsWith(".9.png")) {
                    return new NinePatchInputStream(f);
                }
                return new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                Resources.NotFoundException exception = new Resources.NotFoundException();
                exception.initCause(e);
                throw exception;
            }
        }
        throw new Resources.NotFoundException();
    }

    @Override
    public AssetFileDescriptor openRawResourceFd(int id2) throws Resources.NotFoundException {
        throw new UnsupportedOperationException();
    }

    private void throwException(int id2) throws Resources.NotFoundException {
        Pair resourceInfo = Bridge.resolveResourceId(id2);
        if (resourceInfo == null && this.mProjectCallback != null) {
            resourceInfo = this.mProjectCallback.resolveResourceId(id2);
        }
        String message = null;
        message = resourceInfo != null ? String.format("Could not find %1$s resource matching value 0x%2$X (resolved name: %3$s) in current configuration.", resourceInfo.getFirst(), id2, resourceInfo.getSecond()) : String.format("Could not resolve resource value: 0x%1$X.", id2);
        throw new Resources.NotFoundException(message);
    }

    public class NinePatchInputStream
    extends FileInputStream {
        private boolean mFakeMarkSupport;

        public NinePatchInputStream(File file) throws FileNotFoundException {
            super(file);
            this.mFakeMarkSupport = true;
        }

        @Override
        public boolean markSupported() {
            if (this.mFakeMarkSupport) {
                return true;
            }
            return super.markSupported();
        }

        public void disableFakeMarkSupport() {
            this.mFakeMarkSupport = false;
        }
    }
}

