/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.animation.AnimatorListenerAdapter;
import android.app.Activity;
import android.app.BackStackRecord;
import android.app.BackStackState;
import android.app.Fragment;
import android.app.FragmentContainer;
import android.app.FragmentManager;
import android.app.FragmentManagerState;
import android.app.FragmentState;
import android.app.FragmentTransaction;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.DebugUtils;
import android.util.Log;
import android.util.LogWriter;
import android.util.SparseArray;
import android.util.SuperNotCalledException;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import com.android.internal.R;
import com.android.internal.util.FastPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;

class FragmentManagerImpl
extends FragmentManager
implements LayoutInflater.Factory2 {
    static boolean DEBUG = false;
    static final String TAG = "FragmentManager";
    static final String TARGET_REQUEST_CODE_STATE_TAG = "android:target_req_state";
    static final String TARGET_STATE_TAG = "android:target_state";
    static final String VIEW_STATE_TAG = "android:view_state";
    static final String USER_VISIBLE_HINT_TAG = "android:user_visible_hint";
    ArrayList<Runnable> mPendingActions;
    Runnable[] mTmpActions;
    boolean mExecutingActions;
    ArrayList<Fragment> mActive;
    ArrayList<Fragment> mAdded;
    ArrayList<Integer> mAvailIndices;
    ArrayList<BackStackRecord> mBackStack;
    ArrayList<Fragment> mCreatedMenus;
    ArrayList<BackStackRecord> mBackStackIndices;
    ArrayList<Integer> mAvailBackStackIndices;
    ArrayList<FragmentManager.OnBackStackChangedListener> mBackStackChangeListeners;
    int mCurState = 0;
    Activity mActivity;
    FragmentContainer mContainer;
    Fragment mParent;
    boolean mNeedMenuInvalidate;
    boolean mStateSaved;
    boolean mDestroyed;
    String mNoTransactionsBecause;
    boolean mHavePendingDeferredStart;
    Bundle mStateBundle = null;
    SparseArray<Parcelable> mStateArray = null;
    Runnable mExecCommit = new Runnable(){

        @Override
        public void run() {
            FragmentManagerImpl.this.execPendingActions();
        }
    };

    FragmentManagerImpl() {
    }

    private void throwException(RuntimeException ex) {
        Log.e(TAG, ex.getMessage());
        LogWriter logw = new LogWriter(6, TAG);
        FastPrintWriter pw = new FastPrintWriter(logw, false, 1024);
        if (this.mActivity != null) {
            Log.e(TAG, "Activity state:");
            try {
                this.mActivity.dump("  ", null, pw, new String[0]);
            }
            catch (Exception e) {
                ((PrintWriter)pw).flush();
                Log.e(TAG, "Failed dumping state", e);
            }
        } else {
            Log.e(TAG, "Fragment manager state:");
            try {
                this.dump("  ", null, pw, new String[0]);
            }
            catch (Exception e) {
                ((PrintWriter)pw).flush();
                Log.e(TAG, "Failed dumping state", e);
            }
        }
        ((PrintWriter)pw).flush();
        throw ex;
    }

    @Override
    public FragmentTransaction beginTransaction() {
        return new BackStackRecord(this);
    }

    @Override
    public boolean executePendingTransactions() {
        return this.execPendingActions();
    }

    @Override
    public void popBackStack() {
        this.enqueueAction(new Runnable(){

            @Override
            public void run() {
                FragmentManagerImpl.this.popBackStackState(FragmentManagerImpl.this.mActivity.mHandler, null, -1, 0);
            }
        }, false);
    }

    @Override
    public boolean popBackStackImmediate() {
        this.checkStateLoss();
        this.executePendingTransactions();
        return this.popBackStackState(this.mActivity.mHandler, null, -1, 0);
    }

    @Override
    public void popBackStack(final String name, final int flags) {
        this.enqueueAction(new Runnable(){

            @Override
            public void run() {
                FragmentManagerImpl.this.popBackStackState(FragmentManagerImpl.this.mActivity.mHandler, name, -1, flags);
            }
        }, false);
    }

    @Override
    public boolean popBackStackImmediate(String name, int flags) {
        this.checkStateLoss();
        this.executePendingTransactions();
        return this.popBackStackState(this.mActivity.mHandler, name, -1, flags);
    }

    @Override
    public void popBackStack(final int id2, final int flags) {
        if (id2 < 0) {
            throw new IllegalArgumentException("Bad id: " + id2);
        }
        this.enqueueAction(new Runnable(){

            @Override
            public void run() {
                FragmentManagerImpl.this.popBackStackState(FragmentManagerImpl.this.mActivity.mHandler, null, id2, flags);
            }
        }, false);
    }

    @Override
    public boolean popBackStackImmediate(int id2, int flags) {
        this.checkStateLoss();
        this.executePendingTransactions();
        if (id2 < 0) {
            throw new IllegalArgumentException("Bad id: " + id2);
        }
        return this.popBackStackState(this.mActivity.mHandler, null, id2, flags);
    }

    @Override
    public int getBackStackEntryCount() {
        return this.mBackStack != null ? this.mBackStack.size() : 0;
    }

    @Override
    public FragmentManager.BackStackEntry getBackStackEntryAt(int index) {
        return this.mBackStack.get(index);
    }

    @Override
    public void addOnBackStackChangedListener(FragmentManager.OnBackStackChangedListener listener) {
        if (this.mBackStackChangeListeners == null) {
            this.mBackStackChangeListeners = new ArrayList();
        }
        this.mBackStackChangeListeners.add(listener);
    }

    @Override
    public void removeOnBackStackChangedListener(FragmentManager.OnBackStackChangedListener listener) {
        if (this.mBackStackChangeListeners != null) {
            this.mBackStackChangeListeners.remove(listener);
        }
    }

    @Override
    public void putFragment(Bundle bundle, String key, Fragment fragment) {
        if (fragment.mIndex < 0) {
            this.throwException(new IllegalStateException("Fragment " + fragment + " is not currently in the FragmentManager"));
        }
        bundle.putInt(key, fragment.mIndex);
    }

    @Override
    public Fragment getFragment(Bundle bundle, String key) {
        Fragment f;
        int index = bundle.getInt(key, -1);
        if (index == -1) {
            return null;
        }
        if (index >= this.mActive.size()) {
            this.throwException(new IllegalStateException("Fragment no longer exists for key " + key + ": index " + index));
        }
        if ((f = this.mActive.get(index)) == null) {
            this.throwException(new IllegalStateException("Fragment no longer exists for key " + key + ": index " + index));
        }
        return f;
    }

    @Override
    public Fragment.SavedState saveFragmentInstanceState(Fragment fragment) {
        if (fragment.mIndex < 0) {
            this.throwException(new IllegalStateException("Fragment " + fragment + " is not currently in the FragmentManager"));
        }
        if (fragment.mState > 0) {
            Bundle result = this.saveFragmentBasicState(fragment);
            return result != null ? new Fragment.SavedState(result) : null;
        }
        return null;
    }

    @Override
    public boolean isDestroyed() {
        return this.mDestroyed;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("FragmentManager{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(" in ");
        if (this.mParent != null) {
            DebugUtils.buildShortClassTag(this.mParent, sb);
        } else {
            DebugUtils.buildShortClassTag(this.mActivity, sb);
        }
        sb.append("}}");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        Fragment f;
        int i;
        int N;
        String innerPrefix = prefix + "    ";
        if (this.mActive != null && (N = this.mActive.size()) > 0) {
            writer.print(prefix);
            writer.print("Active Fragments in ");
            writer.print(Integer.toHexString(System.identityHashCode(this)));
            writer.println(":");
            for (i = 0; i < N; ++i) {
                f = this.mActive.get(i);
                writer.print(prefix);
                writer.print("  #");
                writer.print(i);
                writer.print(": ");
                writer.println(f);
                if (f == null) continue;
                f.dump(innerPrefix, fd, writer, args);
            }
        }
        if (this.mAdded != null && (N = this.mAdded.size()) > 0) {
            writer.print(prefix);
            writer.println("Added Fragments:");
            for (i = 0; i < N; ++i) {
                f = this.mAdded.get(i);
                writer.print(prefix);
                writer.print("  #");
                writer.print(i);
                writer.print(": ");
                writer.println(f.toString());
            }
        }
        if (this.mCreatedMenus != null && (N = this.mCreatedMenus.size()) > 0) {
            writer.print(prefix);
            writer.println("Fragments Created Menus:");
            for (i = 0; i < N; ++i) {
                f = this.mCreatedMenus.get(i);
                writer.print(prefix);
                writer.print("  #");
                writer.print(i);
                writer.print(": ");
                writer.println(f.toString());
            }
        }
        if (this.mBackStack != null && (N = this.mBackStack.size()) > 0) {
            writer.print(prefix);
            writer.println("Back Stack:");
            for (i = 0; i < N; ++i) {
                BackStackRecord bs = this.mBackStack.get(i);
                writer.print(prefix);
                writer.print("  #");
                writer.print(i);
                writer.print(": ");
                writer.println(bs.toString());
                bs.dump(innerPrefix, fd, writer, args);
            }
        }
        FragmentManagerImpl i2 = this;
        synchronized (i2) {
            if (this.mBackStackIndices != null && (N = this.mBackStackIndices.size()) > 0) {
                writer.print(prefix);
                writer.println("Back Stack Indices:");
                for (int i3 = 0; i3 < N; ++i3) {
                    BackStackRecord bs = this.mBackStackIndices.get(i3);
                    writer.print(prefix);
                    writer.print("  #");
                    writer.print(i3);
                    writer.print(": ");
                    writer.println(bs);
                }
            }
            if (this.mAvailBackStackIndices != null && this.mAvailBackStackIndices.size() > 0) {
                writer.print(prefix);
                writer.print("mAvailBackStackIndices: ");
                writer.println(Arrays.toString(this.mAvailBackStackIndices.toArray()));
            }
        }
        if (this.mPendingActions != null && (N = this.mPendingActions.size()) > 0) {
            writer.print(prefix);
            writer.println("Pending Actions:");
            for (int i4 = 0; i4 < N; ++i4) {
                Runnable r = this.mPendingActions.get(i4);
                writer.print(prefix);
                writer.print("  #");
                writer.print(i4);
                writer.print(": ");
                writer.println(r);
            }
        }
        writer.print(prefix);
        writer.println("FragmentManager misc state:");
        writer.print(prefix);
        writer.print("  mActivity=");
        writer.println(this.mActivity);
        writer.print(prefix);
        writer.print("  mContainer=");
        writer.println(this.mContainer);
        if (this.mParent != null) {
            writer.print(prefix);
            writer.print("  mParent=");
            writer.println(this.mParent);
        }
        writer.print(prefix);
        writer.print("  mCurState=");
        writer.print(this.mCurState);
        writer.print(" mStateSaved=");
        writer.print(this.mStateSaved);
        writer.print(" mDestroyed=");
        writer.println(this.mDestroyed);
        if (this.mNeedMenuInvalidate) {
            writer.print(prefix);
            writer.print("  mNeedMenuInvalidate=");
            writer.println(this.mNeedMenuInvalidate);
        }
        if (this.mNoTransactionsBecause != null) {
            writer.print(prefix);
            writer.print("  mNoTransactionsBecause=");
            writer.println(this.mNoTransactionsBecause);
        }
        if (this.mAvailIndices != null && this.mAvailIndices.size() > 0) {
            writer.print(prefix);
            writer.print("  mAvailIndices: ");
            writer.println(Arrays.toString(this.mAvailIndices.toArray()));
        }
    }

    Animator loadAnimator(Fragment fragment, int transit, boolean enter, int transitionStyle) {
        Animator anim2;
        Animator animObj = fragment.onCreateAnimator(transit, enter, fragment.mNextAnim);
        if (animObj != null) {
            return animObj;
        }
        if (fragment.mNextAnim != 0 && (anim2 = AnimatorInflater.loadAnimator(this.mActivity, fragment.mNextAnim)) != null) {
            return anim2;
        }
        if (transit == 0) {
            return null;
        }
        int styleIndex = FragmentManagerImpl.transitToStyleIndex(transit, enter);
        if (styleIndex < 0) {
            return null;
        }
        if (transitionStyle == 0 && this.mActivity.getWindow() != null) {
            transitionStyle = this.mActivity.getWindow().getAttributes().windowAnimations;
        }
        if (transitionStyle == 0) {
            return null;
        }
        TypedArray attrs = this.mActivity.obtainStyledAttributes(transitionStyle, R.styleable.FragmentAnimation);
        int anim3 = attrs.getResourceId(styleIndex, 0);
        attrs.recycle();
        if (anim3 == 0) {
            return null;
        }
        return AnimatorInflater.loadAnimator(this.mActivity, anim3);
    }

    public void performPendingDeferredStart(Fragment f) {
        if (f.mDeferStart) {
            if (this.mExecutingActions) {
                this.mHavePendingDeferredStart = true;
                return;
            }
            f.mDeferStart = false;
            this.moveToState(f, this.mCurState, 0, 0, false);
        }
    }

    void moveToState(Fragment f, int newState, int transit, int transitionStyle, boolean keepActive) {
        if (DEBUG) {
            // empty if block
        }
        if ((!f.mAdded || f.mDetached) && newState > 1) {
            newState = 1;
        }
        if (f.mRemoving && newState > f.mState) {
            newState = f.mState;
        }
        if (f.mDeferStart && f.mState < 4 && newState > 3) {
            newState = 3;
        }
        if (f.mState < newState) {
            if (f.mFromLayout && !f.mInLayout) {
                return;
            }
            if (f.mAnimatingAway != null) {
                f.mAnimatingAway = null;
                this.moveToState(f, f.mStateAfterAnimating, 0, 0, true);
            }
            switch (f.mState) {
                case 0: {
                    if (DEBUG) {
                        Log.v(TAG, "moveto CREATED: " + f);
                    }
                    if (f.mSavedFragmentState != null) {
                        f.mSavedViewState = f.mSavedFragmentState.getSparseParcelableArray(VIEW_STATE_TAG);
                        f.mTarget = this.getFragment(f.mSavedFragmentState, TARGET_STATE_TAG);
                        if (f.mTarget != null) {
                            f.mTargetRequestCode = f.mSavedFragmentState.getInt(TARGET_REQUEST_CODE_STATE_TAG, 0);
                        }
                        f.mUserVisibleHint = f.mSavedFragmentState.getBoolean(USER_VISIBLE_HINT_TAG, true);
                        if (!f.mUserVisibleHint) {
                            f.mDeferStart = true;
                            if (newState > 3) {
                                newState = 3;
                            }
                        }
                    }
                    f.mActivity = this.mActivity;
                    f.mParentFragment = this.mParent;
                    f.mFragmentManager = this.mParent != null ? this.mParent.mChildFragmentManager : this.mActivity.mFragments;
                    f.mCalled = false;
                    f.onAttach(this.mActivity);
                    if (!f.mCalled) {
                        throw new SuperNotCalledException("Fragment " + f + " did not call through to super.onAttach()");
                    }
                    if (f.mParentFragment == null) {
                        this.mActivity.onAttachFragment(f);
                    }
                    if (!f.mRetaining) {
                        f.performCreate(f.mSavedFragmentState);
                    }
                    f.mRetaining = false;
                    if (f.mFromLayout) {
                        f.mView = f.performCreateView(f.getLayoutInflater(f.mSavedFragmentState), null, f.mSavedFragmentState);
                        if (f.mView != null) {
                            f.mView.setSaveFromParentEnabled(false);
                            if (f.mHidden) {
                                f.mView.setVisibility(8);
                            }
                            f.onViewCreated(f.mView, f.mSavedFragmentState);
                        }
                    }
                }
                case 1: {
                    if (newState > 1) {
                        if (DEBUG) {
                            Log.v(TAG, "moveto ACTIVITY_CREATED: " + f);
                        }
                        if (!f.mFromLayout) {
                            ViewGroup container = null;
                            if (f.mContainerId != 0 && (container = (ViewGroup)this.mContainer.findViewById(f.mContainerId)) == null && !f.mRestored) {
                                this.throwException(new IllegalArgumentException("No view found for id 0x" + Integer.toHexString(f.mContainerId) + " (" + f.getResources().getResourceName(f.mContainerId) + ") for fragment " + f));
                            }
                            f.mContainer = container;
                            f.mView = f.performCreateView(f.getLayoutInflater(f.mSavedFragmentState), container, f.mSavedFragmentState);
                            if (f.mView != null) {
                                f.mView.setSaveFromParentEnabled(false);
                                if (container != null) {
                                    Animator anim2 = this.loadAnimator(f, transit, true, transitionStyle);
                                    if (anim2 != null) {
                                        anim2.setTarget(f.mView);
                                        anim2.start();
                                    }
                                    container.addView(f.mView);
                                }
                                if (f.mHidden) {
                                    f.mView.setVisibility(8);
                                }
                                f.onViewCreated(f.mView, f.mSavedFragmentState);
                            }
                        }
                        f.performActivityCreated(f.mSavedFragmentState);
                        if (f.mView != null) {
                            f.restoreViewState(f.mSavedFragmentState);
                        }
                        f.mSavedFragmentState = null;
                    }
                }
                case 2: 
                case 3: {
                    if (newState > 3) {
                        if (DEBUG) {
                            Log.v(TAG, "moveto STARTED: " + f);
                        }
                        f.performStart();
                    }
                }
                case 4: {
                    if (newState <= 4) break;
                    if (DEBUG) {
                        Log.v(TAG, "moveto RESUMED: " + f);
                    }
                    f.mResumed = true;
                    f.performResume();
                    f.mSavedFragmentState = null;
                    f.mSavedViewState = null;
                }
            }
        } else if (f.mState > newState) {
            switch (f.mState) {
                case 5: {
                    if (newState < 5) {
                        if (DEBUG) {
                            Log.v(TAG, "movefrom RESUMED: " + f);
                        }
                        f.performPause();
                        f.mResumed = false;
                    }
                }
                case 4: {
                    if (newState < 4) {
                        if (DEBUG) {
                            Log.v(TAG, "movefrom STARTED: " + f);
                        }
                        f.performStop();
                    }
                }
                case 2: 
                case 3: {
                    Animator anim3;
                    if (newState < 2) {
                        if (DEBUG) {
                            Log.v(TAG, "movefrom ACTIVITY_CREATED: " + f);
                        }
                        if (f.mView != null && !this.mActivity.isFinishing() && f.mSavedViewState == null) {
                            this.saveFragmentViewState(f);
                        }
                        f.performDestroyView();
                        if (f.mView != null && f.mContainer != null) {
                            anim3 = null;
                            if (this.mCurState > 0 && !this.mDestroyed) {
                                anim3 = this.loadAnimator(f, transit, false, transitionStyle);
                            }
                            if (anim3 != null) {
                                final ViewGroup container = f.mContainer;
                                final View view = f.mView;
                                final Fragment fragment = f;
                                container.startViewTransition(view);
                                f.mAnimatingAway = anim3;
                                f.mStateAfterAnimating = newState;
                                anim3.addListener(new AnimatorListenerAdapter(){

                                    @Override
                                    public void onAnimationEnd(Animator anim2) {
                                        container.endViewTransition(view);
                                        if (fragment.mAnimatingAway != null) {
                                            fragment.mAnimatingAway = null;
                                            FragmentManagerImpl.this.moveToState(fragment, fragment.mStateAfterAnimating, 0, 0, false);
                                        }
                                    }
                                });
                                anim3.setTarget(f.mView);
                                anim3.start();
                            }
                            f.mContainer.removeView(f.mView);
                        }
                        f.mContainer = null;
                        f.mView = null;
                    }
                }
                case 1: {
                    Animator anim3;
                    if (newState >= 1) break;
                    if (this.mDestroyed && f.mAnimatingAway != null) {
                        anim3 = f.mAnimatingAway;
                        f.mAnimatingAway = null;
                        anim3.cancel();
                    }
                    if (f.mAnimatingAway != null) {
                        f.mStateAfterAnimating = newState;
                        newState = 1;
                        break;
                    }
                    if (DEBUG) {
                        Log.v(TAG, "movefrom CREATED: " + f);
                    }
                    if (!f.mRetaining) {
                        f.performDestroy();
                    }
                    f.mCalled = false;
                    f.onDetach();
                    if (!f.mCalled) {
                        throw new SuperNotCalledException("Fragment " + f + " did not call through to super.onDetach()");
                    }
                    if (keepActive) break;
                    if (!f.mRetaining) {
                        this.makeInactive(f);
                        break;
                    }
                    f.mActivity = null;
                    f.mParentFragment = null;
                    f.mFragmentManager = null;
                    f.mChildFragmentManager = null;
                }
            }
        }
        f.mState = newState;
    }

    void moveToState(Fragment f) {
        this.moveToState(f, this.mCurState, 0, 0, false);
    }

    void moveToState(int newState, boolean always) {
        this.moveToState(newState, 0, 0, always);
    }

    void moveToState(int newState, int transit, int transitStyle, boolean always) {
        if (this.mActivity == null && newState != 0) {
            throw new IllegalStateException("No activity");
        }
        if (!always && this.mCurState == newState) {
            return;
        }
        this.mCurState = newState;
        if (this.mActive != null) {
            boolean loadersRunning = false;
            for (int i = 0; i < this.mActive.size(); ++i) {
                Fragment f = this.mActive.get(i);
                if (f == null) continue;
                this.moveToState(f, newState, transit, transitStyle, false);
                if (f.mLoaderManager == null) continue;
                loadersRunning |= f.mLoaderManager.hasRunningLoaders();
            }
            if (!loadersRunning) {
                this.startPendingDeferredFragments();
            }
            if (this.mNeedMenuInvalidate && this.mActivity != null && this.mCurState == 5) {
                this.mActivity.invalidateOptionsMenu();
                this.mNeedMenuInvalidate = false;
            }
        }
    }

    void startPendingDeferredFragments() {
        if (this.mActive == null) {
            return;
        }
        for (int i = 0; i < this.mActive.size(); ++i) {
            Fragment f = this.mActive.get(i);
            if (f == null) continue;
            this.performPendingDeferredStart(f);
        }
    }

    void makeActive(Fragment f) {
        if (f.mIndex >= 0) {
            return;
        }
        if (this.mAvailIndices == null || this.mAvailIndices.size() <= 0) {
            if (this.mActive == null) {
                this.mActive = new ArrayList();
            }
            f.setIndex(this.mActive.size(), this.mParent);
            this.mActive.add(f);
        } else {
            f.setIndex(this.mAvailIndices.remove(this.mAvailIndices.size() - 1), this.mParent);
            this.mActive.set(f.mIndex, f);
        }
        if (DEBUG) {
            Log.v(TAG, "Allocated fragment index " + f);
        }
    }

    void makeInactive(Fragment f) {
        if (f.mIndex < 0) {
            return;
        }
        if (DEBUG) {
            Log.v(TAG, "Freeing fragment index " + f);
        }
        this.mActive.set(f.mIndex, null);
        if (this.mAvailIndices == null) {
            this.mAvailIndices = new ArrayList();
        }
        this.mAvailIndices.add(f.mIndex);
        this.mActivity.invalidateFragment(f.mWho);
        f.initState();
    }

    public void addFragment(Fragment fragment, boolean moveToStateNow) {
        if (this.mAdded == null) {
            this.mAdded = new ArrayList();
        }
        if (DEBUG) {
            Log.v(TAG, "add: " + fragment);
        }
        this.makeActive(fragment);
        if (!fragment.mDetached) {
            if (this.mAdded.contains(fragment)) {
                throw new IllegalStateException("Fragment already added: " + fragment);
            }
            this.mAdded.add(fragment);
            fragment.mAdded = true;
            fragment.mRemoving = false;
            if (fragment.mHasMenu && fragment.mMenuVisible) {
                this.mNeedMenuInvalidate = true;
            }
            if (moveToStateNow) {
                this.moveToState(fragment);
            }
        }
    }

    public void removeFragment(Fragment fragment, int transition2, int transitionStyle) {
        boolean inactive;
        if (DEBUG) {
            Log.v(TAG, "remove: " + fragment + " nesting=" + fragment.mBackStackNesting);
        }
        boolean bl = inactive = !fragment.isInBackStack();
        if (!fragment.mDetached || inactive) {
            if (this.mAdded != null) {
                this.mAdded.remove(fragment);
            }
            if (fragment.mHasMenu && fragment.mMenuVisible) {
                this.mNeedMenuInvalidate = true;
            }
            fragment.mAdded = false;
            fragment.mRemoving = true;
            this.moveToState(fragment, inactive ? 0 : 1, transition2, transitionStyle, false);
        }
    }

    public void hideFragment(Fragment fragment, int transition2, int transitionStyle) {
        if (DEBUG) {
            Log.v(TAG, "hide: " + fragment);
        }
        if (!fragment.mHidden) {
            fragment.mHidden = true;
            if (fragment.mView != null) {
                Animator anim2 = this.loadAnimator(fragment, transition2, false, transitionStyle);
                if (anim2 != null) {
                    anim2.setTarget(fragment.mView);
                    final Fragment finalFragment = fragment;
                    anim2.addListener(new AnimatorListenerAdapter(){

                        @Override
                        public void onAnimationEnd(Animator animation) {
                            if (finalFragment.mView != null) {
                                finalFragment.mView.setVisibility(8);
                            }
                        }
                    });
                    anim2.start();
                } else {
                    fragment.mView.setVisibility(8);
                }
            }
            if (fragment.mAdded && fragment.mHasMenu && fragment.mMenuVisible) {
                this.mNeedMenuInvalidate = true;
            }
            fragment.onHiddenChanged(true);
        }
    }

    public void showFragment(Fragment fragment, int transition2, int transitionStyle) {
        if (DEBUG) {
            Log.v(TAG, "show: " + fragment);
        }
        if (fragment.mHidden) {
            fragment.mHidden = false;
            if (fragment.mView != null) {
                Animator anim2 = this.loadAnimator(fragment, transition2, true, transitionStyle);
                if (anim2 != null) {
                    anim2.setTarget(fragment.mView);
                    anim2.start();
                }
                fragment.mView.setVisibility(0);
            }
            if (fragment.mAdded && fragment.mHasMenu && fragment.mMenuVisible) {
                this.mNeedMenuInvalidate = true;
            }
            fragment.onHiddenChanged(false);
        }
    }

    public void detachFragment(Fragment fragment, int transition2, int transitionStyle) {
        if (DEBUG) {
            Log.v(TAG, "detach: " + fragment);
        }
        if (!fragment.mDetached) {
            fragment.mDetached = true;
            if (fragment.mAdded) {
                if (this.mAdded != null) {
                    if (DEBUG) {
                        Log.v(TAG, "remove from detach: " + fragment);
                    }
                    this.mAdded.remove(fragment);
                }
                if (fragment.mHasMenu && fragment.mMenuVisible) {
                    this.mNeedMenuInvalidate = true;
                }
                fragment.mAdded = false;
                this.moveToState(fragment, 1, transition2, transitionStyle, false);
            }
        }
    }

    public void attachFragment(Fragment fragment, int transition2, int transitionStyle) {
        if (DEBUG) {
            Log.v(TAG, "attach: " + fragment);
        }
        if (fragment.mDetached) {
            fragment.mDetached = false;
            if (!fragment.mAdded) {
                if (this.mAdded == null) {
                    this.mAdded = new ArrayList();
                }
                if (this.mAdded.contains(fragment)) {
                    throw new IllegalStateException("Fragment already added: " + fragment);
                }
                if (DEBUG) {
                    Log.v(TAG, "add from attach: " + fragment);
                }
                this.mAdded.add(fragment);
                fragment.mAdded = true;
                if (fragment.mHasMenu && fragment.mMenuVisible) {
                    this.mNeedMenuInvalidate = true;
                }
                this.moveToState(fragment, this.mCurState, transition2, transitionStyle, false);
            }
        }
    }

    @Override
    public Fragment findFragmentById(int id2) {
        Fragment f;
        int i;
        if (this.mAdded != null) {
            for (i = this.mAdded.size() - 1; i >= 0; --i) {
                f = this.mAdded.get(i);
                if (f == null || f.mFragmentId != id2) continue;
                return f;
            }
        }
        if (this.mActive != null) {
            for (i = this.mActive.size() - 1; i >= 0; --i) {
                f = this.mActive.get(i);
                if (f == null || f.mFragmentId != id2) continue;
                return f;
            }
        }
        return null;
    }

    @Override
    public Fragment findFragmentByTag(String tag) {
        Fragment f;
        int i;
        if (this.mAdded != null && tag != null) {
            for (i = this.mAdded.size() - 1; i >= 0; --i) {
                f = this.mAdded.get(i);
                if (f == null || !tag.equals(f.mTag)) continue;
                return f;
            }
        }
        if (this.mActive != null && tag != null) {
            for (i = this.mActive.size() - 1; i >= 0; --i) {
                f = this.mActive.get(i);
                if (f == null || !tag.equals(f.mTag)) continue;
                return f;
            }
        }
        return null;
    }

    public Fragment findFragmentByWho(String who) {
        if (this.mActive != null && who != null) {
            for (int i = this.mActive.size() - 1; i >= 0; --i) {
                Fragment f = this.mActive.get(i);
                if (f == null || (f = f.findFragmentByWho(who)) == null) continue;
                return f;
            }
        }
        return null;
    }

    private void checkStateLoss() {
        if (this.mStateSaved) {
            throw new IllegalStateException("Can not perform this action after onSaveInstanceState");
        }
        if (this.mNoTransactionsBecause != null) {
            throw new IllegalStateException("Can not perform this action inside of " + this.mNoTransactionsBecause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueAction(Runnable action, boolean allowStateLoss) {
        if (!allowStateLoss) {
            this.checkStateLoss();
        }
        FragmentManagerImpl fragmentManagerImpl = this;
        synchronized (fragmentManagerImpl) {
            if (this.mDestroyed || this.mActivity == null) {
                throw new IllegalStateException("Activity has been destroyed");
            }
            if (this.mPendingActions == null) {
                this.mPendingActions = new ArrayList();
            }
            this.mPendingActions.add(action);
            if (this.mPendingActions.size() == 1) {
                this.mActivity.mHandler.removeCallbacks(this.mExecCommit);
                this.mActivity.mHandler.post(this.mExecCommit);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int allocBackStackIndex(BackStackRecord bse) {
        FragmentManagerImpl fragmentManagerImpl = this;
        synchronized (fragmentManagerImpl) {
            if (this.mAvailBackStackIndices == null || this.mAvailBackStackIndices.size() <= 0) {
                if (this.mBackStackIndices == null) {
                    this.mBackStackIndices = new ArrayList();
                }
                int index = this.mBackStackIndices.size();
                if (DEBUG) {
                    Log.v(TAG, "Setting back stack index " + index + " to " + bse);
                }
                this.mBackStackIndices.add(bse);
                return index;
            }
            int index = this.mAvailBackStackIndices.remove(this.mAvailBackStackIndices.size() - 1);
            if (DEBUG) {
                Log.v(TAG, "Adding back stack index " + index + " with " + bse);
            }
            this.mBackStackIndices.set(index, bse);
            return index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackStackIndex(int index, BackStackRecord bse) {
        FragmentManagerImpl fragmentManagerImpl = this;
        synchronized (fragmentManagerImpl) {
            int N;
            if (this.mBackStackIndices == null) {
                this.mBackStackIndices = new ArrayList();
            }
            if (index < (N = this.mBackStackIndices.size())) {
                if (DEBUG) {
                    Log.v(TAG, "Setting back stack index " + index + " to " + bse);
                }
                this.mBackStackIndices.set(index, bse);
            } else {
                while (N < index) {
                    this.mBackStackIndices.add(null);
                    if (this.mAvailBackStackIndices == null) {
                        this.mAvailBackStackIndices = new ArrayList();
                    }
                    if (DEBUG) {
                        Log.v(TAG, "Adding available back stack index " + N);
                    }
                    this.mAvailBackStackIndices.add(N);
                    ++N;
                }
                if (DEBUG) {
                    Log.v(TAG, "Adding back stack index " + index + " with " + bse);
                }
                this.mBackStackIndices.add(bse);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeBackStackIndex(int index) {
        FragmentManagerImpl fragmentManagerImpl = this;
        synchronized (fragmentManagerImpl) {
            this.mBackStackIndices.set(index, null);
            if (this.mAvailBackStackIndices == null) {
                this.mAvailBackStackIndices = new ArrayList();
            }
            if (DEBUG) {
                Log.v(TAG, "Freeing back stack index " + index);
            }
            this.mAvailBackStackIndices.add(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execPendingActions() {
        if (this.mExecutingActions) {
            throw new IllegalStateException("Recursive entry to executePendingTransactions");
        }
        if (Looper.myLooper() != this.mActivity.mHandler.getLooper()) {
            throw new IllegalStateException("Must be called from main thread of process");
        }
        boolean didSomething = false;
        while (true) {
            int numActions;
            FragmentManagerImpl fragmentManagerImpl = this;
            synchronized (fragmentManagerImpl) {
                if (this.mPendingActions == null || this.mPendingActions.size() == 0) {
                    break;
                }
                numActions = this.mPendingActions.size();
                if (this.mTmpActions == null || this.mTmpActions.length < numActions) {
                    this.mTmpActions = new Runnable[numActions];
                }
                this.mPendingActions.toArray(this.mTmpActions);
                this.mPendingActions.clear();
                this.mActivity.mHandler.removeCallbacks(this.mExecCommit);
            }
            this.mExecutingActions = true;
            for (int i = 0; i < numActions; ++i) {
                this.mTmpActions[i].run();
                this.mTmpActions[i] = null;
            }
            this.mExecutingActions = false;
            didSomething = true;
        }
        if (this.mHavePendingDeferredStart) {
            boolean loadersRunning = false;
            for (int i = 0; i < this.mActive.size(); ++i) {
                Fragment f = this.mActive.get(i);
                if (f == null || f.mLoaderManager == null) continue;
                loadersRunning |= f.mLoaderManager.hasRunningLoaders();
            }
            if (!loadersRunning) {
                this.mHavePendingDeferredStart = false;
                this.startPendingDeferredFragments();
            }
        }
        return didSomething;
    }

    void reportBackStackChanged() {
        if (this.mBackStackChangeListeners != null) {
            for (int i = 0; i < this.mBackStackChangeListeners.size(); ++i) {
                this.mBackStackChangeListeners.get(i).onBackStackChanged();
            }
        }
    }

    void addBackStackState(BackStackRecord state) {
        if (this.mBackStack == null) {
            this.mBackStack = new ArrayList();
        }
        this.mBackStack.add(state);
        this.reportBackStackChanged();
    }

    boolean popBackStackState(Handler handler, String name, int id2, int flags) {
        if (this.mBackStack == null) {
            return false;
        }
        if (name == null && id2 < 0 && (flags & 1) == 0) {
            int last = this.mBackStack.size() - 1;
            if (last < 0) {
                return false;
            }
            BackStackRecord bss = this.mBackStack.remove(last);
            SparseArray<Fragment> firstOutFragments = new SparseArray<Fragment>();
            SparseArray<Fragment> lastInFragments = new SparseArray<Fragment>();
            bss.calculateBackFragments(firstOutFragments, lastInFragments);
            bss.popFromBackStack(true, null, firstOutFragments, lastInFragments);
            this.reportBackStackChanged();
        } else {
            int index = -1;
            if (name != null || id2 >= 0) {
                BackStackRecord bss;
                for (index = this.mBackStack.size() - 1; index >= 0; --index) {
                    bss = this.mBackStack.get(index);
                    if (name != null && name.equals(bss.getName()) || id2 >= 0 && id2 == bss.mIndex) break;
                }
                if (index < 0) {
                    return false;
                }
                if ((flags & 1) != 0) {
                    --index;
                    while (index >= 0) {
                        bss = this.mBackStack.get(index);
                        if ((name == null || !name.equals(bss.getName())) && (id2 < 0 || id2 != bss.mIndex)) break;
                        --index;
                    }
                }
            }
            if (index == this.mBackStack.size() - 1) {
                return false;
            }
            ArrayList<BackStackRecord> states = new ArrayList<BackStackRecord>();
            for (int i = this.mBackStack.size() - 1; i > index; --i) {
                states.add(this.mBackStack.remove(i));
            }
            int LAST = states.size() - 1;
            SparseArray<Fragment> firstOutFragments = new SparseArray<Fragment>();
            SparseArray<Fragment> lastInFragments = new SparseArray<Fragment>();
            for (int i = 0; i <= LAST; ++i) {
                ((BackStackRecord)states.get(i)).calculateBackFragments(firstOutFragments, lastInFragments);
            }
            BackStackRecord.TransitionState state = null;
            for (int i = 0; i <= LAST; ++i) {
                if (DEBUG) {
                    Log.v(TAG, "Popping back stack state: " + states.get(i));
                }
                state = ((BackStackRecord)states.get(i)).popFromBackStack(i == LAST, state, firstOutFragments, lastInFragments);
            }
            this.reportBackStackChanged();
        }
        return true;
    }

    ArrayList<Fragment> retainNonConfig() {
        ArrayList<Fragment> fragments = null;
        if (this.mActive != null) {
            for (int i = 0; i < this.mActive.size(); ++i) {
                Fragment f = this.mActive.get(i);
                if (f == null || !f.mRetainInstance) continue;
                if (fragments == null) {
                    fragments = new ArrayList<Fragment>();
                }
                fragments.add(f);
                f.mRetaining = true;
                int n = f.mTargetIndex = f.mTarget != null ? f.mTarget.mIndex : -1;
                if (!DEBUG) continue;
                Log.v(TAG, "retainNonConfig: keeping retained " + f);
            }
        }
        return fragments;
    }

    void saveFragmentViewState(Fragment f) {
        if (f.mView == null) {
            return;
        }
        if (this.mStateArray == null) {
            this.mStateArray = new SparseArray();
        } else {
            this.mStateArray.clear();
        }
        f.mView.saveHierarchyState(this.mStateArray);
        if (this.mStateArray.size() > 0) {
            f.mSavedViewState = this.mStateArray;
            this.mStateArray = null;
        }
    }

    Bundle saveFragmentBasicState(Fragment f) {
        Bundle result = null;
        if (this.mStateBundle == null) {
            this.mStateBundle = new Bundle();
        }
        f.performSaveInstanceState(this.mStateBundle);
        if (!this.mStateBundle.isEmpty()) {
            result = this.mStateBundle;
            this.mStateBundle = null;
        }
        if (f.mView != null) {
            this.saveFragmentViewState(f);
        }
        if (f.mSavedViewState != null) {
            if (result == null) {
                result = new Bundle();
            }
            result.putSparseParcelableArray(VIEW_STATE_TAG, f.mSavedViewState);
        }
        if (!f.mUserVisibleHint) {
            if (result == null) {
                result = new Bundle();
            }
            result.putBoolean(USER_VISIBLE_HINT_TAG, f.mUserVisibleHint);
        }
        return result;
    }

    Parcelable saveAllState() {
        this.execPendingActions();
        this.mStateSaved = true;
        if (this.mActive == null || this.mActive.size() <= 0) {
            return null;
        }
        int N = this.mActive.size();
        FragmentState[] active = new FragmentState[N];
        boolean haveFragments = false;
        for (int i = 0; i < N; ++i) {
            FragmentState fs;
            Fragment f = this.mActive.get(i);
            if (f == null) continue;
            if (f.mIndex < 0) {
                this.throwException(new IllegalStateException("Failure saving state: active " + f + " has cleared index: " + f.mIndex));
            }
            haveFragments = true;
            active[i] = fs = new FragmentState(f);
            if (f.mState > 0 && fs.mSavedFragmentState == null) {
                fs.mSavedFragmentState = this.saveFragmentBasicState(f);
                if (f.mTarget != null) {
                    if (f.mTarget.mIndex < 0) {
                        this.throwException(new IllegalStateException("Failure saving state: " + f + " has target not in fragment manager: " + f.mTarget));
                    }
                    if (fs.mSavedFragmentState == null) {
                        fs.mSavedFragmentState = new Bundle();
                    }
                    this.putFragment(fs.mSavedFragmentState, TARGET_STATE_TAG, f.mTarget);
                    if (f.mTargetRequestCode != 0) {
                        fs.mSavedFragmentState.putInt(TARGET_REQUEST_CODE_STATE_TAG, f.mTargetRequestCode);
                    }
                }
            } else {
                fs.mSavedFragmentState = f.mSavedFragmentState;
            }
            if (!DEBUG) continue;
            Log.v(TAG, "Saved state of " + f + ": " + fs.mSavedFragmentState);
        }
        if (!haveFragments) {
            if (DEBUG) {
                Log.v(TAG, "saveAllState: no fragments!");
            }
            return null;
        }
        int[] added = null;
        BackStackState[] backStack = null;
        if (this.mAdded != null && (N = this.mAdded.size()) > 0) {
            added = new int[N];
            for (int i = 0; i < N; ++i) {
                added[i] = this.mAdded.get((int)i).mIndex;
                if (added[i] < 0) {
                    this.throwException(new IllegalStateException("Failure saving state: active " + this.mAdded.get(i) + " has cleared index: " + added[i]));
                }
                if (!DEBUG) continue;
                Log.v(TAG, "saveAllState: adding fragment #" + i + ": " + this.mAdded.get(i));
            }
        }
        if (this.mBackStack != null && (N = this.mBackStack.size()) > 0) {
            backStack = new BackStackState[N];
            for (int i = 0; i < N; ++i) {
                backStack[i] = new BackStackState(this, this.mBackStack.get(i));
                if (!DEBUG) continue;
                Log.v(TAG, "saveAllState: adding back stack #" + i + ": " + this.mBackStack.get(i));
            }
        }
        FragmentManagerState fms = new FragmentManagerState();
        fms.mActive = active;
        fms.mAdded = added;
        fms.mBackStack = backStack;
        return fms;
    }

    void restoreAllState(Parcelable state, ArrayList<Fragment> nonConfig) {
        Fragment f;
        int i;
        if (state == null) {
            return;
        }
        FragmentManagerState fms = (FragmentManagerState)state;
        if (fms.mActive == null) {
            return;
        }
        if (nonConfig != null) {
            for (i = 0; i < nonConfig.size(); ++i) {
                f = nonConfig.get(i);
                if (DEBUG) {
                    Log.v(TAG, "restoreAllState: re-attaching retained " + f);
                }
                FragmentState fs = fms.mActive[f.mIndex];
                fs.mInstance = f;
                f.mSavedViewState = null;
                f.mBackStackNesting = 0;
                f.mInLayout = false;
                f.mAdded = false;
                f.mTarget = null;
                if (fs.mSavedFragmentState == null) continue;
                fs.mSavedFragmentState.setClassLoader(this.mActivity.getClassLoader());
                f.mSavedViewState = fs.mSavedFragmentState.getSparseParcelableArray(VIEW_STATE_TAG);
                f.mSavedFragmentState = fs.mSavedFragmentState;
            }
        }
        this.mActive = new ArrayList(fms.mActive.length);
        if (this.mAvailIndices != null) {
            this.mAvailIndices.clear();
        }
        for (i = 0; i < fms.mActive.length; ++i) {
            FragmentState fs = fms.mActive[i];
            if (fs != null) {
                Fragment f2 = fs.instantiate(this.mActivity, this.mParent);
                if (DEBUG) {
                    Log.v(TAG, "restoreAllState: active #" + i + ": " + f2);
                }
                this.mActive.add(f2);
                fs.mInstance = null;
                continue;
            }
            this.mActive.add(null);
            if (this.mAvailIndices == null) {
                this.mAvailIndices = new ArrayList();
            }
            if (DEBUG) {
                Log.v(TAG, "restoreAllState: avail #" + i);
            }
            this.mAvailIndices.add(i);
        }
        if (nonConfig != null) {
            for (i = 0; i < nonConfig.size(); ++i) {
                f = nonConfig.get(i);
                if (f.mTargetIndex < 0) continue;
                if (f.mTargetIndex < this.mActive.size()) {
                    f.mTarget = this.mActive.get(f.mTargetIndex);
                    continue;
                }
                Log.w(TAG, "Re-attaching retained fragment " + f + " target no longer exists: " + f.mTargetIndex);
                f.mTarget = null;
            }
        }
        if (fms.mAdded != null) {
            this.mAdded = new ArrayList(fms.mAdded.length);
            for (i = 0; i < fms.mAdded.length; ++i) {
                f = this.mActive.get(fms.mAdded[i]);
                if (f == null) {
                    this.throwException(new IllegalStateException("No instantiated fragment for index #" + fms.mAdded[i]));
                }
                f.mAdded = true;
                if (DEBUG) {
                    Log.v(TAG, "restoreAllState: added #" + i + ": " + f);
                }
                if (this.mAdded.contains(f)) {
                    throw new IllegalStateException("Already added!");
                }
                this.mAdded.add(f);
            }
        } else {
            this.mAdded = null;
        }
        if (fms.mBackStack != null) {
            this.mBackStack = new ArrayList(fms.mBackStack.length);
            for (i = 0; i < fms.mBackStack.length; ++i) {
                BackStackRecord bse = fms.mBackStack[i].instantiate(this);
                if (DEBUG) {
                    Log.v(TAG, "restoreAllState: back stack #" + i + " (index " + bse.mIndex + "): " + bse);
                    LogWriter logw = new LogWriter(2, TAG);
                    FastPrintWriter pw = new FastPrintWriter(logw, false, 1024);
                    bse.dump("  ", pw, false);
                    ((PrintWriter)pw).flush();
                }
                this.mBackStack.add(bse);
                if (bse.mIndex < 0) continue;
                this.setBackStackIndex(bse.mIndex, bse);
            }
        } else {
            this.mBackStack = null;
        }
    }

    public void attachActivity(Activity activity, FragmentContainer container, Fragment parent) {
        if (this.mActivity != null) {
            throw new IllegalStateException("Already attached");
        }
        this.mActivity = activity;
        this.mContainer = container;
        this.mParent = parent;
    }

    public void noteStateNotSaved() {
        this.mStateSaved = false;
    }

    public void dispatchCreate() {
        this.mStateSaved = false;
        this.moveToState(1, false);
    }

    public void dispatchActivityCreated() {
        this.mStateSaved = false;
        this.moveToState(2, false);
    }

    public void dispatchStart() {
        this.mStateSaved = false;
        this.moveToState(4, false);
    }

    public void dispatchResume() {
        this.mStateSaved = false;
        this.moveToState(5, false);
    }

    public void dispatchPause() {
        this.moveToState(4, false);
    }

    public void dispatchStop() {
        this.moveToState(3, false);
    }

    public void dispatchDestroyView() {
        this.moveToState(1, false);
    }

    public void dispatchDestroy() {
        this.mDestroyed = true;
        this.execPendingActions();
        this.moveToState(0, false);
        this.mActivity = null;
        this.mContainer = null;
        this.mParent = null;
    }

    public void dispatchConfigurationChanged(Configuration newConfig) {
        if (this.mAdded != null) {
            for (int i = 0; i < this.mAdded.size(); ++i) {
                Fragment f = this.mAdded.get(i);
                if (f == null) continue;
                f.performConfigurationChanged(newConfig);
            }
        }
    }

    public void dispatchLowMemory() {
        if (this.mAdded != null) {
            for (int i = 0; i < this.mAdded.size(); ++i) {
                Fragment f = this.mAdded.get(i);
                if (f == null) continue;
                f.performLowMemory();
            }
        }
    }

    public void dispatchTrimMemory(int level) {
        if (this.mAdded != null) {
            for (int i = 0; i < this.mAdded.size(); ++i) {
                Fragment f = this.mAdded.get(i);
                if (f == null) continue;
                f.performTrimMemory(level);
            }
        }
    }

    public boolean dispatchCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        Fragment f;
        int i;
        boolean show = false;
        ArrayList<Fragment> newMenus = null;
        if (this.mAdded != null) {
            for (i = 0; i < this.mAdded.size(); ++i) {
                f = this.mAdded.get(i);
                if (f == null || !f.performCreateOptionsMenu(menu2, inflater)) continue;
                show = true;
                if (newMenus == null) {
                    newMenus = new ArrayList<Fragment>();
                }
                newMenus.add(f);
            }
        }
        if (this.mCreatedMenus != null) {
            for (i = 0; i < this.mCreatedMenus.size(); ++i) {
                f = this.mCreatedMenus.get(i);
                if (newMenus != null && newMenus.contains(f)) continue;
                f.onDestroyOptionsMenu();
            }
        }
        this.mCreatedMenus = newMenus;
        return show;
    }

    public boolean dispatchPrepareOptionsMenu(Menu menu2) {
        boolean show = false;
        if (this.mAdded != null) {
            for (int i = 0; i < this.mAdded.size(); ++i) {
                Fragment f = this.mAdded.get(i);
                if (f == null || !f.performPrepareOptionsMenu(menu2)) continue;
                show = true;
            }
        }
        return show;
    }

    public boolean dispatchOptionsItemSelected(MenuItem item) {
        if (this.mAdded != null) {
            for (int i = 0; i < this.mAdded.size(); ++i) {
                Fragment f = this.mAdded.get(i);
                if (f == null || !f.performOptionsItemSelected(item)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean dispatchContextItemSelected(MenuItem item) {
        if (this.mAdded != null) {
            for (int i = 0; i < this.mAdded.size(); ++i) {
                Fragment f = this.mAdded.get(i);
                if (f == null || !f.performContextItemSelected(item)) continue;
                return true;
            }
        }
        return false;
    }

    public void dispatchOptionsMenuClosed(Menu menu2) {
        if (this.mAdded != null) {
            for (int i = 0; i < this.mAdded.size(); ++i) {
                Fragment f = this.mAdded.get(i);
                if (f == null) continue;
                f.performOptionsMenuClosed(menu2);
            }
        }
    }

    @Override
    public void invalidateOptionsMenu() {
        if (this.mActivity != null && this.mCurState == 5) {
            this.mActivity.invalidateOptionsMenu();
        } else {
            this.mNeedMenuInvalidate = true;
        }
    }

    public static int reverseTransit(int transit) {
        int rev = 0;
        switch (transit) {
            case 4097: {
                rev = 8194;
                break;
            }
            case 8194: {
                rev = 4097;
                break;
            }
            case 4099: {
                rev = 4099;
            }
        }
        return rev;
    }

    public static int transitToStyleIndex(int transit, boolean enter) {
        int animAttr = -1;
        switch (transit) {
            case 4097: {
                animAttr = enter ? 0 : 1;
                break;
            }
            case 8194: {
                animAttr = enter ? 2 : 3;
                break;
            }
            case 4099: {
                animAttr = enter ? 4 : 5;
            }
        }
        return animAttr;
    }

    @Override
    public View onCreateView(View parent, String name, Context context, AttributeSet attrs) {
        Fragment fragment;
        int containerId;
        if (!"fragment".equals(name)) {
            return null;
        }
        String fname = attrs.getAttributeValue(null, "class");
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Fragment);
        if (fname == null) {
            fname = a.getString(0);
        }
        int id2 = a.getResourceId(1, -1);
        String tag = a.getString(2);
        a.recycle();
        int n = containerId = parent != null ? parent.getId() : 0;
        if (containerId == -1 && id2 == -1 && tag == null) {
            throw new IllegalArgumentException(attrs.getPositionDescription() + ": Must specify unique android:id, android:tag, or have a parent with" + " an id for " + fname);
        }
        Fragment fragment2 = fragment = id2 != -1 ? this.findFragmentById(id2) : null;
        if (fragment == null && tag != null) {
            fragment = this.findFragmentByTag(tag);
        }
        if (fragment == null && containerId != -1) {
            fragment = this.findFragmentById(containerId);
        }
        if (DEBUG) {
            Log.v(TAG, "onCreateView: id=0x" + Integer.toHexString(id2) + " fname=" + fname + " existing=" + fragment);
        }
        if (fragment == null) {
            fragment = Fragment.instantiate(context, fname);
            fragment.mFromLayout = true;
            fragment.mFragmentId = id2 != 0 ? id2 : containerId;
            fragment.mContainerId = containerId;
            fragment.mTag = tag;
            fragment.mInLayout = true;
            fragment.mFragmentManager = this;
            fragment.onInflate(this.mActivity, attrs, fragment.mSavedFragmentState);
            this.addFragment(fragment, true);
        } else {
            if (fragment.mInLayout) {
                throw new IllegalArgumentException(attrs.getPositionDescription() + ": Duplicate id 0x" + Integer.toHexString(id2) + ", tag " + tag + ", or parent id 0x" + Integer.toHexString(containerId) + " with another fragment for " + fname);
            }
            fragment.mInLayout = true;
            if (!fragment.mRetaining) {
                fragment.onInflate(this.mActivity, attrs, fragment.mSavedFragmentState);
            }
        }
        if (this.mCurState < 1 && fragment.mFromLayout) {
            this.moveToState(fragment, 1, 0, 0, false);
        } else {
            this.moveToState(fragment);
        }
        if (fragment.mView == null) {
            throw new IllegalStateException("Fragment " + fname + " did not create a view.");
        }
        if (id2 != 0) {
            fragment.mView.setId(id2);
        }
        if (fragment.mView.getTag() == null) {
            fragment.mView.setTag(tag);
        }
        return fragment.mView;
    }

    @Override
    public View onCreateView(String name, Context context, AttributeSet attrs) {
        return null;
    }

    LayoutInflater.Factory2 getLayoutInflaterFactory() {
        return this;
    }
}

