/*
 * Decompiled with CFR 0.152.
 */
package ie.wombat.jbdiff;

import com.intellij.updater.Utils;
import ie.wombat.jbdiff.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;

public class JBPatch {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bspatch(InputStream oldFileIn, OutputStream newFileOut, InputStream diffFileIn) throws IOException {
        byte[] diffData = Utils.readBytes(diffFileIn);
        DataInputStream diffIn = new DataInputStream(new ByteArrayInputStream(diffData));
        long headerMagic = diffIn.readLong();
        long ctrlBlockLen = diffIn.readLong();
        long diffBlockLen = diffIn.readLong();
        int newsize = (int)diffIn.readLong();
        ByteArrayInputStream in = new ByteArrayInputStream(diffData);
        ((InputStream)in).skip(ctrlBlockLen + 32L);
        GZIPInputStream diffBlockIn = new GZIPInputStream(in);
        in = new ByteArrayInputStream(diffData);
        ((InputStream)in).skip(diffBlockLen + ctrlBlockLen + 32L);
        GZIPInputStream extraBlockIn = new GZIPInputStream(in);
        try (ByteArrayOutputStream oldFileByteOut = new ByteArrayOutputStream();){
            Utils.copyStream(oldFileIn, oldFileByteOut);
        }
        byte[] oldBuf = oldFileByteOut.toByteArray();
        int oldsize = oldBuf.length;
        byte[] newBuf = new byte[newsize + 1];
        int oldpos = 0;
        int newpos = 0;
        int[] ctrl = new int[3];
        while (newpos < newsize) {
            int i;
            for (i = 0; i <= 2; ++i) {
                ctrl[i] = diffIn.readInt();
            }
            if (newpos + ctrl[0] > newsize) {
                System.err.println("Corrupt patch\n");
                return;
            }
            if (!Util.readFromStream(diffBlockIn, newBuf, newpos, ctrl[0])) {
                System.err.println("error reading from extraIn");
                return;
            }
            for (i = 0; i < ctrl[0]; ++i) {
                if (oldpos + i < 0 || oldpos + i >= oldsize) continue;
                int n = newpos + i;
                newBuf[n] = (byte)(newBuf[n] + oldBuf[oldpos + i]);
            }
            oldpos += ctrl[0];
            if ((newpos += ctrl[0]) + ctrl[1] > newsize) {
                System.err.println("Corrupt patch");
                return;
            }
            if (!Util.readFromStream(extraBlockIn, newBuf, newpos, ctrl[1])) {
                System.err.println("error reading from extraIn");
                return;
            }
            newpos += ctrl[1];
            oldpos += ctrl[2];
        }
        diffBlockIn.close();
        extraBlockIn.close();
        diffIn.close();
        newFileOut.write(newBuf, 0, newBuf.length - 1);
    }
}

