/*
 * Decompiled with CFR 0.152.
 */
package com.nothome.delta;

import com.nothome.delta.RandomAccessFileSeekableSource;
import com.nothome.delta.SeekableSource;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;

public class GDiffPatcher {
    private ByteBuffer buf = ByteBuffer.allocate(1024);
    private byte[] buf2 = this.buf.array();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void patch(File input, InputStream patch, OutputStream out) throws IOException {
        RandomAccessFileSeekableSource source = new RandomAccessFileSeekableSource(new RandomAccessFile(input, "r"));
        try {
            int command;
            DataOutputStream outOS = new DataOutputStream(out);
            DataInputStream patchIS = new DataInputStream(patch);
            if (patchIS.readUnsignedByte() != 209 || patchIS.readUnsignedByte() != 255 || patchIS.readUnsignedByte() != 209 || patchIS.readUnsignedByte() != 255 || patchIS.readUnsignedByte() != 4) {
                throw new IOException("magic string not found, aborting!");
            }
            block18: while ((command = patchIS.readUnsignedByte()) != 0) {
                if (command <= 246) {
                    this.append(command, patchIS, outOS);
                    continue;
                }
                switch (command) {
                    case 247: {
                        int length = patchIS.readUnsignedShort();
                        this.append(length, patchIS, outOS);
                        continue block18;
                    }
                    case 248: {
                        int length = patchIS.readInt();
                        this.append(length, patchIS, outOS);
                        continue block18;
                    }
                    case 249: {
                        int offset = patchIS.readUnsignedShort();
                        int length = patchIS.readUnsignedByte();
                        this.copy(offset, length, source, outOS);
                        continue block18;
                    }
                    case 250: {
                        int offset = patchIS.readUnsignedShort();
                        int length = patchIS.readUnsignedShort();
                        this.copy(offset, length, source, outOS);
                        continue block18;
                    }
                    case 251: {
                        int offset = patchIS.readUnsignedShort();
                        int length = patchIS.readInt();
                        this.copy(offset, length, source, outOS);
                        continue block18;
                    }
                    case 252: {
                        int offset = patchIS.readInt();
                        int length = patchIS.readUnsignedByte();
                        this.copy(offset, length, source, outOS);
                        continue block18;
                    }
                    case 253: {
                        int offset = patchIS.readInt();
                        int length = patchIS.readUnsignedShort();
                        this.copy(offset, length, source, outOS);
                        continue block18;
                    }
                    case 254: {
                        int offset = patchIS.readInt();
                        int length = patchIS.readInt();
                        this.copy(offset, length, source, outOS);
                        continue block18;
                    }
                    case 255: {
                        long loffset = patchIS.readLong();
                        int length = patchIS.readInt();
                        this.copy(loffset, length, source, outOS);
                        continue block18;
                    }
                }
                throw new IllegalStateException("command " + command);
            }
            outOS.flush();
        }
        finally {
            try {
                source.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void copy(long offset, int length, SeekableSource source, OutputStream output) throws IOException {
        source.seek(offset);
        while (length > 0) {
            int len = Math.min(this.buf.capacity(), length);
            this.buf.clear().limit(len);
            int res = source.read(this.buf);
            if (res == -1) {
                throw new EOFException("in copy " + offset + " " + length);
            }
            output.write(this.buf.array(), 0, res);
            length -= res;
        }
    }

    private void append(int length, InputStream patch, OutputStream output) throws IOException {
        while (length > 0) {
            int len = Math.min(this.buf2.length, length);
            int res = patch.read(this.buf2, 0, len);
            if (res == -1) {
                throw new EOFException("cannot read " + length);
            }
            output.write(this.buf2, 0, res);
            length -= res;
        }
    }
}

