/*
 * Decompiled with CFR 0.152.
 */
package com.nothome.delta;

import com.nothome.delta.Checksum;
import com.nothome.delta.GDiffWriter;
import com.nothome.delta.RandomAccessFileSeekableSource;
import com.nothome.delta.SeekableSource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;

public class Delta {
    public static final int DEFAULT_CHUNK_SIZE = 16;
    private int S;
    private GDiffWriter output;

    public Delta() {
        this.setChunkSize(16);
    }

    public void setChunkSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Invalid size");
        }
        this.S = size;
    }

    public void compute(File sourceFile, File targetFile, OutputStream outputStream) throws IOException {
        GDiffWriter output;
        SourceState source = new SourceState(new RandomAccessFileSeekableSource(new RandomAccessFile(sourceFile, "r")));
        TargetState target = new TargetState(new BufferedInputStream(new FileInputStream(targetFile)));
        this.output = output = new GDiffWriter(outputStream);
        while (!target.eof()) {
            int index = target.find(source);
            if (index != -1) {
                long offset = (long)index * (long)this.S;
                source.seek(offset);
                int match = target.longestMatch(source);
                if (match >= this.S) {
                    output.addCopy(offset, match);
                    continue;
                }
                target.tbuf.position(target.tbuf.position() - match);
                this.addData(target);
                continue;
            }
            this.addData(target);
        }
        output.end();
    }

    private void addData(TargetState target) throws IOException {
        int i = target.read();
        if (i == -1) {
            return;
        }
        this.output.addData((byte)i);
    }

    class TargetState {
        private ReadableByteChannel c;
        private ByteBuffer tbuf = ByteBuffer.allocate(this.blocksize());
        private ByteBuffer sbuf = ByteBuffer.allocate(this.blocksize());
        private long hash;
        private boolean hashReset = true;
        private boolean eof;

        TargetState(InputStream targetIS) throws IOException {
            this.c = Channels.newChannel(targetIS);
            this.tbuf.limit(0);
        }

        private int blocksize() {
            return Math.min(16384, Delta.this.S * 4);
        }

        public int find(SourceState source) throws IOException {
            if (this.eof) {
                return -1;
            }
            this.sbuf.clear();
            this.sbuf.limit(0);
            if (this.hashReset) {
                while (this.tbuf.remaining() < Delta.this.S) {
                    this.tbuf.compact();
                    int read = this.c.read(this.tbuf);
                    this.tbuf.flip();
                    if (read != -1) continue;
                    return -1;
                }
                this.hash = Checksum.queryChecksum(this.tbuf, Delta.this.S);
                this.hashReset = false;
            }
            return source.checksum.findChecksumIndex(this.hash);
        }

        public boolean eof() {
            return this.eof;
        }

        public int read() throws IOException {
            if (this.tbuf.remaining() <= Delta.this.S) {
                this.readMore();
                if (!this.tbuf.hasRemaining()) {
                    this.eof = true;
                    return -1;
                }
            }
            byte b = this.tbuf.get();
            if (this.tbuf.remaining() >= Delta.this.S) {
                byte nchar = this.tbuf.get(this.tbuf.position() + Delta.this.S - 1);
                this.hash = Checksum.incrementChecksum(this.hash, b, nchar, Delta.this.S);
            }
            return b & 0xFF;
        }

        public int longestMatch(SourceState source) throws IOException {
            int match = 0;
            this.hashReset = true;
            while (true) {
                if (!this.sbuf.hasRemaining()) {
                    this.sbuf.clear();
                    int read = source.source.read(this.sbuf);
                    this.sbuf.flip();
                    if (read == -1) {
                        return match;
                    }
                }
                if (!this.tbuf.hasRemaining()) {
                    this.readMore();
                    if (!this.tbuf.hasRemaining()) {
                        this.eof = true;
                        return match;
                    }
                }
                if (this.sbuf.get() != this.tbuf.get()) {
                    this.tbuf.position(this.tbuf.position() - 1);
                    return match;
                }
                ++match;
            }
        }

        private void readMore() throws IOException {
            this.tbuf.compact();
            this.c.read(this.tbuf);
            this.tbuf.flip();
        }

        public String toString() {
            return "Target[ targetBuff=" + this.dump() + " sourceBuff=" + this.sbuf + " hashf=" + this.hash + " eof=" + this.eof + "]";
        }

        private String dump() {
            return this.dump(this.tbuf);
        }

        private String dump(ByteBuffer bb) {
            return this.getTextDump(bb);
        }

        private void append(StringBuffer sb, int value) {
            char b1 = (char)(value >> 4 & 0xF);
            char b2 = (char)(value & 0xF);
            sb.append(Character.forDigit(b1, 16));
            sb.append(Character.forDigit(b2, 16));
        }

        public String getTextDump(ByteBuffer bb) {
            StringBuffer sb = new StringBuffer(bb.remaining() * 2);
            bb.mark();
            while (bb.hasRemaining()) {
                byte val = bb.get();
                if (val > 32 && val < 127) {
                    sb.append(" ").append((char)val);
                    continue;
                }
                this.append(sb, val);
            }
            bb.reset();
            return sb.toString();
        }
    }

    class SourceState {
        private Checksum checksum;
        private SeekableSource source;

        public SourceState(SeekableSource source) throws IOException {
            this.checksum = new Checksum(source, Delta.this.S);
            this.source = source;
            source.seek(0L);
        }

        public void seek(long index) throws IOException {
            this.source.seek(index);
        }

        public String toString() {
            return "Source checksum=" + this.checksum + " source=" + this.source;
        }
    }
}

