/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.updater;

import com.intellij.updater.Runner;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.LinkedHashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Utils {
    private static final byte[] BUFFER = new byte[65536];
    private static File myTempDir;

    public static boolean isZipFile(String fileName) {
        return fileName.endsWith(".zip") || fileName.endsWith(".jar");
    }

    public static File createTempFile() throws IOException {
        if (myTempDir == null) {
            long requiredFreeSpace = 1000000000L;
            File tempFileBase = File.createTempFile("idea.updater.files", "marker", new File(Runner.getDir(requiredFreeSpace)));
            myTempDir = new File(tempFileBase.getPath().replaceAll("marker$", ""));
            Utils.delete(myTempDir);
            myTempDir.mkdirs();
            Runner.logger.info("created temp file: " + myTempDir.getPath());
        }
        return File.createTempFile("temp", null, myTempDir);
    }

    public static File createTempDir() throws IOException {
        File result = Utils.createTempFile();
        Utils.delete(result);
        Runner.logger.info("deleted tmp dir: " + result.getPath());
        result.mkdirs();
        Runner.logger.info("created tmp dir: " + result.getPath());
        if (!result.exists()) {
            throw new IOException("Cannot create temp dir: " + result);
        }
        return result;
    }

    public static void cleanup() throws IOException {
        if (myTempDir == null) {
            return;
        }
        Utils.delete(myTempDir);
        Runner.logger.info("deleted file " + myTempDir.getPath());
        myTempDir = null;
    }

    public static void delete(File file) throws IOException {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File each : files) {
                Utils.delete(each);
                Runner.logger.info("deleted file " + each.getPath());
            }
        }
        for (int i = 0; i < 10; ++i) {
            if (file.delete() || !file.exists()) {
                return;
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException ignore) {
                Runner.printStackTrace(ignore);
            }
        }
        if (file.exists()) {
            throw new IOException("Cannot delete file " + file);
        }
    }

    public static void setExecutable(File file, boolean executable) throws IOException {
        if (executable && !file.setExecutable(true, false)) {
            Runner.logger.error("Can't set executable permissions for file");
            throw new IOException("Cannot set executable permissions for: " + file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File from, File to) throws IOException {
        Runner.logger.info("from " + from.getPath() + " to " + to.getPath());
        if (from.isDirectory()) {
            to.mkdirs();
            File[] files = from.listFiles();
            if (files == null) {
                throw new IOException("Cannot get directory's content: " + from);
            }
            for (File each : files) {
                Utils.copy(each, new File(to, each.getName()));
            }
        } else {
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(from));){
                Utils.copyStreamToFile(in, to);
            }
            Utils.setExecutable(to, from.canExecute());
        }
    }

    public static void mirror(File from, File to) throws IOException {
        if (from.exists()) {
            Utils.copy(from, to);
        } else {
            Utils.delete(to);
        }
    }

    public static void copyFileToStream(File from, OutputStream out) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(from));){
            Utils.copyStream(in, out);
        }
    }

    public static void copyStreamToFile(InputStream from, File to) throws IOException {
        to.getParentFile().mkdirs();
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(to));){
            Utils.copyStream(from, out);
        }
    }

    public static void copyBytesToStream(ByteArrayOutputStream from, OutputStream to) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(to);
        try {
            from.writeTo(out);
        }
        finally {
            ((OutputStream)out).flush();
        }
    }

    public static void copyBytesToStream(byte[] bytes, OutputStream to) throws IOException {
        to.write(bytes);
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        try (ByteArrayOutputStream byteOut = new ByteArrayOutputStream();){
            Utils.copyStream(in, byteOut);
        }
        return byteOut.toByteArray();
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        int read;
        while ((read = in.read(BUFFER)) >= 0) {
            out.write(BUFFER, 0, read);
        }
    }

    public static InputStream getEntryInputStream(ZipFile zipFile, String entryPath) throws IOException {
        ZipEntry entry = Utils.getZipEntry(zipFile, entryPath);
        return Utils.findEntryInputStreamForEntry(zipFile, entry);
    }

    public static InputStream findEntryInputStream(ZipFile zipFile, String entryPath) throws IOException {
        ZipEntry entry = zipFile.getEntry(entryPath);
        if (entry == null) {
            return null;
        }
        return Utils.findEntryInputStreamForEntry(zipFile, entry);
    }

    public static ZipEntry getZipEntry(ZipFile zipFile, String entryPath) throws IOException {
        ZipEntry entry = zipFile.getEntry(entryPath);
        if (entry == null) {
            throw new IOException("Entry " + entryPath + " not found");
        }
        Runner.logger.info("entryPath: " + entryPath);
        return entry;
    }

    public static InputStream findEntryInputStreamForEntry(ZipFile zipFile, ZipEntry entry) throws IOException {
        if (entry.isDirectory()) {
            return null;
        }
        if (zipFile.getEntry(entry.getName() + "/") != null) {
            return null;
        }
        return new BufferedInputStream(zipFile.getInputStream(entry));
    }

    public static LinkedHashSet<String> collectRelativePaths(File dir, boolean includeDirectories) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Utils.collectRelativePaths(dir, result, null, includeDirectories);
        return result;
    }

    private static void collectRelativePaths(File dir, LinkedHashSet<String> result, String parentPath, boolean includeDirectories) {
        File[] children = dir.listFiles();
        if (children == null) {
            return;
        }
        for (File each : children) {
            String relativePath = (parentPath == null ? "" : parentPath + "/") + each.getName();
            if (each.isDirectory()) {
                if (includeDirectories) {
                    result.add(relativePath + "/");
                }
                Utils.collectRelativePaths(each, result, relativePath, includeDirectories);
                continue;
            }
            result.add(relativePath);
        }
    }

    protected static boolean isSymlink(File file) throws IOException {
        return Files.isSymbolicLink(Paths.get(file.toURI()));
    }

    protected static String getSymlinkTarget(File file) throws IOException {
        return Files.readSymbolicLink(Paths.get(file.toURI())).toString();
    }
}

