/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.updater;

import com.intellij.updater.BaseUpdateAction;
import com.intellij.updater.DiffCalculator;
import com.intellij.updater.Patch;
import com.intellij.updater.Runner;
import com.intellij.updater.Utils;
import com.intellij.updater.ZipOutputWrapper;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class UpdateZipAction
extends BaseUpdateAction {
    Set<String> myFilesToCreate;
    Set<String> myFilesToUpdate;
    Set<String> myFilesToDelete;

    public UpdateZipAction(Patch patch, String path, String source, long checksum, boolean move) {
        super(patch, path, source, checksum, move);
    }

    public UpdateZipAction(Patch patch, String path, Collection<String> filesToCreate, Collection<String> filesToUpdate, Collection<String> filesToDelete, long checksum) {
        super(patch, path, path, checksum, false);
        this.myFilesToCreate = new HashSet<String>(filesToCreate);
        this.myFilesToUpdate = new HashSet<String>(filesToUpdate);
        this.myFilesToDelete = new HashSet<String>(filesToDelete);
    }

    public UpdateZipAction(Patch patch, DataInputStream in) throws IOException {
        super(patch, in);
        int count = in.readInt();
        this.myFilesToCreate = new HashSet<String>(count);
        while (count-- > 0) {
            this.myFilesToCreate.add(in.readUTF());
        }
        count = in.readInt();
        this.myFilesToUpdate = new HashSet<String>(count);
        while (count-- > 0) {
            this.myFilesToUpdate.add(in.readUTF());
        }
        count = in.readInt();
        this.myFilesToDelete = new HashSet<String>(count);
        while (count-- > 0) {
            this.myFilesToDelete.add(in.readUTF());
        }
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        super.write(out);
        out.writeInt(this.myFilesToCreate.size());
        for (String each : this.myFilesToCreate) {
            out.writeUTF(each);
        }
        out.writeInt(this.myFilesToUpdate.size());
        for (String each : this.myFilesToUpdate) {
            out.writeUTF(each);
        }
        out.writeInt(this.myFilesToDelete.size());
        for (String each : this.myFilesToDelete) {
            out.writeUTF(each);
        }
    }

    @Override
    protected boolean doCalculate(File olderFile, File newerFile) throws IOException {
        final HashMap<String, Long> oldCheckSums = new HashMap<String, Long>();
        final HashMap<String, Long> newCheckSums = new HashMap<String, Long>();
        UpdateZipAction.processZipFile(olderFile, new Processor(){

            @Override
            public void process(ZipEntry entry, InputStream in) throws IOException {
                oldCheckSums.put(entry.getName(), UpdateZipAction.this.myPatch.getDigester().digestStream(in));
            }
        });
        UpdateZipAction.processZipFile(newerFile, new Processor(){

            @Override
            public void process(ZipEntry entry, InputStream in) throws IOException {
                newCheckSums.put(entry.getName(), UpdateZipAction.this.myPatch.getDigester().digestStream(in));
            }
        });
        DiffCalculator.Result diff = DiffCalculator.calculate(oldCheckSums, newCheckSums, new LinkedList<String>(), false);
        this.myFilesToCreate = diff.filesToCreate.keySet();
        this.myFilesToUpdate = diff.filesToUpdate.keySet();
        this.myFilesToDelete = diff.filesToDelete.keySet();
        return !this.myFilesToCreate.isEmpty() || !this.myFilesToUpdate.isEmpty() || !this.myFilesToDelete.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doBuildPatchFile(File olderFile, File newerFile, final ZipOutputStream patchOutput) throws IOException {
        ZipFile olderZip;
        try {
            new ZipFile(newerFile).close();
        }
        catch (IOException e) {
            Runner.logger.error("Corrupted target file: " + newerFile);
            Runner.printStackTrace(e);
            throw new IOException("Corrupted target file: " + newerFile, e);
        }
        final HashSet<String> filesToProcess = new HashSet<String>(this.myFilesToCreate);
        filesToProcess.addAll(this.myFilesToUpdate);
        if (filesToProcess.isEmpty()) {
            return;
        }
        try {
            olderZip = new ZipFile(olderFile);
        }
        catch (IOException e) {
            Runner.logger.error("Corrupted source file: " + olderFile);
            Runner.printStackTrace(e);
            throw new IOException("Corrupted source file: " + olderFile, e);
        }
        try {
            UpdateZipAction.processZipFile(newerFile, new Processor(){

                @Override
                public void process(ZipEntry newerEntry, InputStream newerEntryIn) throws IOException {
                    if (newerEntry.isDirectory()) {
                        return;
                    }
                    String name = newerEntry.getName();
                    if (!filesToProcess.contains(name)) {
                        return;
                    }
                    try {
                        patchOutput.putNextEntry(new ZipEntry(UpdateZipAction.this.myPath + "/" + name));
                        InputStream olderEntryIn = Utils.findEntryInputStream(olderZip, name);
                        if (olderEntryIn == null) {
                            Utils.copyStream(newerEntryIn, patchOutput);
                        } else {
                            UpdateZipAction.this.writeDiff(olderEntryIn, newerEntryIn, (OutputStream)patchOutput);
                        }
                        patchOutput.closeEntry();
                    }
                    catch (IOException e) {
                        Runner.logger.error("Error building patch for .zip entry " + name);
                        Runner.printStackTrace(e);
                        throw new IOException("Error building patch for .zip entry " + name, e);
                    }
                }
            });
        }
        finally {
            olderZip.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doApply(final ZipFile patchFile, File backupDir, File toFile) throws IOException {
        File temp = Utils.createTempFile();
        try (FileOutputStream fileOut = new FileOutputStream(temp);){
            final ZipOutputWrapper out = new ZipOutputWrapper(fileOut);
            out.setCompressionLevel(0);
            UpdateZipAction.processZipFile(this.getSource(backupDir), new Processor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void process(ZipEntry entry, InputStream in) throws IOException {
                    String path = entry.getName();
                    if (UpdateZipAction.this.myFilesToDelete.contains(path)) {
                        return;
                    }
                    if (UpdateZipAction.this.myFilesToUpdate.contains(path)) {
                        try (OutputStream entryOut = out.zipStream(path);){
                            UpdateZipAction.this.applyDiff(Utils.findEntryInputStream(patchFile, UpdateZipAction.this.myPath + "/" + path), in, entryOut);
                        }
                    } else {
                        out.zipEntry(entry, in);
                    }
                }
            });
            for (String each : this.myFilesToCreate) {
                try (InputStream in = Utils.getEntryInputStream(patchFile, this.myPath + "/" + each);){
                    out.zipEntry(each, in);
                }
            }
            out.finish();
        }
        this.replaceUpdated(temp, toFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processZipFile(File file, Processor processor) throws IOException {
        try (ZipInputStream in = new ZipInputStream(new FileInputStream(file));){
            ZipEntry inEntry;
            HashSet<String> processed = new HashSet<String>();
            while ((inEntry = in.getNextEntry()) != null) {
                if (inEntry.isDirectory()) continue;
                if (processed.contains(inEntry.getName())) {
                    throw new IOException("Duplicate entry '" + inEntry.getName() + "' in " + file.getPath());
                }
                processor.process(inEntry, new BufferedInputStream(in));
                processed.add(inEntry.getName());
            }
        }
    }

    @Override
    public String toString() {
        return super.toString() + this.myFilesToCreate + " " + this.myFilesToUpdate + " " + this.myFilesToDelete;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UpdateZipAction that = (UpdateZipAction)o;
        if (this.myFilesToCreate != null ? !this.myFilesToCreate.equals(that.myFilesToCreate) : that.myFilesToCreate != null) {
            return false;
        }
        if (this.myFilesToUpdate != null ? !this.myFilesToUpdate.equals(that.myFilesToUpdate) : that.myFilesToUpdate != null) {
            return false;
        }
        return !(this.myFilesToDelete != null ? !this.myFilesToDelete.equals(that.myFilesToDelete) : that.myFilesToDelete != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.myFilesToCreate != null ? this.myFilesToCreate.hashCode() : 0);
        result = 31 * result + (this.myFilesToUpdate != null ? this.myFilesToUpdate.hashCode() : 0);
        result = 31 * result + (this.myFilesToDelete != null ? this.myFilesToDelete.hashCode() : 0);
        return result;
    }

    private static interface Processor {
        public void process(ZipEntry var1, InputStream var2) throws IOException;
    }
}

