/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.updater;

import com.intellij.updater.BaseUpdateAction;
import com.intellij.updater.Patch;
import com.intellij.updater.Utils;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class UpdateAction
extends BaseUpdateAction {
    public UpdateAction(Patch patch, String path, String source, long checksum, boolean move) {
        super(patch, path, source, checksum, move);
    }

    public UpdateAction(Patch patch, String path, long checksum) {
        this(patch, path, path, checksum, false);
    }

    public UpdateAction(Patch patch, DataInputStream in) throws IOException {
        super(patch, in);
    }

    @Override
    protected void doBuildPatchFile(File olderFile, File newerFile, ZipOutputStream patchOutput) throws IOException {
        if (Utils.isSymlink(newerFile)) {
            throw new IOException(String.format("Updates to symlinks not supported: %s -> %s", newerFile.getAbsolutePath(), newerFile.getCanonicalPath()));
        }
        if (!this.myIsMove) {
            patchOutput.putNextEntry(new ZipEntry(this.myPath));
            UpdateAction.writeExecutableFlag(patchOutput, newerFile);
            this.writeDiff(olderFile, newerFile, (OutputStream)patchOutput);
            patchOutput.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doApply(ZipFile patchFile, File backupDir, File toFile) throws IOException {
        File updated;
        File source = this.getSource(backupDir);
        if (!this.myIsMove) {
            updated = Utils.createTempFile();
            InputStream in = Utils.findEntryInputStream(patchFile, this.myPath);
            boolean executable = UpdateAction.readFlag(in);
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(updated));
                 InputStream oldFileIn = null;){
                this.applyDiff(in, source, (OutputStream)out);
            }
            Utils.setExecutable(updated, executable);
        } else {
            updated = source;
        }
        this.replaceUpdated(updated, toFile);
    }
}

