/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.updater;

import com.intellij.updater.OperationCancelledException;
import com.intellij.updater.UpdaterUI;
import com.intellij.updater.ValidationResult;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public abstract class SwingUpdaterUI
implements UpdaterUI {
    private static final EmptyBorder FRAME_BORDER = new EmptyBorder(8, 8, 8, 8);
    private static final EmptyBorder LABEL_BORDER = new EmptyBorder(0, 0, 5, 0);
    private static final EmptyBorder BUTTONS_BORDER = new EmptyBorder(5, 0, 0, 0);
    private static final String TITLE = "Update";
    private static final String CANCEL_BUTTON_TITLE = "Cancel";
    private static final String PROCEED_BUTTON_TITLE = "Proceed";
    private final AtomicBoolean isCancelled = new AtomicBoolean(false);

    protected abstract Component getParentComponent();

    protected abstract void notifyCancelled();

    protected abstract void exit();

    @Override
    public boolean showWarning(String message) {
        Object[] choices = new Object[]{"Retry", "Exit"};
        int choice = JOptionPane.showOptionDialog(this.getParentComponent(), message, "Warning", -1, 3, null, choices, choices[0]);
        return choice == 0;
    }

    @Override
    public Map<String, ValidationResult.Option> askUser(List<ValidationResult> validationResults) throws OperationCancelledException {
        if (validationResults.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, ValidationResult.Option> result = new HashMap<String, ValidationResult.Option>();
        try {
            SwingUtilities.invokeAndWait(() -> {
                Component parent;
                boolean proceed = true;
                for (ValidationResult result1 : validationResults) {
                    if (!result1.options.contains((Object)ValidationResult.Option.NONE)) continue;
                    proceed = false;
                    break;
                }
                JDialog dialog = (parent = this.getParentComponent()) instanceof Frame ? new JDialog((Frame)parent, TITLE, true) : new JDialog((Dialog)parent, TITLE, true);
                dialog.setLayout(new BorderLayout());
                dialog.setDefaultCloseOperation(0);
                JPanel buttonsPanel = new JPanel();
                buttonsPanel.setBorder(BUTTONS_BORDER);
                buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
                buttonsPanel.add(Box.createHorizontalGlue());
                JButton cancelButton = new JButton(CANCEL_BUTTON_TITLE);
                cancelButton.addActionListener(e -> {
                    this.isCancelled.set(true);
                    this.notifyCancelled();
                    dialog.setVisible(false);
                });
                buttonsPanel.add(cancelButton);
                if (proceed) {
                    JButton proceedButton = new JButton(PROCEED_BUTTON_TITLE);
                    proceedButton.addActionListener(e -> dialog.setVisible(false));
                    buttonsPanel.add(proceedButton);
                    dialog.getRootPane().setDefaultButton(proceedButton);
                } else {
                    dialog.getRootPane().setDefaultButton(cancelButton);
                }
                JTable table = new JTable();
                table.setCellSelectionEnabled(true);
                table.setDefaultEditor(ValidationResult.Option.class, new MyCellEditor());
                table.setDefaultRenderer(Object.class, new MyCellRenderer());
                MyTableModel model = new MyTableModel(validationResults);
                table.setModel(model);
                for (int i = 0; i < table.getColumnModel().getColumnCount(); ++i) {
                    TableColumn each = table.getColumnModel().getColumn(i);
                    each.setPreferredWidth(MyTableModel.getColumnWidth(i, new Dimension((int)600, (int)400).width));
                }
                String message = "<html>Some conflicts were found in the installation area.<br><br>";
                message = proceed ? message + "Please select desired solutions from the " + MyTableModel.COLUMNS[3] + " column and press " + PROCEED_BUTTON_TITLE + ".<br>If you do not want to proceed with the update, please press " + CANCEL_BUTTON_TITLE + ".</html>" : message + "Some of the conflicts below do not have a solution, so the patch cannot be applied.<br>Press Cancel to exit.</html>";
                JLabel label = new JLabel(message);
                label.setBorder(LABEL_BORDER);
                dialog.add((Component)label, "North");
                dialog.add((Component)new JScrollPane(table), "Center");
                dialog.add((Component)buttonsPanel, "South");
                dialog.getRootPane().setBorder(FRAME_BORDER);
                dialog.setSize(new Dimension(600, 400));
                dialog.setLocationRelativeTo(null);
                dialog.setVisible(true);
                result.putAll(model.getResult());
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        this.checkCancelled();
        return result;
    }

    @Override
    public void checkCancelled() throws OperationCancelledException {
        if (this.isCancelled.get()) {
            throw new OperationCancelledException();
        }
    }

    private static class MyCellRenderer
    extends DefaultTableCellRenderer {
        private MyCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component result = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!isSelected) {
                MyTableModel tableModel = (MyTableModel)table.getModel();
                Color color = table.getBackground();
                switch (tableModel.getKind(row)) {
                    case ERROR: {
                        color = new Color(255, 175, 175);
                        break;
                    }
                    case CONFLICT: {
                        color = new Color(255, 240, 240);
                    }
                }
                result.setBackground(color);
            }
            return result;
        }
    }

    private static class MyCellEditor
    extends DefaultCellEditor {
        public MyCellEditor() {
            super(new JComboBox());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            MyTableModel tableModel = (MyTableModel)table.getModel();
            DefaultComboBoxModel<ValidationResult.Option> comboModel = new DefaultComboBoxModel<ValidationResult.Option>();
            for (ValidationResult.Option each : tableModel.getOptions(row)) {
                comboModel.addElement(each);
            }
            ((JComboBox)this.editorComponent).setModel(comboModel);
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    private static class MyTableModel
    extends AbstractTableModel {
        public static final String[] COLUMNS = new String[]{"File", "Action", "Problem", "Solution"};
        public static final int OPTIONS_COLUMN_INDEX = 3;
        private final List<Item> myItems = new ArrayList<Item>();

        public MyTableModel(List<ValidationResult> validationResults) {
            for (ValidationResult each : validationResults) {
                this.myItems.add(new Item(each, each.options.get(0)));
            }
        }

        @Override
        public int getColumnCount() {
            return COLUMNS.length;
        }

        @Override
        public String getColumnName(int column) {
            return COLUMNS[column];
        }

        public static int getColumnWidth(int column, int totalWidth) {
            switch (column) {
                case 0: {
                    return (int)((double)totalWidth * 0.6);
                }
            }
            return (int)((double)totalWidth * 0.15);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 3) {
                return ValidationResult.Option.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public int getRowCount() {
            return this.myItems.size();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 3 && this.getOptions(rowIndex).size() > 1;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            if (columnIndex == 3) {
                this.myItems.get((int)rowIndex).option = (ValidationResult.Option)((Object)value);
            }
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Item item = this.myItems.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return item.validationResult.path;
                }
                case 1: {
                    return item.validationResult.action;
                }
                case 2: {
                    return item.validationResult.message;
                }
                case 3: {
                    return item.option;
                }
            }
            return null;
        }

        public ValidationResult.Kind getKind(int rowIndex) {
            return this.myItems.get((int)rowIndex).validationResult.kind;
        }

        public List<ValidationResult.Option> getOptions(int rowIndex) {
            Item item = this.myItems.get(rowIndex);
            return item.validationResult.options;
        }

        public Map<String, ValidationResult.Option> getResult() {
            HashMap<String, ValidationResult.Option> result = new HashMap<String, ValidationResult.Option>();
            for (Item each : this.myItems) {
                result.put(each.validationResult.path, each.option);
            }
            return result;
        }

        private static class Item {
            ValidationResult validationResult;
            ValidationResult.Option option;

            private Item(ValidationResult validationResult, ValidationResult.Option option) {
                this.validationResult = validationResult;
                this.option = option;
            }
        }
    }
}

