/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.updater;

import com.intellij.updater.OperationCancelledException;
import com.intellij.updater.Runner;
import com.intellij.updater.SwingUpdaterUI;
import com.intellij.updater.UpdaterUI;
import com.intellij.updater.ValidationResult;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class StandaloneSwingUpdaterUI
extends SwingUpdaterUI {
    private static final int RESULT_REQUIRES_RESTART = 42;
    private static final EmptyBorder FRAME_BORDER = new EmptyBorder(8, 8, 8, 8);
    private static final EmptyBorder LABEL_BORDER = new EmptyBorder(0, 0, 5, 0);
    private static final EmptyBorder BUTTONS_BORDER = new EmptyBorder(5, 0, 0, 0);
    private static final String TITLE = "Update";
    private static final String CANCEL_BUTTON_TITLE = "Cancel";
    private static final String EXIT_BUTTON_TITLE = "Exit";
    private static final String PROCEED_BUTTON_TITLE = "Proceed";
    private final InstallOperation myOperation;
    private final JLabel myProcessTitle;
    private final JProgressBar myProcessProgress;
    private final JLabel myProcessStatus;
    private final JTextArea myConsole;
    private final JPanel myConsolePane;
    private final JButton myCancelButton;
    private final ConcurrentLinkedQueue<UpdateRequest> myQueue = new ConcurrentLinkedQueue();
    private final AtomicBoolean isCancelled = new AtomicBoolean(false);
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private final AtomicBoolean hasError = new AtomicBoolean(false);
    private final JFrame myFrame;
    private boolean myApplied;

    public StandaloneSwingUpdaterUI(InstallOperation operation) {
        this.myOperation = operation;
        this.myProcessTitle = new JLabel(" ");
        this.myProcessProgress = new JProgressBar(0, 100);
        this.myProcessStatus = new JLabel(" ");
        this.myCancelButton = new JButton(CANCEL_BUTTON_TITLE);
        this.myConsole = new JTextArea();
        this.myConsole.setLineWrap(true);
        this.myConsole.setWrapStyleWord(true);
        this.myConsole.setCaretPosition(this.myConsole.getText().length());
        this.myConsole.setTabSize(1);
        this.myConsole.setMargin(new Insets(2, 4, 2, 4));
        this.myConsolePane = new JPanel(new BorderLayout());
        this.myConsolePane.add(new JScrollPane(this.myConsole));
        this.myConsolePane.setBorder(BUTTONS_BORDER);
        this.myConsolePane.setVisible(false);
        this.myCancelButton.addActionListener(e -> this.doCancel());
        this.myFrame = new JFrame();
        this.myFrame.setTitle(TITLE);
        this.myFrame.setLayout(new BorderLayout());
        this.myFrame.getRootPane().setBorder(FRAME_BORDER);
        this.myFrame.setDefaultCloseOperation(0);
        this.myFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                StandaloneSwingUpdaterUI.this.doCancel();
            }
        });
        JPanel processPanel = new JPanel();
        processPanel.setLayout(new BoxLayout(processPanel, 1));
        processPanel.add(this.myProcessTitle);
        processPanel.add(this.myProcessProgress);
        processPanel.add(this.myProcessStatus);
        processPanel.add(this.myConsolePane);
        for (Component each : processPanel.getComponents()) {
            ((JComponent)each).setAlignmentX(0.0f);
        }
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setBorder(BUTTONS_BORDER);
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        buttonsPanel.add(Box.createHorizontalGlue());
        buttonsPanel.add(this.myCancelButton);
        this.myFrame.add((Component)processPanel, "Center");
        this.myFrame.add((Component)buttonsPanel, "South");
        this.myFrame.setMinimumSize(new Dimension(500, 50));
        this.myFrame.pack();
        this.myFrame.setLocationRelativeTo(null);
        this.myFrame.setVisible(true);
        this.myQueue.add(this::doPerform);
        this.startRequestDispatching();
    }

    @Override
    public void setDescription(String oldBuildDesc, String newBuildDesc) {
        this.myProcessTitle.setText("<html>Updating " + oldBuildDesc + " to " + newBuildDesc + "...");
    }

    @Override
    public boolean showWarning(String message) {
        Object[] choices = new Object[]{"Retry", EXIT_BUTTON_TITLE};
        int choice = JOptionPane.showOptionDialog(null, message, "Warning", -1, 3, null, choices, choices[0]);
        return choice == 0;
    }

    private void startRequestDispatching() {
        new Thread(() -> {
            while (true) {
                UpdateRequest request;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Runner.printStackTrace(e);
                    return;
                }
                ArrayList<UpdateRequest> pendingRequests = new ArrayList<UpdateRequest>();
                while ((request = this.myQueue.poll()) != null) {
                    pendingRequests.add(request);
                }
                SwingUtilities.invokeLater(() -> {
                    for (UpdateRequest each : pendingRequests) {
                        each.perform();
                    }
                });
            }
        }, "swing updater dispatch").start();
    }

    private void doCancel() {
        if (this.isRunning.get()) {
            int result = JOptionPane.showConfirmDialog(this.myFrame, "The patch has not been applied yet.\nAre you sure you want to abort the operation?", TITLE, 0);
            if (result == 0) {
                this.isCancelled.set(true);
                this.myCancelButton.setEnabled(false);
            }
        } else {
            this.exit();
        }
    }

    private void doPerform() {
        this.isRunning.set(true);
        new Thread(() -> {
            try {
                this.myApplied = this.myOperation.execute(this);
            }
            catch (OperationCancelledException ignore) {
                Runner.printStackTrace(ignore);
            }
            catch (Throwable e) {
                Runner.printStackTrace(e);
                this.showError(e);
            }
            finally {
                this.isRunning.set(false);
                if (this.hasError.get()) {
                    this.startProcess("Failed to apply patch");
                    this.setProgress(100);
                    this.myCancelButton.setText(EXIT_BUTTON_TITLE);
                    this.myCancelButton.setEnabled(true);
                } else {
                    this.exit();
                }
            }
        }, "swing updater").start();
    }

    @Override
    protected Component getParentComponent() {
        return this.myFrame;
    }

    @Override
    protected void notifyCancelled() {
        this.myCancelButton.setEnabled(false);
    }

    @Override
    protected void exit() {
        System.exit(this.myApplied ? 42 : 0);
    }

    @Override
    public void startProcess(String title) {
        this.myQueue.add(() -> {
            this.myProcessStatus.setText(title);
            this.myProcessProgress.setIndeterminate(false);
            this.myProcessProgress.setValue(0);
        });
    }

    @Override
    public void setProgress(int percentage) {
        this.myQueue.add(() -> {
            this.myProcessProgress.setIndeterminate(false);
            this.myProcessProgress.setValue(percentage);
        });
    }

    @Override
    public void setProgressIndeterminate() {
        this.myQueue.add(() -> this.myProcessProgress.setIndeterminate(true));
    }

    @Override
    public void setStatus(String status) {
    }

    @Override
    public void showError(Throwable e) {
        this.hasError.set(true);
        this.myQueue.add(() -> {
            StringWriter w = new StringWriter();
            if (!this.myConsolePane.isVisible()) {
                w.write("Temp. directory: ");
                w.write(System.getProperty("java.io.tmpdir"));
                w.write("\n\n");
            }
            e.printStackTrace(new PrintWriter(w));
            w.append("\n");
            this.myConsole.append(w.getBuffer().toString());
            if (!this.myConsolePane.isVisible()) {
                this.myConsole.setCaretPosition(0);
                this.myConsolePane.setVisible(true);
                this.myConsolePane.setPreferredSize(new Dimension(10, 200));
                this.myFrame.pack();
            }
        });
    }

    @Override
    public void checkCancelled() throws OperationCancelledException {
        if (this.isCancelled.get()) {
            throw new OperationCancelledException();
        }
    }

    public static void main(String[] args) {
        new StandaloneSwingUpdaterUI(ui -> {
            int i;
            ui.startProcess("Process1");
            ui.checkCancelled();
            for (i = 0; i < 200; ++i) {
                ui.setStatus("i = " + i);
                ui.checkCancelled();
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                ui.setProgress((i + 1) * 100 / 200);
            }
            ui.showError(new Throwable());
            ui.startProcess("Process3");
            ui.checkCancelled();
            ui.setProgressIndeterminate();
            try {
                for (i = 0; i < 200; ++i) {
                    ui.setStatus("i = " + i);
                    ui.checkCancelled();
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    ui.setProgress((i + 1) * 100 / 200);
                    if (i != 100) continue;
                    ArrayList<ValidationResult> vr = new ArrayList<ValidationResult>();
                    vr.add(new ValidationResult(ValidationResult.Kind.ERROR, "foo/bar", null, ValidationResult.Action.CREATE, "Hello", ValidationResult.Option.REPLACE, ValidationResult.Option.KEEP));
                    vr.add(new ValidationResult(ValidationResult.Kind.CONFLICT, "foo/bar/baz", null, ValidationResult.Action.DELETE, "World", ValidationResult.Option.DELETE, ValidationResult.Option.KEEP));
                    vr.add(new ValidationResult(ValidationResult.Kind.INFO, "xxx", null, ValidationResult.Action.NO_ACTION, "bla-bla", ValidationResult.Option.IGNORE));
                    ui.askUser(vr);
                }
            }
            finally {
                ui.startProcess("Process2");
                for (i = 0; i < 200; ++i) {
                    ui.setStatus("i = " + i);
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    ui.setProgress((i + 1) * 100 / 200);
                }
            }
            return true;
        });
    }

    private static interface UpdateRequest {
        public void perform();
    }

    public static interface InstallOperation {
        public boolean execute(UpdaterUI var1) throws OperationCancelledException;
    }
}

