/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.updater;

import java.util.Collections;
import java.util.List;
import java.util.Map;

public class PatchSpec {
    private String myOldVersionDescription = "";
    private String myNewVersionDescription = "";
    private String myOldFolder;
    private String myNewFolder;
    private String myPatchFile;
    private String myJarFile;
    private boolean myIsBinary;
    private boolean myIsStrict;
    private String myHashAlgorithm = "crc";
    private long myLargeFileCutoff = Long.MAX_VALUE;
    private List<String> myIgnoredFiles = Collections.emptyList();
    private List<String> myCriticalFiles = Collections.emptyList();
    private List<String> myOptionalFiles = Collections.emptyList();
    private Map<String, String> myWarnings = Collections.emptyMap();
    private List<String> myDeleteFiles = Collections.emptyList();
    private String myRoot = "";
    private static final long DEFAULT_LARGE_FILE_CUTOFF = 50000000L;

    public String getOldVersionDescription() {
        return this.myOldVersionDescription;
    }

    public PatchSpec setOldVersionDescription(String oldVersionDescription) {
        this.myOldVersionDescription = oldVersionDescription;
        return this;
    }

    public String getNewVersionDescription() {
        return this.myNewVersionDescription;
    }

    public PatchSpec setNewVersionDescription(String newVersionDescription) {
        this.myNewVersionDescription = newVersionDescription;
        return this;
    }

    public String getOldFolder() {
        return this.myOldFolder;
    }

    public PatchSpec setOldFolder(String oldFolder) {
        this.myOldFolder = oldFolder;
        return this;
    }

    public String getNewFolder() {
        return this.myNewFolder;
    }

    public PatchSpec setNewFolder(String newFolder) {
        this.myNewFolder = newFolder;
        return this;
    }

    public String getPatchFile() {
        return this.myPatchFile;
    }

    public PatchSpec setPatchFile(String patchFile) {
        this.myPatchFile = patchFile;
        return this;
    }

    public String getJarFile() {
        return this.myJarFile;
    }

    public PatchSpec setJarFile(String jarFile) {
        this.myJarFile = jarFile;
        return this;
    }

    public boolean isStrict() {
        return this.myIsStrict;
    }

    public PatchSpec setStrict(boolean strict) {
        this.myIsStrict = strict;
        return this;
    }

    public PatchSpec setSupportLargeFiles(boolean supportLargeFiles) {
        this.myLargeFileCutoff = supportLargeFiles ? 50000000L : Long.MAX_VALUE;
        return this;
    }

    PatchSpec setLargeFileCutoff(long cutoff) {
        this.myLargeFileCutoff = cutoff;
        return this;
    }

    public List<String> getIgnoredFiles() {
        return this.myIgnoredFiles;
    }

    public PatchSpec setIgnoredFiles(List<String> ignoredFiles) {
        this.myIgnoredFiles = ignoredFiles;
        return this;
    }

    public List<String> getCriticalFiles() {
        return this.myCriticalFiles;
    }

    public PatchSpec setCriticalFiles(List<String> criticalFiles) {
        this.myCriticalFiles = criticalFiles;
        return this;
    }

    public List<String> getOptionalFiles() {
        return this.myOptionalFiles;
    }

    public PatchSpec setOptionalFiles(List<String> optionalFiles) {
        this.myOptionalFiles = optionalFiles;
        return this;
    }

    public PatchSpec setBinary(boolean binary) {
        this.myIsBinary = binary;
        return this;
    }

    public boolean isBinary() {
        return this.myIsBinary;
    }

    public PatchSpec setHashAlgorithm(String hashAlgorithm) {
        if (hashAlgorithm != null) {
            this.myHashAlgorithm = hashAlgorithm;
        }
        return this;
    }

    public String getHashAlgorithm() {
        return this.myHashAlgorithm;
    }

    public PatchSpec setWarnings(Map<String, String> warnings) {
        this.myWarnings = warnings;
        return this;
    }

    public Map<String, String> getWarnings() {
        return this.myWarnings;
    }

    public PatchSpec setDeleteFiles(List<String> deleteFiles) {
        this.myDeleteFiles = deleteFiles;
        return this;
    }

    public List<String> getDeleteFiles() {
        return this.myDeleteFiles;
    }

    public PatchSpec setRoot(String root) {
        this.myRoot = root;
        return this;
    }

    public String getRoot() {
        return this.myRoot;
    }

    public long getLargeFileCutoff() {
        return this.myLargeFileCutoff;
    }
}

