/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.updater;

import com.intellij.updater.Digester;
import com.intellij.updater.Patch;
import com.intellij.updater.PatchAction;
import com.intellij.updater.Runner;
import com.intellij.updater.Utils;
import com.intellij.updater.ValidationResult;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class CreateAction
extends PatchAction {
    public CreateAction(Patch patch, String path) {
        super(patch, path, Digester.INVALID);
    }

    public CreateAction(Patch patch, DataInputStream in) throws IOException {
        super(patch, in);
    }

    @Override
    protected void doBuildPatchFile(File olderFile, File newerFile, ZipOutputStream patchOutput) throws IOException {
        Runner.logger.info("building PatchFile");
        ZipEntry entry = new ZipEntry(this.myPath);
        patchOutput.putNextEntry(entry);
        if (!newerFile.isDirectory()) {
            CreateAction.writeExecutableFlag(patchOutput, newerFile);
            CreateAction.writeSymlinkFlag(patchOutput, newerFile);
            if (Utils.isSymlink(newerFile)) {
                patchOutput.write(Utils.getSymlinkTarget(newerFile).getBytes(StandardCharsets.UTF_8));
            } else {
                Utils.copyFileToStream(newerFile, patchOutput);
            }
        }
        patchOutput.closeEntry();
    }

    @Override
    public ValidationResult validate(File toDir) {
        File toFile = this.getFile(toDir);
        ValidationResult result = this.doValidateAccess(toFile, ValidationResult.Action.CREATE);
        if (result != null) {
            return result;
        }
        if (toFile.exists()) {
            ValidationResult.Option[] optionArray;
            if (this.myPatch.isStrict()) {
                ValidationResult.Option[] optionArray2 = new ValidationResult.Option[1];
                optionArray = optionArray2;
                optionArray2[0] = ValidationResult.Option.REPLACE;
            } else {
                ValidationResult.Option[] optionArray3 = new ValidationResult.Option[2];
                optionArray3[0] = ValidationResult.Option.REPLACE;
                optionArray = optionArray3;
                optionArray3[1] = ValidationResult.Option.KEEP;
            }
            ValidationResult.Option[] options = optionArray;
            return new ValidationResult(ValidationResult.Kind.CONFLICT, this.myPath, toFile, ValidationResult.Action.CREATE, "Already exists", options);
        }
        return null;
    }

    @Override
    protected boolean isModified(File toFile) throws IOException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doApply(ZipFile patchFile, File backupDir, File toFile) throws IOException {
        CreateAction.prepareToWriteFile(toFile);
        ZipEntry entry = Utils.getZipEntry(patchFile, this.myPath);
        if (entry.isDirectory()) {
            if (!toFile.mkdir()) {
                throw new IOException("Unable to create directory " + this.myPath);
            }
        } else {
            try (InputStream in = Utils.findEntryInputStreamForEntry(patchFile, entry);){
                boolean executable;
                block12: {
                    executable = CreateAction.readFlag(in);
                    boolean link = CreateAction.readFlag(in);
                    if (link) {
                        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                        Utils.copyStream(in, bytesOut);
                        File containingDir = toFile.getAbsoluteFile().getParentFile();
                        if (!containingDir.exists() && !containingDir.mkdirs()) {
                            throw new IOException("Failed to mkdirs: " + toFile.getAbsoluteFile().getParent());
                        }
                        Process proc = Runtime.getRuntime().exec(new String[]{"ln", "-s", bytesOut.toString(), toFile.getAbsolutePath()});
                        try (BufferedReader errorReader = new BufferedReader(new InputStreamReader(proc.getErrorStream()));){
                            String error = errorReader.readLine();
                            if (error != null && !error.isEmpty()) {
                                throw new IOException(error);
                            }
                            break block12;
                        }
                    }
                    Utils.copyStreamToFile(in, toFile);
                }
                Utils.setExecutable(toFile, executable);
            }
        }
    }

    private static void prepareToWriteFile(File file) throws IOException {
        if (file.exists()) {
            Utils.delete(file);
            return;
        }
        while (file != null && !file.exists()) {
            file = file.getParentFile();
        }
        if (file != null && !file.isDirectory()) {
            Utils.delete(file);
        }
    }

    @Override
    protected void doBackup(File toFile, File backupFile) {
    }

    @Override
    protected void doRevert(File toFile, File backupFile) throws IOException {
        Utils.delete(toFile);
    }
}

