/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.updater;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Locale;

public class Bootstrap {
    private static final String IJ_PLATFORM_UPDATER = "ijPlatformUpdater";

    public static void main(String[] args) throws URISyntaxException, IOException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InterruptedException {
        File file;
        String path;
        if (args.length != 1) {
            return;
        }
        String string = path = args[0].endsWith("\\") || args[0].endsWith("/") ? args[0] : args[0] + File.separator;
        if (Bootstrap.isMac() && path.endsWith(".app/") && (file = new File(path + "Contents")).exists() && file.isDirectory()) {
            path = path + "Contents/";
        }
        Bootstrap.cleanUp();
        ArrayList<URL> urls = new ArrayList<URL>();
        ArrayList<File> files = new ArrayList<File>();
        try (InputStream stream = Bootstrap.class.getClassLoader().getResourceAsStream("dependencies.txt");
             BufferedReader br = new BufferedReader(new InputStreamReader(stream));){
            String line;
            while ((line = br.readLine()) != null) {
                File file2 = new File(path + line);
                Path tmp = Files.createTempFile(IJ_PLATFORM_UPDATER + file2.getName(), "", new FileAttribute[0]);
                Files.copy(file2.toPath(), Files.newOutputStream(tmp, new OpenOption[0]));
                urls.add(tmp.toFile().toURI().toURL());
                files.add(tmp.toFile());
            }
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            Bootstrap.log(System.getProperty("os.name"));
            try {
                for (File file : files) {
                    Bootstrap.log("Deleting " + file.getName() + " - " + (file.delete() ? "OK" : "FAIL"));
                }
            }
            catch (Exception e) {
                Bootstrap.log(e);
            }
        }));
        for (URL url : urls) {
            URLClassLoader classLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)classLoader, url);
        }
        Class<?> runner = Bootstrap.class.getClassLoader().loadClass("com.intellij.updater.Runner");
        Method main = runner.getMethod("main", String[].class);
        main.invoke(null, new Object[]{new String[]{"apply", args[0]}});
    }

    private static void cleanUp() {
        Bootstrap.log("Cleaning up...");
        try {
            Path file = Files.createTempFile("", "", new FileAttribute[0]);
            Files.list(file.getParent()).forEach(p -> {
                if (!p.toFile().isDirectory() && p.toFile().getName().startsWith(IJ_PLATFORM_UPDATER)) {
                    try {
                        Bootstrap.log("Deleting " + p.toString());
                        Files.delete(p);
                    }
                    catch (IOException e) {
                        Bootstrap.log("Can't delete " + p.toString());
                        Bootstrap.log(e);
                    }
                }
            });
            Files.delete(file);
        }
        catch (IOException e) {
            Bootstrap.log(e);
        }
    }

    private static void log(String msg) {
        System.out.println(msg);
    }

    private static void log(Throwable ex) {
        ex.printStackTrace();
    }

    private static boolean isMac() {
        return System.getProperty("os.name").toLowerCase(Locale.US).startsWith("mac");
    }
}

