/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.updater;

import com.android.repository.api.ProgressIndicator;
import com.google.common.collect.ImmutableMap;
import com.intellij.updater.DiffAlgorithm;
import com.intellij.updater.Digester;
import com.intellij.updater.OperationCancelledException;
import com.intellij.updater.Patch;
import com.intellij.updater.PatchFileCreator;
import com.intellij.updater.PatchSpec;
import com.intellij.updater.Runner;
import com.intellij.updater.UpdateAction;
import com.intellij.updater.UpdaterUI;
import com.intellij.updater.Utils;
import com.intellij.updater.ValidationResult;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatchGenerator {
    public static boolean generateFullPackage(final @NotNull File srcRoot, final @Nullable File existingRoot, @NotNull File outputJar, @NotNull String oldDescription, @NotNull String description, @NotNull ProgressIndicator progress) {
        if (srcRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcRoot", "com/android/tools/idea/sdk/updater/PatchGenerator", "generateFullPackage"));
        }
        if (outputJar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputJar", "com/android/tools/idea/sdk/updater/PatchGenerator", "generateFullPackage"));
        }
        if (oldDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldDescription", "com/android/tools/idea/sdk/updater/PatchGenerator", "generateFullPackage"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/android/tools/idea/sdk/updater/PatchGenerator", "generateFullPackage"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/android/tools/idea/sdk/updater/PatchGenerator", "generateFullPackage"));
        }
        Digester digester = new Digester("md5");
        Runner.initLogger();
        progress.logInfo("Generating patch...");
        final HashSet srcFiles = new HashSet();
        try {
            Files.walkFileTree(srcRoot.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String relativePath = srcRoot.toPath().relativize(file).toString();
                    srcFiles.add(relativePath.replace(File.separatorChar, '/'));
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            progress.logWarning("Failed to read unzipped files!", (Throwable)e);
            return false;
        }
        final ArrayList<String> deleteFiles = new ArrayList<String>();
        if (existingRoot != null) {
            try {
                Files.walkFileTree(existingRoot.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        String relativePath = existingRoot.toPath().relativize(file).toString();
                        String path = relativePath.replace(File.separatorChar, '/');
                        if (!srcFiles.contains(path)) {
                            deleteFiles.add(path);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                progress.logWarning("Failed to read existing files!", (Throwable)e);
                return false;
            }
        }
        PatchSpec spec = new PatchSpec().setOldVersionDescription(oldDescription).setNewVersionDescription(description).setRoot("").setBinary(true).setOldFolder(existingRoot == null ? "" : existingRoot.getAbsolutePath()).setNewFolder(srcRoot.getAbsolutePath()).setStrict(true).setCriticalFiles(new ArrayList<String>(srcFiles)).setDeleteFiles(deleteFiles).setHashAlgorithm("md5");
        ProgressUI ui = new ProgressUI(progress);
        File patchZip = new File(outputJar.getParent(), "patch-file.zip");
        try {
            Patch patchInfo = new Patch(spec, ui);
            if (!patchZip.getParentFile().exists()) {
                patchZip.getParentFile().mkdirs();
            }
            patchZip.createNewFile();
            PatchFileCreator.create(spec, patchZip, ui);
            try (FileSystem destFs = FileSystems.newFileSystem(URI.create("jar:" + outputJar.toURI()), ImmutableMap.of((Object)"create", (Object)"true", (Object)"useTempFile", (Object)true));
                 BufferedInputStream is = new BufferedInputStream(new FileInputStream(patchZip));){
                Files.copy(is, destFs.getPath("patch-file.zip", new String[0]), new CopyOption[0]);
            }
        }
        catch (OperationCancelledException | IOException e) {
            progress.logWarning("Failed to create patch", (Throwable)e);
            return false;
        }
        return true;
    }

    private static class ProgressUI
    implements UpdaterUI {
        private final ProgressIndicator myProgressIndicator;

        private ProgressUI(@NotNull ProgressIndicator progressIndicator) {
            if (progressIndicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/android/tools/idea/sdk/updater/PatchGenerator$ProgressUI", "<init>"));
            }
            this.myProgressIndicator = progressIndicator;
        }

        @Override
        public void startProcess(String title) {
        }

        @Override
        public void setProgress(int percentage) {
            this.myProgressIndicator.setIndeterminate(false);
            this.myProgressIndicator.setFraction((double)percentage / 100.0);
        }

        @Override
        public void setProgressIndeterminate() {
            this.myProgressIndicator.setIndeterminate(true);
        }

        @Override
        public void setStatus(@Nullable String status) {
            this.myProgressIndicator.setSecondaryText(status);
        }

        @Override
        public void showError(@Nullable Throwable e) {
            this.myProgressIndicator.logWarning("Error", e);
        }

        @Override
        public void checkCancelled() throws OperationCancelledException {
            if (this.myProgressIndicator.isCanceled()) {
                throw new OperationCancelledException();
            }
        }

        @Override
        public void setDescription(String oldBuildDesc, String newBuildDesc) {
        }

        @Override
        public boolean showWarning(String message) {
            return false;
        }

        @Override
        public Map<String, ValidationResult.Option> askUser(List<ValidationResult> validationResults) throws OperationCancelledException {
            return null;
        }
    }

    private static class ZipBasedUpdateAction
    extends UpdateAction {
        private final ZipEntry myEntry;
        private final ZipFile mySrc;

        public ZipBasedUpdateAction(@NotNull ZipFile src, @NotNull ZipEntry entry, @NotNull Patch patch, long existingChecksum) {
            if (src == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/android/tools/idea/sdk/updater/PatchGenerator$ZipBasedUpdateAction", "<init>"));
            }
            if (entry == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/android/tools/idea/sdk/updater/PatchGenerator$ZipBasedUpdateAction", "<init>"));
            }
            if (patch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patch", "com/android/tools/idea/sdk/updater/PatchGenerator$ZipBasedUpdateAction", "<init>"));
            }
            super(patch, entry.getName(), existingChecksum);
            this.myEntry = entry;
            this.mySrc = src;
        }

        @Override
        protected void writeDiff(File ignored, File newerFile, OutputStream patchOutput) throws IOException {
            patchOutput.write(DiffAlgorithm.determineDiffAlgorithm(null, true, 0L).getId());
            Utils.copyStream(this.mySrc.getInputStream(this.myEntry), patchOutput);
        }
    }
}

