/*
 * Decompiled with CFR 0.152.
 */
package com.android.screenshot;

import com.android.SdkConstants;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.RawImage;
import com.android.ddmlib.TimeoutException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Base64;
import java.util.Iterator;
import java.util.zip.Deflater;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.Node;

public class Screenshot {
    private static final String ICC_PROFILE_DISPLAY_P3 = "AAACSAAAAAAEAAAAbW50clJHQiBYWVogB+EAAgAIAA0AFAAKYWNzcAAAAAAAAAAAR09PRwAAAAAAAAAAAAAAAAAAAAAAAPbWAAEAAAAA0y1HT09Hn6A6MCwYip4tkAyRUvYYTAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAALZGVzYwAAAQgAAAAyY3BydAAAATwAAABad3RwdAAAAZgAAAAUYmtwdAAAAawAAAAUclhZWgAAAcAAAAAUZ1hZWgAAAdQAAAAUYlhZWgAAAegAAAAUclRSQwAAAfwAAAAgY2hhZAAAAhwAAAAsYlRSQwAAAfwAAAAgZ1RSQwAAAfwAAAAgbWx1YwAAAAAAAAABAAAADGVuVVMAAAAWAAAAHABEAGkAcwBwAGwAYQB5ACAAUAAzAAAAAG1sdWMAAAAAAAAAAQAAAAxlblVTAAAAPgAAABwAQwBvAHAAeQByAGkAZwBoAHQAIAAoAGMAKQAgADIAMAAxADcAIABHAG8AbwBnAGwAZQAgAEkAbgBjAC4AAAAAWFlaIAAAAAAAAPNRAAEAAAABFsxYWVogAAAAAAAAAAAAAAAAAAAAAFhZWiAAAAAAAACD3wAAPb////+8WFlaIAAAAAAAAEq/AACxNwAACrlYWVogAAAAAAAAKDgAABELAADIuXBhcmEAAAAAAAMAAAACZmYAAPKnAAANWQAAE9AAAApbc2YzMgAAAAAAAQxCAAAF3v//8ycAAAeTAAD9kP//+6P///2kAAAD3AAAwG4=";
    private static final String ICC_PROFILE_SRGB = "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";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String envSerial;
        boolean device = false;
        boolean emulator = false;
        String serial = null;
        String filepath = null;
        boolean landscape = false;
        if (args.length == 0) {
            Screenshot.printUsageAndQuit();
        }
        int index = 0;
        do {
            String argument;
            if ("-d".equals(argument = args[index++])) {
                if (emulator || serial != null) {
                    Screenshot.printAndExit("-d conflicts with -e and -s", false);
                }
                device = true;
                continue;
            }
            if ("-e".equals(argument)) {
                if (device || serial != null) {
                    Screenshot.printAndExit("-e conflicts with -d and -s", false);
                }
                emulator = true;
                continue;
            }
            if ("-s".equals(argument)) {
                if (index == args.length) {
                    Screenshot.printAndExit("Missing serial number after -s", false);
                }
                if (device || emulator) {
                    Screenshot.printAndExit("-s conflicts with -d and -e", false);
                }
                serial = args[index++];
                continue;
            }
            if ("-l".equals(argument)) {
                landscape = true;
                continue;
            }
            filepath = argument;
            if (index >= args.length) continue;
            Screenshot.printAndExit("Too many arguments!", false);
        } while (index < args.length);
        if (!device && !emulator && serial == null && (envSerial = System.getenv("ANDROID_SERIAL")) != null) {
            serial = envSerial;
        }
        if (filepath == null) {
            Screenshot.printUsageAndQuit();
        }
        Log.setLogOutput((Log.ILogOutput)new Log.ILogOutput(){

            public void printAndPromptLog(Log.LogLevel logLevel, String tag, String message) {
                System.err.println(logLevel.getStringValue() + ":" + tag + ":" + message);
            }

            public void printLog(Log.LogLevel logLevel, String tag, String message) {
                System.err.println(logLevel.getStringValue() + ":" + tag + ":" + message);
            }
        });
        String adbLocation = Screenshot.getAdbLocation();
        AndroidDebugBridge.init((boolean)false);
        try {
            AndroidDebugBridge bridge = AndroidDebugBridge.createBridge((String)adbLocation, (boolean)true);
            if (bridge == null) {
                Screenshot.printAndExit("Couldn't start using adb from: " + adbLocation + ". Verify if it's version is at least " + AndroidDebugBridge.MIN_ADB_VERSION + ".", true);
            }
            int count = 0;
            while (!bridge.hasInitialDeviceList()) {
                try {
                    Thread.sleep(100L);
                    ++count;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (count <= 100) continue;
                System.err.println("Timeout getting device list!");
                return;
            }
            IDevice[] devices = bridge.getDevices();
            if (devices.length == 0) {
                Screenshot.printAndExit("No devices found!", true);
            }
            IDevice target = null;
            if (emulator || device) {
                for (IDevice d : devices) {
                    if (d.isEmulator() != emulator) continue;
                    if (target != null) {
                        if (emulator) {
                            Screenshot.printAndExit("Error: more than one emulator launched!", true);
                        } else {
                            Screenshot.printAndExit("Error: more than one device connected!", true);
                        }
                    }
                    target = d;
                }
            } else if (serial != null) {
                for (IDevice d : devices) {
                    if (!serial.equals(d.getSerialNumber())) continue;
                    target = d;
                    break;
                }
            } else {
                if (devices.length > 1) {
                    Screenshot.printAndExit("Error: more than one emulator or device available!", true);
                }
                target = devices[0];
            }
            if (target != null) {
                try {
                    System.out.println("Taking screenshot from: " + target.getSerialNumber());
                    Screenshot.getDeviceImage(target, filepath, landscape);
                    System.out.println("Success.");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                Screenshot.printAndExit("Could not find matching device/emulator.", true);
            }
        }
        finally {
            AndroidDebugBridge.terminate();
        }
    }

    private static String getAdbLocation() {
        String adbLocation;
        File toolsDir;
        String toolPath = System.getProperty("com.android.sdklib.toolsdir");
        if (toolPath == null) {
            return null;
        }
        try {
            toolsDir = new File(toolPath).getCanonicalFile();
        }
        catch (IOException e) {
            return null;
        }
        if (!toolsDir.exists()) {
            return null;
        }
        String sdk = null;
        File toolRoot = toolsDir.getParentFile();
        if (toolRoot != null && toolRoot.getName().equals("cmdline-tools")) {
            sdk = toolRoot.getParent();
        }
        if (sdk == null) {
            return null;
        }
        File platformTools = new File(sdk, "platform-tools");
        File adb = new File(platformTools, SdkConstants.FN_ADB);
        if (adb.exists()) {
            return adb.getAbsolutePath();
        }
        adb = new File(toolsDir, SdkConstants.FN_ADB);
        if (adb.exists()) {
            return adb.getAbsolutePath();
        }
        String androidOut = System.getenv("ANDROID_HOST_OUT");
        if (androidOut != null && new File(adbLocation = androidOut + File.separator + "bin" + File.separator + SdkConstants.FN_ADB).exists()) {
            return adbLocation;
        }
        return null;
    }

    private static void getDeviceImage(IDevice device, String filepath, boolean landscape) throws IOException {
        RawImage rawImage;
        try {
            rawImage = device.getScreenshot();
        }
        catch (TimeoutException e) {
            Screenshot.printAndExit("Unable to get frame buffer: timeout", true);
            return;
        }
        catch (Exception ioe) {
            Screenshot.printAndExit("Unable to get frame buffer: " + ioe.getMessage(), true);
            return;
        }
        if (rawImage == null) {
            return;
        }
        if (landscape) {
            rawImage = rawImage.getRotated();
        }
        BufferedImage image = new BufferedImage(rawImage.width, rawImage.height, 2);
        int index = 0;
        int IndexInc = rawImage.bpp >> 3;
        for (int y = 0; y < rawImage.height; ++y) {
            for (int x = 0; x < rawImage.width; ++x) {
                int value = rawImage.getARGB(index);
                index += IndexInc;
                image.setRGB(x, y, value);
            }
        }
        File outFile = new File(filepath);
        ImageWriter pngWriter = Screenshot.getWriter(image, "png");
        if (pngWriter == null) {
            throw new IOException("Failed to find png writer");
        }
        try {
            outFile.delete();
            ImageOutputStream outputStream = ImageIO.createImageOutputStream(outFile);
            pngWriter.setOutput(outputStream);
            if (Screenshot.hasColorSpace(rawImage)) {
                ImageTypeSpecifier type = ImageTypeSpecifier.createFromRenderedImage(image);
                ImageWriteParam writeParams = pngWriter.getDefaultWriteParam();
                IIOMetadata metadata = pngWriter.getDefaultImageMetadata(type, writeParams);
                byte[] data = Screenshot.deflate(Base64.getDecoder().decode(Screenshot.getIccProfile(rawImage.colorSpace)));
                Node node = metadata.getAsTree("javax_imageio_png_1.0");
                IIOMetadataNode iccp = new IIOMetadataNode("iCCP");
                iccp.setUserObject(data);
                iccp.setAttribute("profileName", Screenshot.getIccProfileName(rawImage.colorSpace));
                iccp.setAttribute("compressionMethod", "deflate");
                node.appendChild(iccp);
                metadata.setFromTree("javax_imageio_png_1.0", node);
                pngWriter.write(new IIOImage(image, null, metadata));
            } else {
                pngWriter.write(image);
            }
            pngWriter.dispose();
            outputStream.flush();
            outputStream.close();
        }
        catch (IOException e) {
            throw new IOException("Failed to write PNG output", e);
        }
    }

    private static boolean hasColorSpace(RawImage rawImage) {
        return rawImage.colorSpace != 0;
    }

    private static byte[] deflate(byte[] data) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(data.length);
        Deflater deflater = new Deflater();
        deflater.setInput(data);
        deflater.finish();
        byte[] buffer = new byte[1024];
        while (!deflater.finished()) {
            int count = deflater.deflate(buffer);
            out.write(buffer, 0, count);
        }
        data = out.toByteArray();
        return data;
    }

    private static String getIccProfileName(int colorSpace) {
        if (colorSpace == 2) {
            return "Display P3";
        }
        return "sRGB";
    }

    private static String getIccProfile(int colorSpace) {
        if (colorSpace == 2) {
            return ICC_PROFILE_DISPLAY_P3;
        }
        return ICC_PROFILE_SRGB;
    }

    private static ImageWriter getWriter(RenderedImage image, String format) {
        ImageTypeSpecifier type = ImageTypeSpecifier.createFromRenderedImage(image);
        Iterator<ImageWriter> iterator = ImageIO.getImageWriters(type, format);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    private static void printUsageAndQuit() {
        System.out.println("Usage: screenshot2 [-d | -e | -s SERIAL] [-l] OUT_FILE");
        System.out.println("");
        System.out.println("    -d      Uses the first device found.");
        System.out.println("    -e      Uses the first emulator found.");
        System.out.println("    -s      Targets the device by serial number.");
        System.out.println("");
        System.out.println("    -l      Rotate images for landscape mode.");
        System.out.println("");
        System.exit(1);
    }

    private static void printAndExit(String message, boolean terminate) {
        System.out.println(message);
        if (terminate) {
            AndroidDebugBridge.terminate();
        }
        System.exit(1);
    }
}

