/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.ApiLookup;
import com.android.tools.lint.checks.PrivateApiLookup;
import com.android.tools.lint.checks.Restriction;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.TypeEvaluator;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.tools.lint.detector.api.VersionChecks;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 52\u00020\u00012\u00020\u0002:\u00015B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0002J(\u0010\"\u001a\u0004\u0018\u00010\u001b2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u001a2\u0006\u0010\u0011\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u001bH\u0002J*\u0010&\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00142\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010*\u001a\u00020\u00102\u0006\u0010+\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010,\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00142\u0006\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020/H\u0016J \u00100\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00142\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0016R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/android/tools/lint/checks/PrivateApiDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "apiDatabase", "Lcom/android/tools/lint/checks/PrivateApiLookup;", "getApiDatabase", "()Lcom/android/tools/lint/checks/PrivateApiLookup;", "cachedApiDatabase", "", "client", "Lcom/android/tools/lint/client/api/LintClient;", "privateApiDatabase", "psiFactory", "Lcom/intellij/psi/PsiElementFactory;", "beforeCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "checkGetDeclaredField", "Lcom/android/tools/lint/detector/api/JavaContext;", "call", "Lorg/jetbrains/uast/UCallExpression;", "checkGetDeclaredMethod", "checkLoadClass", "getApplicableMethodNames", "", "", "getApplicableReferenceNames", "getJavaClassFromMemberLookup", "getJavaClassType", "Lcom/intellij/psi/PsiType;", "element", "Lorg/jetbrains/uast/UElement;", "getMethodDescriptor", "arguments", "Lorg/jetbrains/uast/UExpression;", "methodName", "reportIssue", "restriction", "Lcom/android/tools/lint/checks/Restriction;", "api", "reportUnknownMember", "cls", "visitMethodCall", "node", "method", "Lcom/intellij/psi/PsiMethod;", "visitReference", "reference", "Lorg/jetbrains/uast/UReferenceExpression;", "referenced", "Lcom/intellij/psi/PsiElement;", "Issues", "lint-checks"})
public final class PrivateApiDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @Nullable
    private LintClient client;
    @Nullable
    private PsiElementFactory psiFactory;
    private boolean cachedApiDatabase;
    @Nullable
    private PrivateApiLookup privateApiDatabase;
    @JvmField
    @NotNull
    public static final Issue PRIVATE_API;
    @JvmField
    @NotNull
    public static final Issue DISCOURAGED_PRIVATE_API;
    @JvmField
    @NotNull
    public static final Issue SOON_BLOCKED_PRIVATE_API;
    @JvmField
    @NotNull
    public static final Issue BLOCKED_PRIVATE_API;
    @NotNull
    private static final String LOAD_CLASS = "loadClass";
    @NotNull
    private static final String FOR_NAME = "forName";
    @NotNull
    private static final String GET_CLASS = "getClass";
    @NotNull
    private static final String GET_DECLARED_CONSTRUCTOR = "getDeclaredConstructor";
    @NotNull
    private static final String GET_DECLARED_METHOD = "getDeclaredMethod";
    @NotNull
    private static final String GET_DECLARED_FIELD = "getDeclaredField";
    @NotNull
    private static final List<String> KOTLIN_REFLECTION_METHODS;
    @NotNull
    private static final String ERROR_MESSAGE = "Accessing internal APIs via reflection is not supported and may not work on all devices or in the future";

    private final PrivateApiLookup getApiDatabase() {
        if (!this.cachedApiDatabase && this.privateApiDatabase == null && this.client != null) {
            LintClient lintClient = this.client;
            Intrinsics.checkNotNull((Object)lintClient);
            this.privateApiDatabase = PrivateApiLookup.Companion.get(lintClient);
            this.cachedApiDatabase = true;
        }
        return this.privateApiDatabase;
    }

    public void beforeCheckRootProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.client = context.getClient();
        this.cachedApiDatabase = false;
        this.psiFactory = PsiElementFactory.getInstance((Project)context.getProject().getIdeaProject());
    }

    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{FOR_NAME, LOAD_CLASS, GET_DECLARED_CONSTRUCTOR, GET_DECLARED_METHOD, GET_DECLARED_FIELD};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<String> getApplicableReferenceNames() {
        return KOTLIN_REFLECTION_METHODS;
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        JavaEvaluator evaluator = context.getEvaluator();
        String string = method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"method.name");
        String name = string;
        if (Intrinsics.areEqual((Object)LOAD_CLASS, (Object)name)) {
            if (evaluator.isMemberInClass((PsiMember)method, "java.lang.ClassLoader") || evaluator.isMemberInClass((PsiMember)method, "dalvik.system.DexFile")) {
                this.checkLoadClass(context, node);
            }
        } else {
            if (!evaluator.isMemberInClass((PsiMember)method, "java.lang.Class")) {
                return;
            }
            string = name;
            if (Intrinsics.areEqual((Object)string, (Object)GET_DECLARED_METHOD)) {
                this.checkGetDeclaredMethod(context, node);
            } else if (Intrinsics.areEqual((Object)string, (Object)GET_DECLARED_FIELD)) {
                this.checkGetDeclaredField(context, node);
            } else {
                this.checkLoadClass(context, node);
            }
        }
    }

    public void visitReference(@NotNull JavaContext context, @NotNull UReferenceExpression reference, @NotNull PsiElement referenced) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)referenced, (String)"referenced");
    }

    private final void checkGetDeclaredMethod(JavaContext context, UCallExpression call) {
        int targetSdk;
        String string = this.getJavaClassFromMemberLookup(call);
        if (string == null) {
            return;
        }
        String cls = string;
        List arguments = call.getValueArguments();
        if (arguments.isEmpty()) {
            return;
        }
        String methodName = ConstantEvaluator.evaluateString((JavaContext)context, (UElement)((UElement)arguments.get(0)), (boolean)false);
        PsiClass aClass = context.getEvaluator().findClass(cls);
        if (aClass != null && methodName != null) {
            PsiMethod[] psiMethodArray = aClass.findMethodsByName(methodName, true);
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"aClass.findMethodsByName(methodName, true)");
            Object[] objectArray = psiMethodArray;
            if (!(objectArray.length == 0)) {
                Restriction restriction;
                String string2 = this.getMethodDescriptor(arguments, context, methodName);
                if (string2 == null) {
                    return;
                }
                String desc = string2;
                PrivateApiLookup privateApiLookup = this.getApiDatabase();
                Restriction restriction2 = restriction = privateApiLookup == null ? null : privateApiLookup.getMethodRestriction(cls, methodName, desc);
                if (restriction != null) {
                    this.reportIssue(context, restriction, methodName, call);
                }
                return;
            }
        }
        if ((targetSdk = context.getProject().getTargetSdk()) < 26) {
            this.reportUnknownMember(cls, context, call);
        } else if (methodName != null) {
            String string3 = this.getMethodDescriptor(arguments, context, methodName);
            if (string3 == null) {
                return;
            }
            String desc = string3;
            PrivateApiLookup privateApiLookup = this.getApiDatabase();
            Restriction restriction = privateApiLookup == null ? null : privateApiLookup.getMethodRestriction(cls, methodName, desc);
            this.reportIssue(context, restriction, methodName, call);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String getMethodDescriptor(List<? extends UExpression> arguments, JavaContext context, String methodName) {
        PsiType[] psiTypeArray;
        if (arguments.size() >= 2) {
            void $this$toTypedArray$iv;
            void $this$mapNotNullTo$iv$iv;
            Collection $this$mapNotNull$iv;
            Iterable iterable = arguments.subList(1, arguments.size());
            boolean $i$f$mapNotNull = false;
            void var7_7 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                PsiType psiType;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                UExpression it = (UExpression)element$iv$iv;
                boolean bl2 = false;
                if (this.getJavaClassType((UElement)it) == null) continue;
                PsiType it$iv$iv = psiType;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            PsiType[] psiTypeArray2 = thisCollection$iv.toArray(new PsiType[0]);
            if (psiTypeArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            psiTypeArray = psiTypeArray2;
        } else {
            boolean $i$f$emptyArray = false;
            psiTypeArray = (PsiType[])((Object[])new PsiType[0]);
        }
        PsiType[] argTypes = psiTypeArray;
        return JavaEvaluator.constructMethodDescription$default((JavaEvaluator)context.getEvaluator(), (String)methodName, (boolean)false, (PsiType[])argTypes, null, (boolean)false, (int)26, null);
    }

    private final void checkGetDeclaredField(JavaContext context, UCallExpression call) {
        String string = this.getJavaClassFromMemberLookup(call);
        if (string == null) {
            return;
        }
        String cls = string;
        List arguments = call.getValueArguments();
        if (arguments.isEmpty()) {
            return;
        }
        String fieldName = ConstantEvaluator.evaluateString((JavaContext)context, (UElement)((UElement)arguments.get(0)), (boolean)false);
        PsiClass aClass = context.getEvaluator().findClass(cls);
        if (aClass != null && fieldName != null && aClass.findFieldByName(fieldName, true) != null) {
            Restriction restriction;
            PrivateApiLookup privateApiLookup = this.getApiDatabase();
            Restriction restriction2 = restriction = privateApiLookup == null ? null : privateApiLookup.getFieldRestriction(cls, fieldName);
            if (restriction != null) {
                this.reportIssue(context, restriction, fieldName, call);
            }
            return;
        }
        int targetSdk = context.getProject().getTargetSdk();
        if (targetSdk < 26) {
            this.reportUnknownMember(cls, context, call);
        } else if (fieldName != null) {
            PrivateApiLookup privateApiLookup = this.getApiDatabase();
            Restriction restriction = privateApiLookup == null ? null : privateApiLookup.getFieldRestriction(cls, fieldName);
            this.reportIssue(context, restriction, fieldName, call);
        }
    }

    private final void checkLoadClass(JavaContext context, UCallExpression call) {
        List arguments = call.getValueArguments();
        if (arguments.isEmpty()) {
            return;
        }
        Object object = ConstantEvaluator.evaluate((JavaContext)context, (UElement)((UElement)arguments.get(0)));
        String string = object instanceof String ? (String)object : null;
        if (string == null) {
            return;
        }
        String value = string;
        boolean isInternal = false;
        if (StringsKt.startsWith$default((String)value, (String)"com.android.internal.", (boolean)false, (int)2, null)) {
            isInternal = true;
        } else if (StringsKt.startsWith$default((String)value, (String)"com.android.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)value, (String)"android.", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)value, (String)"android.support.", (boolean)false, (int)2, null)) {
            PsiClass aClass = context.getEvaluator().findClass(value);
            if (aClass != null) {
                return;
            }
            ApiLookup apiLookup = ApiLookup.get(context.getClient(), context.getProject().getBuildTarget());
            if (apiLookup == null) {
                return;
            }
            ApiLookup apiLookup2 = apiLookup;
            boolean bl = isInternal = !apiLookup2.containsClass(value);
        }
        if (isInternal) {
            Location location = context.getLocation((UElement)call);
            JavaContext.report$default((JavaContext)context, (Issue)PRIVATE_API, (UElement)((UElement)call), (Location)location, (String)ERROR_MESSAGE, null, (int)16, null);
        }
    }

    private final String getJavaClassFromMemberLookup(UCallExpression call) {
        PsiType psiType = this.getJavaClassType((UElement)call.getReceiver());
        return psiType == null ? null : psiType.getCanonicalText();
    }

    private final PsiType getJavaClassType(UElement element) {
        if (element instanceof UExpression) {
            if (element instanceof UParenthesizedExpression) {
                return this.getJavaClassType((UElement)((UParenthesizedExpression)element).getExpression());
            }
            PsiType type = ((UExpression)element).getExpressionType();
            if (type instanceof PsiClassType && ((PsiClassType)type).getParameterCount() == 1) {
                PsiType clazz = null;
                clazz = ((PsiClassType)type).getParameters()[0];
                if (clazz instanceof PsiClassType) {
                    PsiPrimitiveType psiPrimitiveType = PsiPrimitiveType.getUnboxedType((PsiType)clazz);
                    if (psiPrimitiveType != null) {
                        PsiPrimitiveType it = psiPrimitiveType;
                        boolean bl = false;
                        if (element instanceof UQualifiedReferenceExpression) {
                            String identifier;
                            UExpression uExpression = UastUtils.skipParenthesizedExprDown((UExpression)((UQualifiedReferenceExpression)element).getSelector());
                            USimpleNameReferenceExpression uSimpleNameReferenceExpression = uExpression instanceof USimpleNameReferenceExpression ? (USimpleNameReferenceExpression)uExpression : null;
                            String string = identifier = uSimpleNameReferenceExpression == null ? null : uSimpleNameReferenceExpression.getIdentifier();
                            if (Intrinsics.areEqual((Object)identifier, (Object)"javaPrimitiveType") || Intrinsics.areEqual((Object)identifier, (Object)"TYPE")) {
                                clazz = it;
                            }
                        }
                        if (element instanceof UClassLiteralExpression && ((UExpression)element).evaluate() instanceof PsiPrimitiveType) {
                            clazz = it;
                        }
                    }
                    return clazz;
                }
            }
            if (element instanceof UReferenceExpression) {
                PsiElement resolved = ((UReferenceExpression)element).resolve();
                if (resolved instanceof PsiVariable) {
                    UExpression uExpression = UastLintUtils.Companion.findLastAssignment((PsiVariable)resolved, element);
                    if (uExpression != null) {
                        UExpression expression = uExpression;
                        boolean bl = false;
                        return this.getJavaClassType((UElement)expression);
                    }
                }
                if (element instanceof UQualifiedReferenceExpression && UastUtils.skipParenthesizedExprDown((UExpression)((UQualifiedReferenceExpression)element).getSelector()) instanceof UCallExpression) {
                    UExpression uExpression = UastUtils.skipParenthesizedExprDown((UExpression)((UQualifiedReferenceExpression)element).getSelector());
                    if (uExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.uast.UCallExpression");
                    }
                    UCallExpression call = (UCallExpression)uExpression;
                    String name = call.getMethodName();
                    if (Intrinsics.areEqual((Object)FOR_NAME, (Object)name) || Intrinsics.areEqual((Object)LOAD_CLASS, (Object)name)) {
                        List arguments = call.getValueArguments();
                        if (!((Collection)arguments).isEmpty()) {
                            PsiType psiType;
                            String string = ConstantEvaluator.evaluateString(null, (UElement)((UElement)arguments.get(0)), (boolean)false);
                            if (string == null) {
                                psiType = null;
                            } else {
                                String it = string;
                                boolean bl = false;
                                PsiElementFactory psiElementFactory = this.psiFactory;
                                Intrinsics.checkNotNull((Object)psiElementFactory);
                                psiType = psiElementFactory.createTypeFromText(it, null);
                            }
                            return psiType;
                        }
                    } else if (Intrinsics.areEqual((Object)GET_CLASS, (Object)name)) {
                        return TypeEvaluator.evaluate((UElement)((UElement)((UQualifiedReferenceExpression)element).getReceiver()));
                    }
                }
            }
        }
        return TypeEvaluator.evaluate((UElement)element);
    }

    private final void reportIssue(JavaContext context, Restriction restriction, String api, UCallExpression call) {
        int targetSdk = context.getProject().getTargetSdk();
        LintClient client = context.getClient();
        JavaEvaluator evaluator = context.getEvaluator();
        Restriction restriction2 = restriction;
        switch (restriction2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[restriction2.ordinal()]) {
            case 1: {
                PrivateApiDetector.reportIssue$fatal(context, call, api, targetSdk);
                break;
            }
            case 2: {
                if (targetSdk <= 26 || VersionChecks.Companion.isWithinVersionCheckConditional(client, evaluator, (UElement)call, 26, false)) {
                    PrivateApiDetector.reportIssue$warning(context, call, api);
                    break;
                }
                PrivateApiDetector.reportIssue$error(context, call, api, targetSdk);
                break;
            }
            case 3: {
                if (targetSdk <= 28 || VersionChecks.Companion.isWithinVersionCheckConditional(client, evaluator, (UElement)call, 28, false)) {
                    PrivateApiDetector.reportIssue$warning(context, call, api);
                    break;
                }
                PrivateApiDetector.reportIssue$error(context, call, api, targetSdk);
                break;
            }
            case 4: {
                if (targetSdk <= 29 || VersionChecks.Companion.isWithinVersionCheckConditional(client, evaluator, (UElement)call, 29, false)) {
                    PrivateApiDetector.reportIssue$warning(context, call, api);
                    break;
                }
                PrivateApiDetector.reportIssue$error(context, call, api, targetSdk);
                break;
            }
            case 5: {
                if (targetSdk <= 30 || VersionChecks.Companion.isWithinVersionCheckConditional(client, evaluator, (UElement)call, 30, false)) {
                    PrivateApiDetector.reportIssue$warning(context, call, api);
                    break;
                }
                PrivateApiDetector.reportIssue$error(context, call, api, targetSdk);
                break;
            }
            case 6: {
                PrivateApiDetector.reportIssue$warning(context, call, api);
                break;
            }
            default: {
                return;
            }
        }
    }

    private final void reportUnknownMember(String cls, JavaContext context, UCallExpression call) {
        if (!StringsKt.startsWith$default((String)cls, (String)"com.android.", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)cls, (String)"android.", (boolean)false, (int)2, null)) {
            return;
        }
        Location location = context.getLocation((UElement)call);
        JavaContext.report$default((JavaContext)context, (Issue)PRIVATE_API, (UElement)((UElement)call), (Location)location, (String)ERROR_MESSAGE, null, (int)16, null);
    }

    private static final void reportIssue$fatal(JavaContext $context, UCallExpression $call, String $api, int targetSdk) {
        JavaContext.report$default((JavaContext)$context, (Issue)BLOCKED_PRIVATE_API, (UElement)((UElement)$call), (Location)$context.getLocation((UElement)$call), (String)("Reflective access to " + $api + " is forbidden when targeting API " + targetSdk + " and above"), null, (int)16, null);
    }

    private static final void reportIssue$error(JavaContext $context, UCallExpression $call, String $api, int targetSdk) {
        JavaContext.report$default((JavaContext)$context, (Issue)SOON_BLOCKED_PRIVATE_API, (UElement)((UElement)$call), (Location)$context.getLocation((UElement)$call), (String)("Reflective access to " + $api + " will throw an exception when targeting API " + targetSdk + " and above"), null, (int)16, null);
    }

    private static final void reportIssue$warning(JavaContext $context, UCallExpression $call, String $api) {
        JavaContext.report$default((JavaContext)$context, (Issue)DISCOURAGED_PRIVATE_API, (UElement)((UElement)$call), (Location)$context.getLocation((UElement)$call), (String)("Reflective access to " + $api + ", which is not part of the public SDK and therefore likely to change in future Android releases"), null, (int)16, null);
    }

    static {
        Object[] objectArray = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(PrivateApiDetector.class, Scope.JAVA_FILE_SCOPE);
        PRIVATE_API = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"PrivateApi", (String)"Using Private APIs", (String)"\n            Using reflection to access hidden/private Android APIs is not safe; it will often not work on \\\n            devices from other vendors, and it may suddenly stop working (if the API is removed) or crash \\\n            spectacularly (if the API behavior changes, since there are no guarantees for compatibility).\n            ", (Implementation)implementation, (String)"https://developer.android.com/preview/restrictions-non-sdk-interfaces", (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        implementation = new Implementation(PrivateApiDetector.class, Scope.JAVA_FILE_SCOPE);
        DISCOURAGED_PRIVATE_API = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"DiscouragedPrivateApi", (String)"Using Discouraged Private API", (String)"\n            Usage of restricted non-SDK interface may throw an exception at runtime. Accessing \\\n            non-SDK methods or fields through reflection has a high likelihood to break your app \\\n            between versions, and is being restricted to facilitate future app compatibility.\n            ", (Implementation)implementation, (String)"https://developer.android.com/preview/restrictions-non-sdk-interfaces", (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.ERROR;
        implementation = new Implementation(PrivateApiDetector.class, Scope.JAVA_FILE_SCOPE);
        SOON_BLOCKED_PRIVATE_API = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"SoonBlockedPrivateApi", (String)"Using Soon-to-Be Blocked Private API", (String)"\n            Usage of restricted non-SDK interface will throw an exception at runtime. Accessing \\\n            non-SDK methods or fields through reflection has a high likelihood to break your app \\\n            between versions, and is being restricted to facilitate future app compatibility.\n            ", (Implementation)implementation, (String)"https://developer.android.com/preview/restrictions-non-sdk-interfaces", (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.FATAL;
        implementation = new Implementation(PrivateApiDetector.class, Scope.JAVA_FILE_SCOPE);
        BLOCKED_PRIVATE_API = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"BlockedPrivateApi", (String)"Using Blocked Private API", (String)"\n            Usage of restricted non-SDK interface is forbidden for this targetSDK. Accessing \\\n            non-SDK methods or fields through reflection has a high likelihood to break your app \\\n            between versions, and is being restricted to facilitate future app compatibility.\n            ", (Implementation)implementation, (String)"https://developer.android.com/preview/restrictions-non-sdk-interfaces", (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        objectArray = new String[]{"members", "declaredMembers", "declaredFunctions", "declaredMemberFunctions", "declaredMemberProperties"};
        KOTLIN_REFLECTION_METHODS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/checks/PrivateApiDetector$Issues;", "", "()V", "BLOCKED_PRIVATE_API", "Lcom/android/tools/lint/detector/api/Issue;", "DISCOURAGED_PRIVATE_API", "ERROR_MESSAGE", "", "FOR_NAME", "GET_CLASS", "GET_DECLARED_CONSTRUCTOR", "GET_DECLARED_FIELD", "GET_DECLARED_METHOD", "KOTLIN_REFLECTION_METHODS", "", "LOAD_CLASS", "PRIVATE_API", "SOON_BLOCKED_PRIVATE_API", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Restriction.values().length];
            nArray[Restriction.DENY.ordinal()] = 1;
            nArray[Restriction.MAYBE_MAX_O.ordinal()] = 2;
            nArray[Restriction.MAYBE_MAX_P.ordinal()] = 3;
            nArray[Restriction.MAYBE_MAX_Q.ordinal()] = 4;
            nArray[Restriction.MAYBE_MAX_R.ordinal()] = 5;
            nArray[Restriction.MAYBE.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

