/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.gradle;

import com.android.tools.lint.client.api.GradleVisitor;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.GradleContext;
import com.android.tools.lint.detector.api.GradleScanner;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.utils.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.builder.AstBuilder;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;

public class GroovyGradleVisitor
extends GradleVisitor {
    public void visitBuildScript(GradleContext context, List<? extends GradleScanner> detectors) {
        try {
            GroovyGradleVisitor.visitQuietly(context, detectors);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void visitQuietly(final GradleContext context, final List<? extends GradleScanner> detectors) {
        CharSequence sequence = context.getContents();
        if (sequence == null) {
            return;
        }
        final String source = sequence.toString();
        List astNodes = new AstBuilder().buildFromString(source);
        CodeVisitorSupport visitor = new CodeVisitorSupport(){
            private final List<MethodCallExpression> mMethodCallStack = new ArrayList<MethodCallExpression>();

            public void visitMethodCallExpression(MethodCallExpression expression) {
                this.mMethodCallStack.add(expression);
                super.visitMethodCallExpression(expression);
                assert (!this.mMethodCallStack.isEmpty());
                assert (this.mMethodCallStack.get(this.mMethodCallStack.size() - 1) == expression);
                this.mMethodCallStack.remove(this.mMethodCallStack.size() - 1);
            }

            public void visitBinaryExpression(BinaryExpression expression) {
                if (expression.getOperation().getText().equals("=")) {
                    Expression leftExpression = expression.getLeftExpression();
                    List<String> hierarchy = this.getPropertyHierarchy(leftExpression);
                    String property = null;
                    String parent = null;
                    String parentParent = null;
                    if (hierarchy != null && hierarchy.size() > 0) {
                        property = hierarchy.get(0);
                        if (hierarchy.size() == 2) {
                            parent = hierarchy.get(1);
                            if (!this.mMethodCallStack.isEmpty()) {
                                parentParent = this.getParent();
                            }
                        } else if (hierarchy.size() > 2) {
                            parent = hierarchy.get(1);
                            parentParent = hierarchy.get(2);
                        } else if (!this.mMethodCallStack.isEmpty()) {
                            parent = this.getParent();
                            parentParent = this.getParentN(2);
                        }
                        this.maybeCheckDslProperty(property, parent, parentParent, expression);
                    }
                }
                super.visitBinaryExpression(expression);
            }

            public void visitTupleExpression(TupleExpression tupleExpression) {
                MethodCallExpression call;
                if (!this.mMethodCallStack.isEmpty() && (call = this.mMethodCallStack.get(this.mMethodCallStack.size() - 1)).getArguments() == tupleExpression) {
                    String parent = this.getParent();
                    String parentParent = this.getParentN(2);
                    String parent3 = this.getParentN(3);
                    HashMap<String, String> namedArguments = new HashMap<String, String>();
                    ArrayList<String> unnamedArguments = new ArrayList<String>();
                    this.extractMethodCallArguments(tupleExpression, unnamedArguments, namedArguments);
                    if (tupleExpression instanceof ArgumentListExpression) {
                        ArgumentListExpression ale = (ArgumentListExpression)tupleExpression;
                        List expressions = ale.getExpressions();
                        if (expressions.size() == 1 && expressions.get(0) instanceof ClosureExpression) {
                            this.maybeCheckMethodCall(parent, parentParent, parent3, unnamedArguments, namedArguments, call);
                        } else {
                            this.maybeCheckMethodCall(parent, parentParent, parent3, unnamedArguments, namedArguments, call);
                            this.maybeCheckDslProperty(parent, parentParent, parent3, unnamedArguments, namedArguments, call);
                        }
                    } else {
                        this.maybeCheckMethodCall(parent, parentParent, parent3, unnamedArguments, namedArguments, call);
                        this.maybeCheckDslProperty(parent, parentParent, parent3, unnamedArguments, namedArguments, call);
                    }
                }
                super.visitTupleExpression(tupleExpression);
            }

            private void extractMethodCallArguments(TupleExpression tupleExpression, List<String> unnamedArguments, Map<String, String> namedArguments) {
                for (Expression subExpr : tupleExpression.getExpressions()) {
                    if (subExpr instanceof NamedArgumentListExpression) {
                        NamedArgumentListExpression nale = (NamedArgumentListExpression)subExpr;
                        for (MapEntryExpression mae : nale.getMapEntryExpressions()) {
                            namedArguments.put(mae.getKeyExpression().getText(), mae.getValueExpression().getText());
                        }
                        continue;
                    }
                    unnamedArguments.add(this.getText((ASTNode)subExpr));
                }
            }

            private String getParent() {
                return this.getParentN(1);
            }

            private String getParentN(int n) {
                int nParent = 0;
                MethodCallExpression methodCallExpression = this.mMethodCallStack.get(this.mMethodCallStack.size() - 1);
                List<String> hierarchy = this.getMethodCallHierarchy(methodCallExpression);
                if (hierarchy == null) {
                    return null;
                }
                if (n - nParent - 1 < hierarchy.size()) {
                    return hierarchy.get(n - nParent - 1);
                }
                nParent += hierarchy.size();
                for (int i = this.mMethodCallStack.size() - 2; i >= 0; --i) {
                    ArgumentListExpression ale;
                    List expressions;
                    methodCallExpression = this.mMethodCallStack.get(i);
                    Expression arguments = methodCallExpression.getArguments();
                    if (!(arguments instanceof ArgumentListExpression) || (expressions = (ale = (ArgumentListExpression)arguments).getExpressions()).size() != 1 || !(expressions.get(0) instanceof ClosureExpression)) continue;
                    hierarchy = this.getMethodCallHierarchy(methodCallExpression);
                    if (hierarchy == null) {
                        return null;
                    }
                    if (n - nParent - 1 < hierarchy.size()) {
                        return hierarchy.get(n - nParent - 1);
                    }
                    nParent += hierarchy.size();
                }
                return null;
            }

            private List<String> getMethodCallHierarchy(MethodCallExpression methodCallExpression) {
                ArrayList<String> result;
                block3: {
                    result = new ArrayList<String>();
                    result.add(methodCallExpression.getMethodAsString());
                    Expression expression = methodCallExpression.getObjectExpression();
                    while (true) {
                        if (expression instanceof VariableExpression) {
                            VariableExpression variableExpr = (VariableExpression)expression;
                            if (!variableExpr.isThisExpression()) {
                                result.add(variableExpr.getName());
                            }
                            break block3;
                        }
                        if (!(expression instanceof PropertyExpression)) break;
                        PropertyExpression propertyExpression = (PropertyExpression)expression;
                        result.add(propertyExpression.getPropertyAsString());
                        expression = propertyExpression.getObjectExpression();
                    }
                    return null;
                }
                return result;
            }

            private List<String> getPropertyHierarchy(Expression propertyOrVariableExpression) {
                ArrayList<String> result;
                block5: {
                    result = new ArrayList<String>();
                    if (propertyOrVariableExpression instanceof VariableExpression) {
                        VariableExpression variableExpression = (VariableExpression)propertyOrVariableExpression;
                        result.add(variableExpression.getName());
                        return result;
                    }
                    if (!(propertyOrVariableExpression instanceof PropertyExpression)) {
                        return null;
                    }
                    PropertyExpression propertyExpression = (PropertyExpression)propertyOrVariableExpression;
                    result.add(propertyExpression.getPropertyAsString());
                    Expression expression = propertyExpression.getObjectExpression();
                    while (true) {
                        if (expression instanceof VariableExpression) {
                            VariableExpression variableExpr = (VariableExpression)expression;
                            if (!variableExpr.isThisExpression()) {
                                result.add(variableExpr.getName());
                            }
                            break block5;
                        }
                        if (!(expression instanceof PropertyExpression)) break;
                        propertyExpression = (PropertyExpression)expression;
                        result.add(propertyExpression.getPropertyAsString());
                        expression = propertyExpression.getObjectExpression();
                    }
                    return null;
                }
                return result;
            }

            private void maybeCheckMethodCall(String methodName, String parent, String parentParent, List<String> unnamedArguments, Map<String, String> namedArguments, MethodCallExpression call) {
                if (methodName != null) {
                    for (GradleScanner scanner : detectors) {
                        scanner.checkMethodCall(context, methodName, parent, parentParent, namedArguments, unnamedArguments, (Object)call);
                    }
                }
            }

            private void maybeCheckDslProperty(String property, String parent, String parentParent, List<String> unnamedArguments, Map<String, String> namedArguments, MethodCallExpression c) {
                if (property != null && parent != null) {
                    String value = null;
                    if (unnamedArguments.size() == 1 && namedArguments.size() == 0) {
                        value = unnamedArguments.get(0);
                    } else if (unnamedArguments.size() == 0 && namedArguments.size() > 0) {
                        value = this.getText((ASTNode)c.getArguments());
                    }
                    if (value != null) {
                        for (GradleScanner scanner : detectors) {
                            scanner.checkDslPropertyAssignment(context, property, value, parent, parentParent, (Object)c.getMethod(), (Object)c.getArguments(), (Object)c);
                        }
                    }
                }
            }

            private void maybeCheckDslProperty(String property, String parent, String parentParent, BinaryExpression b) {
                Expression rightExpression = b.getRightExpression();
                if (parent == null) {
                    parent = "";
                }
                if (rightExpression != null) {
                    String value = this.getText((ASTNode)rightExpression);
                    for (GradleScanner scanner : detectors) {
                        scanner.checkDslPropertyAssignment(context, property, value, parent, parentParent, (Object)b.getLeftExpression(), (Object)b, (Object)b);
                    }
                }
            }

            private String getText(ASTNode node) {
                Pair offsets = GroovyGradleVisitor.getOffsets(node, (Context)context);
                return source.substring((Integer)offsets.getFirst(), (Integer)offsets.getSecond());
            }
        };
        for (ASTNode node : astNodes) {
            node.visit((GroovyCodeVisitor)visitor);
        }
    }

    private static Pair<ASTNode, ASTNode> getBoundingNodes(ASTNode node) {
        TupleExpression expression;
        List expressions;
        if (node.getLastLineNumber() == -1 && node instanceof TupleExpression && !(expressions = (expression = (TupleExpression)node).getExpressions()).isEmpty()) {
            return Pair.of((Object)((ASTNode)GroovyGradleVisitor.getBoundingNodes((ASTNode)expressions.get(0)).getFirst()), (Object)((ASTNode)GroovyGradleVisitor.getBoundingNodes((ASTNode)expressions.get(expressions.size() - 1)).getSecond()));
        }
        if (node instanceof ArgumentListExpression && !(expressions = (expression = (ArgumentListExpression)node).getExpressions()).isEmpty()) {
            return Pair.of((Object)((ASTNode)GroovyGradleVisitor.getBoundingNodes((ASTNode)expressions.get(0)).getFirst()), (Object)((ASTNode)GroovyGradleVisitor.getBoundingNodes((ASTNode)expressions.get(expressions.size() - 1)).getSecond()));
        }
        return Pair.of((Object)node, (Object)node);
    }

    private static Pair<Integer, Integer> getOffsets(ASTNode node, Context context) {
        Pair<ASTNode, ASTNode> boundingNodes = GroovyGradleVisitor.getBoundingNodes(node);
        ASTNode startNode = (ASTNode)boundingNodes.getFirst();
        ASTNode endNode = (ASTNode)boundingNodes.getSecond();
        CharSequence source = context.getContents();
        assert (source != null);
        int start = 0;
        int end = source.length();
        int line2 = 1;
        int startLine = startNode.getLineNumber();
        int startColumn = startNode.getColumnNumber();
        int endLine = endNode.getLastLineNumber();
        int endColumn = endNode.getLastColumnNumber();
        int column = 1;
        int len = end;
        for (int index = 0; index < len; ++index) {
            if (line2 == startLine && column == startColumn) {
                start = index;
            }
            if (line2 == endLine && column == endColumn) {
                end = index;
                break;
            }
            char c = source.charAt(index);
            if (c == '\n') {
                ++line2;
                column = 1;
                continue;
            }
            ++column;
        }
        return Pair.of((Object)start, (Object)end);
    }

    public int getStartOffset(GradleContext context, Object cookie) {
        ASTNode node = (ASTNode)cookie;
        Pair<Integer, Integer> offsets = GroovyGradleVisitor.getOffsets(node, (Context)context);
        return (Integer)offsets.getFirst();
    }

    public Location createLocation(GradleContext context, Object cookie) {
        ASTNode node = (ASTNode)cookie;
        Pair<ASTNode, ASTNode> boundingNodes = GroovyGradleVisitor.getBoundingNodes(node);
        ASTNode startNode = (ASTNode)boundingNodes.getFirst();
        ASTNode endNode = (ASTNode)boundingNodes.getSecond();
        Pair<Integer, Integer> offsets = GroovyGradleVisitor.getOffsets(node, (Context)context);
        int fromLine = startNode.getLineNumber() - 1;
        int fromColumn = startNode.getColumnNumber() - 1;
        int toLine = endNode.getLastLineNumber() - 1;
        int toColumn = endNode.getLastColumnNumber() - 1;
        return Location.create((File)context.file, (Position)new DefaultPosition(fromLine, fromColumn, ((Integer)offsets.getFirst()).intValue()), (Position)new DefaultPosition(toLine, toColumn, ((Integer)offsets.getSecond()).intValue()));
    }
}

