/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.repository.Revision;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintFixPerformer;
import com.android.tools.lint.LintStats;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.SarifReporter;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.SdkUtils;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J.\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0011H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0017H\u0002J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u001bH\u0002J,\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u00172\b\b\u0002\u0010\u001f\u001a\u00020\u00172\b\b\u0002\u0010 \u001a\u00020\u0017H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u00052\u0006\u0010\"\u001a\u00020\nH\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0005H\u0002J\u0018\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020(2\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u0016\u0010)\u001a\u00020$2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u001bH\u0002J&\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u001b2\u0006\u0010.\u001a\u00020/H\u0016J(\u00100\u001a\u00020+2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010%\u001a\u0002012\u0006\u00102\u001a\u00020$2\u0006\u00103\u001a\u00020\u0017H\u0002J(\u00104\u001a\u00020+2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u00172\u0006\u00102\u001a\u00020$H\u0002J\u001e\u00105\u001a\u00020+2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u001b2\u0006\u00103\u001a\u00020\u0017H\u0002J\u0018\u00106\u001a\u00020+2\u0006\u0010\"\u001a\u00020\n2\u0006\u00103\u001a\u00020\u0017H\u0002J\u0018\u00107\u001a\u00020+2\u0006\u0010\"\u001a\u00020\n2\u0006\u00103\u001a\u00020\u0017H\u0002J6\u00108\u001a\u00020+2\u0006\u0010\"\u001a\u00020\n2\u0006\u00109\u001a\u00020:2\f\u0010;\u001a\b\u0012\u0004\u0012\u0002010\u001b2\u0006\u00102\u001a\u00020$2\u0006\u00103\u001a\u00020\u0017H\u0002J\u0018\u0010<\u001a\u00020+2\u0006\u0010\"\u001a\u00020\n2\u0006\u00103\u001a\u00020\u0017H\u0002J \u0010=\u001a\u00020+2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010'\u001a\u00020(2\u0006\u00103\u001a\u00020\u0017H\u0002J,\u0010>\u001a\u00020+2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u001b2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u00103\u001a\u00020\u0017H\u0002J\u001e\u0010@\u001a\u00020+2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u00103\u001a\u00020\u0017H\u0002J>\u0010A\u001a\u00020+2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010'\u001a\u00020(2\u0006\u00102\u001a\u00020$2\u0006\u00103\u001a\u00020\u00172\b\b\u0002\u0010B\u001a\u00020\u00172\n\b\u0002\u0010C\u001a\u0004\u0018\u00010\u000bH\u0002J\u001e\u0010D\u001a\u00020+2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u00103\u001a\u00020\u0017H\u0002J\f\u0010E\u001a\u00020\u000b*\u00020\u000bH\u0002J\u0014\u00103\u001a\u00020\u000e*\u00020\u000e2\u0006\u00103\u001a\u00020\u0017H\u0002J\f\u0010F\u001a\u00020\u000b*\u00020GH\u0002J\f\u0010H\u001a\u00020\u0017*\u00020\u001cH\u0002J8\u0010I\u001a\u00020\u000e*\u00020\u000e2\u0006\u00103\u001a\u00020\u00172\u0006\u0010J\u001a\u00020\u000b2\u0006\u0010K\u001a\u00020\u000b2\b\b\u0002\u0010L\u001a\u00020$2\b\b\u0002\u0010M\u001a\u00020$H\u0002R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lcom/android/tools/lint/SarifReporter;", "Lcom/android/tools/lint/Reporter;", "client", "Lcom/android/tools/lint/LintCliClient;", "output", "Ljava/io/File;", "(Lcom/android/tools/lint/LintCliClient;Ljava/io/File;)V", "home", "incidentSnippets", "", "Lcom/android/tools/lint/detector/api/Incident;", "", "root", "writer", "Ljava/io/Writer;", "computeContext", "Lkotlin/Pair;", "Lcom/android/tools/lint/detector/api/Position;", "fileText", "", "lineStart", "lineEnd", "getColumn", "", "source", "offset", "getIssues", "", "Lcom/android/tools/lint/detector/api/Issue;", "incidents", "getLineNumber", "startOffset", "startLineNumber", "getRoot", "incident", "isBinary", "", "file", "locationContainsHome", "location", "Lcom/android/tools/lint/detector/api/Location;", "locationsContainHome", "write", "", "stats", "Lcom/android/tools/lint/LintStats;", "registry", "Lcom/android/tools/lint/client/api/IssueRegistry;", "writeArtifactChange", "Lcom/android/tools/lint/LintFixPerformer$PendingEditFile;", "last", "indent", "writeArtifactLocation", "writeBaseUris", "writeFingerprint", "writeLocations", "writeQuickFix", "fix", "Lcom/android/tools/lint/detector/api/LintFix;", "files", "writeQuickFixes", "writeRelatedLocations", "writeResults", "issues", "writeRules", "writeSingleLocation", "id", "message", "writeTools", "escapeJson", "level", "Lcom/android/tools/lint/detector/api/Severity;", "rank", "writeDescription", "name", "raw", "comma", "newline", "lint-cli"})
public final class SarifReporter
extends Reporter {
    @NotNull
    private final Writer writer;
    @NotNull
    private final Map<Incident, String> incidentSnippets;
    @Nullable
    private File root;
    @NotNull
    private final File home;

    public SarifReporter(@NotNull LintCliClient client, @NotNull File output) throws IOException {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        super(client, output);
        this.writer = new BufferedWriter(Files.newWriter((File)output, (Charset)Charsets.UTF_8));
        this.incidentSnippets = new LinkedHashMap();
        this.home = new File(System.getProperty("user.home"));
    }

    private final File getRoot(Incident incident) {
        File file = this.root;
        if (file == null) {
            File file2 = this.client.getRootDir();
            if (file2 == null) {
                File file3;
                File file4;
                SarifReporter $this$getRoot_u24lambda_u2d0 = this;
                boolean bl = false;
                Project project = incident.getProject();
                if (project != null) {
                    File parent;
                    File dir = project.getDir();
                    while (dir.getParentFile() != null && (new File(parent, "build.gradle").exists() || new File(parent, "build.gradle.kts").exists())) {
                        dir = parent;
                    }
                    file4 = dir;
                } else {
                    file4 = null;
                }
                File it = file3 = file4;
                boolean bl2 = false;
                this.root = it;
                file = file3;
            } else {
                file = file2;
            }
        }
        return file;
    }

    @Override
    public void write(@NotNull LintStats stats, @NotNull List<Incident> incidents, @NotNull IssueRegistry registry) throws IOException {
        int indent;
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        Intrinsics.checkNotNullParameter(incidents, (String)"incidents");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        int n = indent = 0;
        indent = n + 1;
        this.indent(this.writer, n).write("{\n");
        this.indent(this.writer, indent).write("\"$schema\" : \"https://raw.githubusercontent.com/oasis-tcs/sarif-spec/master/Schemata/sarif-schema-2.1.0.json\",\n");
        this.indent(this.writer, indent).write("\"version\" : \"2.1.0\",\n");
        n = indent;
        indent = n + 1;
        this.indent(this.writer, n).write("\"runs\" : [\n");
        n = indent;
        indent = n + 1;
        this.indent(this.writer, n).write("{\n");
        List<Issue> issues = this.getIssues(incidents);
        this.writeTools(issues, indent);
        this.writeBaseUris(incidents, indent);
        this.writeResults(incidents, issues, indent);
        this.indent(this.writer, --indent).write("}\n");
        this.indent(this.writer, --indent).write("]\n");
        this.indent(this.writer, --indent).write("}\n");
        this.writer.close();
        if (!(this.client.getFlags().isQuiet() || this.getOutput() == null || stats.getErrorCount() <= 0 && stats.getWarningCount() <= 0)) {
            String url = SdkUtils.fileToUrlString((File)this.getOutput().getAbsoluteFile());
            String string = "Wrote SARIF report to %1$s";
            Object[] objectArray = new Object[]{url};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            System.out.println((Object)string2);
        }
    }

    private final List<Issue> getIssues(List<Incident> incidents) {
        Issue previousIssue = null;
        List issues = new ArrayList();
        for (Incident incident : incidents) {
            Issue issue = incident.getIssue();
            if (issue == previousIssue) continue;
            previousIssue = issue;
            issues.add(issue);
        }
        List $this$sortBy$iv = issues;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    String string;
                    Issue it = (Issue)a;
                    boolean bl = false;
                    String string2 = it.getId();
                    Locale locale = Locale.US;
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                    String string3 = string = string2;
                    if (string3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
                    it = (Issue)b;
                    Comparable comparable = (Comparable)((Object)string4);
                    bl = false;
                    string2 = it.getId();
                    locale = Locale.US;
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                    String string5 = string = string2;
                    if (string5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string6 = string5.toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toLowerCase(locale)");
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string6)));
                }
            });
        }
        return issues;
    }

    private final boolean locationsContainHome(List<Incident> incidents) {
        Incident incident = (Incident)CollectionsKt.firstOrNull(incidents);
        if (incident == null) {
            return false;
        }
        Incident first = incident;
        File file = this.getRoot(first);
        if (file == null) {
            return false;
        }
        File root = file;
        for (Incident incident2 : incidents) {
            if (!this.locationContainsHome(incident2.getLocation(), root)) continue;
            return true;
        }
        return false;
    }

    private final boolean locationContainsHome(Location location, File root) {
        File file = location.getFile();
        if (!Lint.isParent((File)root, (File)file, (boolean)false) && Lint.isParent((File)this.home, (File)file, (boolean)false)) {
            return true;
        }
        Location next = location.getSecondary();
        return next != null && this.locationContainsHome(next, root);
    }

    private final void writeTools(List<Issue> issues, int indent) {
        String string;
        int indent2 = indent;
        String revision = this.client.getClientRevision();
        String string2 = this.client.getClientDisplayRevision();
        if (string2 == null) {
            string = null;
        } else {
            String it = string2;
            boolean bl = false;
            string = !Character.isDigit(it.charAt(0)) ? "1.0" : it;
        }
        String displayRevision = string;
        int n = indent2;
        indent2 = n + 1;
        this.indent(this.writer, n).write("\"tool\": {\n");
        n = indent2;
        indent2 = n + 1;
        this.indent(this.writer, n).write("\"driver\": {\n");
        this.indent(this.writer, indent2).write("\"name\": \"Android Lint\",\n");
        this.indent(this.writer, indent2).write("\"fullName\": \"Android Lint (in " + LintClient.Companion.getClientName() + ")\",\n");
        this.indent(this.writer, indent2).write("\"version\": \"" + displayRevision + "\",\n");
        if (!Intrinsics.areEqual((Object)Revision.safeParseRevision((String)revision), (Object)Revision.NOT_SPECIFIED)) {
            this.indent(this.writer, indent2).write("\"semanticVersion\": \"" + revision + "\",\n");
        }
        this.indent(this.writer, indent2).write("\"organization\": \"Google\",\n");
        this.indent(this.writer, indent2).write("\"informationUri\": \"https://developer.android.com/studio/write/lint\",\n");
        SarifReporter.writeDescription$default(this, this.writer, indent2, "fullDescription", "Static analysis originally for Android source code but now performing general analysis", true, false, 16, null);
        this.indent(this.writer, indent2).write("\"language\": \"en-US\",\n");
        this.writeRules(issues, indent2);
        this.indent(this.writer, --indent2).write("}\n");
        this.indent(this.writer, --indent2).write("},\n");
    }

    private final String level(Severity $this$level) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$level.ordinal()]) {
            case 1: 
            case 2: {
                string = "error";
                break;
            }
            case 3: {
                string = "warning";
                break;
            }
            case 4: {
                string = "note";
                break;
            }
            case 5: {
                string = "none";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final int rank(Issue $this$rank) {
        int n = $this$rank.getPriority();
        return (1 <= n ? n < 11 : false) ? (11 - $this$rank.getPriority()) * 10 : 50;
    }

    /*
     * WARNING - void declaration
     */
    private final void writeRules(List<Issue> issues, int indent) {
        this.indent(this.writer, indent).write("\"rules\": [\n");
        Iterable $this$forEachIndexed$iv = issues;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int indent2;
            void issue;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Issue issue2 = (Issue)item$iv;
            int index = n;
            boolean bl = false;
            Sequence categories2 = SequencesKt.generateSequence((Object)issue.getCategory(), (Function1)writeRules.1.categories.1.INSTANCE);
            String separator = ",\n                                    ";
            String tags2 = SequencesKt.joinToString$default((Sequence)categories2, (CharSequence)separator, null, null, (int)0, null, (Function1)((Function1)new Function1<Category, CharSequence>(this){
                final /* synthetic */ SarifReporter this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull Category it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return '\"' + SarifReporter.access$escapeJson(this.this$0, it.getName()) + '\"';
                }
            }), (int)30, null);
            String string = issue.getBriefDescription(TextFormat.RAW);
            String full = issue.getExplanation(TextFormat.RAW);
            String level = this.level(issue.getDefaultSeverity());
            int rank = this.rank((Issue)issue);
            int n2 = indent2 = indent;
            n2 = indent2 = n2 + 1;
            indent2 = n2 + 1;
            this.indent(this.writer, n2).write("{\n");
            this.indent(this.writer, indent2).write("\"id\": \"" + issue.getId() + "\",\n");
            SarifReporter.writeDescription$default(this, this.writer, indent2, "shortDescription", string, true, false, 16, null);
            SarifReporter.writeDescription$default(this, this.writer, indent2, "fullDescription", full, true, false, 16, null);
            n2 = indent2;
            indent2 = n2 + 1;
            this.indent(this.writer, n2).write("\"defaultConfiguration\": {\n");
            this.indent(this.writer, indent2).write("\"level\": \"" + level + "\",\n");
            this.indent(this.writer, indent2).write("\"rank\": " + rank + '\n');
            this.indent(this.writer, --indent2).write("},\n");
            n2 = indent2;
            indent2 = n2 + 1;
            this.indent(this.writer, n2).write("\"properties\": {\n");
            n2 = indent2;
            indent2 = n2 + 1;
            this.indent(this.writer, n2).write("\"tags\": [\n");
            this.indent(this.writer, indent2).write(Intrinsics.stringPlus((String)tags2, (Object)"\n"));
            this.indent(this.writer, --indent2).write("]\n");
            this.indent(this.writer, --indent2).write("}\n");
            this.indent(this.writer, --indent2).write("}");
            if (index < issues.size() - 1) {
                this.writer.write(",");
            }
            this.writer.write("\n");
        }
        this.indent(this.writer, indent).write("]\n");
    }

    private final void writeBaseUris(List<Incident> incidents, int indent) {
        int indent2;
        if (incidents.isEmpty()) {
            return;
        }
        File file = this.getRoot((Incident)CollectionsKt.first(incidents));
        if (file == null) {
            return;
        }
        File rootDir = file;
        String sourceRoot = this.escapeJson(Lint.getFileUri((File)rootDir));
        int n = indent2 = indent;
        indent2 = n + 1;
        this.indent(this.writer, n).write("\"originalUriBaseIds\": {\n");
        n = indent2;
        indent2 = n + 1;
        this.indent(this.writer, n).write("\"%SRCROOT%\": {\n");
        this.indent(this.writer, indent2).write("\"uri\": \"" + sourceRoot + "\"\n");
        this.indent(this.writer, --indent2).write("}");
        if (this.locationsContainHome(incidents)) {
            this.writer.write(",\n");
            n = indent2;
            indent2 = n + 1;
            this.indent(this.writer, n).write("\"USER_HOME\": {\n");
            this.indent(this.writer, indent2).write("\"uri\": \"" + sourceRoot + "\"\n");
            this.indent(this.writer, --indent2).write("}\n");
        } else {
            this.writer.write("\n");
        }
        this.indent(this.writer, --indent2).write("},\n");
    }

    /*
     * WARNING - void declaration
     */
    private final void writeResults(List<Incident> incidents, List<Issue> issues, int indent) {
        this.indent(this.writer, indent).write("\"results\": [\n");
        Map ruleIndices = new LinkedHashMap();
        int n = 0;
        int n2 = issues.size();
        while (n < n2) {
            int i = n++;
            Issue issue = issues.get(i);
            Map map = ruleIndices;
            Integer n3 = i;
            map.put(issue, n3);
        }
        Iterable $this$forEachIndexed$iv = incidents;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int indent2;
            void incident;
            int n4;
            if ((n4 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Incident incident2 = (Incident)item$iv;
            int index = n4;
            boolean bl = false;
            String ruleId = this.escapeJson(incident.getIssue().getId());
            Integer ruleIndex = (Integer)ruleIndices.get(incident.getIssue());
            String message2 = incident.getMessage();
            int n5 = indent2 = indent + 1;
            indent2 = n5 + 1;
            this.indent(this.writer, n5).write("{\n");
            this.indent(this.writer, indent2).write("\"ruleId\": \"" + ruleId + "\",\n");
            this.indent(this.writer, indent2).write("\"ruleIndex\": " + ruleIndex + ",\n");
            SarifReporter.writeDescription$default(this, this.writer, indent2, "message", message2, true, false, 16, null);
            if (incident.getSeverity() != incident.getIssue().getDefaultSeverity()) {
                String level = this.level(incident.getSeverity());
                this.indent(this.writer, indent2).write("\"level\": \"" + level + "\",\n");
            }
            this.writeLocations((Incident)incident, indent2);
            this.writeQuickFixes((Incident)incident, indent2);
            this.writeFingerprint((Incident)incident, indent2);
            this.indent(this.writer, --indent2).write('}' + (index < incidents.size() - 1 ? "," : "") + '\n');
        }
        this.indent(this.writer, indent).write("]\n");
    }

    private final void writeFingerprint(Incident incident, int indent) {
        this.indent(this.writer, indent).write("\"partialFingerprints\": {\n");
        HashFunction hashFunction = Hashing.farmHashFingerprint64();
        String string = this.incidentSnippets.get(incident);
        if (string != null) {
            String context = string;
            boolean bl = false;
            String string2 = hashFunction.hashString((CharSequence)context, Charsets.UTF_8).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"hashFunction.hashString(context, UTF_8).toString()");
            String fingerprint = string2;
            this.indent(this.writer, indent + 1).write("\"sourceContext/v1\": \"" + fingerprint + "\"\n");
        }
        this.indent(this.writer, indent).write("}\n");
    }

    private final void writeRelatedLocations(Incident incident, Location location, int indent) {
        int indent2;
        int n = indent2 = indent;
        indent2 = n + 1;
        this.indent(this.writer, n).write("\"relatedLocations\": [\n");
        Location curr = location;
        int id = 1;
        while (true) {
            int n2 = id;
            id = n2 + 1;
            Location next = curr.getSecondary();
            this.writeSingleLocation(incident, curr, next == null, indent2, n2, curr.getMessage());
            if (next == null) break;
            curr = next;
        }
        this.indent(this.writer, --indent2).write("],\n");
    }

    private final void writeLocations(Incident incident, int indent) {
        int indent2 = 0;
        indent2 = indent;
        Location location = incident.getLocation();
        int n = indent2;
        indent2 = n + 1;
        this.indent(this.writer, n).write("\"locations\": [\n");
        SarifReporter.writeSingleLocation$default(this, incident, location, true, indent2, 0, location.getMessage(), 16, null);
        this.indent(this.writer, indent2 += -1).write("],\n");
        Location location2 = location.getSecondary();
        if (location2 != null) {
            Location it = location2;
            boolean bl = false;
            this.writeRelatedLocations(incident, it, indent2);
        }
    }

    private final void writeSingleLocation(Incident incident, Location location, boolean last, int indent, int id, String message2) {
        int indent2;
        int n = indent2 = indent;
        indent2 = n + 1;
        this.indent(this.writer, n).write("{\n");
        if (id != -1) {
            this.indent(this.writer, indent2).write("\"id\": " + id + ",\n");
        }
        if (message2 != null) {
            SarifReporter.writeDescription$default(this, this.writer, indent2, "message", message2, true, false, 16, null);
        }
        n = indent2;
        indent2 = n + 1;
        this.indent(this.writer, n).write("\"physicalLocation\": {\n");
        File file = location.getFile();
        this.writeArtifactLocation(incident, file, 8, false);
        Position start = location.getStart();
        Position end = location.getEnd();
        if (start != null && end != null) {
            String string;
            int n2;
            CharSequence fileText = this.client.getSourceText(file);
            if (fileText.length() > 0) {
                CharSequence charSequence = fileText;
                n2 = start.getOffset();
                int n3 = end.getOffset();
                string = ((Object)charSequence.subSequence(n2, n3)).toString();
            } else {
                string = null;
            }
            String segment = string;
            Pair<Position, Position> context = this.computeContext(fileText, start, end);
            n2 = indent2;
            indent2 = n2 + 1;
            this.indent(this.writer, n2).write("\"region\": {\n");
            this.indent(this.writer, indent2).write("\"startLine\": " + (start.getLine() + 1) + ",\n");
            this.indent(this.writer, indent2).write("\"startColumn\": " + (start.getColumn() + 1) + ",\n");
            this.indent(this.writer, indent2).write("\"endLine\": " + (end.getLine() + 1) + ",\n");
            this.indent(this.writer, indent2).write("\"endColumn\": " + (end.getColumn() + 1) + ",\n");
            this.indent(this.writer, indent2).write("\"charOffset\": " + start.getOffset() + ",\n");
            this.indent(this.writer, indent2).write(Intrinsics.stringPlus((String)"\"charLength\": ", (Object)(end.getOffset() - start.getOffset())));
            if (segment != null) {
                this.writer.write(",\n");
                n2 = indent2;
                indent2 = n2 + 1;
                this.indent(this.writer, n2).write("\"snippet\": {\n");
                this.indent(this.writer, indent2).write("\"text\": \"" + this.escapeJson(segment) + "\"\n");
                this.indent(this.writer, --indent2).write("}\n");
            } else {
                this.writer.write("\n");
            }
            this.indent(this.writer, --indent2).write("}");
            if (context != null) {
                Position contextStart = (Position)context.getFirst();
                Position contextEnd = (Position)context.getSecond();
                CharSequence charSequence = fileText;
                int n4 = contextStart.getOffset();
                int n5 = contextEnd.getOffset();
                String snippet = ((Object)charSequence.subSequence(n4, n5)).toString();
                this.writer.write(",\n");
                int n6 = indent2;
                indent2 = n6 + 1;
                this.indent(this.writer, n6).write("\"contextRegion\": {\n");
                this.indent(this.writer, indent2).write("\"startLine\": " + (contextStart.getLine() + 1) + ",\n");
                this.indent(this.writer, indent2).write("\"endLine\": " + (contextEnd.getLine() + 1) + ",\n");
                n6 = indent2;
                indent2 = n6 + 1;
                this.indent(this.writer, n6).write("\"snippet\": {\n");
                this.indent(this.writer, indent2).write("\"text\": \"" + this.escapeJson(snippet) + "\"\n");
                this.indent(this.writer, --indent2).write("}\n");
                this.indent(this.writer, --indent2).write("}\n");
                if (!this.incidentSnippets.containsKey(incident)) {
                    this.incidentSnippets.put(incident, snippet);
                }
            } else {
                this.writer.write("\n");
                if (segment != null && !this.incidentSnippets.containsKey(incident)) {
                    this.incidentSnippets.put(incident, segment);
                }
            }
        } else {
            int n7 = indent2;
            indent2 = n7 + 1;
            this.indent(this.writer, n7).write("\"region\": {\n");
            if (this.isBinary(file)) {
                this.indent(this.writer, indent2).write("\"byteOffset\": 0\n");
            } else {
                this.indent(this.writer, indent2).write("\"startLine\": 1\n");
            }
            this.indent(this.writer, --indent2).write("}");
        }
        this.indent(this.writer, --indent2).write("}\n");
        this.indent(this.writer, --indent2).write('}' + (!last ? "," : "") + '\n');
    }

    static /* synthetic */ void writeSingleLocation$default(SarifReporter sarifReporter, Incident incident, Location location, boolean bl, int n, int n2, String string, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            n2 = -1;
        }
        if ((n3 & 0x20) != 0) {
            string = null;
        }
        sarifReporter.writeSingleLocation(incident, location, bl, n, n2, string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isBinary(File file) {
        String path = file.getPath();
        if (SdkUtils.isBitmapFile((File)file)) return true;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
        if (StringsKt.endsWith$default((String)path, (String)".jar", (boolean)false, (int)2, null)) return true;
        if (StringsKt.endsWith$default((String)path, (String)".class", (boolean)false, (int)2, null)) return true;
        if (StringsKt.endsWith$default((String)path, (String)".srcjar", (boolean)false, (int)2, null)) return true;
        if (StringsKt.endsWith$default((String)path, (String)".aar", (boolean)false, (int)2, null)) return true;
        if (StringsKt.endsWith$default((String)path, (String)".dex", (boolean)false, (int)2, null)) return true;
        if (StringsKt.endsWith$default((String)path, (String)".apk", (boolean)false, (int)2, null)) return true;
        if (StringsKt.endsWith$default((String)path, (String)".ser", (boolean)false, (int)2, null)) return true;
        if (StringsKt.endsWith$default((String)path, (String)".flat", (boolean)false, (int)2, null)) return true;
        if (!StringsKt.endsWith$default((String)path, (String)".bin", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private final void writeArtifactLocation(Incident incident, File file, int indent, boolean last) {
        String string;
        String uriBaseId = null;
        File root = this.getRoot(incident);
        if (root != null && Lint.isParent$default((File)root, (File)file, (boolean)false, (int)4, null)) {
            uriBaseId = "%SRCROOT%";
            string = this.escapeJson(StringsKt.replace$default((String)this.client.getDisplayPath(root, file, false), (char)'\\', (char)'/', (boolean)false, (int)4, null));
        } else if (Lint.isParent$default((File)this.home, (File)file, (boolean)false, (int)4, null)) {
            uriBaseId = "USER_HOME";
            string = this.escapeJson(StringsKt.replace$default((String)this.client.getDisplayPath(this.home, file, false), (char)'\\', (char)'/', (boolean)false, (int)4, null));
        } else {
            uriBaseId = null;
            string = this.escapeJson(Lint.getFileUri((File)file));
        }
        String uri = string;
        this.indent(this.writer, indent).write("\"artifactLocation\": {\n");
        if (uriBaseId != null) {
            this.indent(this.writer, indent + 1).write("\"uriBaseId\": \"" + uriBaseId + "\",\n");
        }
        this.indent(this.writer, indent + 1).write("\"uri\": \"" + uri + "\"\n");
        this.indent(this.writer, indent).write('}' + (!last ? "," : "") + '\n');
    }

    private final Pair<Position, Position> computeContext(CharSequence fileText, Position lineStart, Position lineEnd) {
        int i;
        if (fileText.length() == 0) {
            return null;
        }
        int size = 2;
        Position start = null;
        if (lineStart.getOffset() > 0) {
            int beginLine = lineStart.getLine();
            int beginOffset = 0;
            int offset = lineStart.getOffset() - 1;
            int n = 0;
            block0: while (n < size) {
                i = n++;
                while (offset != 0) {
                    int n2 = offset;
                    offset = n2 + -1;
                    char ch = fileText.charAt(n2);
                    if (ch != '\n') continue;
                    n2 = beginLine;
                    beginLine = n2 + -1;
                    continue block0;
                }
            }
            while (true) {
                if (offset == 0) {
                    beginOffset = 0;
                    break;
                }
                if (fileText.charAt(offset) == '\n') {
                    beginOffset = offset + 1;
                    break;
                }
                n = offset;
                offset = n + -1;
            }
            start = (Position)new DefaultPosition(beginLine, 1, beginOffset);
        } else {
            start = lineStart;
        }
        int endOffset = lineEnd.getOffset();
        int endLine = lineEnd.getLine();
        int endColumn = lineEnd.getColumn();
        int offset = endOffset;
        while (offset < fileText.length()) {
            i = offset;
            offset = i + 1;
            if (fileText.charAt(i) == '\n') {
                i = endLine;
                endLine = i + 1;
                endColumn = 1;
                endOffset = offset;
                break;
            }
            if (offset == fileText.length()) {
                endOffset = offset;
            }
            i = endColumn;
            endColumn = i + 1;
        }
        i = 0;
        block4: while (i < size) {
            int i2 = i++;
            while (offset < fileText.length()) {
                int n;
                char ch = fileText.charAt(offset);
                if (ch == '\n' || offset == fileText.length() - 1) {
                    endOffset = offset;
                    n = endLine;
                    endLine = n + 1;
                    if (ch != '\n') continue block4;
                    endColumn = 1;
                    continue block4;
                }
                n = offset;
                offset = n + 1;
                n = endColumn;
                endColumn = n + 1;
            }
        }
        DefaultPosition end = new DefaultPosition(endLine, endColumn, endOffset);
        return new Pair((Object)start, (Object)end);
    }

    /*
     * WARNING - void declaration
     */
    private final void writeQuickFixes(Incident incident, int indent) {
        Iterable $this$map$iv;
        LintFix lintFix = incident.getFix();
        if (lintFix == null) {
            return;
        }
        LintFix lintFix2 = lintFix;
        List fixes = lintFix2 instanceof LintFix.LintFixGroup && ((LintFix.LintFixGroup)lintFix2).getType() == LintFix.GroupType.ALTERNATIVES ? ((LintFix.LintFixGroup)lintFix2).getFixes() : CollectionsKt.listOf((Object)lintFix2);
        LintFixPerformer performer = new LintFixPerformer(this.client, false, false, false, 12, null);
        try {
            void $this$mapTo$iv$iv;
            $this$map$iv = fixes;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void fix;
                LintFix lintFix3 = (LintFix)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Pair((Object)fix, performer.computeEdits(incident, (LintFix)fix)));
            }
            $this$map$iv = (List)destination$iv$iv;
        }
        catch (Throwable exception) {
            this.client.log(exception, Intrinsics.stringPlus((String)"Couldn't compute fix edits for ", (Object)lintFix2.getDisplayName()), new Object[0]);
            return;
        }
        Iterable edits = $this$map$iv;
        int indent2 = 0;
        int exception = indent2 = indent;
        indent2 = exception + 1;
        this.indent(this.writer, exception).write("\"fixes\": [\n");
        Iterable $this$forEachIndexed$iv = edits;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void $dstr$fix$files;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pair bl = (Pair)item$iv;
            int index = n;
            boolean bl2 = false;
            LintFix fix = (LintFix)$dstr$fix$files.component1();
            List files = (List)$dstr$fix$files.component2();
            this.writeQuickFix(incident, fix, files, index == fixes.size() - 1, indent2);
        }
        this.indent(this.writer, indent2 += -1).write("],\n");
    }

    /*
     * WARNING - void declaration
     */
    private final void writeQuickFix(Incident incident, LintFix fix, List<LintFixPerformer.PendingEditFile> files, boolean last, int indent) {
        if (!((Collection)files).isEmpty()) {
            boolean bl;
            block8: {
                Iterable $this$any$iv = files;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        LintFixPerformer.PendingEditFile it = (LintFixPerformer.PendingEditFile)element$iv;
                        boolean bl2 = false;
                        boolean bl3 = !((Collection)it.getEdits()).isEmpty();
                        if (!bl3) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl) {
                int indent2 = 0;
                indent2 = indent;
                String string = fix.getDisplayName();
                if (string == null) {
                    string = "Fix";
                }
                String description = string;
                int n = indent2;
                indent2 = n + 1;
                this.indent(this.writer, n).write("{\n");
                SarifReporter.writeDescription$default(this, this.writer, indent2, "description", description, true, false, 16, null);
                n = indent2;
                indent2 = n + 1;
                this.indent(this.writer, n).write("\"artifactChanges\": [\n");
                Iterable $this$forEachIndexed$iv = files;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void file;
                    int n2;
                    if ((n2 = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    LintFixPerformer.PendingEditFile pendingEditFile = (LintFixPerformer.PendingEditFile)item$iv;
                    int index = n2;
                    boolean bl4 = false;
                    if (!(!((Collection)file.getEdits()).isEmpty())) continue;
                    this.writeArtifactChange(incident, (LintFixPerformer.PendingEditFile)file, index == files.size() - 1, indent2);
                }
                this.indent(this.writer, indent2 += -1).write("]\n");
                this.indent(this.writer, indent2 += -1).write(Intrinsics.stringPlus((String)"}", (Object)(last ? "\n" : ",\n")));
            }
        }
    }

    private final int getLineNumber(String source, int offset, int startOffset, int startLineNumber) {
        int lineNumber = startLineNumber;
        int n = startOffset;
        int n2 = source.length();
        int n3 = Math.min(offset, n2);
        while (n < n3) {
            int i;
            if (source.charAt(i = n++) != '\n') continue;
            int n4 = lineNumber;
            lineNumber = n4 + 1;
        }
        return lineNumber;
    }

    static /* synthetic */ int getLineNumber$default(SarifReporter sarifReporter, String string, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = 1;
        }
        return sarifReporter.getLineNumber(string, n, n2, n3);
    }

    private final int getColumn(String source, int offset) {
        boolean bl;
        boolean bl2 = 0 <= offset ? offset < source.length() : (bl = false);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        int prevNewline = StringsKt.lastIndexOf$default((CharSequence)source.subSequence(0, offset), (char)'\n', (int)0, (boolean)false, (int)6, null);
        return offset - prevNewline;
    }

    /*
     * WARNING - void declaration
     */
    private final void writeArtifactChange(Incident incident, LintFixPerformer.PendingEditFile file, boolean last, int indent) {
        int indent2 = 0;
        int n = indent2 = indent;
        indent2 = n + 1;
        this.indent(this.writer, n).write("{\n");
        this.writeArtifactLocation(incident, file.getFile(), indent2, false);
        n = indent2;
        indent2 = n + 1;
        this.indent(this.writer, n).write("\"replacements\": [\n");
        List<LintFixPerformer.PendingEdit> edits = file.getEdits();
        Iterable $this$forEachIndexed$iv = edits;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int indent3;
            void edit;
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            LintFixPerformer.PendingEdit pendingEdit = (LintFixPerformer.PendingEdit)item$iv;
            int index = n2;
            boolean bl = false;
            void $this$writeArtifactChange_u24lambda_u2d13_u24lambda_u2d12 = edit;
            boolean bl2 = false;
            int startLine = SarifReporter.getLineNumber$default(this, $this$writeArtifactChange_u24lambda_u2d13_u24lambda_u2d12.getSource(), $this$writeArtifactChange_u24lambda_u2d13_u24lambda_u2d12.getStartOffset(), 0, 0, 12, null);
            int startColumn = this.getColumn($this$writeArtifactChange_u24lambda_u2d13_u24lambda_u2d12.getSource(), $this$writeArtifactChange_u24lambda_u2d13_u24lambda_u2d12.getStartOffset());
            int n3 = indent3 = indent2;
            indent3 = n3 + 1;
            this.indent(this.writer, n3).write("{\n");
            n3 = indent3;
            indent3 = n3 + 1;
            this.indent(this.writer, n3).write("\"deletedRegion\": {\n");
            this.indent(this.writer, indent3).write("\"startLine\": " + startLine + ",\n");
            this.indent(this.writer, indent3).write("\"startColumn\": " + startColumn + ",\n");
            this.indent(this.writer, indent3).write(Intrinsics.stringPlus((String)"\"charOffset\": ", (Object)$this$writeArtifactChange_u24lambda_u2d13_u24lambda_u2d12.getStartOffset()));
            if ($this$writeArtifactChange_u24lambda_u2d13_u24lambda_u2d12.getEndOffset() > $this$writeArtifactChange_u24lambda_u2d13_u24lambda_u2d12.getStartOffset()) {
                this.writer.write(",\n");
                int endLine = this.getLineNumber($this$writeArtifactChange_u24lambda_u2d13_u24lambda_u2d12.getSource(), $this$writeArtifactChange_u24lambda_u2d13_u24lambda_u2d12.getEndOffset(), $this$writeArtifactChange_u24lambda_u2d13_u24lambda_u2d12.getStartOffset(), startLine);
                int endColumn = this.getColumn($this$writeArtifactChange_u24lambda_u2d13_u24lambda_u2d12.getSource(), $this$writeArtifactChange_u24lambda_u2d13_u24lambda_u2d12.getEndOffset() - 1) + 1;
                this.indent(this.writer, indent3).write("\"endLine\": " + endLine + ",\n");
                this.indent(this.writer, indent3).write("\"endColumn\": " + endColumn + ",\n");
                this.indent(this.writer, indent3).write("\"charLength\": " + ($this$writeArtifactChange_u24lambda_u2d13_u24lambda_u2d12.getEndOffset() - $this$writeArtifactChange_u24lambda_u2d13_u24lambda_u2d12.getStartOffset()) + '\n');
            } else {
                this.writer.write("\n");
            }
            this.indent(this.writer, --indent3).write("},\n");
            n3 = indent3;
            indent3 = n3 + 1;
            this.indent(this.writer, n3).write("\"insertedContent\": {\n");
            this.indent(this.writer, indent3).write("\"text\": \"" + this.escapeJson($this$writeArtifactChange_u24lambda_u2d13_u24lambda_u2d12.getReplacement()) + "\\n\"\n");
            this.indent(this.writer, --indent3).write("}\n");
            this.indent(this.writer, --indent3).write('}' + (index < edits.size() - 1 ? "," : "") + '\n');
        }
        this.indent(this.writer, indent2 += -1).write("]\n");
        this.indent(this.writer, indent2 += -1).write(Intrinsics.stringPlus((String)"}", (Object)(last ? "\n" : ",\n")));
    }

    private final Writer writeDescription(Writer $this$writeDescription, int indent, String name, String raw, boolean comma, boolean newline) {
        this.indent(this.writer, indent).write('\"' + name + "\": {\n");
        String text = TextFormat.RAW.convertTo(raw, TextFormat.TEXT);
        this.indent(this.writer, indent + 1).write("\"text\": \"" + this.escapeJson(text) + '\"');
        if (!Intrinsics.areEqual((Object)text, (Object)raw)) {
            this.writer.write(",\n");
            this.indent(this.writer, indent + 1).write("\"markdown\": \"" + this.escapeJson(raw) + "\"\n");
        } else {
            this.writer.write("\n");
        }
        this.indent(this.writer, indent).write("}");
        if (comma) {
            this.writer.write(",");
        }
        if (newline || comma) {
            this.writer.write("\n");
        }
        return $this$writeDescription;
    }

    static /* synthetic */ Writer writeDescription$default(SarifReporter sarifReporter, Writer writer, int n, String string, String string2, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = false;
        }
        if ((n2 & 0x10) != 0) {
            bl2 = false;
        }
        return sarifReporter.writeDescription(writer, n, string, string2, bl, bl2);
    }

    private final Writer indent(Writer $this$indent, int indent) {
        int n = 0;
        while (n < indent) {
            int level = n++;
            $this$indent.write("    ");
        }
        return $this$indent;
    }

    private final String escapeJson(String $this$escapeJson) {
        int n = $this$escapeJson.length();
        for (int i = 0; i < n; ++i) {
            char ch = $this$escapeJson.charAt(i);
            char c = ch;
            if (!((((c == '\\' ? true : c == '\"') ? true : c == '\n') ? true : c == '\t') ? true : c == '\r')) continue;
            StringBuilder sb = new StringBuilder($this$escapeJson.length() + 5);
            int n2 = $this$escapeJson.length();
            for (int j = 0; j < n2; ++j) {
                char c2 = $this$escapeJson.charAt(j);
                char c3 = c2;
                if (c3 == '\\' ? true : c3 == '\"') {
                    sb.append("\\").append(c2);
                    continue;
                }
                if (c3 == '\n') {
                    sb.append("\\n");
                    continue;
                }
                if (c3 == '\t') {
                    sb.append("\\t");
                    continue;
                }
                if (c3 == '\r') {
                    sb.append("\\r");
                    continue;
                }
                sb.append(c2);
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            return string;
        }
        return $this$escapeJson;
    }

    public static final /* synthetic */ String access$escapeJson(SarifReporter $this, String $receiver) {
        return $this.escapeJson($receiver);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Severity.values().length];
            nArray[Severity.FATAL.ordinal()] = 1;
            nArray[Severity.ERROR.ordinal()] = 2;
            nArray[Severity.WARNING.ordinal()] = 3;
            nArray[Severity.INFORMATIONAL.ordinal()] = 4;
            nArray[Severity.IGNORE.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

