/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.SdkConstants;
import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.tools.lint.ManualProject;
import com.android.tools.lint.ProjectInitializerKt;
import com.android.tools.lint.ProjectMetadata;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Desugaring;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Platform;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.model.LintModelModule;
import com.android.tools.lint.model.LintModelSerialization;
import com.android.tools.lint.model.LintModelVariant;
import com.android.utils.StringHelper;
import com.android.utils.XmlUtils;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.ByteStreams;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.intellij.pom.java.LanguageLevel;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010(\u001a\u00020)J\b\u0010*\u001a\u00020+H\u0002J\u001c\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00050\u001eH\u0002J2\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00050\u001e2\u0006\u0010/\u001a\u00020\u00132\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018H\u0002J\u0012\u00102\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0012\u00103\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J \u0010\u0019\u001a\u00020\u00052\u0006\u00104\u001a\u00020\u00132\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u0005H\u0002J.\u0010\u0019\u001a\u00020\u00052\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u00052\n\b\u0002\u00108\u001a\u0004\u0018\u00010\u00132\b\b\u0002\u00109\u001a\u00020\tH\u0002J\u0018\u0010:\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00152\u0006\u00105\u001a\u000206H\u0002JN\u0010;\u001a\u00020+2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018H\u0002J\\\u0010;\u001a\u00020+2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018H\u0002J\u001a\u0010@\u001a\u0004\u0018\u00010\u00132\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u0005H\u0002J\u001a\u0010A\u001a\u0004\u0018\u00010\u00132\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u0005H\u0002J\u0010\u0010B\u001a\u00020+2\u0006\u0010C\u001a\u000206H\u0002J\u0010\u0010D\u001a\u00020)2\u0006\u0010E\u001a\u000206H\u0002J \u0010F\u001a\u00020\t2\u0006\u0010G\u001a\u00020\u00132\u0006\u00104\u001a\u00020\u00132\u0006\u0010H\u001a\u00020IH\u0002J\u0010\u0010J\u001a\u00020\u00052\u0006\u0010K\u001a\u00020\u0013H\u0002J\u001c\u0010L\u001a\u00020+2\u0006\u0010M\u001a\u00020\u00132\n\b\u0002\u0010N\u001a\u0004\u0018\u00010OH\u0002J\u0016\u0010P\u001a\u00020+2\u0006\u0010Q\u001a\u00020\u00052\u0006\u00107\u001a\u00020\u0005R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00130\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u001e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00120\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001a\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020'0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lcom/android/tools/lint/ProjectInitializer;", "", "client", "Lcom/android/tools/lint/client/api/LintClient;", "file", "Ljava/io/File;", "root", "(Lcom/android/tools/lint/client/api/LintClient;Ljava/io/File;Ljava/io/File;)V", "android", "", "baselines", "", "Lcom/android/tools/lint/detector/api/Project;", "cache", "getClient", "()Lcom/android/tools/lint/client/api/LintClient;", "dependencies", "Lcom/google/common/collect/Multimap;", "Lcom/android/tools/lint/ManualProject;", "", "desugaring", "Ljava/util/EnumSet;", "Lcom/android/tools/lint/detector/api/Desugaring;", "externalAnnotations", "", "getFile", "()Ljava/io/File;", "globalClasspath", "jarAarMap", "lintChecks", "", "mergedManifests", "moduleDirectories", "", "modules", "getRoot", "setRoot", "(Ljava/io/File;)V", "visibility", "Lcom/android/ide/common/repository/ResourceVisibilityLookup;", "computeMetadata", "Lcom/android/tools/lint/ProjectMetadata;", "computeResourceVisibility", "", "computeSourceRoots", "sources", "computeUniqueSourceRoots", "type", "typeSources", "sourceRoots", "findPackage", "findRoot", "path", "element", "Lorg/w3c/dom/Element;", "dir", "attribute", "required", "handleDesugaring", "handleSrcJars", "resources", "manifests", "classes", "list", "parseAar", "parseJar", "parseModule", "moduleElement", "parseModules", "projectElement", "pathMatchesPackage", "pkg", "packageStart", "", "pickDirectory", "moduleName", "reportError", "message", "node", "Lorg/w3c/dom/Node;", "unpackZipFile", "zip", "lint-cli"})
final class ProjectInitializer {
    @NotNull
    private final LintClient client;
    @NotNull
    private final File file;
    @NotNull
    private File root;
    @NotNull
    private final Map<String, ManualProject> modules;
    @NotNull
    private final List<File> globalClasspath;
    @NotNull
    private final Multimap<ManualProject, String> dependencies;
    @NotNull
    private final Map<Project, File> mergedManifests;
    @NotNull
    private final Map<Project, List<File>> lintChecks;
    @NotNull
    private final List<File> externalAnnotations;
    @NotNull
    private final Map<Project, File> baselines;
    @NotNull
    private final Map<File, String> jarAarMap;
    @NotNull
    private final Map<String, ResourceVisibilityLookup> visibility;
    @Nullable
    private File cache;
    private boolean android;
    @Nullable
    private EnumSet<Desugaring> desugaring;
    @NotNull
    private final Set<File> moduleDirectories;

    public ProjectInitializer(@NotNull LintClient client, @NotNull File file, @NotNull File root) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.client = client;
        this.file = file;
        this.root = root;
        this.modules = new LinkedHashMap();
        this.globalClasspath = new ArrayList();
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        Intrinsics.checkNotNullExpressionValue((Object)arrayListMultimap, (String)"create()");
        this.dependencies = (Multimap)arrayListMultimap;
        this.mergedManifests = new LinkedHashMap();
        this.lintChecks = new LinkedHashMap();
        this.externalAnnotations = new ArrayList();
        this.baselines = new LinkedHashMap();
        this.jarAarMap = new LinkedHashMap();
        this.visibility = new LinkedHashMap();
        this.moduleDirectories = new HashSet();
    }

    @NotNull
    public final LintClient getClient() {
        return this.client;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public final File getRoot() {
        return this.root;
    }

    public final void setRoot(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.root = file;
    }

    @NotNull
    public final ProjectMetadata computeMetadata() {
        Document document = LintClient.getXmlDocument$default((LintClient)this.client, (File)this.file, null, (int)2, null);
        if (document == null || document.getDocumentElement() == null) {
            ProjectInitializer.reportError$default(this, Intrinsics.stringPlus((String)"Failed to parse project descriptor ", (Object)this.file), null, 2, null);
            return new ProjectMetadata(null, null, null, null, null, null, null, null, null, null, null, null, false, null, 16383, null);
        }
        Element element = document.getDocumentElement();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"document.documentElement");
        return this.parseModules(element);
    }

    private final void reportError(String message2, Node node) {
        Location location = node != null ? this.client.getXmlParser().getLocation(this.file, node) : Location.Companion.create(this.file);
        LintClient.Companion companion = LintClient.Companion;
        LintClient lintClient = this.client;
        Issue issue = IssueRegistry.LINT_ERROR;
        File file = this.file;
        LintClient.Companion.report$default((LintClient.Companion)companion, (LintClient)lintClient, (Issue)issue, (String)message2, (File)file, null, null, null, null, null, null, null, null, (Location)location, (int)4080, null);
    }

    static /* synthetic */ void reportError$default(ProjectInitializer projectInitializer, String string, Node node, int n, Object object) {
        if ((n & 2) != 0) {
            node = null;
        }
        projectInitializer.reportError(string, node);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final ProjectMetadata parseModules(Element projectElement) {
        if (!Intrinsics.areEqual((Object)projectElement.getTagName(), (Object)"project")) {
            this.reportError("Expected <project> as the root tag", projectElement);
            return new ProjectMetadata(null, null, null, null, null, null, null, null, null, null, null, null, false, null, 16383, null);
        }
        incomplete = Intrinsics.areEqual((Object)projectElement.getAttribute("incomplete"), (Object)"true");
        this.android = Intrinsics.areEqual((Object)projectElement.getAttribute("android"), (Object)"true");
        this.desugaring = this.handleDesugaring(projectElement);
        client = projectElement.getAttribute("client");
        globalLintChecks = new ArrayList<E>();
        child = XmlUtils.getFirstSubTag((Node)projectElement);
        sdk = null;
        jdk = null;
        baseline = null;
        jdkBootClasspath = new ArrayList<E>();
        while (child != null) {
            tag = child.getTagName();
            var11_11 = tag;
            if (var11_11 == null) ** GOTO lbl-1000
            tmp = -1;
            switch (var11_11.hashCode()) {
                case 105073: {
                    if (var11_11.equals("jdk")) {
                        tmp = 1;
                    }
                    break;
                }
                case 94416770: {
                    if (var11_11.equals("cache")) {
                        tmp = 2;
                    }
                    break;
                }
                case -8875619: {
                    if (var11_11.equals("classpath")) {
                        tmp = 3;
                    }
                    break;
                }
                case -1710494882: {
                    if (var11_11.equals("jdk-boot-classpath")) {
                        tmp = 4;
                    }
                    break;
                }
                case -1068784020: {
                    if (var11_11.equals("module")) {
                        tmp = 5;
                    }
                    break;
                }
                case 3506402: {
                    if (var11_11.equals("root")) {
                        tmp = 6;
                    }
                    break;
                }
                case -961709276: {
                    if (var11_11.equals("annotations")) {
                        tmp = 7;
                    }
                    break;
                }
                case 113722: {
                    if (var11_11.equals("sdk")) {
                        tmp = 8;
                    }
                    break;
                }
                case -1720785339: {
                    if (var11_11.equals("baseline")) {
                        tmp = 9;
                    }
                    break;
                }
                case -983827083: {
                    if (var11_11.equals("lint-checks")) {
                        tmp = 10;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 5: {
                    this.parseModule(child);
                    break;
                }
                case 3: {
                    this.globalClasspath.add(ProjectInitializer.getFile$default(this, child, this.root, null, false, 12, null));
                    break;
                }
                case 10: {
                    globalLintChecks.add(ProjectInitializer.getFile$default(this, child, this.root, null, false, 12, null));
                    break;
                }
                case 7: {
                    ((Collection)this.externalAnnotations).add(ProjectInitializer.getFile$default(this, child, this.root, null, false, 12, null));
                    break;
                }
                case 8: {
                    sdk = ProjectInitializer.getFile$default(this, child, this.root, null, false, 12, null);
                    break;
                }
                case 1: {
                    jdk = ProjectInitializer.getFile$default(this, child, this.root, null, false, 12, null);
                    break;
                }
                case 4: {
                    path = child.getAttribute("path");
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
                    if (((CharSequence)path).length() > 0) {
                        var14_17 = new char[]{File.pathSeparatorChar};
                        for (String s : StringsKt.split$default((CharSequence)path, (char[])var14_17, (boolean)false, (int)0, (int)6, null)) {
                            ((Collection)jdkBootClasspath).add(this.getFile(s, child, this.root));
                        }
                        break;
                    }
                    ((Collection)jdkBootClasspath).add(ProjectInitializer.getFile$default(this, child, this.root, null, false, 12, null));
                    break;
                }
                case 9: {
                    baseline = ProjectInitializer.getFile$default(this, child, this.root, null, false, 12, null);
                    break;
                }
                case 2: {
                    this.cache = ProjectInitializer.getFile$default(this, child, this.root, null, false, 12, null);
                    break;
                }
                case 6: {
                    dir = new File(child.getAttribute("dir"));
                    if (dir.isDirectory()) {
                        var13_13 = dir.getCanonicalFile();
                        Intrinsics.checkNotNullExpressionValue((Object)var13_13, (String)"dir.canonicalFile");
                        this.root = var13_13;
                        break;
                    }
                    this.reportError(dir + " does not exist", child);
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    this.reportError("Unexpected top level tag " + tag + " in " + this.file, child);
                }
            }
            child = XmlUtils.getNextTag((Node)child);
        }
        for (Object var11_11 : this.dependencies.entries()) {
            Intrinsics.checkNotNullExpressionValue((Object)var11_11, (String)"dependencies.entries()");
            module = (ManualProject)var11_11.getKey();
            dependencyName = (String)var11_11.getValue();
            to /* !! */  = this.modules.get(dependencyName);
            if (to /* !! */  != null) {
                module.addDirectDependency(to /* !! */ );
                continue;
            }
            ProjectInitializer.reportError$default(this, "No module " + dependencyName + " found (depended on by " + module.getName(), null, 2, null);
        }
        allModules = this.modules.values();
        roots = new HashSet<ManualProject>(allModules);
        for (ManualProject project : allModules) {
            to /* !! */  = roots;
            var15_22 = project.getAllLibraries();
            Intrinsics.checkNotNullExpressionValue((Object)var15_22, (String)"project.allLibraries");
            var15_22 = (Collection)var15_22;
            TypeIntrinsics.asMutableCollection((Object)to /* !! */ ).removeAll((Collection<?>)var15_22);
        }
        $this$sortBy$iv = sortedModules = CollectionsKt.toMutableList((Collection)roots);
        $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ManualProject it = (ManualProject)((Object)a);
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (ManualProject)((Object)b);
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                }
            });
        }
        if (!this.globalClasspath.isEmpty()) {
            useForAnalysis = true;
            for (ManualProject module : sortedModules) {
                if (module.getJavaLibraries(true).isEmpty()) {
                    module.setClasspath(this.globalClasspath, false);
                }
                if (!module.getJavaClassFolders().isEmpty()) continue;
                module.setClasspath(this.globalClasspath, useForAnalysis);
                useForAnalysis = false;
            }
        }
        this.computeResourceVisibility();
        var13_16 = sdk;
        var14_21 = jdk;
        var15_22 = baseline;
        var16_23 = this.lintChecks;
        var17_24 = this.externalAnnotations;
        var18_25 = this.cache;
        var19_26 = this.baselines;
        var20_27 = this.mergedManifests;
        var21_28 = this.android != false ? Platform.ANDROID_SET : Platform.JDK_SET;
        return new ProjectMetadata(sortedModules, (File)var15_22, var13_16, var14_21, var18_25, var20_27, var19_26, globalLintChecks, var16_23, jdkBootClasspath, var21_28, var17_24, incomplete, client);
    }

    private final EnumSet<Desugaring> handleDesugaring(Element element) {
        EnumSet<Enum> desugaring = null;
        if (Intrinsics.areEqual((Object)"true", (Object)element.getAttribute("android_java8_libs"))) {
            desugaring = EnumSet.of((Enum)Desugaring.JAVA_8_LIBRARY);
        }
        String s = element.getAttribute("desugar");
        Intrinsics.checkNotNullExpressionValue((Object)s, (String)"s");
        if (!(((CharSequence)s).length() == 0)) {
            String[] stringArray = new String[]{","};
            for (String option : StringsKt.split$default((CharSequence)s, (String[])stringArray, (boolean)false, (int)0, (int)6, null)) {
                boolean found = false;
                for (Desugaring v : Desugaring.values()) {
                    if (!StringsKt.equals((String)option, (String)v.name(), (boolean)true)) continue;
                    if (desugaring == null) {
                        desugaring = EnumSet.of((Enum)v);
                    } else {
                        desugaring.add((Enum)v);
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                try {
                    EnumSet v;
                    String fieldName;
                    String string = option;
                    if (string == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string.toUpperCase(), (String)"(this as java.lang.String).toUpperCase()");
                    Class<Desugaring> cls = Desugaring.class;
                    Object object = cls.getField(fieldName).get(null);
                    if ((object instanceof EnumSet ? (EnumSet)object : null) == null) continue;
                    v = v;
                    if (desugaring == null) {
                        desugaring = EnumSet.noneOf(Desugaring.class);
                    }
                    EnumSet<Enum> enumSet = desugaring;
                    if (enumSet == null) continue;
                    enumSet.addAll(v);
                }
                catch (Throwable throwable) {}
            }
        }
        return desugaring;
    }

    private final void computeResourceVisibility() {
        for (ManualProject module : this.modules.values()) {
            List aarDeps = new ArrayList();
            for (String dependencyName : this.dependencies.get((Object)module)) {
                ResourceVisibilityLookup visibility;
                if (this.visibility.get(dependencyName) == null) continue;
                aarDeps.add(visibility);
            }
            if (aarDeps.isEmpty()) continue;
            ResourceVisibilityLookup visibilityLookup = aarDeps.size() == 1 ? (ResourceVisibilityLookup)aarDeps.get(0) : ResourceVisibilityLookup.create((List)aarDeps);
            module.setResourceVisibility(visibilityLookup);
        }
    }

    private final File pickDirectory(String moduleName) {
        File dir;
        File file;
        int n;
        int n2;
        String string;
        CharSequence charSequence = moduleName;
        String string2 = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"separator");
        int separatorIndex = StringsKt.lastIndexOf$default((CharSequence)charSequence, (String)string2, (int)0, (boolean)false, (int)6, null);
        int index = StringsKt.indexOf$default((CharSequence)moduleName, (char)':', (int)(separatorIndex + 1), (boolean)false, (int)4, null);
        if (separatorIndex != -1 && index != -1) {
            string = moduleName;
            n2 = 0;
            n = StringsKt.indexOf$default((CharSequence)moduleName, (char)':', (int)separatorIndex, (boolean)false, (int)4, null);
            String string3 = string;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n2, n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            file = new File(string4);
        } else if (index != -1 && index < moduleName.length() - 1) {
            string = moduleName;
            n2 = index + 1;
            String string5 = string;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n2);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
            file = new File(this.root, string6);
        } else {
            file = dir = new File(this.root, moduleName);
        }
        if (this.moduleDirectories.add(dir)) {
            return dir;
        }
        int count = 2;
        File unique;
        while (!this.moduleDirectories.add(unique = new File(Intrinsics.stringPlus((String)dir.getPath(), (Object)count)))) {
            n = count;
            count = n + 1;
        }
        return unique;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void parseModule(Element moduleElement) {
        Unit unit;
        LanguageLevel it;
        Unit unit2;
        Object object;
        List resourceRoots;
        List<File> generatedSourceRoots;
        List<File> testSourceRoots;
        List<File> sourceRoots;
        File mergedManifest;
        File baseline;
        List lintChecks;
        List classpath;
        List classes;
        List manifests;
        List resources;
        List testSources;
        List generatedSources;
        List sources;
        LintModelModule model;
        ManualProject module;
        LanguageVersionSettingsImpl kotlinLanguageLevel;
        LanguageLevel javaLanguageLevel;
        EnumSet<Desugaring> desugaring;
        String buildApi;
        block59: {
            block60: {
                Element child;
                block58: {
                    LanguageVersionSettingsImpl languageVersionSettingsImpl;
                    LanguageLevel languageLevel;
                    String string = moduleElement.getAttribute("name");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"moduleElement.getAttribute(ATTR_NAME)");
                    String name = string;
                    boolean library = Intrinsics.areEqual((Object)moduleElement.getAttribute("library"), (Object)"true");
                    boolean android = !Intrinsics.areEqual((Object)moduleElement.getAttribute("android"), (Object)"false");
                    String string2 = moduleElement.getAttribute("compile-sdk-version");
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"moduleElement.getAttribu\u2026ATTR_COMPILE_SDK_VERSION)");
                    buildApi = string2;
                    EnumSet<Desugaring> enumSet = this.handleDesugaring(moduleElement);
                    if (enumSet == null) {
                        enumSet = desugaring = this.desugaring;
                    }
                    if (android) {
                        this.android = true;
                    }
                    String level = moduleElement.getAttribute("javaLanguage");
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level");
                    if (!StringsKt.isBlank((CharSequence)level)) {
                        LanguageLevel languageLevel2;
                        LanguageLevel languageLevel3;
                        LanguageLevel languageLevel4 = LanguageLevel.parse((String)level);
                        if (languageLevel4 == null) {
                            ProjectInitializer $this$parseModule_u24lambda_u2d2_u24lambda_u2d1 = this;
                            boolean bl2 = false;
                            $this$parseModule_u24lambda_u2d2_u24lambda_u2d1.reportError("Invalid Java language level \"" + level + '\"', moduleElement);
                            languageLevel3 = null;
                        } else {
                            languageLevel3 = languageLevel4;
                        }
                        languageLevel = languageLevel2 = languageLevel3;
                    } else {
                        languageLevel = null;
                    }
                    javaLanguageLevel = languageLevel;
                    String level2 = moduleElement.getAttribute("kotlinLanguage");
                    boolean bl3 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"level");
                    if (!StringsKt.isBlank((CharSequence)level2)) {
                        LanguageVersion languageLevel5;
                        LanguageVersion languageVersion;
                        LanguageVersion languageVersion2 = LanguageVersion.Companion.fromVersionString(level2);
                        if (languageVersion2 == null) {
                            ProjectInitializer $this$parseModule_u24lambda_u2d4_u24lambda_u2d3 = this;
                            boolean bl4 = false;
                            $this$parseModule_u24lambda_u2d4_u24lambda_u2d3.reportError("Invalid Kotlin language level \"" + level2 + '\"', moduleElement);
                            languageVersion = null;
                        } else {
                            languageVersion = languageLevel5 = languageVersion2;
                        }
                        languageVersionSettingsImpl = languageLevel5 != null ? new LanguageVersionSettingsImpl(languageLevel5, ApiVersion.Companion.createByLanguageVersion(languageLevel5), null, null, 12, null) : (LanguageVersionSettingsImpl)null;
                    } else {
                        languageVersionSettingsImpl = null;
                    }
                    kotlinLanguageLevel = languageVersionSettingsImpl;
                    File it2 = this.pickDirectory(name);
                    boolean bl5 = false;
                    File dir = it2.isDirectory() ? it2 : this.getRoot();
                    module = new ManualProject(this.client, dir, name, library, android);
                    this.modules.put(name, module);
                    model = moduleElement.hasAttribute("model") ? LintModelSerialization.readModule$default((LintModelSerialization)LintModelSerialization.INSTANCE, (File)this.getFile(moduleElement, dir, "model", false), null, (boolean)false, null, (int)14, null) : (LintModelModule)null;
                    sources = new ArrayList();
                    generatedSources = new ArrayList();
                    testSources = new ArrayList();
                    resources = new ArrayList();
                    manifests = new ArrayList();
                    classes = new ArrayList();
                    classpath = new ArrayList();
                    lintChecks = new ArrayList();
                    baseline = null;
                    mergedManifest = null;
                    child = XmlUtils.getFirstSubTag((Node)moduleElement);
                    while (child != null) {
                        String string3 = child.getTagName();
                        if (string3 == null) break block58;
                        int n = -1;
                        switch (string3.hashCode()) {
                            case 114148: {
                                if (!string3.equals("src")) break;
                                n = 1;
                                break;
                            }
                            case -341064690: {
                                if (!string3.equals("resource")) break;
                                n = 2;
                                break;
                            }
                            case -8875619: {
                                if (!string3.equals("classpath")) break;
                                n = 3;
                                break;
                            }
                            case 130625071: {
                                if (!string3.equals("manifest")) break;
                                n = 4;
                                break;
                            }
                            case 853620774: {
                                if (!string3.equals("classes")) break;
                                n = 5;
                                break;
                            }
                            case -961709276: {
                                if (!string3.equals("annotations")) break;
                                n = 6;
                                break;
                            }
                            case -260399184: {
                                if (!string3.equals("merged-manifest")) break;
                                n = 7;
                                break;
                            }
                            case -1720785339: {
                                if (!string3.equals("baseline")) break;
                                n = 8;
                                break;
                            }
                            case -983827083: {
                                if (!string3.equals("lint-checks")) break;
                                n = 9;
                                break;
                            }
                            case 99343: {
                                if (!string3.equals("dep")) break;
                                n = 10;
                                break;
                            }
                            case -1000992744: {
                                if (!string3.equals("proguard")) break;
                                n = 11;
                                break;
                            }
                            case 96338: {
                                if (!string3.equals("aar")) break;
                                n = 12;
                                break;
                            }
                            case 104987: {
                                if (!string3.equals("jar")) break;
                                n = 13;
                                break;
                            }
                            case 2993840: {
                                if (!string3.equals("aidl")) break;
                                n = 11;
                                break;
                            }
                        }
                        switch (n) {
                            case 4: {
                                manifests.add(ProjectInitializer.getFile$default(this, child, dir, null, false, 12, null));
                                Unit unit3 = Unit.INSTANCE;
                                break;
                            }
                            case 7: {
                                mergedManifest = ProjectInitializer.getFile$default(this, child, dir, null, false, 12, null);
                                Unit unit3 = Unit.INSTANCE;
                                break;
                            }
                            case 1: {
                                File file = ProjectInitializer.getFile$default(this, child, dir, null, false, 12, null);
                                boolean bl6 = Intrinsics.areEqual((Object)child.getAttribute("generated"), (Object)"true");
                                if (bl6) {
                                    generatedSources.add(file);
                                } else if (!bl6) {
                                    boolean bl7 = Intrinsics.areEqual((Object)child.getAttribute("test"), (Object)"true");
                                    if (!bl7) {
                                        sources.add(file);
                                    } else if (bl7) {
                                        testSources.add(file);
                                    }
                                }
                                Unit unit3 = Unit.INSTANCE;
                                break;
                            }
                            case 2: {
                                resources.add(ProjectInitializer.getFile$default(this, child, dir, null, false, 12, null));
                                Unit unit3 = Unit.INSTANCE;
                                break;
                            }
                            case 5: {
                                classes.add(ProjectInitializer.getFile$default(this, child, dir, null, false, 12, null));
                                Unit unit3 = Unit.INSTANCE;
                                break;
                            }
                            case 3: {
                                classpath.add(ProjectInitializer.getFile$default(this, child, dir, null, false, 12, null));
                                Unit unit3 = Unit.INSTANCE;
                                break;
                            }
                            case 12: {
                                Boolean bl8;
                                String aar = this.parseAar(child, dir);
                                if (aar == null) {
                                    bl8 = null;
                                } else {
                                    boolean bl9 = false;
                                    bl8 = this.dependencies.put((Object)module, (Object)aar);
                                }
                                Unit unit3 = Unit.INSTANCE;
                                break;
                            }
                            case 13: {
                                Boolean bl10;
                                Object jar = this.parseJar(child, dir);
                                if (jar == null) {
                                    bl10 = null;
                                } else {
                                    boolean bl11 = false;
                                    bl10 = this.dependencies.put((Object)module, jar);
                                }
                                Unit unit3 = Unit.INSTANCE;
                                break;
                            }
                            case 8: {
                                baseline = ProjectInitializer.getFile$default(this, child, dir, null, false, 12, null);
                                Unit unit3 = Unit.INSTANCE;
                                break;
                            }
                            case 9: {
                                lintChecks.add(ProjectInitializer.getFile$default(this, child, dir, null, false, 12, null));
                                Unit unit3 = Unit.INSTANCE;
                                break;
                            }
                            case 6: {
                                Object jar = this.externalAnnotations;
                                File file = ProjectInitializer.getFile$default(this, child, this.root, null, false, 12, null);
                                jar.add(file);
                                Unit unit3 = Unit.INSTANCE;
                                break;
                            }
                            case 10: {
                                String target = child.getAttribute("module");
                                Intrinsics.checkNotNullExpressionValue((Object)target, (String)"target");
                                if (((CharSequence)target).length() == 0) {
                                    this.reportError(Intrinsics.stringPlus((String)"Invalid module dependency in ", (Object)module.getName()), child);
                                }
                                this.dependencies.put((Object)module, (Object)target);
                                Unit unit3 = Unit.INSTANCE;
                                break;
                            }
                            case 11: {
                                Unit unit3 = Unit.INSTANCE;
                                break;
                            }
                            default: {
                                break block58;
                            }
                        }
                        child = XmlUtils.getNextTag((Node)child);
                    }
                    sourceRoots = this.computeSourceRoots(sources);
                    testSourceRoots = this.computeUniqueSourceRoots("test", testSources, sourceRoots);
                    generatedSourceRoots = this.computeUniqueSourceRoots("generated", generatedSources, sourceRoots);
                    resourceRoots = new ArrayList();
                    if (!(!((Collection)resources).isEmpty())) break block59;
                    object = resources.iterator();
                    break block60;
                }
                this.reportError(Intrinsics.stringPlus((String)"Unexpected tag ", (Object)child.getTagName()), child);
                return;
            }
            while (object.hasNext()) {
                File res;
                File typeFolder;
                File file = (File)object.next();
                if (file.getParentFile() == null || typeFolder.getParentFile() == null || resourceRoots.contains(res)) continue;
                resourceRoots.add(res);
            }
        }
        this.handleSrcJars(sources, resources, manifests, classes, sourceRoots);
        module.setManifests(manifests);
        module.setResources(resourceRoots, resources);
        module.setTestSources(testSourceRoots, testSources);
        module.setGeneratedSources(generatedSourceRoots, generatedSources);
        module.setSources(sourceRoots, sources);
        module.setClasspath(classes, true);
        module.setClasspath(classpath, false);
        module.setDesugaring((Set<? extends Desugaring>)desugaring);
        LanguageLevel languageLevel = javaLanguageLevel;
        if (languageLevel == null) {
            unit2 = null;
        } else {
            it = languageLevel;
            boolean bl = false;
            module.setJavaLanguageLevel(it);
            unit2 = Unit.INSTANCE;
        }
        LanguageVersionSettingsImpl languageVersionSettingsImpl = kotlinLanguageLevel;
        if (languageVersionSettingsImpl == null) {
            unit = null;
        } else {
            it = languageVersionSettingsImpl;
            boolean bl = false;
            module.setKotlinLanguageLevel((LanguageVersionSettings)it);
            unit = Unit.INSTANCE;
        }
        module.setCompileSdkVersion(buildApi);
        this.lintChecks.put(module, lintChecks);
        this.mergedManifests.put(module, mergedManifest);
        this.baselines.put(module, baseline);
        LintModelModule lintModelModule = model;
        module.setVariant((LintModelVariant)(lintModelModule == null ? null : lintModelModule.defaultVariant()));
        object = module.getDir();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"module.dir");
        this.client.registerProject((File)object, (Project)module);
    }

    private final void handleSrcJars(List<File> sources, List<File> resources, List<File> manifests, List<File> classes, List<File> sourceRoots) {
        this.handleSrcJars(sources, sources, resources, manifests, classes, sourceRoots);
        this.handleSrcJars(resources, sources, resources, manifests, classes, sourceRoots);
        this.handleSrcJars(manifests, sources, resources, manifests, classes, sourceRoots);
        this.handleSrcJars(classes, sources, resources, manifests, classes, sourceRoots);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleSrcJars(List<File> list2, List<File> sources, List<File> resources, List<File> manifests, List<File> classes, List<File> sourceRoots) {
        ListIterator<File> iterator = list2.listIterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            Object object = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"file.path");
            if (!StringsKt.endsWith$default((String)object, (String)".srcjar", (boolean)false, (int)2, null)) continue;
            iterator.remove();
            sourceRoots.add(file);
            object = new ZipFile(file);
            Throwable throwable = null;
            try {
                ZipFile zipFile = (ZipFile)object;
                boolean bl = false;
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry zipEntry = entries.nextElement();
                    if (zipEntry.isDirectory()) continue;
                    String path = file.getPath() + "!/" + zipEntry.getName();
                    File newFile = new File(path);
                    if (StringsKt.endsWith$default((String)path, (String)"AndroidManifest.xml", (boolean)false, (int)2, null)) {
                        if (list2 == manifests) {
                            iterator.add(newFile);
                            continue;
                        }
                        manifests.add(newFile);
                        continue;
                    }
                    if (StringsKt.endsWith$default((String)path, (String)".xml", (boolean)false, (int)2, null)) {
                        if (list2 == resources) {
                            iterator.add(newFile);
                            continue;
                        }
                        resources.add(newFile);
                        continue;
                    }
                    if (StringsKt.endsWith$default((String)path, (String)".java", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path, (String)".kt", (boolean)false, (int)2, null)) {
                        if (list2 == sources) {
                            iterator.add(newFile);
                            continue;
                        }
                        sources.add(newFile);
                        continue;
                    }
                    if (!StringsKt.endsWith$default((String)path, (String)".class", (boolean)false, (int)2, null)) continue;
                    if (list2 == classes) {
                        iterator.add(newFile);
                        continue;
                    }
                    classes.add(newFile);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String parseAar(Element element, File dir) {
        File classesJar;
        List list2;
        Object object;
        Object it;
        File resources;
        File file;
        File aarFile = ProjectInitializer.getFile$default(this, element, dir, null, false, 12, null);
        String moduleName = this.jarAarMap.get(aarFile);
        if (moduleName != null) {
            return moduleName;
        }
        String name = aarFile.getName();
        ProjectInitializer $this$parseAar_u24lambda_u2d11 = this;
        boolean bl = false;
        File expanded = $this$parseAar_u24lambda_u2d11.getFile(element, dir, "extracted", false);
        String string = expanded.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"expanded.path");
        if (((CharSequence)string).length() == 0) {
            File cacheDir = $this$parseAar_u24lambda_u2d11.cache != null ? new File($this$parseAar_u24lambda_u2d11.cache, "aars") : $this$parseAar_u24lambda_u2d11.getClient().getCacheDir("aars", true);
            File target = new File(cacheDir, name);
            if (!target.isDirectory()) {
                $this$parseAar_u24lambda_u2d11.unpackZipFile(aarFile, target);
            }
            file = target;
        } else {
            if (!expanded.isDirectory()) {
                ProjectInitializer.reportError$default($this$parseAar_u24lambda_u2d11, "Expanded AAR path " + expanded + " is not a directory", null, 2, null);
            }
            file = expanded;
        }
        File expanded2 = file;
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
        ManualProject project = new ManualProject(this.client, expanded2, name, true, true);
        project.setReportIssues(false);
        File manifest = new File(expanded2, "AndroidManifest.xml");
        if (manifest.isFile()) {
            project.setManifests(CollectionsKt.listOf((Object)manifest));
        }
        if ((resources = new File(expanded2, "res")).isDirectory()) {
            project.setResources(CollectionsKt.listOf((Object)resources), CollectionsKt.emptyList());
        }
        List jarList = new ArrayList();
        File jarsDir = new File(expanded2, "jars");
        if (jarsDir.isDirectory()) {
            File[] fileArray = jarsDir.listFiles();
            if (fileArray != null) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                it = fileArray;
                boolean bl2 = false;
                object = it;
                list2 = jarList;
                boolean $i$f$filter = false;
                void var19_20 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                void var22_23 = $this$filterTo$iv$iv;
                int n = ((void)var22_23).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void file2 = element$iv$iv = var22_23[i];
                    boolean bl3 = false;
                    String string2 = file2.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.name");
                    if (!StringsKt.endsWith$default((String)string2, (String)".jar", (boolean)false, (int)2, null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2.addAll(CollectionsKt.toList((Iterable)((List)destination$iv$iv)));
            }
        }
        if ((classesJar = new File(expanded2, "classes.jar")).isFile()) {
            jarList.add(classesJar);
        }
        if (!((Collection)jarList).isEmpty()) {
            project.setClasspath(jarList, false);
        }
        Map<Object, Object> map = this.jarAarMap;
        it = name;
        map.put(aarFile, (String)it);
        map = this.modules;
        it = name;
        map.put((File)it, (String)((Object)project));
        File publicResources = new File(expanded2, "public.txt");
        File allResources = new File(expanded2, "R.txt");
        Map<String, ResourceVisibilityLookup> map2 = this.visibility;
        object = name;
        list2 = ResourceVisibilityLookup.create((File)publicResources, (File)allResources, (String)name);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"create(publicResources, allResources, name)");
        map2.put((String)object, (ResourceVisibilityLookup)list2);
        return name;
    }

    private final String parseJar(Element element, File dir) {
        File jarFile = ProjectInitializer.getFile$default(this, element, dir, null, false, 12, null);
        String moduleName = this.jarAarMap.get(jarFile);
        if (moduleName != null) {
            return moduleName;
        }
        String name = jarFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
        ManualProject project = new ManualProject(this.client, jarFile, name, true, false);
        project.setReportIssues(false);
        project.setClasspath(CollectionsKt.listOf((Object)jarFile), false);
        Map<Object, Object> map = this.jarAarMap;
        String string = name;
        map.put(jarFile, string);
        map = this.modules;
        string = name;
        map.put((File)((Object)string), (String)((Object)project));
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unpackZipFile(@NotNull File zip, @NotNull File dir) throws ZipException, IOException {
        Intrinsics.checkNotNullParameter((Object)zip, (String)"zip");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Closeable closeable = new ZipFile(zip);
        Throwable throwable = null;
        try {
            ZipFile zipFile = (ZipFile)closeable;
            boolean bl = false;
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                if (zipEntry.isDirectory()) continue;
                File targetFile = new File(dir, zipEntry.getName());
                Files.createParentDirs((File)targetFile);
                Closeable closeable2 = Files.asByteSink((File)targetFile, (FileWriteMode[])new FileWriteMode[0]).openBufferedStream();
                Throwable throwable2 = null;
                try {
                    OutputStream it = (OutputStream)closeable2;
                    boolean bl2 = false;
                    long l = ByteStreams.copy((InputStream)zipFile.getInputStream(zipEntry), (OutputStream)it);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final List<File> computeUniqueSourceRoots(String type, List<File> typeSources, List<File> sourceRoots) {
        if (typeSources.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List<File> typeSourceRoots = this.computeSourceRoots(typeSources);
        for (File root : typeSourceRoots) {
            if (!sourceRoots.contains(root)) continue;
            ProjectInitializer.reportError$default(this, StringHelper.usLocaleCapitalize((String)type) + " sources cannot be in the same source root as production files; source root " + root + " is also a test root", null, 2, null);
            break;
        }
        typeSourceRoots.removeAll((Collection)sourceRoots);
        return typeSourceRoots;
    }

    private final List<File> computeSourceRoots(List<? extends File> sources) {
        List sourceRoots = new ArrayList();
        if (!sources.isEmpty()) {
            Map dirToRootCache = new LinkedHashMap();
            for (File file : sources) {
                Object object;
                File parent;
                File found;
                if (file.getParentFile() == null || (found = (File)dirToRootCache.get(parent.getPath())) != null) continue;
                File file2 = this.findRoot(file);
                if (file2 == null && (file2 = file.getParentFile()) == null) {
                    file2 = file.getAbsoluteFile().getParentFile();
                }
                if ((object = file2) == null) continue;
                File root = object;
                object = dirToRootCache;
                String string = parent.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parent.path");
                object.put(string, root);
                if (sourceRoots.contains(root)) continue;
                sourceRoots.add(root);
            }
        }
        return sourceRoots;
    }

    private final File getFile(Element element, File dir, String attribute, boolean required) {
        String path = null;
        if (attribute != null) {
            String string = element.getAttribute(attribute);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.getAttribute(attribute)");
            path = string;
            if (((CharSequence)path).length() == 0 && required) {
                this.reportError("Must specify " + attribute + "= attribute", element);
            }
        } else {
            String string = element.getAttribute("file");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.getAttribute(ATTR_FILE)");
            path = string;
            if (((CharSequence)path).length() == 0) {
                string = element.getAttribute("dir");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.getAttribute(ATTR_DIR)");
                path = string;
                if (((CharSequence)path).length() == 0) {
                    string = element.getAttribute("jar");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.getAttribute(ATTR_JAR)");
                    path = string;
                }
            }
        }
        if (((CharSequence)path).length() == 0) {
            if (required) {
                ProjectInitializer.reportError$default(this, "Must specify file/dir/jar on <" + element.getTagName() + '>', null, 2, null);
            }
            return new File("");
        }
        return this.getFile(path, element, dir);
    }

    static /* synthetic */ File getFile$default(ProjectInitializer projectInitializer, Element element, File file, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return projectInitializer.getFile(element, file, string, bl);
    }

    private final File getFile(String path, Element element, File dir) {
        File source = new File(path);
        if (!source.isAbsolute()) {
            if (!source.exists()) {
                source = new File(dir, path);
                if (!source.exists()) {
                    source = new File(this.root, path);
                }
            } else {
                File file = source.getAbsoluteFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"source.absoluteFile");
                return file;
            }
        }
        if (!source.exists()) {
            String string;
            if (SdkConstants.currentPlatform() == 2) {
                String string2 = dir.getCanonicalPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dir.canonicalPath");
                String string3 = string2;
                string2 = File.separator;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"separator");
                string = StringsKt.replace$default((String)string3, (String)string2, (String)"\\\\", (boolean)false, (int)4, null);
            } else {
                string = dir.getCanonicalPath();
            }
            String relativePath = string;
            this.reportError(path + ' ' + (!new File(path).isAbsolute() ? "(relative to " + relativePath + ") " : "") + "does not exist", element);
        }
        return source;
    }

    private final File findRoot(File file) {
        String path = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
        if (StringsKt.endsWith$default((String)path, (String)".java", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path, (String)".kt", (boolean)false, (int)2, null)) {
            String string = this.findPackage(file);
            if (string == null) {
                return null;
            }
            String pkg = string;
            File file2 = file.getParentFile();
            if (file2 == null) {
                return null;
            }
            File parent = file2;
            int packageStart = Math.max(0, parent.getPath().length() - pkg.length());
            if (!this.pathMatchesPackage(pkg, path, packageStart)) {
                String string2;
                String string3 = this.root.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"root.path");
                if (StringsKt.startsWith$default((String)path, (String)string3, (boolean)false, (int)2, null)) {
                    String string4 = path;
                    int n = this.root.getPath().length();
                    String string5 = string4.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                    String s = string5;
                    int end = Math.max(0, s.length() - pkg.length());
                    String string6 = s;
                    if (string6 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string7 = string6.substring(end);
                    string2 = string7;
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                } else {
                    String string8 = path.substring(packageStart);
                    string2 = string8;
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.String).substring(startIndex)");
                }
                String actual = string2;
                String expected = File.separator + StringsKt.replace$default((String)pkg, (char)'.', (char)File.separatorChar, (boolean)false, (int)4, null) + File.separator + file.getName();
                this.client.log(Severity.INFORMATIONAL, null, "The source file " + file.getName() + " does not appear to be in the right project location; its package implies ..." + expected + " but it was found in ..." + actual, new Object[0]);
                return null;
            }
            String string9 = path;
            int n = 0;
            String string10 = string9.substring(n, packageStart);
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            return new File(string10);
        }
        return null;
    }

    private final boolean pathMatchesPackage(String pkg, String path, int packageStart) {
        int i = 0;
        int j = packageStart;
        while (i < pkg.length()) {
            if (pkg.charAt(i) != path.charAt(j) && pkg.charAt(i) != '.') {
                return false;
            }
            int n = i;
            i = n + 1;
            n = j;
            j = n + 1;
        }
        return true;
    }

    private final String findPackage(File file) {
        return ProjectInitializerKt.findPackage(FilesKt.readText$default((File)file, null, (int)1, null), file);
    }
}

