/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.checks.ViewBindingTypeDetector;
import com.android.tools.lint.checks.ViewTypeDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.SdkUtils;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.intellij.psi.PsiClass;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmlpull.v1.XmlPullParser;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 *2\u00020\u00012\u00020\u0002:\u0001*B\u0005\u00a2\u0006\u0002\u0010\u0003J$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J(\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\bH\u0002J(\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\b0 H\u0016J \u0010!\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010 2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020#H\u0002J&\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u0006H\u0002J\u0018\u0010%\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u001cH\u0016J\u0014\u0010'\u001a\n (*\u0004\u0018\u00010\b0\b*\u00020\u000bH\u0002J\f\u0010)\u001a\u00020\b*\u00020\u001eH\u0002J\f\u0010)\u001a\u00020\b*\u00020\u0011H\u0002R(\u0010\u0004\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\u00020\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006+"}, d2={"Lcom/android/tools/lint/checks/ViewBindingTypeDetector;", "Lcom/android/tools/lint/detector/api/LayoutDetector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "()V", "layoutToBindingIdPairs", "", "Lcom/android/ide/common/util/PathString;", "Lcom/google/common/collect/Multimap;", "", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "Lcom/android/tools/lint/detector/api/Context;", "getEvaluator", "(Lcom/android/tools/lint/detector/api/Context;)Lcom/android/tools/lint/client/api/JavaEvaluator;", "addViewBindingTypesForId", "", "parser", "Lorg/xmlpull/v1/XmlPullParser;", "map", "attachLocations", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "location", "Lcom/android/tools/lint/detector/api/Location;", "id", "layout", "checkConsistentAcrossLayouts", "idAttribute", "Lorg/w3c/dom/Attr;", "element", "Lorg/w3c/dom/Element;", "getApplicableAttributes", "", "getViewBindingTypesForId", "item", "Lcom/android/ide/common/resources/ResourceItem;", "file", "visitAttribute", "attribute", "toLayoutName", "kotlin.jvm.PlatformType", "toTagOrClass", "Companion", "lint-checks"})
public final class ViewBindingTypeDetector
extends LayoutDetector
implements XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Map<PathString, Multimap<String, String>> layoutToBindingIdPairs;
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(ViewBindingTypeDetector.class, Scope.RESOURCE_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @NotNull
    public Collection<String> getApplicableAttributes() {
        return CollectionsKt.listOf((Object)"viewBindingType");
    }

    public void visitAttribute(@NotNull XmlContext context, @NotNull Attr attribute) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        if (!Intrinsics.areEqual((Object)attribute.getNamespaceURI(), (Object)"http://schemas.android.com/tools")) {
            return;
        }
        boolean isDataBindingLayout = Intrinsics.areEqual((Object)context.document.getDocumentElement().getTagName(), (Object)"layout");
        if (isDataBindingLayout) {
            context.report(new Incident(ISSUE, "`tools:viewBindingType` is not applicable in data binding layouts.", context.getLocation((Node)attribute)));
        } else {
            Element element = attribute.getOwnerElement();
            String tagName = element.getTagName();
            if (Intrinsics.areEqual((Object)tagName, (Object)"include")) {
                context.report(new Incident(ISSUE, "`tools:viewBindingType` is not applicable on `<" + tagName + ">` tags.", context.getLocation((Node)attribute)));
            } else {
                String typeTag = attribute.getValue();
                JavaEvaluator evaluator = this.getEvaluator((Context)context);
                Intrinsics.checkNotNullExpressionValue((Object)typeTag, (String)"typeTag");
                PsiClass psiClass = ViewTypeDetector.Companion.findViewForTag(typeTag, evaluator);
                if (psiClass == null || !JavaEvaluator.extendsClass$default((JavaEvaluator)evaluator, (PsiClass)psiClass, (String)"android.view.View", (boolean)false, (int)4, null)) {
                    context.report(new Incident(ISSUE, "`tools:viewBindingType` (`" + typeTag + "`) must refer to a class that inherits from `android.view.View`", context.getLocation((Node)attribute)));
                } else {
                    Attr idAttribute = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "id");
                    if (idAttribute == null) {
                        context.report(new Incident(ISSUE, "`tools:viewBindingType` should be defined on a tag that also defines an `android:id`. Otherwise, its value won't have any effect.", context.getLocation((Node)attribute)));
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"element");
                        String tagView = this.toTagOrClass(element);
                        PsiClass psiClass2 = ViewTypeDetector.Companion.findViewForTag(typeTag, evaluator);
                        String typeClass = psiClass2 == null ? null : psiClass2.getQualifiedName();
                        PsiClass tagClass = ViewTypeDetector.Companion.findViewForTag(tagView, evaluator);
                        if (typeClass != null && tagClass != null && !JavaEvaluator.extendsClass$default((JavaEvaluator)evaluator, (PsiClass)tagClass, (String)typeClass, (boolean)false, (int)4, null)) {
                            context.report(new Incident(ISSUE, "`tools:viewBindingType` (`" + typeTag + "`) is not compatible (i.e. a match or superclass) with its tag (`" + tagView + "`).", context.getLocation((Node)attribute)));
                        } else {
                            this.checkConsistentAcrossLayouts(context, idAttribute, evaluator, element);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkConsistentAcrossLayouts(XmlContext context, Attr idAttribute, JavaEvaluator evaluator, Element element) {
        boolean full = context.isGlobalAnalysis();
        LintClient client = context.getClient();
        Project project = full ? context.getMainProject() : context.getProject();
        ResourceRepository resources = client.getResources(project, ResourceRepositoryScope.LOCAL_DEPENDENCIES);
        ResourceUrl resourceUrl = ResourceUrl.parse((String)idAttribute.getValue());
        if (resourceUrl != null && resourceUrl.type == ResourceType.ID && !resourceUrl.isFramework()) {
            String id = resourceUrl.name;
            List items = resources.getResources(ResourceNamespace.TODO(), ResourceType.ID, id);
            if (items.size() > 1) {
                Object object;
                String layout = this.toLayoutName((Context)context);
                boolean bl = false;
                Set bindingTypes = new LinkedHashSet();
                for (Object item : items) {
                    String fileName;
                    Object object2 = item.getSource();
                    object = object2 == null ? null : object2.getFileName();
                    if (object == null || !Intrinsics.areEqual((Object)SdkUtils.fileNameToResourceName((String)(fileName = object)), (Object)layout)) continue;
                    Context context2 = (Context)context;
                    Intrinsics.checkNotNullExpressionValue((Object)item, (String)"item");
                    object = this.getViewBindingTypesForId(context2, (ResourceItem)item);
                    if (object == null) continue;
                    object2 = object;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    Object it = object2;
                    boolean bl4 = false;
                    bindingTypes.addAll(it);
                }
                if (bindingTypes.size() > 1) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Object item;
                    item = bindingTypes;
                    boolean $i$f$map = false;
                    object = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        String string;
                        void it;
                        String bl4 = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl5 = false;
                        PsiClass psiClass = ViewTypeDetector.Companion.findViewForTag((String)it, evaluator);
                        void var27_31 = psiClass == null ? it : ((string = psiClass.getQualifiedName()) == null ? it : string);
                        collection.add(var27_31);
                    }
                    SortedSet views = CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv));
                    Location location = context.getLocation((Node)element);
                    Intrinsics.checkNotNullExpressionValue((Object)id, (String)"id");
                    Intrinsics.checkNotNullExpressionValue((Object)layout, (String)"layout");
                    this.attachLocations(context, location, id, layout);
                    context.report(new Incident(ISSUE, Intrinsics.stringPlus((String)"`tools:viewBindingType` is not defined consistently, with the following types resolved across layouts: ", (Object)CollectionsKt.joinToString$default((Iterable)views, null, null, null, (int)0, null, (Function1)checkConsistentAcrossLayouts.2.INSTANCE, (int)31, null)), location));
                }
            }
        }
    }

    private final void attachLocations(XmlContext context, Location location, String id, String layout) {
        boolean bl;
        if (Scope.Companion.checkSingleFile(context.getDriver().getScope())) {
            return;
        }
        boolean bl2 = false;
        List locations = new ArrayList();
        Map<PathString, Multimap<String, String>> map = this.layoutToBindingIdPairs;
        if (map != null) {
            Map<PathString, Multimap<String, String>> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Map<PathString, Multimap<String, String>> map2 = $this$forEach$iv;
            bl = false;
            Iterator<Map.Entry<PathString, Multimap<String, String>>> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                File file;
                Map.Entry<PathString, Multimap<String, String>> element$iv;
                Map.Entry<PathString, Multimap<String, String>> $dstr$path$u = element$iv = iterator.next();
                boolean bl3 = false;
                Map.Entry<PathString, Multimap<String, String>> entry = $dstr$path$u;
                boolean bl4 = false;
                PathString path = entry.getKey();
                Map.Entry<PathString, Multimap<String, String>> entry2 = $dstr$path$u;
                boolean bl5 = false;
                Multimap<String, String> u = entry2.getValue();
                if (!Intrinsics.areEqual((Object)SdkUtils.fileNameToResourceName((String)path.getFileName()), (Object)layout)) continue;
                bl5 = false;
                Set types = new LinkedHashSet();
                for (Map.Entry entry3 : u.entries()) {
                    Intrinsics.checkNotNullExpressionValue((Object)entry3, (String)"u.entries()");
                    Map.Entry entry4 = entry3;
                    boolean bl6 = false;
                    String k = (String)entry4.getKey();
                    Map.Entry entry5 = entry3;
                    boolean bl7 = false;
                    String v = (String)entry5.getValue();
                    if (!Intrinsics.areEqual((Object)id, (Object)k)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)v, (String)"v");
                    types.add(v);
                }
                Collection collection = types;
                boolean bl8 = false;
                if (!(!collection.isEmpty()) || (file = path.toFile()) == null || Intrinsics.areEqual((Object)file, (Object)context.file)) continue;
                Location l = Location.Companion.create(file);
                String list = Lint.formatList$default((List)CollectionsKt.sorted((Iterable)types), (int)0, (int)2, null);
                l.setMessage("Using `viewBindingType` " + list + " here", false);
                locations.add(l);
            }
        }
        Location prev = location;
        Iterable $this$sortedBy$iv = locations;
        boolean $i$f$sortedBy = false;
        bl = false;
        for (Location l : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Location it = (Location)a;
                boolean bl2 = false;
                Comparable comparable = it.getFile();
                it = (Location)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                File file = it.getFile();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)file);
            }
        })) {
            prev.setSecondary(l);
            prev = l;
        }
    }

    private final String toLayoutName(Context $this$toLayoutName) {
        return SdkUtils.fileNameToResourceName((String)$this$toLayoutName.file.getName());
    }

    private final String toTagOrClass(Element $this$toTagOrClass) {
        String string;
        if (Intrinsics.areEqual((Object)$this$toTagOrClass.getTagName(), (Object)"view")) {
            String string2;
            String string3 = $this$toTagOrClass.getAttribute("class");
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            CharSequence charSequence = it;
            boolean bl4 = false;
            String string4 = string2 = charSequence.length() > 0 ? string3 : null;
            string = string2 == null ? "android.view.View" : string2;
        } else {
            String string5 = $this$toTagOrClass.getTagName();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"{\n            tagName\n        }");
            string = string5;
        }
        return string;
    }

    private final String toTagOrClass(XmlPullParser $this$toTagOrClass) {
        String string;
        String tag = $this$toTagOrClass.getName();
        if (Intrinsics.areEqual((Object)tag, (Object)"view")) {
            String string2 = $this$toTagOrClass.getAttributeValue(null, "class");
            string = string2 == null ? "android.view.View" : string2;
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)tag, (String)"tag");
            string = tag;
        }
        return string;
    }

    private final JavaEvaluator getEvaluator(Context $this$evaluator) {
        return $this$evaluator.getClient().getUastParser($this$evaluator.getProject()).getEvaluator();
    }

    private final Collection<String> getViewBindingTypesForId(Context context, ResourceItem item) {
        PathString pathString = item.getSource();
        if (pathString == null) {
            return null;
        }
        PathString source = pathString;
        Multimap<String, String> multimap = this.getViewBindingTypesForId(context, source);
        if (multimap == null) {
            return null;
        }
        Multimap<String, String> map = multimap;
        return map.get((Object)item.getName());
    }

    private final Multimap<String, String> getViewBindingTypesForId(Context context, PathString file) {
        Map<PathString, Multimap<String, String>> map;
        boolean bl;
        Map<PathString, Multimap<String, String>> map2;
        if (!StringsKt.endsWith$default((String)file.getFileName(), (String)".xml", (boolean)false, (int)2, null)) {
            return null;
        }
        Map<PathString, Multimap<String, String>> map3 = this.layoutToBindingIdPairs;
        if (map3 == null) {
            boolean bl2 = false;
            map2 = new LinkedHashMap();
            bl = false;
            boolean bl3 = false;
            Map<PathString, Multimap<String, String>> it = map2;
            boolean bl4 = false;
            this.layoutToBindingIdPairs = it;
            map = map2;
        } else {
            map = map3;
        }
        Map<PathString, Multimap<String, String>> cache = map;
        Multimap map4 = cache.get(file);
        if (map4 == null) {
            map4 = (Multimap)ArrayListMultimap.create();
            map2 = cache;
            bl = false;
            map2.put(file, (Multimap<String, String>)map4);
            try {
                XmlPullParser parser = context.getClient().createXmlPullParser(file);
                if (parser != null) {
                    this.addViewBindingTypesForId(parser, (Multimap<String, String>)map4);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return map4;
    }

    private final void addViewBindingTypesForId(XmlPullParser parser, Multimap<String, String> map) {
        block4: while (true) {
            int event = parser.next();
            switch (event) {
                case 2: {
                    String string = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "id");
                    if (string == null) continue block4;
                    String id = string;
                    CharSequence charSequence = parser.getAttributeValue("http://schemas.android.com/tools", "viewBindingType");
                    String binding = charSequence == null ? this.toTagOrClass(parser) : charSequence;
                    charSequence = id;
                    boolean bl = false;
                    if (!(charSequence.length() > 0)) continue block4;
                    charSequence = binding;
                    bl = false;
                    if (!(charSequence.length() > 0) || map.containsEntry((Object)(id = Lint.stripIdPrefix((String)id)), (Object)binding)) continue block4;
                    map.put((Object)id, (Object)binding);
                    continue block4;
                }
                case 1: {
                    return;
                }
            }
        }
    }

    static {
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"ViewBindingType", (String)"`tools:viewBindingType` issues", (String)"All issues related to using the View Binding `tools:viewBindingType` attribute.", (Implementation)implementation, null, (Category)category, (int)1, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/checks/ViewBindingTypeDetector$Companion;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

