/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.SdkConstants;
import com.android.tools.lint.checks.AbstractAnnotationDetector;
import com.android.tools.lint.checks.AnnotationDetector;
import com.android.tools.lint.checks.FloatRangeConstraint;
import com.android.tools.lint.checks.IntRangeConstraint;
import com.android.tools.lint.checks.RangeConstraint;
import com.android.tools.lint.checks.RangeDetector;
import com.android.tools.lint.checks.SizeConstraint;
import com.android.tools.lint.detector.api.AnnotationInfo;
import com.android.tools.lint.detector.api.AnnotationUsageInfo;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u00012\u00020\u0002:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/lint/checks/RangeDetector;", "Lcom/android/tools/lint/checks/AbstractAnnotationDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableAnnotations", "", "", "checkFloatRange", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "argument", "Lorg/jetbrains/uast/UElement;", "checkIntRange", "usageInfo", "Lcom/android/tools/lint/detector/api/AnnotationUsageInfo;", "checkSize", "visitAnnotationUsage", "element", "annotationInfo", "Lcom/android/tools/lint/detector/api/AnnotationInfo;", "Companion", "lint-checks"})
public final class RangeDetector
extends AbstractAnnotationDetector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(RangeDetector.class, Scope.JAVA_FILE_SCOPE);
    @NotNull
    private static final String AOSP_INT_RANGE_ANNOTATION = "android.annotation.IntRange";
    @JvmField
    @NotNull
    public static final Issue RANGE = Issue.Companion.create("Range", "Outside Range", "\n                Some parameters are required to in a particular numerical range; this check \\\n                makes sure that arguments passed fall within the range. For arrays, Strings \\\n                and collections this refers to the size or length.", Category.CORRECTNESS, 6, Severity.ERROR, IMPLEMENTATION);

    @NotNull
    public List<String> applicableAnnotations() {
        Object[] objectArray = new String[]{AnnotationDetector.INT_RANGE_ANNOTATION.oldName(), AnnotationDetector.INT_RANGE_ANNOTATION.newName(), AnnotationDetector.FLOAT_RANGE_ANNOTATION.oldName(), AnnotationDetector.FLOAT_RANGE_ANNOTATION.newName(), AnnotationDetector.SIZE_ANNOTATION.oldName(), AnnotationDetector.SIZE_ANNOTATION.newName(), SdkConstants.INT_DEF_ANNOTATION.oldName(), SdkConstants.INT_DEF_ANNOTATION.newName(), SdkConstants.LONG_DEF_ANNOTATION.oldName(), SdkConstants.LONG_DEF_ANNOTATION.newName()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement element, @NotNull AnnotationInfo annotationInfo, @NotNull AnnotationUsageInfo usageInfo) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)annotationInfo, (String)"annotationInfo");
        Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
        UAnnotation annotation = annotationInfo.getAnnotation();
        String string = annotationInfo.getQualifiedName();
        if (Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.INT_RANGE_ANNOTATION.oldName()) ? true : Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.INT_RANGE_ANNOTATION.newName())) {
            this.checkIntRange(context, annotation, element, usageInfo);
        } else if (Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.FLOAT_RANGE_ANNOTATION.oldName()) ? true : Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.FLOAT_RANGE_ANNOTATION.newName())) {
            this.checkFloatRange(context, annotation, element);
        } else if (Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.SIZE_ANNOTATION.oldName()) ? true : Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.SIZE_ANNOTATION.newName())) {
            this.checkSize(context, annotation, element);
        } else if (((Intrinsics.areEqual((Object)string, (Object)SdkConstants.INT_DEF_ANNOTATION.oldName()) ? true : Intrinsics.areEqual((Object)string, (Object)SdkConstants.INT_DEF_ANNOTATION.newName())) ? true : Intrinsics.areEqual((Object)string, (Object)SdkConstants.LONG_DEF_ANNOTATION.oldName())) ? true : Intrinsics.areEqual((Object)string, (Object)SdkConstants.LONG_DEF_ANNOTATION.newName())) {
            // empty if block
        }
    }

    private final void checkIntRange(JavaContext context, UAnnotation annotation, UElement argument, AnnotationUsageInfo usageInfo) {
        if (argument instanceof UIfExpression) {
            boolean bl;
            boolean bl2;
            UExpression uExpression;
            UExpression uExpression2 = ((UIfExpression)argument).getThenExpression();
            if (uExpression2 != null) {
                uExpression = uExpression2;
                bl2 = false;
                bl = false;
                UExpression thenExpression = uExpression;
                boolean bl3 = false;
                this.checkIntRange(context, annotation, (UElement)thenExpression, usageInfo);
            }
            uExpression2 = ((UIfExpression)argument).getElseExpression();
            if (uExpression2 != null) {
                uExpression = uExpression2;
                bl2 = false;
                bl = false;
                UExpression elseExpression = uExpression;
                boolean bl4 = false;
                this.checkIntRange(context, annotation, (UElement)elseExpression, usageInfo);
            }
            return;
        }
        if (argument instanceof UParenthesizedExpression) {
            this.checkIntRange(context, annotation, (UElement)((UParenthesizedExpression)argument).getExpression(), usageInfo);
            return;
        }
        String message2 = Companion.getIntRangeError(context, annotation, argument);
        if (message2 != null) {
            if (usageInfo.anySameScope((Function1)checkIntRange.3.INSTANCE)) {
                return;
            }
            this.report(context, RANGE, argument, context.getLocation(argument), message2);
        }
    }

    private final void checkFloatRange(JavaContext context, UAnnotation annotation, UElement argument) {
        if (argument instanceof UIfExpression) {
            boolean bl;
            UExpression uExpression;
            UExpression uExpression2 = ((UIfExpression)argument).getThenExpression();
            if (uExpression2 != null) {
                uExpression = uExpression2;
                boolean bl2 = false;
                bl = false;
                UExpression thenExpression = uExpression;
                boolean bl3 = false;
                this.checkFloatRange(context, annotation, (UElement)thenExpression);
            }
            uExpression2 = ((UIfExpression)argument).getElseExpression();
            if (uExpression2 != null) {
                uExpression = uExpression2;
                boolean bl2 = false;
                bl = false;
                UExpression elseExpression = uExpression;
                boolean bl4 = false;
                this.checkFloatRange(context, annotation, (UElement)elseExpression);
            }
            return;
        }
        if (argument instanceof UParenthesizedExpression) {
            this.checkFloatRange(context, annotation, (UElement)((UParenthesizedExpression)argument).getExpression());
            return;
        }
        if (UastExpressionUtils.isNewArrayWithDimensions((UElement)argument)) {
            return;
        }
        FloatRangeConstraint floatRangeConstraint = FloatRangeConstraint.create(annotation);
        Intrinsics.checkNotNullExpressionValue((Object)floatRangeConstraint, (String)"create(annotation)");
        FloatRangeConstraint constraint2 = floatRangeConstraint;
        Object constant = ConstantEvaluator.evaluate((JavaContext)context, (UElement)argument);
        if (!(constant instanceof Number)) {
            Boolean contains;
            RangeConstraint here;
            RangeConstraint rangeConstraint;
            if (constant instanceof float[] || constant instanceof double[] || constant instanceof int[] || constant instanceof long[]) {
                if (constant instanceof float[]) {
                    for (float value : (float[])constant) {
                        if (constraint2.isValid(value)) continue;
                        String string = constraint2.describe(value);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"constraint.describe(value.toDouble())");
                        String message2 = string;
                        this.report(context, RANGE, argument, context.getLocation(argument), message2);
                        return;
                    }
                }
                if (constant instanceof double[]) {
                    for (double value : (double[])constant) {
                        if (constraint2.isValid(value)) continue;
                        String string = constraint2.describe(value);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"constraint.describe(value)");
                        String message3 = string;
                        this.report(context, RANGE, argument, context.getLocation(argument), message3);
                        return;
                    }
                }
                if (constant instanceof int[]) {
                    for (int value : (int[])constant) {
                        if (constraint2.isValid(value)) continue;
                        String message3 = constraint2.describe(value);
                        Intrinsics.checkNotNullExpressionValue((Object)message3, (String)"constraint.describe(value.toDouble())");
                        String message4 = message3;
                        this.report(context, RANGE, argument, context.getLocation(argument), message4);
                        return;
                    }
                }
                if (constant instanceof long[]) {
                    for (long value : (long[])constant) {
                        if (constraint2.isValid(value)) continue;
                        String string = constraint2.describe(value);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"constraint.describe(value.toDouble())");
                        String message5 = string;
                        this.report(context, RANGE, argument, context.getLocation(argument), message5);
                        return;
                    }
                }
            }
            if (argument instanceof UResolvable && (rangeConstraint = RangeDetector.Companion.getRangeConstraint(context, (UResolvable)argument)) != null && (here = RangeConstraint.create(annotation)) != null && (contains = here.contains(rangeConstraint)) != null && !contains.booleanValue()) {
                String message6 = here.toString();
                this.report(context, RANGE, argument, context.getLocation(argument), message6);
            }
            return;
        }
        double d = ((Number)constant).doubleValue();
        if (!constraint2.isValid(d)) {
            String string = constraint2.describe(argument instanceof UExpression ? (UExpression)argument : null, d);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"constraint.describe(\n                argument as? UExpression, value\n            )");
            String message7 = string;
            this.report(context, RANGE, argument, context.getLocation(argument), message7);
        }
    }

    private final void checkSize(JavaContext context, UAnnotation annotation, UElement argument) {
        long actual = 0L;
        boolean isString = false;
        if (UastExpressionUtils.isNewArrayWithInitializer((UElement)argument)) {
            actual = ((UCallExpression)argument).getValueArgumentCount();
        } else {
            if (argument instanceof UIfExpression) {
                boolean bl;
                boolean bl2;
                UExpression uExpression;
                UExpression uExpression2 = ((UIfExpression)argument).getThenExpression();
                if (uExpression2 != null) {
                    uExpression = uExpression2;
                    bl2 = false;
                    bl = false;
                    UExpression thenExpression = uExpression;
                    boolean bl3 = false;
                    this.checkSize(context, annotation, (UElement)thenExpression);
                }
                uExpression2 = ((UIfExpression)argument).getElseExpression();
                if (uExpression2 != null) {
                    uExpression = uExpression2;
                    bl2 = false;
                    bl = false;
                    UExpression elseExpression = uExpression;
                    boolean bl4 = false;
                    this.checkSize(context, annotation, (UElement)elseExpression);
                }
                return;
            }
            if (argument instanceof UParenthesizedExpression) {
                this.checkSize(context, annotation, (UElement)((UParenthesizedExpression)argument).getExpression());
                return;
            }
            Object object = ConstantEvaluator.evaluate((JavaContext)context, (UElement)argument);
            if (object instanceof String) {
                actual = ((String)object).length();
                isString = true;
            } else {
                actual = ConstantEvaluator.getArraySize((Object)object);
                if (actual == -1L) {
                    Boolean contains;
                    RangeConstraint here;
                    RangeConstraint constraint2;
                    if (argument instanceof UResolvable && (constraint2 = RangeDetector.Companion.getRangeConstraint(context, (UResolvable)argument)) != null && (here = RangeConstraint.create(annotation)) != null && (contains = here.contains(constraint2)) != null && !contains.booleanValue()) {
                        String message2 = here.toString();
                        this.report(context, RANGE, argument, context.getLocation(argument), message2);
                    }
                    return;
                }
            }
        }
        SizeConstraint constraint2 = SizeConstraint.create(annotation);
        Intrinsics.checkNotNullExpressionValue((Object)constraint2, (String)"create(annotation)");
        SizeConstraint constraint3 = constraint2;
        if (!constraint3.isValid(actual)) {
            String unit = isString ? "length" : "size";
            String string = constraint3.describe(argument instanceof UExpression ? (UExpression)argument : null, unit, actual);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"constraint.describe(\n                argument as? UExpression,\n                unit, actual\n            )");
            String message3 = string;
            this.report(context, RANGE, argument, context.getLocation(argument), message3);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/checks/RangeDetector$Companion;", "", "()V", "AOSP_INT_RANGE_ANNOTATION", "", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "RANGE", "Lcom/android/tools/lint/detector/api/Issue;", "getIntRangeError", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "argument", "Lorg/jetbrains/uast/UElement;", "getRangeConstraint", "Lcom/android/tools/lint/checks/RangeConstraint;", "resolvable", "Lorg/jetbrains/uast/UResolvable;", "isIntRange", "", "qualifiedName", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isIntRange(@Nullable String qualifiedName) {
            return AnnotationDetector.INT_RANGE_ANNOTATION.isEquals(qualifiedName) || Intrinsics.areEqual((Object)RangeDetector.AOSP_INT_RANGE_ANNOTATION, (Object)qualifiedName);
        }

        @Nullable
        public final String getIntRangeError(@NotNull JavaContext context, @NotNull UAnnotation annotation, @NotNull UElement argument) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
            if (UastExpressionUtils.isNewArrayWithInitializer((UElement)argument)) {
                UCallExpression newExpression = (UCallExpression)argument;
                for (UExpression uExpression : newExpression.getValueArguments()) {
                    UExpression expression;
                    String error;
                    UExpression uExpression2 = UastUtils.skipParenthesizedExprDown((UExpression)uExpression);
                    if (uExpression2 == null || (error = this.getIntRangeError(context, annotation, (UElement)(expression = uExpression2))) == null) continue;
                    return error;
                }
            } else if (UastExpressionUtils.isNewArrayWithDimensions((UElement)argument)) {
                return null;
            }
            IntRangeConstraint intRangeConstraint = IntRangeConstraint.create(annotation);
            Intrinsics.checkNotNullExpressionValue((Object)intRangeConstraint, (String)"create(annotation)");
            Object constraint2 = intRangeConstraint;
            Object o = ConstantEvaluator.evaluate((JavaContext)context, (UElement)argument);
            if (!(o instanceof Number)) {
                Boolean contains;
                RangeConstraint here;
                RangeConstraint rangeConstraint;
                if (o instanceof int[] || o instanceof long[]) {
                    if (o instanceof int[]) {
                        for (int value : (int[])o) {
                            if (((IntRangeConstraint)constraint2).isValid(value)) continue;
                            return ((IntRangeConstraint)constraint2).describe(value);
                        }
                    }
                    if (o instanceof long[]) {
                        for (long value : (long[])o) {
                            if (((IntRangeConstraint)constraint2).isValid(value)) continue;
                            return ((IntRangeConstraint)constraint2).describe(value);
                        }
                    }
                }
                if (argument instanceof UResolvable && (rangeConstraint = this.getRangeConstraint(context, (UResolvable)argument)) != null && (here = RangeConstraint.create(annotation)) != null && (contains = here.contains(rangeConstraint)) != null && !contains.booleanValue()) {
                    return here.toString();
                }
                return null;
            }
            long l = ((Number)o).longValue();
            return !((IntRangeConstraint)constraint2).isValid(l) ? ((IntRangeConstraint)constraint2).describe(l) : null;
        }

        private final RangeConstraint getRangeConstraint(JavaContext context, UResolvable resolvable) {
            RangeConstraint rangeConstraint;
            PsiElement psiElement;
            UResolvable uResolvable = resolvable;
            PsiElement psiElement2 = psiElement = uResolvable == null ? null : uResolvable.resolve();
            if (psiElement == null) {
                return null;
            }
            PsiElement resolved = psiElement;
            if (resolved instanceof PsiModifierListOwner) {
                RangeConstraint rangeConstraint2;
                UElement uElement = UastContextKt.toUElement((PsiElement)resolved);
                UAnnotated uAnnotated = uResolvable = uElement instanceof UAnnotated ? (UAnnotated)uElement : null;
                if (uResolvable == null) {
                    rangeConstraint2 = null;
                } else {
                    uElement = uResolvable;
                    boolean bl = false;
                    boolean bl2 = false;
                    UElement it = uElement;
                    boolean bl3 = false;
                    rangeConstraint2 = RangeConstraint.create((UAnnotated)it, context.getEvaluator());
                }
                psiElement = rangeConstraint2;
                rangeConstraint = psiElement == null ? RangeConstraint.create((PsiModifierListOwner)resolved, context.getEvaluator()) : psiElement;
            } else {
                rangeConstraint = null;
            }
            return rangeConstraint;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

