/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.SdkConstants;
import com.android.tools.lint.client.api.AndroidPlatformAnnotations;
import com.android.tools.lint.client.api.AnnotationLookup;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.AnnotationInfo;
import com.android.tools.lint.detector.api.AnnotationOrigin;
import com.android.tools.lint.detector.api.AnnotationUsageInfo;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UImplicitCallExpressionKt;
import com.google.common.collect.Multimap;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.classes.KtUltraLightClass;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UArrayAccessExpression;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UEnumConstant;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UObjectLiteralExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.UastLanguagePlugin;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.java.JavaUAnnotation;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u00f8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J8\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J8\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u001a2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J \u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020!H\u0002J.\u0010\"\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010$\u001a\u00020%H\u0002J,\u0010&\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010'\u001a\u0004\u0018\u00010(H\u0002J5\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u00182\u0006\u0010+\u001a\u00020,2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020.0-2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0012H\u0002\u00a2\u0006\u0002\u0010/J$\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u00182\u0006\u0010+\u001a\u00020,2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020*0\u0018H\u0002J&\u00100\u001a\b\u0012\u0004\u0012\u00020\u0019012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u00102\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%H\u0002J&\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010+\u001a\u00020,2\u0006\u00103\u001a\u00020%2\u0006\u00104\u001a\u000205H\u0002J&\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020*0\u00182\u0006\u0010+\u001a\u00020,2\u0006\u00103\u001a\u00020%2\u0006\u00106\u001a\u00020\u0012H\u0002J&\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010+\u001a\u00020,2\u0006\u0010$\u001a\u00020\u001a2\u0006\u00104\u001a\u000205H\u0002J\u0016\u00107\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u00108\u001a\u00020*J\u0016\u00109\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010:\u001a\u00020;J\u0016\u0010<\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010=\u001a\u00020>J\u0016\u0010?\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020!J\u0016\u0010@\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010A\u001a\u00020BJ\u0016\u0010C\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010=\u001a\u00020DJ\u0016\u0010E\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010=\u001a\u00020FJ \u0010G\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010=\u001a\u00020\u00122\u0006\u0010H\u001a\u00020(H\u0002J\u0016\u0010I\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010J\u001a\u00020KJ\u0016\u0010L\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020MJ\u0016\u0010N\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010=\u001a\u00020OJ\u0016\u0010P\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010=\u001a\u00020QJ\u0016\u0010R\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010=\u001a\u00020SJ\u0016\u0010T\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010U\u001a\u00020VJ4\u0010W\u001a\u00020X*\b\u0012\u0004\u0012\u00020\u0019012\u0006\u00108\u001a\u00020*2\u0006\u00103\u001a\u00020\u00162\u0006\u0010Y\u001a\u0002052\b\b\u0002\u0010Z\u001a\u00020XH\u0002J<\u0010[\u001a\u00020\\*\b\u0012\u0004\u0012\u00020\u0019012\u0006\u0010+\u001a\u00020,2\u0006\u00103\u001a\u00020%2\u0006\u00106\u001a\u00020\u00122\u0006\u0010Y\u001a\u0002052\b\b\u0002\u0010Z\u001a\u00020XH\u0002J:\u0010[\u001a\u00020\\*\b\u0012\u0004\u0012\u00020\u0019012\u0006\u00103\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020*0\u00182\u0006\u0010Y\u001a\u0002052\b\b\u0002\u0010Z\u001a\u00020XH\u0002J\u001e\u0010]\u001a\u0004\u0018\u00010\u0019*\u00020*2\u0006\u00103\u001a\u00020\u00162\u0006\u0010Y\u001a\u000205H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006^"}, d2={"Lcom/android/tools/lint/client/api/AnnotationHandler;", "", "scanners", "Lcom/google/common/collect/Multimap;", "", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "(Lcom/google/common/collect/Multimap;)V", "annotationLookup", "Lcom/android/tools/lint/client/api/AnnotationLookup;", "relevantAnnotations", "", "getRelevantAnnotations", "()Ljava/util/Set;", "checkAnnotations", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "argument", "Lorg/jetbrains/uast/UElement;", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "referenced", "Lcom/intellij/psi/PsiElement;", "annotations", "", "Lcom/android/tools/lint/detector/api/AnnotationInfo;", "Lorg/jetbrains/uast/UAnnotated;", "checkCall", "method", "Lcom/intellij/psi/PsiMethod;", "call", "Lorg/jetbrains/uast/UExpression;", "checkCallUnresolved", "Lorg/jetbrains/uast/UCallExpression;", "checkContextAnnotations", "origCall", "annotated", "Lcom/intellij/psi/PsiModifierListOwner;", "doCheckCall", "containingClass", "Lcom/intellij/psi/PsiClass;", "filterRelevantAnnotations", "Lorg/jetbrains/uast/UAnnotation;", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "", "Lcom/intellij/psi/PsiAnnotation;", "(Lcom/android/tools/lint/client/api/JavaEvaluator;[Lcom/intellij/psi/PsiAnnotation;Lorg/jetbrains/uast/UElement;)Ljava/util/List;", "getMemberAnnotations", "", "reference", "owner", "origin", "Lcom/android/tools/lint/detector/api/AnnotationOrigin;", "element", "visitAnnotation", "annotation", "visitArrayAccessExpression", "expression", "Lorg/jetbrains/uast/UArrayAccessExpression;", "visitBinaryExpression", "node", "Lorg/jetbrains/uast/UBinaryExpression;", "visitCallExpression", "visitCallableReferenceExpression", "methodReference", "Lorg/jetbrains/uast/UCallableReferenceExpression;", "visitClass", "Lorg/jetbrains/uast/UClass;", "visitClassLiteralExpression", "Lorg/jetbrains/uast/UClassLiteralExpression;", "visitClassReference", "cls", "visitEnumConstant", "constant", "Lorg/jetbrains/uast/UEnumConstant;", "visitMethod", "Lorg/jetbrains/uast/UMethod;", "visitObjectLiteralExpression", "Lorg/jetbrains/uast/UObjectLiteralExpression;", "visitSimpleNameReferenceExpression", "Lorg/jetbrains/uast/USimpleNameReferenceExpression;", "visitUnaryExpression", "Lorg/jetbrains/uast/UUnaryExpression;", "visitVariable", "variable", "Lorg/jetbrains/uast/UVariable;", "addAnnotation", "", "source", "prepend", "addAnnotations", "", "toAnnotationInfo", "lint-api"})
public final class AnnotationHandler {
    @NotNull
    private final Multimap<String, SourceCodeScanner> scanners;
    @NotNull
    private final Set<String> relevantAnnotations;
    @NotNull
    private final AnnotationLookup annotationLookup;

    public AnnotationHandler(@NotNull Multimap<String, SourceCodeScanner> scanners) {
        Intrinsics.checkNotNullParameter(scanners, (String)"scanners");
        this.scanners = scanners;
        this.relevantAnnotations = new HashSet((Collection)this.scanners.keys());
        this.annotationLookup = new AnnotationLookup();
    }

    @NotNull
    public final Set<String> getRelevantAnnotations() {
        return this.relevantAnnotations;
    }

    private final void checkContextAnnotations(JavaContext context2, UElement origCall, List<AnnotationInfo> annotations, PsiModifierListOwner annotated) {
        UElement call = origCall;
        UElement uElement = UastUtils.skipParenthesizedExprUp((UElement)call.getUastParent());
        if (uElement == null) {
            return;
        }
        UElement p = uElement;
        if (p instanceof UQualifiedReferenceExpression) {
            call = p;
            uElement = UastUtils.skipParenthesizedExprUp((UElement)p.getUastParent());
            if (uElement == null) {
                return;
            }
            p = uElement;
        }
        if (p instanceof UBinaryExpression) {
            UExpression check = null;
            UElement binary = p;
            UExpression leftOperand = UastUtils.skipParenthesizedExprDown((UExpression)((UBinaryExpression)binary).getLeftOperand());
            UExpression rightOperand = UastUtils.skipParenthesizedExprDown((UExpression)((UBinaryExpression)binary).getRightOperand());
            if (call == leftOperand) {
                check = rightOperand;
            } else if (call == rightOperand) {
                check = leftOperand;
            }
            if (check != null) {
                UastBinaryOperator uastBinaryOperator = ((UBinaryExpression)p).getOperator();
                AnnotationUsageType type = Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.ASSIGN) ? AnnotationUsageType.ASSIGNMENT_LHS : ((((Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.EQUALS) ? true : Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.NOT_EQUALS)) ? true : Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.IDENTITY_EQUALS)) ? true : Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.IDENTITY_NOT_EQUALS)) ? AnnotationUsageType.EQUALITY : AnnotationUsageType.BINARY);
                this.checkAnnotations(context2, (UElement)check, type, (PsiElement)annotated, annotations);
            }
        } else if (p instanceof UQualifiedReferenceExpression) {
            UExpression argument;
            List arguments;
            UExpression selector;
            UQualifiedReferenceExpression ref = (UQualifiedReferenceExpression)p;
            UQualifiedReferenceExpression binary = ref;
            if (Intrinsics.areEqual((Object)"equals", (Object)binary.getResolvedName()) && (selector = ref.getSelector()) instanceof UCallExpression && (arguments = ((UCallExpression)selector).getValueArguments()).size() == 1 && (argument = UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)arguments.get(0)))) != null) {
                this.checkAnnotations(context2, (UElement)argument, AnnotationUsageType.EQUALITY, (PsiElement)annotated, annotations);
            }
        } else if (call instanceof UVariable) {
            UElement variable = call;
            PsiElement variablePsi = call.getSourcePsi();
            UMethod arguments = UastUtils.getContainingUMethod((UElement)call);
            if (arguments != null) {
                arguments.accept((UastVisitor)new AbstractUastVisitor(variable, variablePsi, this, context2, annotated, annotations){
                    final /* synthetic */ UElement $variable;
                    final /* synthetic */ PsiElement $variablePsi;
                    final /* synthetic */ AnnotationHandler this$0;
                    final /* synthetic */ JavaContext $context;
                    final /* synthetic */ PsiModifierListOwner $annotated;
                    final /* synthetic */ List<AnnotationInfo> $annotations;
                    {
                        this.$variable = $variable;
                        this.$variablePsi = $variablePsi;
                        this.this$0 = $receiver;
                        this.$context = $context;
                        this.$annotated = $annotated;
                        this.$annotations = $annotations;
                    }

                    public boolean visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                        UExpression expression;
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        PsiElement referencedVariable = node.resolve();
                        if ((Intrinsics.areEqual((Object)this.$variable, (Object)referencedVariable) || Intrinsics.areEqual((Object)this.$variablePsi, (Object)referencedVariable)) && (expression = (UExpression)UastUtils.getParentOfType((UElement)((UElement)node), UExpression.class, (boolean)true)) != null) {
                            UExpression uExpression = (UExpression)UastUtils.getParentOfType((UElement)((UElement)node), UExpression.class, (boolean)false);
                            if (uExpression == null) {
                                return false;
                            }
                            UExpression inner = uExpression;
                            AnnotationHandler.access$checkAnnotations(this.this$0, this.$context, (UElement)inner, AnnotationUsageType.VARIABLE_REFERENCE, (PsiElement)this.$annotated, this.$annotations);
                            return false;
                        }
                        return super.visitSimpleNameReferenceExpression(node);
                    }
                });
            }
            UExpression initializer = ((UVariable)variable).getUastInitializer();
            if (initializer != null) {
                this.checkAnnotations(context2, (UElement)initializer, AnnotationUsageType.ASSIGNMENT_RHS, (PsiElement)annotated, annotations);
            }
        }
    }

    public final void visitBinaryExpression(@NotNull JavaContext context2, @NotNull UBinaryExpression node) {
        PsiMethod method;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (UastExpressionUtils.isAssignment((UElement)((UElement)node))) {
            PsiField resolved;
            PsiElement psiElement = UastUtils.tryResolve((UElement)((UElement)node.getLeftOperand()));
            PsiField psiField = resolved = psiElement instanceof PsiField ? (PsiField)psiElement : null;
            if (resolved != null) {
                JavaEvaluator evaluator = context2.getEvaluator();
                List<AnnotationInfo> annotations = this.getRelevantAnnotations(evaluator, (PsiModifierListOwner)resolved, AnnotationOrigin.FIELD);
                this.checkAnnotations(context2, (UElement)node.getRightOperand(), AnnotationUsageType.ANNOTATION_REFERENCE, (PsiElement)resolved, annotations);
            }
        }
        if ((method = node.resolveOperator()) != null) {
            if ((Intrinsics.areEqual((Object)node.getOperator(), (Object)UastBinaryOperator.EQUALS) || Intrinsics.areEqual((Object)node.getOperator(), (Object)UastBinaryOperator.NOT_EQUALS)) && (UastLiteralUtils.isNullLiteral((UElement)((UElement)node.getRightOperand())) || UastLiteralUtils.isNullLiteral((UElement)((UElement)node.getLeftOperand())))) {
                return;
            }
            UCallExpression call = UImplicitCallExpressionKt.asCall(node, method);
            this.checkCall(context2, method, (UExpression)call);
        }
    }

    public final void visitObjectLiteralExpression(@NotNull JavaContext context2, @NotNull UObjectLiteralExpression node) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.visitCallExpression(context2, (UCallExpression)node);
    }

    public final void visitClassLiteralExpression(@NotNull JavaContext context2, @NotNull UClassLiteralExpression node) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        PsiClass psiClass = context2.getEvaluator().getTypeClass(node.getType());
        if (psiClass == null) {
            return;
        }
        PsiClass containingClass = psiClass;
        this.visitClassReference(context2, (UElement)node, containingClass);
    }

    private final void visitClassReference(JavaContext context2, UElement node, PsiClass cls) {
        List<AnnotationInfo> annotations = this.getMemberAnnotations(context2, node, (PsiModifierListOwner)cls);
        this.checkAnnotations(context2, node, AnnotationUsageType.CLASS_REFERENCE, (PsiElement)cls, annotations);
    }

    public final void visitUnaryExpression(@NotNull JavaContext context2, @NotNull UUnaryExpression node) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        PsiMethod method = node.resolveOperator();
        if (method != null) {
            UCallExpression call = UImplicitCallExpressionKt.asCall(node, method);
            this.checkCall(context2, method, (UExpression)call);
        }
    }

    private final int addAnnotations(List<AnnotationInfo> $this$addAnnotations, JavaEvaluator evaluator, PsiModifierListOwner owner, UElement element, AnnotationOrigin source, boolean prepend) {
        List<UAnnotation> annotations = this.getRelevantAnnotations(evaluator, owner, element);
        return this.addAnnotations($this$addAnnotations, (PsiElement)owner, annotations, source, prepend);
    }

    static /* synthetic */ int addAnnotations$default(AnnotationHandler annotationHandler, List list2, JavaEvaluator javaEvaluator, PsiModifierListOwner psiModifierListOwner, UElement uElement, AnnotationOrigin annotationOrigin, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return annotationHandler.addAnnotations(list2, javaEvaluator, psiModifierListOwner, uElement, annotationOrigin, bl);
    }

    private final int addAnnotations(List<AnnotationInfo> $this$addAnnotations, PsiElement owner, List<? extends UAnnotation> annotations, AnnotationOrigin source, boolean prepend) {
        int n;
        Iterable $this$count$iv = annotations;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                UAnnotation annotation = (UAnnotation)element$iv;
                boolean bl = false;
                if (!this.addAnnotation($this$addAnnotations, annotation, owner, source, prepend)) continue;
                int n2 = ++count$iv;
                boolean bl2 = false;
                if (n2 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n;
    }

    static /* synthetic */ int addAnnotations$default(AnnotationHandler annotationHandler, List list2, PsiElement psiElement, List list3, AnnotationOrigin annotationOrigin, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return annotationHandler.addAnnotations(list2, psiElement, list3, annotationOrigin, bl);
    }

    private final boolean addAnnotation(List<AnnotationInfo> $this$addAnnotation, UAnnotation annotation, PsiElement owner, AnnotationOrigin source, boolean prepend) {
        AnnotationInfo annotationInfo = this.toAnnotationInfo(annotation, owner, source);
        if (annotationInfo == null) {
            return false;
        }
        AnnotationInfo info = annotationInfo;
        if (prepend) {
            $this$addAnnotation.add(0, info);
        } else {
            $this$addAnnotation.add(info);
        }
        return true;
    }

    static /* synthetic */ boolean addAnnotation$default(AnnotationHandler annotationHandler, List list2, UAnnotation uAnnotation, PsiElement psiElement, AnnotationOrigin annotationOrigin, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return annotationHandler.addAnnotation(list2, uAnnotation, psiElement, annotationOrigin, bl);
    }

    private final AnnotationInfo toAnnotationInfo(UAnnotation $this$toAnnotationInfo, PsiElement owner, AnnotationOrigin source) {
        String string = $this$toAnnotationInfo.getQualifiedName();
        if (string == null) {
            return null;
        }
        String name = string;
        return new AnnotationInfo($this$toAnnotationInfo, name, owner, source);
    }

    /*
     * WARNING - void declaration
     */
    private final List<AnnotationInfo> getRelevantAnnotations(JavaEvaluator evaluator, UAnnotated annotated, AnnotationOrigin origin) {
        void $this$mapNotNullTo$iv$iv;
        PsiElement psiElement;
        PsiElement psiElement2 = psiElement = annotated instanceof PsiElement ? (PsiElement)annotated : null;
        if (psiElement == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement owner = psiElement;
        List<UAnnotation> allAnnotations = evaluator.getAllAnnotations(annotated, true);
        Iterable $this$mapNotNull$iv = this.filterRelevantAnnotations(evaluator, allAnnotations);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            AnnotationInfo annotationInfo;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            UAnnotation it = (UAnnotation)element$iv$iv;
            boolean bl2 = false;
            if (this.toAnnotationInfo(it, owner, origin) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            AnnotationInfo it$iv$iv = annotationInfo;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<AnnotationInfo> getRelevantAnnotations(JavaEvaluator evaluator, PsiModifierListOwner owner, AnnotationOrigin origin) {
        void $this$mapNotNullTo$iv$iv;
        PsiAnnotation[] allAnnotations = evaluator.getAllAnnotations(owner, true);
        Iterable $this$mapNotNull$iv = AnnotationHandler.filterRelevantAnnotations$default(this, evaluator, allAnnotations, null, 4, null);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            AnnotationInfo annotationInfo;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            UAnnotation it = (UAnnotation)element$iv$iv;
            boolean bl2 = false;
            if (this.toAnnotationInfo(it, (PsiElement)owner, origin) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            AnnotationInfo it$iv$iv = annotationInfo;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<UAnnotation> getRelevantAnnotations(JavaEvaluator evaluator, PsiModifierListOwner owner, UElement element) {
        PsiAnnotation[] allAnnotations = evaluator.getAllAnnotations(owner, true);
        return this.filterRelevantAnnotations(evaluator, allAnnotations, element);
    }

    private final List<AnnotationInfo> getMemberAnnotations(JavaContext context2, UElement reference, PsiModifierListOwner annotated) {
        PsiPackage pkg;
        KtFile ktFile;
        Object object;
        Object object2;
        KtFile ktFile2;
        PsiClass psiClass;
        PsiClass psiClass2;
        PsiClass psiClass3;
        ArrayDeque list2 = new ArrayDeque();
        JavaEvaluator evaluator = context2.getEvaluator();
        PsiModifierListOwner psiModifierListOwner = annotated;
        if (psiModifierListOwner instanceof PsiMethod) {
            AnnotationHandler.addAnnotations$default(this, (List)list2, evaluator, annotated, reference, AnnotationOrigin.METHOD, false, 16, null);
            psiClass3 = ((PsiMethod)annotated).getContainingClass();
            if (psiClass3 == null) {
                return (List)list2;
            }
            psiClass = psiClass2 = psiClass3;
        } else if (psiModifierListOwner instanceof PsiField) {
            AnnotationHandler.addAnnotations$default(this, (List)list2, evaluator, annotated, reference, AnnotationOrigin.FIELD, false, 16, null);
            psiClass3 = ((PsiField)annotated).getContainingClass();
            if (psiClass3 == null) {
                return (List)list2;
            }
            psiClass = psiClass2 = psiClass3;
        } else if (psiModifierListOwner instanceof PsiClass) {
            psiClass = (PsiClass)annotated;
        } else {
            String string = Intrinsics.stringPlus((String)"Unexpected ", (Object)annotated);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        PsiClass containingClass = psiClass;
        AnnotationHandler.addAnnotations$default(this, (List)list2, evaluator, (PsiModifierListOwner)containingClass, reference, AnnotationOrigin.CLASS, false, 16, null);
        PsiClass topLevelClass = containingClass;
        PsiClass outerClass = containingClass.getContainingClass();
        while (outerClass != null && !(outerClass instanceof PsiAnonymousClass)) {
            AnnotationHandler.addAnnotations$default(this, (List)list2, evaluator, (PsiModifierListOwner)outerClass, reference, AnnotationOrigin.OUTER_CLASS, false, 16, null);
            PsiClass outer = outerClass.getContainingClass();
            if (outer == null) break;
            topLevelClass = outerClass;
            outerClass = outer;
        }
        KtFile ktFile3 = ktFile2 = (object2 = topLevelClass.getContainingFile()) instanceof KtFile ? (KtFile)object2 : null;
        if (ktFile2 == null) {
            PsiClass psiClass4 = topLevelClass;
            KtUltraLightClass ktUltraLightClass = object2 = psiClass4 instanceof KtUltraLightClass ? (KtUltraLightClass)psiClass4 : null;
            object = object2 == null ? null : ((psiClass4 = object2.getKotlinOrigin()) == null ? null : psiClass4.getContainingKtFile());
        } else {
            object = ktFile2;
        }
        ktFile2 = ktFile = object;
        if (ktFile2 != null && (object2 = ktFile2.getAnnotationEntries()) != null) {
            Iterable $this$forEach$iv = (Iterable)object2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtAnnotationEntry entry = (KtAnnotationEntry)element$iv;
                boolean bl = false;
                UElement uElement = UastLanguagePlugin.DefaultImpls.convertElement$default((UastLanguagePlugin)((UastLanguagePlugin)UastFacade.INSTANCE), (PsiElement)((PsiElement)entry), null, null, (int)4, null);
                UAnnotation annotation = uElement instanceof UAnnotation ? (UAnnotation)uElement : null;
                if (annotation == null) continue;
                AnnotationHandler.addAnnotation$default(this, (List)list2, annotation, (PsiElement)ktFile, AnnotationOrigin.FILE, false, 8, null);
            }
        }
        if ((pkg = evaluator.getPackage((PsiElement)containingClass)) != null) {
            AnnotationHandler.addAnnotations$default(this, (List)list2, evaluator, (PsiModifierListOwner)pkg, reference, AnnotationOrigin.PACKAGE, false, 16, null);
        }
        return (List)list2;
    }

    private final void checkAnnotations(JavaContext context2, UElement argument, AnnotationUsageType type, UAnnotated referenced, List<AnnotationInfo> annotations) {
        PsiElement owner = referenced instanceof PsiElement ? (PsiElement)referenced : null;
        this.checkAnnotations(context2, argument, type, owner, annotations);
    }

    private final void checkAnnotations(JavaContext context2, UElement argument, AnnotationUsageType type, PsiElement referenced, List<AnnotationInfo> annotations) {
        AnnotationUsageInfo usageInfo = new AnnotationUsageInfo(0, annotations, argument, referenced, type);
        int n = 0;
        int n2 = annotations.size() + -1;
        if (n <= n2) {
            do {
                int index = n++;
                AnnotationInfo info = annotations.get(index);
                usageInfo.setIndex(index);
                String signature = info.getQualifiedName();
                Collection uastScanners = this.scanners.get((Object)signature);
                if (uastScanners == null || usageInfo.anyCloser((Function1<? super AnnotationInfo, Boolean>)((Function1)new Function1<AnnotationInfo, Boolean>(signature){
                    final /* synthetic */ String $signature;
                    {
                        this.$signature = $signature;
                        super(1);
                    }

                    public final boolean invoke(@NotNull AnnotationInfo it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)this.$signature);
                    }
                }))) continue;
                for (SourceCodeScanner scanner : uastScanners) {
                    if (!scanner.isApplicableAnnotationUsage(type) || !scanner.inheritAnnotation(signature) && info.isInherited()) continue;
                    scanner.visitAnnotationUsage(context2, argument, info, usageInfo);
                }
            } while (n <= n2);
        }
    }

    public final void visitMethod(@NotNull JavaContext context2, @NotNull UMethod method) {
        PsiMethod psiMethod;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        JavaEvaluator evaluator = context2.getEvaluator();
        List<AnnotationInfo> methodAnnotations = this.getRelevantAnnotations(evaluator, (UAnnotated)method, AnnotationOrigin.METHOD);
        Collection collection = methodAnnotations;
        boolean bl = false;
        if (!collection.isEmpty()) {
            UExpression body;
            UExpression uExpression = method.getUastBody();
            UExpression uExpression2 = body = uExpression == null ? null : UastUtils.skipParenthesizedExprDown((UExpression)uExpression);
            if (body != null && !(body instanceof UBlockExpression) && !(body instanceof UReturnExpression)) {
                this.checkAnnotations(context2, (UElement)body, AnnotationUsageType.METHOD_RETURN, (UAnnotated)method, methodAnnotations);
            } else {
                method.accept((UastVisitor)new AbstractUastVisitor(this, context2, method, methodAnnotations){
                    final /* synthetic */ AnnotationHandler this$0;
                    final /* synthetic */ JavaContext $context;
                    final /* synthetic */ UMethod $method;
                    final /* synthetic */ List<AnnotationInfo> $methodAnnotations;
                    {
                        this.this$0 = $receiver;
                        this.$context = $context;
                        this.$method = $method;
                        this.$methodAnnotations = $methodAnnotations;
                    }

                    public boolean visitClass(@NotNull UClass node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        return true;
                    }

                    public boolean visitLambdaExpression(@NotNull ULambdaExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        return true;
                    }

                    public boolean visitReturnExpression(@NotNull UReturnExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        UExpression returnValue = node.getReturnExpression();
                        if (returnValue != null) {
                            AnnotationHandler.access$checkAnnotations(this.this$0, this.$context, (UElement)returnValue, AnnotationUsageType.METHOD_RETURN, (UAnnotated)this.$method, this.$methodAnnotations);
                        }
                        return super.visitReturnExpression(node);
                    }
                });
            }
        }
        if ((psiMethod = evaluator.getSuperMethod((PsiMethod)method)) == null) {
            return;
        }
        PsiMethod superMethod = psiMethod;
        List<AnnotationInfo> annotations = this.getMemberAnnotations(context2, (UElement)method, (PsiModifierListOwner)superMethod);
        this.checkAnnotations(context2, (UElement)method, AnnotationUsageType.METHOD_OVERRIDE, (PsiElement)superMethod, annotations);
    }

    public final void visitClass(@NotNull JavaContext context2, @NotNull UClass node) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        for (UTypeReferenceExpression superType : node.getUastSuperTypes()) {
            PsiClass psiClass;
            PsiType type = superType.getType();
            PsiClass psiClass2 = PsiTypesUtil.getPsiClass((PsiType)type);
            if (psiClass2 == null) continue;
            PsiClass resolved = psiClass = psiClass2;
            JavaEvaluator evaluator = context2.getEvaluator();
            List<AnnotationInfo> annotations = this.getRelevantAnnotations(evaluator, (PsiModifierListOwner)resolved, AnnotationOrigin.CLASS);
            this.checkAnnotations(context2, (UElement)superType, AnnotationUsageType.EXTENDS, (PsiElement)resolved, annotations);
        }
    }

    public final void visitSimpleNameReferenceExpression(@NotNull JavaContext context2, @NotNull USimpleNameReferenceExpression node) {
        PsiModifierListOwner field;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        PsiElement psiElement = node.resolve();
        PsiModifierListOwner psiModifierListOwner = field = psiElement instanceof PsiModifierListOwner ? (PsiModifierListOwner)psiElement : null;
        if (field instanceof PsiField || field instanceof PsiMethod) {
            block4: {
                PsiMethod operatorMethod;
                UElement prev = (UElement)node;
                UElement parent = prev.getUastParent();
                while (parent instanceof UParenthesizedExpression || parent instanceof UQualifiedReferenceExpression && ((UQualifiedReferenceExpression)parent).getSelector() == prev) {
                    prev = parent;
                    UElement uElement = parent.getUastParent();
                    if (uElement != null) {
                        parent = uElement;
                        continue;
                    }
                    break block4;
                }
                if (parent instanceof UBinaryExpression && ((UBinaryExpression)parent).getLeftOperand() == prev && (operatorMethod = ((UBinaryExpression)parent).resolveOperator()) != null && ((UBinaryExpression)parent).getOperator() instanceof UastBinaryOperator.AssignOperator) {
                    return;
                }
            }
            List<AnnotationInfo> annotations = this.getMemberAnnotations(context2, (UElement)node, field);
            this.checkAnnotations(context2, (UElement)node, AnnotationUsageType.FIELD_REFERENCE, (PsiElement)field, annotations);
        }
    }

    public final void visitCallExpression(@NotNull JavaContext context2, @NotNull UCallExpression call) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        PsiMethod method = call.resolve();
        if (method == null) {
            this.checkCallUnresolved(context2, call);
        } else {
            this.checkCall(context2, method, (UExpression)call);
        }
    }

    public final void visitCallableReferenceExpression(@NotNull JavaContext context2, @NotNull UCallableReferenceExpression methodReference) {
        PsiMethod psiMethod;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)methodReference, (String)"methodReference");
        PsiElement psiElement = methodReference.resolve();
        PsiMethod psiMethod2 = psiMethod = psiElement instanceof PsiMethod ? (PsiMethod)psiElement : null;
        if (psiMethod == null) {
            return;
        }
        PsiMethod method = psiMethod;
        List<AnnotationInfo> annotations = this.getMemberAnnotations(context2, (UElement)methodReference, (PsiModifierListOwner)method);
        this.checkAnnotations(context2, (UElement)methodReference, AnnotationUsageType.METHOD_REFERENCE, (PsiElement)method, annotations);
    }

    public final void visitAnnotation(@NotNull JavaContext context2, @NotNull UAnnotation annotation) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        String qualifiedName = annotation.getQualifiedName();
        if (qualifiedName == null || StringsKt.startsWith$default((String)qualifiedName, (String)"java.", (boolean)false, (int)2, null) || SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.isPrefix(qualifiedName)) {
            return;
        }
        List attributeValues = annotation.getAttributeValues();
        if (attributeValues.isEmpty()) {
            return;
        }
        PsiClass psiClass = annotation.resolve();
        if (psiClass == null) {
            return;
        }
        PsiClass resolved = psiClass;
        for (UNamedExpression expression : attributeValues) {
            String string = expression.getName();
            String name = string == null ? "value" : string;
            PsiMethod[] methods = resolved.findMethodsByName(name, false);
            if (methods.length != 1) continue;
            PsiMethod method = methods[0];
            JavaEvaluator evaluator = context2.getEvaluator();
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method");
            List<AnnotationInfo> methodAnnotations = this.getRelevantAnnotations(evaluator, (PsiModifierListOwner)method, AnnotationOrigin.METHOD);
            Collection collection = methodAnnotations;
            boolean bl = false;
            if (!(!collection.isEmpty())) continue;
            UExpression value = expression.getExpression();
            this.checkAnnotations(context2, (UElement)value, AnnotationUsageType.ANNOTATION_REFERENCE, (PsiElement)method, methodAnnotations);
        }
    }

    public final void visitEnumConstant(@NotNull JavaContext context2, @NotNull UEnumConstant constant) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)constant, (String)"constant");
        PsiMethod method = constant.resolveMethod();
        if (method != null) {
            this.checkCall(context2, method, (UExpression)constant);
        }
    }

    public final void visitArrayAccessExpression(@NotNull JavaContext context2, @NotNull UArrayAccessExpression expression) {
        Object evaluator;
        PsiElement resolved;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        UExpression arrayExpression = expression.getReceiver();
        if (arrayExpression instanceof UReferenceExpression && (resolved = ((UReferenceExpression)arrayExpression).resolve()) instanceof PsiModifierListOwner) {
            evaluator = context2.getEvaluator();
            AnnotationOrigin origin = resolved instanceof PsiMethod ? AnnotationOrigin.METHOD : AnnotationOrigin.FIELD;
            List<AnnotationInfo> methodAnnotations = this.getRelevantAnnotations((JavaEvaluator)evaluator, (PsiModifierListOwner)resolved, origin);
            Collection collection = methodAnnotations;
            boolean bl = false;
            if (!collection.isEmpty()) {
                this.checkContextAnnotations(context2, (UElement)expression, methodAnnotations, (PsiModifierListOwner)resolved);
            }
        }
        if ((evaluator = Lint.resolveOperator(expression)) == null) {
            return;
        }
        PsiMethod method = evaluator;
        UCallExpression call = UImplicitCallExpressionKt.asCall(expression, method);
        this.checkCall(context2, method, (UExpression)call);
    }

    public final void visitVariable(@NotNull JavaContext context2, @NotNull UVariable variable) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        JavaEvaluator evaluator = context2.getEvaluator();
        List<AnnotationInfo> methodAnnotations = this.getRelevantAnnotations(evaluator, (UAnnotated)variable, AnnotationOrigin.VARIABLE);
        Collection collection = methodAnnotations;
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.checkContextAnnotations(context2, (UElement)variable, methodAnnotations, (PsiModifierListOwner)variable);
        }
    }

    private final void checkCall(JavaContext context2, PsiMethod method, UExpression call) {
        this.doCheckCall(context2, method, call, null);
    }

    private final void checkCallUnresolved(JavaContext context2, UCallExpression call) {
        Object object;
        PsiClass psiClass;
        JavaEvaluator evaluator = context2.getEvaluator();
        UReferenceExpression uReferenceExpression = call.getClassReference();
        PsiElement psiElement = uReferenceExpression == null ? null : uReferenceExpression.resolve();
        PsiClass psiClass2 = psiClass = psiElement instanceof PsiClass ? (PsiClass)psiElement : null;
        if (psiClass == null) {
            PsiClass psiClass3;
            PsiElement psiElement2 = call.getSourcePsi();
            PsiNewExpression psiNewExpression = psiElement2 instanceof PsiNewExpression ? (PsiNewExpression)psiElement2 : null;
            PsiAnonymousClass psiAnonymousClass = uReferenceExpression = psiNewExpression == null ? null : psiNewExpression.getAnonymousClass();
            if (uReferenceExpression == null) {
                psiClass3 = null;
            } else {
                psiNewExpression = uReferenceExpression.getBaseClassType();
                if (psiNewExpression == null) {
                    psiClass3 = null;
                } else {
                    psiElement2 = psiNewExpression;
                    boolean bl = false;
                    boolean bl2 = false;
                    PsiElement it = psiElement2;
                    boolean bl3 = false;
                    psiClass3 = evaluator.getTypeClass((PsiType)it);
                }
            }
            psiElement = psiClass3;
            object = psiElement == null ? ((uReferenceExpression = Lint.resolveKotlinCall((psiNewExpression = call.getClassReference()) == null ? null : psiNewExpression.getSourcePsi())) instanceof PsiClass ? (PsiClass)uReferenceExpression : null) : psiElement;
        } else {
            object = psiClass;
        }
        PsiClass containingClass = object;
        this.doCheckCall(context2, null, (UExpression)call, containingClass);
    }

    private final void doCheckCall(JavaContext context2, PsiMethod method, UExpression call, PsiClass containingClass) {
        JavaEvaluator evaluator = context2.getEvaluator();
        if (method != null) {
            Object object;
            Object object2;
            List<AnnotationInfo> annotations = this.getMemberAnnotations(context2, (UElement)call, (PsiModifierListOwner)method);
            Collection collection = annotations;
            boolean bl = false;
            if (!collection.isEmpty()) {
                this.checkAnnotations(context2, (UElement)call, AnnotationUsageType.METHOD_CALL, (PsiElement)method, annotations);
                List<AnnotationInfo> local = this.getRelevantAnnotations(evaluator, (PsiModifierListOwner)method, AnnotationOrigin.METHOD);
                Collection collection2 = local;
                boolean bl2 = false;
                if (!collection2.isEmpty()) {
                    this.checkContextAnnotations(context2, (UElement)call, local, (PsiModifierListOwner)method);
                }
                while (true) {
                    AnnotationOrigin first;
                    AnnotationOrigin annotationOrigin = first = (object2 = (AnnotationInfo)CollectionsKt.firstOrNull(annotations)) == null ? null : ((AnnotationInfo)object2).getOrigin();
                    if (first != AnnotationOrigin.METHOD) break;
                    CollectionsKt.removeFirst(annotations);
                }
            }
            if (!((object = call) instanceof UCallExpression)) {
                if (object instanceof UUnaryExpression) {
                    return;
                }
                object2 = Intrinsics.stringPlus((String)"Unexpected call type ", (Object)call);
                boolean bl3 = false;
                throw (Throwable)new IllegalStateException(object2.toString());
            }
            Map<UExpression, PsiParameter> mapping = evaluator.computeArgumentMapping((UCallExpression)call, method);
            object2 = mapping;
            boolean bl4 = false;
            object = object2.entrySet().iterator();
            while (object.hasNext()) {
                Object object3 = object2 = (Map.Entry)object.next();
                boolean bl5 = false;
                UExpression argument = (UExpression)object3.getKey();
                Object object4 = object2;
                boolean bl6 = false;
                PsiModifierListOwner parameter = (PsiModifierListOwner)object4.getValue();
                int added = this.addAnnotations(annotations, evaluator, parameter, (UElement)call, AnnotationOrigin.PARAMETER, true);
                if (added <= 0) continue;
                this.checkAnnotations(context2, (UElement)argument, AnnotationUsageType.METHOD_CALL_PARAMETER, (PsiElement)method, annotations);
                bl6 = false;
                int n = 0;
                n = 0;
                int n2 = added;
                while (n < n2) {
                    int it = n++;
                    boolean bl7 = false;
                    CollectionsKt.removeFirst(annotations);
                }
            }
        } else if (containingClass != null) {
            List<AnnotationInfo> annotations = this.getMemberAnnotations(context2, (UElement)call, (PsiModifierListOwner)containingClass);
            this.checkAnnotations(context2, (UElement)call, AnnotationUsageType.METHOD_CALL, (PsiElement)null, annotations);
        }
    }

    private final List<UAnnotation> filterRelevantAnnotations(JavaEvaluator evaluator, PsiAnnotation[] annotations, UElement context2) {
        List result = null;
        int length = annotations.length;
        if (length == 0) {
            return CollectionsKt.emptyList();
        }
        Object object = annotations;
        int n = 0;
        int n2 = ((PsiAnnotation[])object).length;
        while (n < n2) {
            PsiAnnotation[] innerAnnotations;
            int n3;
            int n4;
            PsiElement psiElement;
            PsiElement cls;
            PsiElement psiElement2;
            Object $this$filterRelevantAnnotations_u24lambda_u2d6;
            PsiElement psiElement3;
            PsiAnnotation annotation = object[n];
            ++n;
            String signature = annotation.getQualifiedName();
            if (signature == null || (StringsKt.startsWith$default((String)signature, (String)"kotlin.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)signature, (String)"java.", (boolean)false, (int)2, null)) && !this.relevantAnnotations.contains(signature)) continue;
            if (this.relevantAnnotations.contains(signature)) {
                UAnnotation uAnnotation = JavaUAnnotation.Companion.wrap(annotation);
                if (length == 1) {
                    return CollectionsKt.listOf((Object)uAnnotation);
                }
                if (result == null) {
                    result = new ArrayList(2);
                }
                result.add(uAnnotation);
                continue;
            }
            if (AndroidPlatformAnnotations.Companion.isPlatformAnnotation(signature)) {
                if (result == null) {
                    result = new ArrayList(2);
                }
                result.add(AndroidPlatformAnnotations.Companion.fromPlatformAnnotation(annotation, signature));
                continue;
            }
            PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = annotation.getNameReferenceElement();
            PsiElement psiElement4 = psiElement3 = psiJavaCodeReferenceElement == null ? null : psiJavaCodeReferenceElement.resolve();
            if (psiElement3 == null) {
                AnnotationHandler annotationHandler = this;
                boolean bl = false;
                boolean bl2 = false;
                $this$filterRelevantAnnotations_u24lambda_u2d6 = annotationHandler;
                boolean bl3 = false;
                Project project = annotation.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"annotation.project");
                Project project2 = project;
                psiJavaCodeReferenceElement = JavaPsiFacade.getInstance((Project)project2).findClass(signature, GlobalSearchScope.projectScope((Project)project2));
                if (psiJavaCodeReferenceElement == null) continue;
                psiElement2 = (PsiElement)psiJavaCodeReferenceElement;
            } else {
                psiElement2 = psiElement3;
            }
            if (!((cls = (psiElement = psiElement2)) instanceof PsiClass) || !((PsiClass)cls).isAnnotationType() || (n4 = 0) > (n3 = (innerAnnotations = evaluator.getAllAnnotations((PsiModifierListOwner)cls, false)).length + -1)) continue;
            do {
                UAnnotation innerU;
                int j;
                PsiAnnotation inner;
                String string;
                if ((string = (inner = innerAnnotations[j = n4++]).getQualifiedName()) == null) continue;
                $this$filterRelevantAnnotations_u24lambda_u2d6 = string;
                Object innerName = $this$filterRelevantAnnotations_u24lambda_u2d6;
                if (this.relevantAnnotations.contains(innerName)) {
                    if (result == null) {
                        result = new ArrayList(2);
                    }
                    innerU = this.annotationLookup.findRealAnnotation(inner, (PsiClass)cls, context2);
                    result.add(innerU);
                    continue;
                }
                if (!AndroidPlatformAnnotations.Companion.isPlatformAnnotation((String)innerName)) continue;
                if (result == null) {
                    result = new ArrayList(2);
                }
                innerU = this.annotationLookup.findRealAnnotation(inner, (PsiClass)cls, context2);
                result.add(AndroidPlatformAnnotations.Companion.fromPlatformAnnotation(innerU, (String)innerName));
            } while (n4 <= n3);
        }
        object = result;
        return object == null ? CollectionsKt.emptyList() : object;
    }

    static /* synthetic */ List filterRelevantAnnotations$default(AnnotationHandler annotationHandler, JavaEvaluator javaEvaluator, PsiAnnotation[] psiAnnotationArray, UElement uElement, int n, Object object) {
        if ((n & 4) != 0) {
            uElement = null;
        }
        return annotationHandler.filterRelevantAnnotations(javaEvaluator, psiAnnotationArray, uElement);
    }

    private final List<UAnnotation> filterRelevantAnnotations(JavaEvaluator evaluator, List<? extends UAnnotation> annotations) {
        List result = null;
        int length = annotations.size();
        if (length == 0) {
            return annotations;
        }
        for (UAnnotation annotation : annotations) {
            PsiAnnotation[] innerAnnotations;
            int n;
            int n2;
            String signature = annotation.getQualifiedName();
            if (signature == null || StringsKt.startsWith$default((String)signature, (String)"java.", (boolean)false, (int)2, null) && !this.relevantAnnotations.contains(signature)) continue;
            if (this.relevantAnnotations.contains(signature)) {
                if (length == 1) {
                    return annotations;
                }
                if (result == null) {
                    result = new ArrayList(2);
                }
                result.add(annotation);
                continue;
            }
            if (AndroidPlatformAnnotations.Companion.isPlatformAnnotation(signature)) {
                if (result == null) {
                    result = new ArrayList(2);
                }
                result.add(AndroidPlatformAnnotations.Companion.fromPlatformAnnotation(annotation, signature));
                continue;
            }
            PsiClass cls = annotation.resolve();
            if (cls == null || !cls.isAnnotationType() || (n2 = 0) > (n = (innerAnnotations = evaluator.getAllAnnotations((PsiModifierListOwner)cls, false)).length + -1)) continue;
            do {
                UAnnotation innerU;
                int j;
                PsiAnnotation inner;
                String string;
                if ((string = (inner = innerAnnotations[j = n2++]).getQualifiedName()) == null) continue;
                String string2 = string;
                String innerName = string2;
                if (this.relevantAnnotations.contains(innerName)) {
                    if (result == null) {
                        result = new ArrayList(2);
                    }
                    innerU = AnnotationLookup.findRealAnnotation$default(this.annotationLookup, inner, cls, null, 4, null);
                    result.add(innerU);
                    continue;
                }
                if (!AndroidPlatformAnnotations.Companion.isPlatformAnnotation(innerName)) continue;
                if (result == null) {
                    result = new ArrayList(2);
                }
                innerU = AnnotationLookup.findRealAnnotation$default(this.annotationLookup, inner, cls, null, 4, null);
                result.add(AndroidPlatformAnnotations.Companion.fromPlatformAnnotation(innerU, innerName));
            } while (n2 <= n);
        }
        List list2 = result;
        return list2 == null ? CollectionsKt.emptyList() : list2;
    }

    public static final /* synthetic */ void access$checkAnnotations(AnnotationHandler $this, JavaContext context2, UElement argument, AnnotationUsageType type, PsiElement referenced, List annotations) {
        $this.checkAnnotations(context2, argument, type, referenced, (List<AnnotationInfo>)annotations);
    }

    public static final /* synthetic */ void access$checkAnnotations(AnnotationHandler $this, JavaContext context2, UElement argument, AnnotationUsageType type, UAnnotated referenced, List annotations) {
        $this.checkAnnotations(context2, argument, type, referenced, (List<AnnotationInfo>)annotations);
    }
}

