/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintStats;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.XmlFileType;
import com.android.tools.lint.XmlReporter;
import com.android.tools.lint.XmlWriter;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Incident;
import com.google.common.annotations.Beta;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bJ \u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0017\u001a\u00020\u0018J\u001e\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0016R\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/lint/XmlReporter;", "Lcom/android/tools/lint/Reporter;", "client", "Lcom/android/tools/lint/LintCliClient;", "output", "Ljava/io/File;", "type", "Lcom/android/tools/lint/XmlFileType;", "(Lcom/android/tools/lint/LintCliClient;Ljava/io/File;Lcom/android/tools/lint/XmlFileType;)V", "attributes", "", "", "getType", "()Lcom/android/tools/lint/XmlFileType;", "setType", "(Lcom/android/tools/lint/XmlFileType;)V", "setAttribute", "", "name", "value", "setBaselineAttributes", "Lcom/android/tools/lint/client/api/LintClient;", "variant", "includeDependencies", "", "write", "stats", "Lcom/android/tools/lint/LintStats;", "incidents", "", "Lcom/android/tools/lint/detector/api/Incident;", "unnamed"})
@Beta
public final class XmlReporter
extends Reporter {
    @NotNull
    private XmlFileType type;
    @Nullable
    private Map<String, String> attributes;

    public XmlReporter(@NotNull LintCliClient client, @NotNull File output, @NotNull XmlFileType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        super(client, output);
        this.type = type;
    }

    @NotNull
    public final XmlFileType getType() {
        return this.type;
    }

    public final void setType(@NotNull XmlFileType xmlFileType) {
        Intrinsics.checkNotNullParameter((Object)((Object)xmlFileType), (String)"<set-?>");
        this.type = xmlFileType;
    }

    public final void setBaselineAttributes(@NotNull LintClient client, @Nullable String variant, boolean includeDependencies) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.setAttribute("client", LintClient.Companion.getClientName());
        this.setAttribute("name", client.getClientDisplayName());
        String revision = client.getClientDisplayRevision();
        if (revision != null) {
            this.setAttribute("version", revision);
        }
        if (variant != null) {
            this.setAttribute("variant", variant);
        }
        this.setAttribute("dependencies", String.valueOf(includeDependencies));
    }

    public final void setAttribute(@NotNull String name, @NotNull String value) {
        Map attributes;
        Map map;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Map map2 = this.attributes;
        if (map2 == null) {
            Map newMap;
            XmlReporter xmlReporter = this;
            boolean bl = false;
            boolean bl2 = false;
            XmlReporter $this$setAttribute_u24lambda_u2d0 = xmlReporter;
            boolean bl3 = false;
            boolean bl4 = false;
            $this$setAttribute_u24lambda_u2d0.attributes = newMap = (Map)new LinkedHashMap();
            map = newMap;
        } else {
            map = map2;
        }
        map2 = attributes = map;
        boolean bl = false;
        map2.put((String)name, (String)value);
    }

    @Override
    public void write(@NotNull LintStats stats, @NotNull List<Incident> incidents) throws IOException {
        Object object;
        BufferedWriter bufferedWriter;
        Charset charset;
        File file;
        BufferedWriter bufferedWriter2;
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        Intrinsics.checkNotNullParameter(incidents, (String)"incidents");
        File file2 = this.getOutput();
        if (file2 == null) {
            bufferedWriter2 = null;
        } else {
            file = file2;
            charset = Charsets.UTF_8;
            int n = 8192;
            boolean bl = false;
            Object object2 = file;
            boolean bl2 = false;
            Object object3 = object2;
            boolean bl3 = false;
            object3 = new FileOutputStream((File)object3);
            bl3 = false;
            object2 = new OutputStreamWriter((OutputStream)object3, charset);
            bl2 = false;
            bufferedWriter2 = bufferedWriter = object2 instanceof BufferedWriter ? (BufferedWriter)object2 : new BufferedWriter((Writer)object2, n);
        }
        if (bufferedWriter == null) {
            return;
        }
        BufferedWriter writer = bufferedWriter;
        XmlWriter xmlWriter = new XmlWriter(this.client, this.type, writer);
        Sequence sequence = this.attributes;
        if (sequence == null) {
            object = null;
        } else {
            Sequence sequence2 = MapsKt.asSequence(sequence);
            if (sequence2 == null) {
                object = null;
            } else {
                Sequence $this$sortedBy$iv = sequence2;
                boolean $i$f$sortedBy = false;
                boolean bl = false;
                object = charset = SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        Map.Entry it = (Map.Entry)a;
                        boolean bl2 = false;
                        Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                        it = (Map.Entry)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        String string = (String)it.getKey();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                    }
                });
            }
        }
        file = charset == null ? null : ((sequence = SequencesKt.map((Sequence)charset, (Function1)write.clientAttributes.2.INSTANCE)) == null ? null : SequencesKt.toList((Sequence)sequence));
        Object clientAttributes2 = file == null ? CollectionsKt.emptyList() : file;
        xmlWriter.writeIncidents(incidents, (List<Pair<String, String>>)clientAttributes2);
    }
}

