/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.ide.common.util.PathString;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.detector.api.Constraint;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0013H\u0002J\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0&J\u0010\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\rH\u0002J\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00180*J\n\u0010+\u001a\u0004\u0018\u00010\u0013H\u0002J\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110&J\b\u0010-\u001a\u00020#H\u0002J\b\u0010.\u001a\u00020/H\u0002J\b\u00100\u001a\u00020#H\u0002J\b\u00101\u001a\u00020\u0013H\u0002J\b\u00102\u001a\u00020\u0013H\u0002J\b\u00103\u001a\u00020#H\u0002J\b\u00104\u001a\u000205H\u0002J\b\u00106\u001a\u00020\u0013H\u0002J\b\u00107\u001a\u00020\u0013H\u0002J\b\u00108\u001a\u00020\u0013H\u0002J\b\u00109\u001a\u00020#H\u0002J\b\u0010:\u001a\u00020\u0011H\u0002J\b\u0010;\u001a\u00020\u001cH\u0002J\b\u0010<\u001a\u00020#H\u0002J\b\u0010=\u001a\u00020#H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/android/tools/lint/XmlReader;", "", "client", "Lcom/android/tools/lint/LintCliClient;", "registry", "Lcom/android/tools/lint/client/api/IssueRegistry;", "project", "Lcom/android/tools/lint/detector/api/Project;", "xmlFile", "Ljava/io/File;", "(Lcom/android/tools/lint/LintCliClient;Lcom/android/tools/lint/client/api/IssueRegistry;Lcom/android/tools/lint/detector/api/Project;Ljava/io/File;)V", "configs", "", "", "Lcom/android/tools/lint/detector/api/Severity;", "data", "Lcom/android/tools/lint/detector/api/Issue;", "Lcom/android/tools/lint/detector/api/LintMap;", "fix", "Lcom/android/tools/lint/detector/api/LintFix;", "fixLists", "Ljava/util/ArrayDeque;", "", "incidents", "Lcom/android/tools/lint/detector/api/Incident;", "issueId", "lintMap", "location", "Lcom/android/tools/lint/detector/api/Location;", "message", "parser", "Lorg/xmlpull/v1/XmlPullParser;", "prevLocation", "severity", "addFix", "", "newFix", "getConfiguredIssues", "", "getFile", "path", "getIncidents", "", "getParentFix", "getPartialResults", "parse", "readCondition", "Lcom/android/tools/lint/detector/api/Constraint;", "readConfigInto", "readCreateFile", "readFixAnnotate", "readFixComposite", "readFixData", "Lcom/android/tools/lint/detector/api/LintFix$DataMap;", "readFixReplace", "readFixSetAttribute", "readFixShowUrl", "readIncidentHeader", "readLintMap", "readLocation", "readRange", "skipToNextTag", "unnamed"})
public final class XmlReader {
    @NotNull
    private final LintCliClient client;
    @NotNull
    private final IssueRegistry registry;
    @Nullable
    private final Project project;
    @NotNull
    private final List<Incident> incidents;
    @Nullable
    private Map<Issue, LintMap> data;
    @Nullable
    private Map<String, Severity> configs;
    @NotNull
    private final XmlPullParser parser;
    @Nullable
    private String issueId;
    @Nullable
    private String message;
    @Nullable
    private Severity severity;
    @Nullable
    private Location location;
    @Nullable
    private Location prevLocation;
    @Nullable
    private LintMap lintMap;
    @Nullable
    private LintFix fix;
    @NotNull
    private final ArrayDeque<List<LintFix>> fixLists;

    public XmlReader(@NotNull LintCliClient client, @NotNull IssueRegistry registry, @Nullable Project project, @NotNull File xmlFile) {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)xmlFile, (String)"xmlFile");
        this.client = client;
        this.registry = registry;
        this.project = project;
        boolean bl = false;
        this.incidents = new ArrayList();
        this.fixLists = new ArrayDeque();
        if (xmlFile.exists()) {
            XmlPullParser xmlPullParser = this.client.createXmlPullParser(new PathString(xmlFile));
            this.parser = xmlPullParser == null ? (XmlPullParser)new KXmlParser() : xmlPullParser;
            this.parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
            this.parse();
        } else {
            this.parser = (XmlPullParser)new KXmlParser();
        }
    }

    @NotNull
    public final List<Incident> getIncidents() {
        return this.incidents;
    }

    @NotNull
    public final Map<Issue, LintMap> getPartialResults() {
        Map<Issue, LintMap> map = this.data;
        return map == null ? MapsKt.emptyMap() : map;
    }

    @NotNull
    public final Map<String, Severity> getConfiguredIssues() {
        Map<String, Severity> map = this.configs;
        return map == null ? MapsKt.emptyMap() : map;
    }

    private final void addFix(LintFix newFix) {
        if (this.fixLists.isEmpty()) {
            this.fix = newFix;
        } else {
            this.fixLists.getLast().add(newFix);
        }
    }

    private final LintFix getParentFix() {
        LintFix lintFix;
        if (this.fixLists.isEmpty()) {
            lintFix = this.fix;
        } else {
            List<LintFix> list2 = this.fixLists.getLast();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"fixLists.last");
            lintFix = (LintFix)CollectionsKt.last(list2);
        }
        return lintFix;
    }

    private final void parse() {
        try {
            block49: while (this.parser.next() != 1) {
                int eventType;
                block87: {
                    String string;
                    String tag;
                    block88: {
                        Object location;
                        String message;
                        int n;
                        block85: {
                            eventType = this.parser.getEventType();
                            if (eventType != 3) break block85;
                            String string2 = this.parser.getName();
                            if (string2 == null) continue;
                            n = -1;
                            switch (string2.hashCode()) {
                                case -1732277553: {
                                    if (string2.equals("fix-composite")) {
                                        n = 1;
                                    }
                                    break;
                                }
                                case 100509913: {
                                    if (string2.equals("issue")) {
                                        n = 2;
                                    }
                                    break;
                                }
                                case 477851934: {
                                    if (string2.equals("fix-alternatives")) {
                                        n = 3;
                                    }
                                    break;
                                }
                                case 86983890: {
                                    if (string2.equals("incident")) {
                                        n = 2;
                                    }
                                    break;
                                }
                            }
                            switch (n) {
                                case 2: {
                                    Issue issue;
                                    String issueId = this.issueId;
                                    message = this.message;
                                    location = this.location;
                                    if (issueId != null && message != null && location != null && (issue = this.registry.getIssue(issueId)) != null) {
                                        Severity it;
                                        boolean bl;
                                        boolean bl2;
                                        Severity severity;
                                        Incident incident = new Incident(issue, message, location, this.fix);
                                        Severity severity2 = this.severity;
                                        if (severity2 != null) {
                                            severity = severity2;
                                            bl2 = false;
                                            bl = false;
                                            it = severity;
                                            boolean bl3 = false;
                                            incident.setSeverity(it);
                                        }
                                        severity2 = this.lintMap;
                                        if (severity2 != null) {
                                            severity = severity2;
                                            bl2 = false;
                                            bl = false;
                                            it = severity;
                                            boolean bl4 = false;
                                            incident.setClientProperties((LintMap)it);
                                        }
                                        severity2 = this.project;
                                        if (severity2 != null) {
                                            severity = severity2;
                                            bl2 = false;
                                            bl = false;
                                            it = severity;
                                            boolean bl5 = false;
                                            incident.setProject((Project)it);
                                        }
                                        this.incidents.add(incident);
                                    }
                                    this.issueId = null;
                                    this.message = null;
                                    this.location = null;
                                    this.prevLocation = null;
                                    this.lintMap = null;
                                    this.severity = null;
                                    this.fix = null;
                                    this.fixLists.clear();
                                    break;
                                }
                                case 3: {
                                    this.fixLists.removeLast();
                                    break;
                                }
                                case 1: {
                                    this.fixLists.removeLast();
                                }
                            }
                            continue;
                        }
                        if (eventType != 2) break block87;
                        tag = this.parser.getName();
                        if (tag == null) break block88;
                        tmp = -1;
                        switch (tag.hashCode()) {
                            case -540167251: {
                                if (tag.equals("create-file")) {
                                    tmp = 1;
                                }
                                break;
                            }
                            case -339980641: {
                                if (tag.equals("show-url")) {
                                    tmp = 2;
                                }
                                break;
                            }
                            case 100509913: {
                                if (tag.equals("issue")) {
                                    tmp = 3;
                                }
                                break;
                            }
                            case 477851934: {
                                if (tag.equals("fix-alternatives")) {
                                    tmp = 4;
                                }
                                break;
                            }
                            case 108280125: {
                                if (tag.equals("range")) {
                                    tmp = 5;
                                }
                                break;
                            }
                            case -649662132: {
                                if (tag.equals("annotate")) {
                                    tmp = 6;
                                }
                                break;
                            }
                            case -1179159878: {
                                if (tag.equals("issues")) {
                                    tmp = 7;
                                }
                                break;
                            }
                            case -1732277553: {
                                if (tag.equals("fix-composite")) {
                                    tmp = 4;
                                }
                                break;
                            }
                            case 96667762: {
                                if (tag.equals("entry")) {
                                    tmp = 8;
                                }
                                break;
                            }
                            case -319438108: {
                                if (tag.equals("fix-attribute")) {
                                    tmp = 9;
                                }
                                break;
                            }
                            case -443233694: {
                                if (tag.equals("fix-data")) {
                                    tmp = 10;
                                }
                                break;
                            }
                            case -1994113796: {
                                if (tag.equals("fix-replace")) {
                                    tmp = 11;
                                }
                                break;
                            }
                            case -1598466591: {
                                if (tag.equals("incidents")) {
                                    tmp = 7;
                                }
                                break;
                            }
                            case 1901043637: {
                                if (tag.equals("location")) {
                                    tmp = 12;
                                }
                                break;
                            }
                            case 86983890: {
                                if (tag.equals("incident")) {
                                    tmp = 3;
                                }
                                break;
                            }
                            case -1354792126: {
                                if (tag.equals("config")) {
                                    tmp = 13;
                                }
                                break;
                            }
                            case 107868: {
                                if (tag.equals("map")) {
                                    tmp = 14;
                                }
                                break;
                            }
                        }
                        switch (tmp) {
                            case 7: {
                                continue block49;
                            }
                            case 12: {
                                Unit unit;
                                Location newLocation = this.readLocation();
                                location = this.prevLocation;
                                if (location == null) {
                                    unit = null;
                                } else {
                                    Location location2 = location;
                                    boolean bl = false;
                                    boolean bl6 = false;
                                    Location it = location2;
                                    boolean bl7 = false;
                                    it.setSecondary(newLocation);
                                    this.prevLocation = newLocation;
                                    unit = Unit.INSTANCE;
                                }
                                if ((message = unit) != null) continue block49;
                                location = this;
                                boolean bl = false;
                                boolean bl8 = false;
                                XmlReader $this$parse_u24lambda_u2d4 = (XmlReader)location;
                                boolean bl9 = false;
                                $this$parse_u24lambda_u2d4.location = newLocation;
                                $this$parse_u24lambda_u2d4.prevLocation = newLocation;
                                continue block49;
                            }
                            case 5: {
                                this.readRange();
                                continue block49;
                            }
                            case 3: {
                                this.readIncidentHeader();
                                continue block49;
                            }
                            case 13: {
                                this.readConfigInto();
                                continue block49;
                            }
                            case 14: {
                                Issue issue;
                                message = this.parser.getAttributeValue(null, "id");
                                if (message == null) {
                                    issue = null;
                                } else {
                                    location = message;
                                    boolean bl = false;
                                    boolean bl10 = false;
                                    Object it = location;
                                    boolean bl11 = false;
                                    issue = this.registry.getIssue((String)it);
                                }
                                Issue issue2 = issue;
                                LintMap newNote = this.readLintMap();
                                if (issue2 != null) {
                                    Map map;
                                    Map map2;
                                    Object object = this.data;
                                    if (object == null) {
                                        HashMap hashMap = new HashMap();
                                        boolean bl = false;
                                        boolean bl12 = false;
                                        HashMap it = hashMap;
                                        boolean bl13 = false;
                                        this.data = it;
                                        map2 = hashMap;
                                    } else {
                                        map2 = map = object;
                                    }
                                    if (map.get(issue2) != null) {
                                        object = Intrinsics.stringPlus((String)"Should only specify one LintMap for issue ", (Object)issue2);
                                        boolean bl = false;
                                        throw (Throwable)new IllegalStateException(object.toString());
                                    }
                                    object = map;
                                    boolean bl = false;
                                    object.put(issue2, newNote);
                                    continue block49;
                                }
                                this.lintMap = newNote;
                                continue block49;
                            }
                            case 8: {
                                string = "entry should be nested inside map";
                                boolean bl = false;
                                throw (Throwable)new IllegalStateException(string.toString());
                            }
                            case 10: {
                                this.addFix((LintFix)this.readFixData());
                                continue block49;
                            }
                            case 2: {
                                this.addFix(this.readFixShowUrl());
                                continue block49;
                            }
                            case 6: {
                                this.addFix(this.readFixAnnotate());
                                continue block49;
                            }
                            case 11: {
                                this.addFix(this.readFixReplace());
                                continue block49;
                            }
                            case 9: {
                                this.addFix(this.readFixSetAttribute());
                                continue block49;
                            }
                            case 1: {
                                this.addFix(this.readCreateFile());
                                continue block49;
                            }
                            case 4: {
                                this.readFixComposite();
                                continue block49;
                            }
                        }
                    }
                    string = Intrinsics.stringPlus((String)"Unexpected tag ", (Object)tag);
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                if (eventType == 2) continue;
            }
        }
        catch (IOException e) {
            this.client.log(e, null, new Object[0]);
        }
        catch (XmlPullParserException e) {
            this.client.log(e, null, new Object[0]);
        }
        if (this.project != null) {
            for (Incident incident : this.incidents) {
                incident.setProject(this.project);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void readIncidentHeader() {
        block15: {
            var2_2 = 0;
            n = this.parser.getAttributeCount();
            if (var2_2 >= n) break block15;
            do {
                i = var2_2++;
                name = this.parser.getAttributeName(i);
                value = this.parser.getAttributeValue(i);
                var6_7 = name;
                if (var6_7 == null) ** GOTO lbl-1000
                tmp = -1;
                switch (var6_7.hashCode()) {
                    case 1478300413: {
                        if (var6_7.equals("severity")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 3355: {
                        if (var6_7.equals("id")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case 954925063: {
                        if (var6_7.equals("message")) {
                            tmp = 3;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 2: {
                        this.issueId = value;
                        break;
                    }
                    case 3: {
                        this.message = value;
                        break;
                    }
                    case 1: {
                        Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                        this.severity = Severity.Companion.fromName(value);
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        var7_8 = Intrinsics.stringPlus((String)"Unexpected issue attribute: ", (Object)value);
                        var8_9 = false;
                        throw (Throwable)new IllegalStateException(var7_8.toString());
                    }
                }
            } while (var2_2 < n);
        }
        if (this.issueId == null || this.message == null) {
            var2_3 = "Missing required issue or message";
            var3_4 = false;
            throw (Throwable)new IllegalStateException(var2_3.toString());
        }
    }

    private final void readRange() {
        Location newLocation = this.readLocation();
        LintFix parentFix = this.getParentFix();
        if (parentFix instanceof LintFix.ReplaceString) {
            parentFix.setRange(newLocation);
        } else if (parentFix instanceof LintFix.SetAttribute) {
            parentFix.setRange(newLocation);
        } else if (parentFix instanceof LintFix.AnnotateFix) {
            parentFix.setRange(newLocation);
        } else {
            String string = "Unexpected parent of <range>";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    private final void readConfigInto() {
        Map map;
        Map map2;
        boolean bl;
        Object object;
        String id = this.parser.getAttributeValue(null, "id");
        String severityString = this.parser.getAttributeValue(null, "severity");
        if (id == null || severityString == null) {
            String string = "Missing required id or severity";
            boolean bl2 = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Object object2 = this.configs;
        if (object2 == null) {
            object = new HashMap();
            boolean bl3 = false;
            bl = false;
            Severity it = object;
            boolean bl4 = false;
            this.configs = (Map)it;
            map2 = (Map)object;
        } else {
            map2 = map = object2;
        }
        if (map.get(id) != null) {
            object2 = Intrinsics.stringPlus((String)"Should only specify one severity for issue ", (Object)id);
            boolean bl5 = false;
            throw (Throwable)new IllegalStateException(object2.toString());
        }
        object = Severity.Companion.fromName(severityString);
        if (object == null) {
            String string = Intrinsics.stringPlus((String)"Unknown severity ", (Object)severityString);
            bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Severity s = object;
        object = map;
        String string = id;
        bl = false;
        object.put(string, s);
    }

    /*
     * Unable to fully structure code
     */
    private final void readFixComposite() {
        block17: {
            tag = this.parser.getName();
            displayName = null;
            familyName = null;
            robot = false;
            independent = false;
            var7_7 = 0;
            n = this.parser.getAttributeCount();
            if (var7_7 >= n) break block17;
            do {
                i = var7_7++;
                name = this.parser.getAttributeName(i);
                value = this.parser.getAttributeValue(i);
                var11_13 = name;
                if (var11_13 == null) ** GOTO lbl-1000
                tmp = -1;
                switch (var11_13.hashCode()) {
                    case 0x67A6A6A: {
                        if (var11_13.equals("robot")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case -952207494: {
                        if (var11_13.equals("independent")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case -1724546052: {
                        if (var11_13.equals("description")) {
                            tmp = 3;
                        }
                        break;
                    }
                    case -1281860764: {
                        if (var11_13.equals("family")) {
                            tmp = 4;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 3: {
                        displayName = value;
                        break;
                    }
                    case 4: {
                        familyName = value;
                        break;
                    }
                    case 1: {
                        robot = true;
                        break;
                    }
                    case 2: {
                        independent = true;
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        var12_14 = Intrinsics.stringPlus((String)"Unexpected note attribute: ", (Object)name);
                        var13_15 = false;
                        throw (Throwable)new IllegalStateException(var12_14.toString());
                    }
                }
            } while (var7_7 < n);
        }
        fixList = new ArrayList<E>();
        type = Intrinsics.areEqual((Object)tag, (Object)"fix-alternatives") != false ? LintFix.GroupType.ALTERNATIVES : LintFix.GroupType.COMPOSITE;
        newFix = new LintFix.LintFixGroup(displayName, familyName, type, (List)fixList);
        newFix.autoFix(robot, independent);
        this.addFix((LintFix)newFix);
        this.fixLists.addLast(fixList);
    }

    /*
     * Unable to fully structure code
     */
    private final LintFix readCreateFile() {
        block39: {
            text = null;
            binary = null;
            selectPattern = null;
            reformat = false;
            displayName = null;
            familyName = null;
            robot = false;
            independent = false;
            file = null;
            delete = false;
            var12_12 = 0;
            n = this.parser.getAttributeCount();
            if (var12_12 >= n) break block39;
            do {
                i = var12_12++;
                name = this.parser.getAttributeName(i);
                value = this.parser.getAttributeValue(i);
                var16_18 = name;
                if (var16_18 == null) ** GOTO lbl-1000
                tmp = -1;
                switch (var16_18.hashCode()) {
                    case 0x67A6A6A: {
                        if (var16_18.equals("robot")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case -713337878: {
                        if (var16_18.equals("reformat")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case 3143036: {
                        if (var16_18.equals("file")) {
                            tmp = 3;
                        }
                        break;
                    }
                    case -67634444: {
                        if (var16_18.equals("selectPattern")) {
                            tmp = 4;
                        }
                        break;
                    }
                    case -952207494: {
                        if (var16_18.equals("independent")) {
                            tmp = 5;
                        }
                        break;
                    }
                    case -1388966911: {
                        if (var16_18.equals("binary")) {
                            tmp = 6;
                        }
                        break;
                    }
                    case -1724546052: {
                        if (var16_18.equals("description")) {
                            tmp = 7;
                        }
                        break;
                    }
                    case -1281860764: {
                        if (var16_18.equals("family")) {
                            tmp = 8;
                        }
                        break;
                    }
                    case -1335458389: {
                        if (var16_18.equals("delete")) {
                            tmp = 9;
                        }
                        break;
                    }
                    case 430919186: {
                        if (var16_18.equals("replacement")) {
                            tmp = 10;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 3: {
                        Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                        file = this.getFile(value);
                        break;
                    }
                    case 9: {
                        delete = Intrinsics.areEqual((Object)value, (Object)"true");
                        break;
                    }
                    case 10: {
                        text = value;
                        break;
                    }
                    case 6: {
                        binary = Base64.getDecoder().decode(value);
                        break;
                    }
                    case 4: {
                        selectPattern = value;
                        break;
                    }
                    case 2: {
                        reformat = true;
                        break;
                    }
                    case 7: {
                        displayName = value;
                        break;
                    }
                    case 8: {
                        familyName = value;
                        break;
                    }
                    case 5: {
                        independent = true;
                        break;
                    }
                    case 1: {
                        robot = true;
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        var17_19 = Intrinsics.stringPlus((String)"Unexpected fix attribute: ", (Object)name);
                        var18_20 = false;
                        throw (Throwable)new IllegalStateException(var17_19.toString());
                    }
                }
            } while (var12_12 < n);
        }
        builder = LintFix.Companion.create().name(displayName).sharedName(familyName);
        if (delete) {
            Intrinsics.checkNotNull(file);
            v0 = builder.deleteFile(file);
        } else if (text != null) {
            Intrinsics.checkNotNull(file);
            v0 = builder.newFile(file, text);
        } else {
            Intrinsics.checkNotNull(file);
            Intrinsics.checkNotNull(binary);
            v0 = builder.newFile(file, binary);
        }
        fix = v0;
        return fix.select(selectPattern).reformat(reformat).autoFix(robot, independent).build();
    }

    /*
     * Unable to fully structure code
     */
    private final LintFix readFixSetAttribute() {
        block32: {
            namespace = null;
            attributeName = null;
            attributeValue = null;
            dot = -2147483648;
            mark = -2147483648;
            displayName = null;
            familyName = null;
            robot = false;
            independent = false;
            var11_11 = 0;
            n = this.parser.getAttributeCount();
            if (var11_11 >= n) break block32;
            do {
                i = var11_11++;
                name = this.parser.getAttributeName(i);
                value = this.parser.getAttributeValue(i);
                var15_15 = name;
                if (var15_15 == null) ** GOTO lbl-1000
                tmp = -1;
                switch (var15_15.hashCode()) {
                    case 0x67A6A6A: {
                        if (var15_15.equals("robot")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case -952207494: {
                        if (var15_15.equals("independent")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case 1252218203: {
                        if (var15_15.equals("namespace")) {
                            tmp = 3;
                        }
                        break;
                    }
                    case 99657: {
                        if (var15_15.equals("dot")) {
                            tmp = 4;
                        }
                        break;
                    }
                    case -1724546052: {
                        if (var15_15.equals("description")) {
                            tmp = 5;
                        }
                        break;
                    }
                    case 13085340: {
                        if (var15_15.equals("attribute")) {
                            tmp = 6;
                        }
                        break;
                    }
                    case -1281860764: {
                        if (var15_15.equals("family")) {
                            tmp = 7;
                        }
                        break;
                    }
                    case 111972721: {
                        if (var15_15.equals("value")) {
                            tmp = 8;
                        }
                        break;
                    }
                    case 3344077: {
                        if (var15_15.equals("mark")) {
                            tmp = 9;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 3: {
                        namespace = value;
                        break;
                    }
                    case 6: {
                        attributeName = value;
                        break;
                    }
                    case 8: {
                        attributeValue = value;
                        break;
                    }
                    case 4: {
                        Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                        var16_16 = value;
                        var17_17 = false;
                        dot = Integer.parseInt(var16_16);
                        break;
                    }
                    case 9: {
                        Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                        var16_16 = value;
                        var17_17 = false;
                        mark = Integer.parseInt(var16_16);
                        break;
                    }
                    case 5: {
                        displayName = value;
                        break;
                    }
                    case 7: {
                        familyName = value;
                        break;
                    }
                    case 2: {
                        independent = true;
                        break;
                    }
                    case 1: {
                        robot = true;
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        var16_16 = Intrinsics.stringPlus((String)"Unexpected note attribute: ", (Object)name);
                        var17_17 = false;
                        throw (Throwable)new IllegalStateException(var16_16.toString());
                    }
                }
            } while (var11_11 < n);
        }
        Intrinsics.checkNotNull(attributeName);
        return LintFix.Companion.create().set().name(displayName).sharedName(familyName).namespace(namespace).attribute(attributeName).value(attributeValue).range(null).select(dot, mark).autoFix(robot, independent).build();
    }

    /*
     * Unable to fully structure code
     */
    private final LintFix readFixAnnotate() {
        block23: {
            source = null;
            replace = true;
            displayName = null;
            familyName = null;
            robot = false;
            independent = false;
            var8_8 = 0;
            n = this.parser.getAttributeCount();
            if (var8_8 >= n) break block23;
            do {
                i = var8_8++;
                name = this.parser.getAttributeName(i);
                value = this.parser.getAttributeValue(i);
                var12_12 = name;
                if (var12_12 == null) ** GOTO lbl-1000
                tmp = -1;
                switch (var12_12.hashCode()) {
                    case 0x67A6A6A: {
                        if (var12_12.equals("robot")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case -952207494: {
                        if (var12_12.equals("independent")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case 1094496948: {
                        if (var12_12.equals("replace")) {
                            tmp = 3;
                        }
                        break;
                    }
                    case -1724546052: {
                        if (var12_12.equals("description")) {
                            tmp = 4;
                        }
                        break;
                    }
                    case -896505829: {
                        if (var12_12.equals("source")) {
                            tmp = 5;
                        }
                        break;
                    }
                    case -1281860764: {
                        if (var12_12.equals("family")) {
                            tmp = 6;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 5: {
                        source = value;
                        break;
                    }
                    case 3: {
                        replace = true;
                        break;
                    }
                    case 4: {
                        displayName = value;
                        break;
                    }
                    case 6: {
                        familyName = value;
                        break;
                    }
                    case 2: {
                        independent = true;
                        break;
                    }
                    case 1: {
                        robot = true;
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        var13_13 = Intrinsics.stringPlus((String)"Unexpected note attribute: ", (Object)name);
                        var14_14 = false;
                        throw (Throwable)new IllegalStateException(var13_13.toString());
                    }
                }
            } while (var8_8 < n);
        }
        v0 = LintFix.Companion.create().name(displayName).sharedName(familyName);
        Intrinsics.checkNotNull(source);
        return v0.annotate(source, replace).autoFix(robot, independent).build();
    }

    /*
     * Unable to fully structure code
     */
    private final LintFix readFixShowUrl() {
        block14: {
            url = null;
            displayName = null;
            familyName = null;
            var5_5 = 0;
            n = this.parser.getAttributeCount();
            if (var5_5 >= n) break block14;
            do {
                i = var5_5++;
                name = this.parser.getAttributeName(i);
                value = this.parser.getAttributeValue(i);
                var9_9 = name;
                if (var9_9 == null) ** GOTO lbl-1000
                tmp = -1;
                switch (var9_9.hashCode()) {
                    case -1724546052: {
                        if (var9_9.equals("description")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case -1281860764: {
                        if (var9_9.equals("family")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case 116079: {
                        if (var9_9.equals("url")) {
                            tmp = 3;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 3: {
                        url = value;
                        break;
                    }
                    case 1: {
                        displayName = value;
                        break;
                    }
                    case 2: {
                        familyName = value;
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        var10_10 = Intrinsics.stringPlus((String)"Unexpected note attribute: ", (Object)name);
                        var11_11 = false;
                        throw (Throwable)new IllegalStateException(var10_10.toString());
                    }
                }
            } while (var5_5 < n);
        }
        v0 = LintFix.Companion.create().name(displayName).sharedName(familyName);
        Intrinsics.checkNotNull(url);
        return v0.url(url).build();
    }

    private final LintFix.DataMap readFixData() {
        HashMap map = new HashMap();
        String desc = null;
        String familyName = null;
        int n = 0;
        int n2 = this.parser.getAttributeCount();
        if (n < n2) {
            do {
                int i = n++;
                String name = this.parser.getAttributeName(i);
                String string = this.parser.getAttributeValue(i);
                Intrinsics.checkNotNull((Object)string);
                String value = string;
                string = name;
                if (Intrinsics.areEqual((Object)string, (Object)"description")) {
                    desc = value;
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"family")) {
                    familyName = value;
                    continue;
                }
                Map map2 = map;
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                String string2 = name;
                boolean bl = false;
                map2.put(string2, value);
            } while (n < n2);
        }
        return new LintFix.DataMap(desc, familyName, (Map)map);
    }

    /*
     * Unable to fully structure code
     */
    private final LintFix readFixReplace() {
        block35: {
            oldString = null;
            oldPattern = null;
            selectPattern = null;
            replacement = null;
            shortenNames = false;
            reformat = false;
            displayName = null;
            familyName = null;
            robot = false;
            independent = false;
            var12_12 = 0;
            n = this.parser.getAttributeCount();
            if (var12_12 >= n) break block35;
            do {
                i = var12_12++;
                name = this.parser.getAttributeName(i);
                value = this.parser.getAttributeValue(i);
                var16_17 = name;
                if (var16_17 == null) ** GOTO lbl-1000
                tmp = -1;
                switch (var16_17.hashCode()) {
                    case -1793911773: {
                        if (var16_17.equals("shortenNames")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 0x67A6A6A: {
                        if (var16_17.equals("robot")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case -713337878: {
                        if (var16_17.equals("reformat")) {
                            tmp = 3;
                        }
                        break;
                    }
                    case -67634444: {
                        if (var16_17.equals("selectPattern")) {
                            tmp = 4;
                        }
                        break;
                    }
                    case 1086188393: {
                        if (var16_17.equals("oldPattern")) {
                            tmp = 5;
                        }
                        break;
                    }
                    case -952207494: {
                        if (var16_17.equals("independent")) {
                            tmp = 6;
                        }
                        break;
                    }
                    case -1724546052: {
                        if (var16_17.equals("description")) {
                            tmp = 7;
                        }
                        break;
                    }
                    case 1523876120: {
                        if (var16_17.equals("oldString")) {
                            tmp = 8;
                        }
                        break;
                    }
                    case -1281860764: {
                        if (var16_17.equals("family")) {
                            tmp = 9;
                        }
                        break;
                    }
                    case 430919186: {
                        if (var16_17.equals("replacement")) {
                            tmp = 10;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 8: {
                        oldString = value;
                        break;
                    }
                    case 5: {
                        oldPattern = value;
                        break;
                    }
                    case 4: {
                        selectPattern = value;
                        break;
                    }
                    case 10: {
                        replacement = value;
                        break;
                    }
                    case 1: {
                        shortenNames = true;
                        break;
                    }
                    case 3: {
                        reformat = true;
                        break;
                    }
                    case 7: {
                        displayName = value;
                        break;
                    }
                    case 9: {
                        familyName = value;
                        break;
                    }
                    case 6: {
                        independent = true;
                        break;
                    }
                    case 2: {
                        robot = true;
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        var17_18 = Intrinsics.stringPlus((String)"Unexpected note attribute: ", (Object)name);
                        var18_19 = false;
                        throw (Throwable)new IllegalStateException(var17_18.toString());
                    }
                }
            } while (var12_12 < n);
        }
        return LintFix.Companion.create().replace().name(displayName).sharedName(familyName).text(oldString).pattern(oldPattern).select(selectPattern).with((var12_13 = replacement) == null ? "" : var12_13).shortenNames(shortenNames).reformat(reformat).autoFix(robot, independent).build();
    }

    private final File getFile(String path) {
        Project project;
        return this.client.getPathVariables().fromPathString(path, (project = this.project) == null ? null : project.getDir());
    }

    /*
     * Unable to fully structure code
     */
    private final Location readLocation() {
        block46: {
            file = null;
            line = null;
            endLine = null;
            column = "0";
            endColumn = "0";
            startOffset = null;
            endOffset = null;
            locationMessage = null;
            var10_10 = 0;
            n = this.parser.getAttributeCount();
            if (var10_10 >= n) break block46;
            do {
                i = var10_10++;
                name = this.parser.getAttributeName(i);
                value = this.parser.getAttributeValue(i);
                var14_21 = name;
                if (var14_21 == null) ** GOTO lbl-1000
                tmp = -1;
                switch (var14_21.hashCode()) {
                    case -1607481489: {
                        if (var14_21.equals("endLine")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 1146353681: {
                        if (var14_21.equals("endColumn")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case 1481410894: {
                        if (var14_21.equals("endOffset")) {
                            tmp = 3;
                        }
                        break;
                    }
                    case 3143036: {
                        if (var14_21.equals("file")) {
                            tmp = 4;
                        }
                        break;
                    }
                    case -1993948267: {
                        if (var14_21.equals("startOffset")) {
                            tmp = 5;
                        }
                        break;
                    }
                    case 3321844: {
                        if (var14_21.equals("line")) {
                            tmp = 6;
                        }
                        break;
                    }
                    case -1354837162: {
                        if (var14_21.equals("column")) {
                            tmp = 7;
                        }
                        break;
                    }
                    case 3355: {
                        if (var14_21.equals("id")) {
                            tmp = 8;
                        }
                        break;
                    }
                    case 954925063: {
                        if (var14_21.equals("message")) {
                            tmp = 9;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 4: {
                        Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                        file = this.getFile(value);
                        break;
                    }
                    case 6: {
                        line = value;
                        break;
                    }
                    case 1: {
                        endLine = value;
                        break;
                    }
                    case 7: {
                        Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                        column = value;
                        break;
                    }
                    case 2: {
                        Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                        endColumn = value;
                        break;
                    }
                    case 5: {
                        startOffset = value;
                        break;
                    }
                    case 3: {
                        endOffset = value;
                        break;
                    }
                    case 9: {
                        locationMessage = value;
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        var15_25 = Intrinsics.stringPlus((String)"Unexpected location attribute: ", (Object)value);
                        var16_28 = false;
                        throw (Throwable)new IllegalStateException(var15_25.toString());
                    }
                    case 8: 
                }
            } while (var10_10 < n);
        }
        if (file == null) {
            var10_11 = "Missing " + file + " attribute";
            i = 0;
            throw (Throwable)new IllegalStateException(var10_11.toString());
        }
        if (line == null && startOffset == null) {
            v0 = Location.Companion.create(file);
        } else {
            try {
                if (line != null) {
                    name = line;
                    var13_18 = false;
                    v1 = Integer.parseInt(name) - 1;
                } else {
                    v1 = -1;
                }
                name = column;
                var13_19 = 0;
                v2 = Integer.parseInt(name) - 1;
                name = startOffset;
                if (name == null) {
                    v3 = -1;
                } else {
                    var14_21 = name;
                    var15_26 = false;
                    v3 = var13_19 = Integer.parseInt(var14_21);
                }
                start = new DefaultPosition(v1, v2, v3);
                if (endLine != null) {
                    var13_20 = endLine;
                    var14_22 = false;
                    v4 = Integer.parseInt(var13_20) - 1;
                } else {
                    v4 = -1;
                }
                var13_17 = endColumn;
                var14_23 = 0;
                v5 = Integer.parseInt(var13_17) - 1;
                var13_17 = endOffset;
                if (var13_17 == null) {
                    v6 = -1;
                } else {
                    var15_27 = var13_17;
                    var16_29 = false;
                    v6 = var14_23 = Integer.parseInt(var15_27);
                }
                end = new DefaultPosition(v4, v5, v6);
                var11_14 = Location.Companion.create(file, (Position)start, (Position)end);
            }
            catch (NumberFormatException e) {
                var13_17 = Intrinsics.stringPlus((String)"Invalid number: ", (Object)e);
                var14_24 = false;
                throw (Throwable)new IllegalStateException(var13_17.toString());
            }
            v0 = newLocation = var11_14;
        }
        if (locationMessage != null) {
            newLocation.setMessage(locationMessage);
        }
        return newLocation;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Constraint readCondition() {
        int index = this.parser.getAttributeCount() == 2 ? 1 : 0;
        String name = this.parser.getAttributeName(index);
        String value = this.parser.getAttributeValue(index);
        String string = name;
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case 103899824: {
                    if (!string.equals("minGE")) break;
                    n = 1;
                    break;
                }
                case -441951527: {
                    if (!string.equals("targetLT")) break;
                    n = 2;
                    break;
                }
                case 92905304: {
                    if (!string.equals("allOf")) break;
                    n = 3;
                    break;
                }
                case 166208699: {
                    if (!string.equals("library")) break;
                    n = 4;
                    break;
                }
                case -441951697: {
                    if (!string.equals("targetGE")) break;
                    n = 5;
                    break;
                }
                case -861391249: {
                    if (!string.equals("android")) break;
                    n = 6;
                    break;
                }
                case 92977379: {
                    if (!string.equals("anyOf")) break;
                    n = 7;
                    break;
                }
                case 103899994: {
                    if (!string.equals("minLT")) break;
                    n = 8;
                    break;
                }
            }
            switch (n) {
                case 1: {
                    Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                    String string2 = value;
                    boolean bl = false;
                    Constraint constraint = Constraints.minSdkAtLeast((int)Integer.parseInt(string2));
                    return constraint;
                }
                case 8: {
                    Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                    String string3 = value;
                    boolean bl = false;
                    Constraint constraint = Constraints.minSdkLessThan((int)Integer.parseInt(string3));
                    return constraint;
                }
                case 5: {
                    Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                    String string4 = value;
                    boolean bl = false;
                    Constraint constraint = Constraints.targetSdkAtLeast((int)Integer.parseInt(string4));
                    return constraint;
                }
                case 2: {
                    Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                    String string5 = value;
                    boolean bl = false;
                    Constraint constraint = Constraints.targetSdkLessThan((int)Integer.parseInt(string5));
                    return constraint;
                }
                case 4: {
                    Constraint constraint;
                    if (Intrinsics.areEqual((Object)value, (Object)"true")) {
                        constraint = Constraints.isLibraryProject();
                        return constraint;
                    }
                    constraint = Constraints.notLibraryProject();
                    return constraint;
                }
                case 6: {
                    Constraint constraint;
                    if (Intrinsics.areEqual((Object)value, (Object)"true")) {
                        constraint = Constraints.isAndroidProject();
                        return constraint;
                    }
                    constraint = Constraints.notAndroidProject();
                    return constraint;
                }
                case 3: {
                    this.skipToNextTag();
                    Constraint left = this.readCondition();
                    this.skipToNextTag();
                    Constraint right = this.readCondition();
                    Constraint constraint = left.and(right);
                    return constraint;
                }
                case 7: {
                    this.skipToNextTag();
                    Constraint left = this.readCondition();
                    this.skipToNextTag();
                    Constraint right = this.readCondition();
                    Constraint constraint = left.or(right);
                    return constraint;
                }
            }
        }
        String string6 = "Unexpected condition attribute: " + name + '=' + value;
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string6.toString());
    }

    private final void skipToNextTag() {
        int eventType;
        while (this.parser.next() != 1 && (eventType = this.parser.getEventType()) != 2) {
        }
    }

    /*
     * Unable to fully structure code
     */
    private final LintMap readLintMap() {
        var1_1 = Intrinsics.areEqual((Object)this.parser.getName(), (Object)"map") != false || Intrinsics.areEqual((Object)this.parser.getName(), (Object)"data") != false;
        var2_3 = false;
        var3_5 = false;
        if (_Assertions.ENABLED && !var1_1) {
            var4_6 = false;
            var4_7 = "Assertion failed";
            throw (Throwable)new AssertionError((Object)var4_7);
        }
        lintMap = new LintMap();
        map = LintMap.Companion.getInternalMap(lintMap);
        block40: while (this.parser.next() != 1) {
            eventType = this.parser.getEventType();
            switch (eventType) {
                case 3: {
                    tag = this.parser.getName();
                    if (tag == null) ** GOTO lbl44
                    tmp = -1;
                    switch (tag.hashCode()) {
                        case 96667762: {
                            if (tag.equals("entry")) {
                                tmp = 1;
                            }
                            break;
                        }
                        case -861311717: {
                            if (tag.equals("condition")) {
                                tmp = 1;
                            }
                            break;
                        }
                        case 1901043637: {
                            if (tag.equals("location")) {
                                tmp = 1;
                            }
                            break;
                        }
                        case 107868: {
                            if (tag.equals("map")) {
                                tmp = 2;
                            }
                            break;
                        }
                    }
                    switch (tmp) {
                        case 1: {
                            continue block40;
                        }
                        case 2: {
                            return lintMap;
                        }
                    }
lbl44:
                    // 2 sources

                    var5_9 = Intrinsics.stringPlus((String)"Unexpected tag ", (Object)tag);
                    var6_16 = false;
                    throw (Throwable)new IllegalStateException(var5_9.toString());
                }
                case 2: {
                    tag = this.parser.getName();
                    if (tag == null) ** GOTO lbl186
                    tmp = -1;
                    switch (tag.hashCode()) {
                        case 96667762: {
                            if (tag.equals("entry")) {
                                tmp = 1;
                            }
                            break;
                        }
                        case -861311717: {
                            if (tag.equals("condition")) {
                                tmp = 2;
                            }
                            break;
                        }
                        case 1901043637: {
                            if (tag.equals("location")) {
                                tmp = 3;
                            }
                            break;
                        }
                        case 107868: {
                            if (tag.equals("map")) {
                                tmp = 4;
                            }
                            break;
                        }
                    }
                    switch (tmp) {
                        case 1: {
                            n = this.parser.getAttributeCount();
                            if (n != 2) {
                                var6_15 = "Expected key and value";
                                var7_19 = false;
                                throw (Throwable)new IllegalStateException(var6_15.toString());
                            }
                            noteKey = "";
                            noteValue = null;
                            var8_20 = 0;
                            if (var8_20 >= n) ** GOTO lbl147
                            do {
                                i = var8_20++;
                                name = this.parser.getAttributeName(i);
                                value = this.parser.getAttributeValue(i);
                                var12_32 = name;
                                if (var12_32 == null) ** GOTO lbl-1000
                                tmp = -1;
                                switch (var12_32.hashCode()) {
                                    case 1478300413: {
                                        if (var12_32.equals("severity")) {
                                            tmp = 1;
                                        }
                                        break;
                                    }
                                    case 64711720: {
                                        if (var12_32.equals("boolean")) {
                                            tmp = 2;
                                        }
                                        break;
                                    }
                                    case -891985903: {
                                        if (var12_32.equals("string")) {
                                            tmp = 3;
                                        }
                                        break;
                                    }
                                    case 3373707: {
                                        if (var12_32.equals("name")) {
                                            tmp = 4;
                                        }
                                        break;
                                    }
                                    case 104431: {
                                        if (var12_32.equals("int")) {
                                            tmp = 5;
                                        }
                                        break;
                                    }
                                }
                                switch (tmp) {
                                    case 4: {
                                        Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                                        noteKey = value;
                                        break;
                                    }
                                    case 5: {
                                        Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                                        var13_33 = value;
                                        var14_34 = false;
                                        noteValue = Integer.parseInt(var13_33);
                                        break;
                                    }
                                    case 2: {
                                        Intrinsics.checkNotNull((Object)value);
                                        var13_33 = value;
                                        var14_34 = false;
                                        noteValue = Boolean.parseBoolean(var13_33);
                                        break;
                                    }
                                    case 1: {
                                        Intrinsics.checkNotNull((Object)value);
                                        noteValue = Severity.Companion.fromName(value);
                                        break;
                                    }
                                    case 3: {
                                        noteValue = value;
                                        break;
                                    }
                                    default: lbl-1000:
                                    // 2 sources

                                    {
                                        var13_33 = Intrinsics.stringPlus((String)"Unexpected note attribute: ", (Object)name);
                                        var14_34 = false;
                                        throw (Throwable)new IllegalStateException(var13_33.toString());
                                    }
                                }
                            } while (var8_20 < n);
lbl147:
                            // 2 sources

                            var8_21 = map;
                            Intrinsics.checkNotNull(noteValue);
                            var9_27 = noteValue;
                            var10_29 = false;
                            var8_21.put(noteKey, var9_27);
                            continue block40;
                        }
                        case 4: {
                            noteKey = this.parser.getAttributeValue(null, "id");
                            if (noteKey == null) {
                                var7_18 = "No key on nested map";
                                var8_22 = false;
                                throw (Throwable)new IllegalStateException(var7_18.toString());
                            }
                            mapName = noteKey;
                            nestedNode = this.readLintMap();
                            var7_18 = map;
                            var8_23 = false;
                            var7_18.put(mapName, nestedNode);
                            continue block40;
                        }
                        case 3: {
                            id = this.parser.getAttributeValue(null, "id");
                            location = this.readLocation();
                            var7_18 = map;
                            Intrinsics.checkNotNullExpressionValue((Object)id, (String)"id");
                            var8_24 = id;
                            var9_28 = false;
                            var7_18.put(var8_24, location);
                            continue block40;
                        }
                        case 2: {
                            location = this.parser.getAttributeValue(null, "id");
                            id = location == null ? "_condition_" : location;
                            condition = this.readCondition();
                            var7_18 = map;
                            var8_25 = false;
                            var7_18.put(id, condition);
                            continue block40;
                        }
                    }
lbl186:
                    // 2 sources

                    var5_14 = Intrinsics.stringPlus((String)"Unexpected tag ", (Object)tag);
                    var6_17 = false;
                    throw (Throwable)new IllegalStateException(var5_14.toString());
                }
            }
        }
        return lintMap;
    }
}

