/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.LintStats;
import com.android.tools.lint.Main;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.ReporterKt;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.Vendor;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.SdkUtils;
import com.google.common.annotations.Beta;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\rJ\u001c\u0010\u001c\u001a\u00020\u001d2\n\u0010\u001e\u001a\u00060\u001fj\u0002` 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\"2\u0006\u0010!\u001a\u00020\"H\u0002J\u001e\u0010$\u001a\u00020\u001d2\n\u0010%\u001a\u00060\u001fj\u0002` 2\b\u0010&\u001a\u0004\u0018\u00010'H\u0002J\u000e\u0010(\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\tJ\u001e\u0010)\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0016\"\u0004\b\u001a\u0010\u0018R\u000e\u0010\u001b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/android/tools/lint/TextReporter;", "Lcom/android/tools/lint/Reporter;", "client", "Lcom/android/tools/lint/LintCliClient;", "flags", "Lcom/android/tools/lint/LintCliFlags;", "writer", "Ljava/io/Writer;", "close", "", "(Lcom/android/tools/lint/LintCliClient;Lcom/android/tools/lint/LintCliFlags;Ljava/io/Writer;Z)V", "file", "Ljava/io/File;", "(Lcom/android/tools/lint/LintCliClient;Lcom/android/tools/lint/LintCliFlags;Ljava/io/File;Ljava/io/Writer;Z)V", "format", "Lcom/android/tools/lint/detector/api/TextFormat;", "getFormat", "()Lcom/android/tools/lint/detector/api/TextFormat;", "setFormat", "(Lcom/android/tools/lint/detector/api/TextFormat;)V", "includeSecondaryLineContent", "getIncludeSecondaryLineContent", "()Z", "setIncludeSecondaryLineContent", "(Z)V", "isForwardSlashPaths", "setForwardSlashPaths", "writeStats", "appendPath", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "path", "", "convertPath", "explainIssue", "output", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "setWriteStats", "write", "stats", "Lcom/android/tools/lint/LintStats;", "issues", "", "Lcom/android/tools/lint/detector/api/Incident;", "unnamed"})
@Beta
public final class TextReporter
extends Reporter {
    @NotNull
    private final LintCliFlags flags;
    @NotNull
    private final Writer writer;
    private final boolean close;
    @NotNull
    private TextFormat format;
    private boolean isForwardSlashPaths;
    private boolean includeSecondaryLineContent;
    private boolean writeStats;

    public TextReporter(@NotNull LintCliClient client, @NotNull LintCliFlags flags, @Nullable File file, @NotNull Writer writer, boolean close) {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        super(client, file);
        this.flags = flags;
        this.writer = writer;
        this.close = close;
        this.format = TextFormat.TEXT;
        this.writeStats = true;
    }

    @NotNull
    public final TextFormat getFormat() {
        return this.format;
    }

    public final void setFormat(@NotNull TextFormat textFormat) {
        Intrinsics.checkNotNullParameter((Object)textFormat, (String)"<set-?>");
        this.format = textFormat;
    }

    public final boolean isForwardSlashPaths() {
        return this.isForwardSlashPaths;
    }

    public final void setForwardSlashPaths(boolean bl) {
        this.isForwardSlashPaths = bl;
    }

    public final boolean getIncludeSecondaryLineContent() {
        return this.includeSecondaryLineContent;
    }

    public final void setIncludeSecondaryLineContent(boolean bl) {
        this.includeSecondaryLineContent = bl;
    }

    public TextReporter(@NotNull LintCliClient client, @NotNull LintCliFlags flags, @NotNull Writer writer, boolean close) {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        this(client, flags, null, writer, close);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void write(@NotNull LintStats stats, @NotNull List<Incident> issues) throws IOException {
        block28: {
            block27: {
                Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
                Intrinsics.checkNotNullParameter(issues, (String)"issues");
                abbreviate = this.flags.isShowEverything() == false;
                output = new StringBuilder(issues.size() * 200);
                if (!issues.isEmpty()) break block27;
                if (this.isDisplayEmpty() && this.writeStats) {
                    this.writer.write("No issues found");
                    if (stats.getBaselineErrorCount() > 0 || stats.getBaselineWarningCount() > 0) {
                        var7_5 = this.flags.getBaselineFile();
                        Intrinsics.checkNotNull((Object)var7_5);
                        var6_8 = var7_5;
                        baselineFile = var6_8;
                        counts = Lint.describeCounts((int)stats.getBaselineErrorCount(), (int)stats.getBaselineWarningCount(), (boolean)true, (boolean)true);
                        this.writer.write(" (" + (String)counts + " filtered by baseline " + baselineFile.getName() + ')');
                    }
                    this.writer.write(46);
                    this.writer.write(10);
                    this.writer.flush();
                }
                break block28;
            }
            lastIssue = null;
            for (Object incident : issues) {
                block29: {
                    issue = incident.getIssue();
                    if (issue != lastIssue) {
                        this.explainIssue(output, lastIssue);
                        lastIssue = issue;
                    }
                    startLength = output.length();
                    displayPath = incident.getDisplayPath();
                    this.appendPath(output, displayPath);
                    output.append(':');
                    if (incident.getLine() >= 0) {
                        output.append(String.valueOf(incident.getLine() + 1));
                        output.append(':');
                    }
                    if (startLength < output.length()) {
                        output.append(' ');
                    }
                    if ((severity = incident.getSeverity()) == Severity.FATAL) {
                        severity = Severity.ERROR;
                    }
                    output.append(severity.getDescription());
                    output.append(':');
                    output.append(' ');
                    output.append(TextFormat.RAW.convertTo(incident.getMessage(), this.format));
                    output.append(' ').append('[');
                    output.append(issue.getId());
                    var13_15 /* !! */  = issue.getVendor();
                    var13_15 /* !! */  = from = var13_15 /* !! */  == null ? ((var14_16 /* !! */  = issue.getRegistry()) == null ? null : var14_16 /* !! */ .getVendor()) : var13_15 /* !! */ ;
                    if (var13_15 /* !! */  != null && (var14_16 /* !! */  = var13_15 /* !! */ .getIdentifier()) != null) {
                        var15_19 /* !! */  = var14_16 /* !! */ ;
                        var16_21 = false;
                        var17_24 = false;
                        identifier /* !! */  = var15_19 /* !! */ ;
                        $i$a$-let-TextReporter$write$1 = false;
                        if (!Intrinsics.areEqual((Object)from, (Object)IssueRegistry.Companion.getAOSP_VENDOR())) {
                            var20_37 = (CharSequence)identifier /* !! */ ;
                            var21_40 = false;
                            if (StringsKt.isBlank((CharSequence)var20_37) == false) {
                                output.append(" from ");
                                output.append(TextFormat.RAW.convertTo((String)identifier /* !! */ , this.getFormat()));
                            }
                        }
                    }
                    output.append(']');
                    output.append('\n');
                    if (incident.getWasAutoFixed()) {
                        output.append("This issue has been automatically fixed.\n");
                    }
                    if (this.flags.isShowSourceLines() && (var13_15 /* !! */  = ReporterKt.getErrorLines((Incident)incident, (Function1<? super File, ? extends CharSequence>)((Function1)new Function1<File, CharSequence>(this){
                        final /* synthetic */ TextReporter this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        @Nullable
                        public final CharSequence invoke(@NotNull File it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return this.this$0.client.getSourceText(it);
                        }
                    }))) != null) {
                        var14_16 /* !! */  = var13_15 /* !! */ ;
                        var15_20 = false;
                        var16_21 = false;
                        it /* !! */  = var14_16 /* !! */ ;
                        $i$a$-let-TextReporter$write$3 = false;
                        $i$a$-let-TextReporter$write$1 = (CharSequence)it /* !! */ ;
                        var20_38 = false;
                        if ($i$a$-let-TextReporter$write$1.length() > 0) {
                            output.append((String)it /* !! */ );
                        }
                    }
                    if (incident.getLocation().getSecondary() == null) break block29;
                    omitted = false;
                    for (location = incident.getLocation().getSecondary(); location != null; location = location.getSecondary()) {
                        locationMessage = location.getMessage();
                        if (locationMessage == null) ** GOTO lbl-1000
                        var16_22 = locationMessage;
                        it = false;
                        if (var16_22.length() > 0) {
                            output.append("    ");
                            path = this.client.getDisplayPath(incident.getProject(), location.getFile());
                            this.appendPath(output, path);
                            start = location.getStart();
                            if (start != null && (line = start.getLine()) >= 0) {
                                output.append(':');
                                output.append(String.valueOf(line + 1));
                            }
                            output.append(':');
                            output.append(' ');
                            output.append(TextFormat.RAW.convertTo(locationMessage, this.format));
                            output.append('\n');
                        } else lbl-1000:
                        // 2 sources

                        {
                            omitted = true;
                        }
                        if (!this.flags.isShowSourceLines() || !this.includeSecondaryLineContent || (path = ReporterKt.getErrorLines(location, (Function1<? super File, ? extends CharSequence>)((Function1)new Function1<File, CharSequence>(this){
                            final /* synthetic */ TextReporter this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            @Nullable
                            public final CharSequence invoke(@NotNull File it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                return this.this$0.client.getSourceText(it);
                            }
                        }))) == null) continue;
                        start = path;
                        line = false;
                        $i$a$-let-TextReporter$write$1 = false;
                        it = start;
                        $i$a$-let-TextReporter$write$5 = false;
                        var22_41 = it;
                        var23_42 = false;
                        if (!(var22_41.length() > 0)) continue;
                        output.append(it);
                    }
                    if (!abbreviate && omitted) {
                        sb = new StringBuilder(100);
                        sb.append("Also affects: ");
                        begin = sb.length();
                        for (location = incident.getLocation().getSecondary(); location != null; location = location.getSecondary()) {
                            locationMessage = location.getMessage();
                            if (locationMessage != null) {
                                line = locationMessage;
                                $i$a$-let-TextReporter$write$1 = false;
                                if (!(line.length() == 0)) continue;
                            }
                            if (sb.length() > begin) {
                                sb.append(", ");
                            }
                            path = this.client.getDisplayPath(incident.getProject(), location.getFile());
                            this.appendPath(sb, path);
                            start = location.getStart();
                            if (start == null || (line = start.getLine()) < 0) continue;
                            sb.append(':');
                            sb.append(String.valueOf(line + 1));
                        }
                        wrapped = Main.wrap(sb.toString(), 78, "     ");
                        output.append(wrapped);
                    }
                }
                if ((applicableVariants = incident.getApplicableVariants()) == null || !applicableVariants.getVariantSpecific()) continue;
                if (applicableVariants.includesMoreThanExcludes()) {
                    output.append("Applies to variants: ");
                    v0 = applicableVariants.getIncludedVariantNames();
                } else {
                    output.append("Does not apply to variants: ");
                    v0 = applicableVariants.getExcludedVariantNames();
                }
                names = v0;
                output.append(Joiner.on((String)", ").join((Iterable)names));
                output.append('\n');
            }
            this.explainIssue(output, lastIssue);
            this.writer.write(output.toString());
            if (this.writeStats) {
                this.writer.write(stats.getErrorCount() + " errors, " + stats.getWarningCount() + " warnings");
                if (stats.getBaselineErrorCount() > 0 || stats.getBaselineWarningCount() > 0) {
                    var8_10 = this.flags.getBaselineFile();
                    Intrinsics.checkNotNull((Object)var8_10);
                    baselineFile = incident = var8_10;
                    counts = Lint.describeCounts((int)stats.getBaselineErrorCount(), (int)stats.getBaselineWarningCount(), (boolean)true, (boolean)true);
                    this.writer.write(" (" + counts + " filtered by baseline " + baselineFile.getName() + ')');
                }
            }
            this.writer.write(10);
            this.writer.flush();
        }
        if (this.close) {
            this.writer.close();
            if (!this.client.getFlags().isQuiet() && this.getOutput() != null) {
                var6_8 = this.getOutput().getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)var6_8, (String)"this.output.absolutePath");
                path = this.convertPath((String)var6_8);
                var6_8 = Intrinsics.stringPlus((String)"Wrote text report to ", (Object)path);
                var7_7 = false;
                System.out.println(var6_8);
            }
        }
    }

    private final void appendPath(StringBuilder sb, String path) {
        sb.append(this.convertPath(path));
    }

    private final String convertPath(String path) {
        return this.isForwardSlashPaths ? (File.separatorChar == '/' ? path : StringsKt.replace$default((String)path, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null)) : path;
    }

    private final void explainIssue(StringBuilder output, Issue issue) {
        IssueRegistry issueRegistry;
        Vendor vendor;
        Vendor issueVendor;
        if (issue == null || !this.flags.isExplainIssues() || issue == IssueRegistry.LINT_ERROR || issue == IssueRegistry.LINT_WARNING || issue == IssueRegistry.BASELINE) {
            return;
        }
        String explanation = issue.getExplanation(this.format);
        CharSequence $this$trim$iv = explanation;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv2 = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv2 <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv2 : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv2;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        $this$trim$iv = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv2, endIndex$iv$iv + 1)).toString();
        $i$f$trim = false;
        if ($this$trim$iv.length() == 0) {
            return;
        }
        String indent = "   ";
        String formatted = SdkUtils.wrap((String)explanation, (int)(78 - indent.length()), null);
        output.append('\n');
        output.append(indent);
        output.append("Explanation for issues of type \"").append(issue.getId()).append("\":\n");
        for (String line2 : Splitter.on((char)'\n').split((CharSequence)formatted)) {
            Intrinsics.checkNotNullExpressionValue((Object)line2, (String)"line");
            CharSequence startIndex$iv$iv2 = line2;
            boolean bl = false;
            if (startIndex$iv$iv2.length() > 0) {
                output.append(indent);
                output.append(line2);
            }
            output.append('\n');
        }
        List moreInfo = issue.getMoreInfo();
        Collection line2 = moreInfo;
        startIndex$iv$iv2 = 0;
        if (!line2.isEmpty()) {
            for (String url : moreInfo) {
                Intrinsics.checkNotNullExpressionValue((Object)formatted, (String)"formatted");
                if (StringsKt.contains$default((CharSequence)formatted, (CharSequence)url, (boolean)false, (int)2, null)) continue;
                output.append(indent);
                output.append(url);
                output.append('\n');
            }
            output.append('\n');
        }
        vendor = issueVendor = (vendor = issue.getVendor()) == null ? ((issueRegistry = issue.getRegistry()) == null ? null : issueRegistry.getVendor()) : vendor;
        if (vendor != null) {
            Vendor vendor2 = vendor;
            boolean bl = false;
            boolean bl3 = false;
            Vendor vendor3 = vendor2;
            boolean bl4 = false;
            if (!Intrinsics.areEqual((Object)vendor3, (Object)IssueRegistry.Companion.getAOSP_VENDOR())) {
                vendor3.describeInto(output, this.getFormat(), indent);
                output.append('\n');
            }
        }
    }

    public final void setWriteStats(boolean writeStats) {
        this.writeStats = writeStats;
    }
}

