/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.ide.common.blame.SourcePosition;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Severity;
import com.android.utils.PositionXmlParser;
import com.android.utils.XmlUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u0016\u0018\u0000 J2\u00020\u0001:\u0004JKLMB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\"\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\"\u0010\u0015\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\"\u0010\u001d\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\"\u0010 \u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010!\u001a\u00020\"2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J8\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020'2\u0006\u0010*\u001a\u00020'2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010+\u001a\u00020\u00052\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\r0-H\u0002J\u001c\u0010.\u001a\b\u0012\u0004\u0012\u00020\r0-2\u0006\u0010/\u001a\u0002002\u0006\u0010\u0017\u001a\u00020\u0018J\u001c\u00101\u001a\b\u0012\u0004\u0012\u00020\r0-2\f\u00102\u001a\b\u0012\u0004\u0012\u0002000-H\u0002J \u00103\u001a\u00020'2\u0006\u00104\u001a\u00020\u001a2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u001aH\u0002J\u0016\u00108\u001a\u00020\u00052\f\u00109\u001a\b\u0012\u0004\u0012\u00020:0-H\u0002J\u001c\u0010\u0013\u001a\u00020\u00052\u0006\u0010/\u001a\u0002002\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00180-J(\u0010\u0013\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020;2\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00180-2\b\b\u0002\u0010<\u001a\u00020\u001aH\u0007J\u0014\u0010\u0013\u001a\u00020\u00052\f\u00102\u001a\b\u0012\u0004\u0012\u0002000-J$\u0010=\u001a\u00020\r2\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020\r0?2\u0006\u0010\f\u001a\u00020;H\u0002J4\u0010\u0004\u001a\u00020$2\u0006\u0010@\u001a\u00020A2\u0012\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020'0?2\u0006\u0010C\u001a\u00020'2\u0006\u0010D\u001a\u00020'H\u0014J,\u0010E\u001a\u00020$2\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020\r0?2\u0006\u0010/\u001a\u0002002\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001a\u0010F\u001a\u00020$2\u0006\u0010G\u001a\u00020\r2\b\u0010H\u001a\u0004\u0018\u00010IH\u0014J\u0018\u0010F\u001a\u00020$2\u0006\u0010G\u001a\u00020\r2\u0006\u0010H\u001a\u00020\u001aH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lcom/android/tools/lint/LintFixPerformer;", "", "client", "Lcom/android/tools/lint/LintCliClient;", "printStatistics", "", "requireAutoFixable", "includeMarkers", "(Lcom/android/tools/lint/LintCliClient;ZZZ)V", "getClient", "()Lcom/android/tools/lint/LintCliClient;", "addAnnotation", "file", "Lcom/android/tools/lint/LintFixPerformer$PendingEditFile;", "annotateFix", "Lcom/android/tools/lint/detector/api/LintFix$AnnotateFix;", "fixLocation", "Lcom/android/tools/lint/detector/api/Location;", "addCreateFile", "fix", "Lcom/android/tools/lint/detector/api/LintFix$CreateFileFix;", "addEdits", "location", "lintFix", "Lcom/android/tools/lint/detector/api/LintFix;", "addMarkers", "", "fileData", "fileContents", "addReplaceString", "replaceFix", "Lcom/android/tools/lint/detector/api/LintFix$ReplaceString;", "addSetAttribute", "setFix", "Lcom/android/tools/lint/detector/api/LintFix$SetAttribute;", "addValueSelection", "", "value", "dot", "", "mark", "startOffset", "valueOffset", "applyEdits", "files", "", "computeEdits", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "findApplicableFixes", "incidents", "findAttributeInsertionOffset", "xml", "element", "Lorg/w3c/dom/Element;", "attributeName", "findConflicts", "fixes", "Lcom/android/tools/lint/LintFixPerformer$PendingEdit;", "Ljava/io/File;", "text", "getFileData", "fileMap", "", "writer", "Ljava/io/PrintWriter;", "editMap", "appliedEditCount", "editedFileCount", "registerFix", "writeFile", "pendingFile", "contents", "", "Companion", "PendingEdit", "PendingEditFile", "Selection", "unnamed"})
public class LintFixPerformer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LintCliClient client;
    private final boolean printStatistics;
    private final boolean requireAutoFixable;
    private final boolean includeMarkers;

    public LintFixPerformer(@NotNull LintCliClient client, boolean printStatistics, boolean requireAutoFixable, boolean includeMarkers) {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        this.client = client;
        this.printStatistics = printStatistics;
        this.requireAutoFixable = requireAutoFixable;
        this.includeMarkers = includeMarkers;
    }

    public /* synthetic */ LintFixPerformer(LintCliClient lintCliClient, boolean bl, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        this(lintCliClient, bl, bl2, bl3);
    }

    @NotNull
    public final LintCliClient getClient() {
        return this.client;
    }

    private final PendingEditFile getFileData(Map<File, PendingEditFile> fileMap, File file) {
        PendingEditFile pendingEditFile;
        PendingEditFile pendingEditFile2 = fileMap.get(file);
        if (pendingEditFile2 == null) {
            LintFixPerformer lintFixPerformer = this;
            boolean bl = false;
            boolean bl2 = false;
            LintFixPerformer $this$getFileData_u24lambda_u2d0 = lintFixPerformer;
            boolean bl3 = false;
            CharSequence source = $this$getFileData_u24lambda_u2d0.getClient().getSourceText(file);
            PendingEditFile fileData = new PendingEditFile($this$getFileData_u24lambda_u2d0.getClient(), file, ((Object)source).toString());
            Map<File, PendingEditFile> map = fileMap;
            boolean bl4 = false;
            map.put(file, fileData);
            pendingEditFile = fileData;
        } else {
            pendingEditFile = pendingEditFile2;
        }
        return pendingEditFile;
    }

    private final void registerFix(Map<File, PendingEditFile> fileMap, Incident incident, LintFix lintFix) {
        Location location = Companion.getLocation(incident, lintFix);
        PendingEditFile fileData = this.getFileData(fileMap, location.getFile());
        if (this.addEdits(fileData, location, lintFix)) {
            incident.setWasAutoFixed(true);
        }
    }

    public final boolean fix(@NotNull List<Incident> incidents) {
        Intrinsics.checkNotNullParameter(incidents, (String)"incidents");
        List<PendingEditFile> files = this.findApplicableFixes(incidents);
        return this.applyEdits(files);
    }

    public final boolean fix(@NotNull Incident incident, @NotNull List<? extends LintFix> fixes) {
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter(fixes, (String)"fixes");
        boolean bl = false;
        Map fileMap = new LinkedHashMap();
        for (LintFix lintFix : fixes) {
            if (!Companion.canAutoFix(lintFix, this.requireAutoFixable)) continue;
            this.registerFix(fileMap, incident, lintFix);
        }
        return this.applyEdits(CollectionsKt.toList((Iterable)fileMap.values()));
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final boolean fix(@NotNull File file, @NotNull List<? extends LintFix> fixes, @NotNull String text) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(fixes, (String)"fixes");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        PendingEditFile pendingEditFile = new PendingEditFile(this.client, file, text);
        Iterable $this$filter$iv = fixes;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LintFix it = (LintFix)element$iv$iv;
            boolean bl = false;
            if (!Companion.canAutoFix(it, this.requireAutoFixable)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LintFix it = (LintFix)element$iv;
            boolean bl = false;
            this.addEdits(pendingEditFile, null, it);
        }
        return this.applyEdits(CollectionsKt.listOf((Object)pendingEditFile));
    }

    public static /* synthetic */ boolean fix$default(LintFixPerformer lintFixPerformer, File file, List list2, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: fix");
        }
        if ((n & 4) != 0) {
            string = FilesKt.readText((File)file, (Charset)Charsets.UTF_8);
        }
        return lintFixPerformer.fix(file, list2, string);
    }

    private final boolean applyEdits(List<PendingEditFile> files) {
        int appliedEditCount = 0;
        int editedFileCount = 0;
        boolean bl = false;
        Map editMap = new LinkedHashMap();
        for (PendingEditFile fileData : files) {
            List edits;
            String newText = fileData.getCreateText();
            if (newText != null) {
                this.writeFile(fileData, this.addMarkers(fileData, newText));
            } else if (fileData.getCreateBytes() != null) {
                this.writeFile(fileData, fileData.getCreateBytes());
            } else if (fileData.getDelete()) {
                this.writeFile(fileData, (byte[])null);
                continue;
            }
            if (fileData.getEdits().isEmpty() || this.findConflicts(edits = SequencesKt.toList((Sequence)SequencesKt.distinct((Sequence)SequencesKt.sorted((Sequence)CollectionsKt.asSequence((Iterable)fileData.getEdits())))))) continue;
            String fileContents = fileData.getInitialText();
            for (PendingEdit edit : edits) {
                int n = appliedEditCount;
                appliedEditCount = n + 1;
                String key = edit.fixName();
                Object object = (Integer)editMap.get(key);
                int count = object == null ? 0 : (Integer)object;
                object = editMap;
                Object object2 = count + 1;
                boolean bl2 = false;
                object.put(key, object2);
                fileContents = edit.apply(fileContents);
                object = fileData.getSelection();
                if (object == null) continue;
                object2 = object;
                bl2 = false;
                boolean bl3 = false;
                Object it = object2;
                boolean bl4 = false;
                int n2 = ((Selection)it).getDot();
                int n3 = ((Selection)it).getMark();
                int n4 = 0;
                int dot = Math.min(n2, n3);
                n3 = ((Selection)it).getDot();
                n4 = ((Selection)it).getMark();
                boolean bl5 = false;
                int mark = Math.max(n3, n4);
                if (dot == Integer.MIN_VALUE) continue;
                ((Selection)it).setDot(edit.adjustOffset(dot, true));
                if (mark == Integer.MIN_VALUE) continue;
                ((Selection)it).setMark(edit.adjustOffset(mark, false));
            }
            fileContents = this.addMarkers(fileData, fileContents);
            this.writeFile(fileData, fileContents);
            int n = editedFileCount;
            editedFileCount = n + 1;
        }
        if (this.printStatistics && editedFileCount > 0) {
            this.printStatistics(new PrintWriter(System.out), editMap, appliedEditCount, editedFileCount);
        }
        return editedFileCount > 0;
    }

    private final String addMarkers(PendingEditFile fileData, String fileContents) {
        Selection selection;
        if (this.includeMarkers && (selection = fileData.getSelection()) != null) {
            String string;
            int n;
            Matcher matcher;
            Selection selection2 = selection;
            boolean bl = false;
            boolean bl2 = false;
            Selection it = selection2;
            boolean bl3 = false;
            Selection selection3 = it;
            Pattern pattern = selection3.component1();
            int offset = selection3.component2();
            int mark = selection3.component3();
            int selectStart = 0;
            int selectEnd = 0;
            Object object = pattern;
            Matcher matcher2 = matcher = object == null ? null : ((Pattern)object).matcher(fileContents);
            if (matcher != null && matcher.find(offset)) {
                if (matcher.groupCount() > 0) {
                    selectStart = matcher.start(1);
                    selectEnd = matcher.end(1);
                } else {
                    selectStart = matcher.start();
                    selectEnd = matcher.end();
                }
            } else if (pattern == null && offset != Integer.MIN_VALUE) {
                int effectiveMark = mark != Integer.MIN_VALUE ? mark : offset;
                n = 0;
                selectStart = Math.min(offset, effectiveMark);
                n = 0;
                selectEnd = Math.max(offset, effectiveMark);
            } else {
                return fileContents;
            }
            if (selectStart == selectEnd) {
                StringBuilder stringBuilder = new StringBuilder();
                object = fileContents;
                n = 0;
                boolean bl4 = false;
                Object object2 = object;
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = ((String)object2).substring(n, selectStart);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                StringBuilder stringBuilder2 = stringBuilder.append(string2).append('|');
                object = fileContents;
                n = 0;
                Object object3 = object;
                if (object3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = ((String)object3).substring(selectEnd);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                string = stringBuilder2.append(string3).toString();
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                object = fileContents;
                n = 0;
                boolean bl5 = false;
                Object object4 = object;
                if (object4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = ((String)object4).substring(n, selectStart);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                StringBuilder stringBuilder3 = stringBuilder.append(string4).append('[');
                object = fileContents;
                n = 0;
                Object object5 = object;
                if (object5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = ((String)object5).substring(selectStart, selectEnd);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                StringBuilder stringBuilder4 = stringBuilder3.append(string5).append("]|");
                object = fileContents;
                n = 0;
                Object object6 = object;
                if (object6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = ((String)object6).substring(selectEnd);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
                string = stringBuilder4.append(string6).toString();
            }
            return string;
        }
        return fileContents;
    }

    protected void printStatistics(@NotNull PrintWriter writer, @NotNull Map<String, Integer> editMap, int appliedEditCount, int editedFileCount) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter(editMap, (String)"editMap");
        if (editMap.keySet().size() == 1) {
            writer.println("Applied " + appliedEditCount + " edits across " + editedFileCount + " files for this fix: " + (String)CollectionsKt.first((Iterable)editMap.keySet()));
        } else {
            writer.println("Applied " + appliedEditCount + " edits across " + editedFileCount + " files");
            Map<String, Integer> $this$forEach$iv = editMap;
            boolean $i$f$forEach = false;
            Map<String, Integer> map = $this$forEach$iv;
            boolean bl = false;
            Iterator<Map.Entry<String, Integer>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Integer> element$iv;
                Map.Entry<String, Integer> $dstr$name$count = element$iv = iterator.next();
                boolean bl2 = false;
                Map.Entry<String, Integer> entry = $dstr$name$count;
                boolean bl3 = false;
                String name = entry.getKey();
                Map.Entry<String, Integer> entry2 = $dstr$name$count;
                boolean bl4 = false;
                int count = ((Number)entry2.getValue()).intValue();
                writer.println(count + ": " + name);
            }
        }
    }

    protected void writeFile(@NotNull PendingEditFile pendingFile, @NotNull String contents) {
        Intrinsics.checkNotNullParameter((Object)pendingFile, (String)"pendingFile");
        Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
        String string = contents;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        this.writeFile(pendingFile, byArray);
    }

    protected void writeFile(@NotNull PendingEditFile pendingFile, @Nullable byte[] contents) {
        Intrinsics.checkNotNullParameter((Object)pendingFile, (String)"pendingFile");
        if (contents == null) {
            pendingFile.getFile().delete();
        } else {
            File file = pendingFile.getFile().getParentFile();
            if (file != null) {
                file.mkdirs();
            }
            FilesKt.writeBytes((File)pendingFile.getFile(), (byte[])contents);
        }
    }

    private final List<PendingEditFile> findApplicableFixes(List<Incident> incidents) {
        boolean bl = false;
        Map fileMap = new LinkedHashMap();
        for (Incident incident : incidents) {
            LintFix lintFix = incident.getFix();
            if (lintFix == null) continue;
            LintFix data = lintFix;
            if (data instanceof LintFix.LintFixGroup) {
                if (((LintFix.LintFixGroup)data).getType() != LintFix.GroupType.COMPOSITE) continue;
                boolean all = true;
                for (LintFix sub : ((LintFix.LintFixGroup)data).getFixes()) {
                    if (Companion.canAutoFix(sub, this.requireAutoFixable)) continue;
                    all = false;
                    break;
                }
                if (!all) continue;
                for (LintFix sub : ((LintFix.LintFixGroup)data).getFixes()) {
                    this.registerFix(fileMap, incident, sub);
                }
                continue;
            }
            if (!Companion.canAutoFix(data, this.requireAutoFixable)) continue;
            this.registerFix(fileMap, incident, data);
        }
        return CollectionsKt.toList((Iterable)fileMap.values());
    }

    private final boolean findConflicts(List<PendingEdit> fixes) {
        PendingEdit prev = fixes.get(fixes.size() - 1);
        int n = fixes.size() - 2;
        if (0 <= n) {
            do {
                int index;
                PendingEdit fix;
                if ((fix = fixes.get(index = n--)).getStartOffset() < prev.getEndOffset()) {
                    this.client.log(Severity.WARNING, null, "Overlapping edits in quickfixes; skipping. Involved fixes: " + prev.getFix().getDisplayName() + " in [" + prev.getStartOffset() + '-' + prev.getEndOffset() + "] and " + fix.getFix().getDisplayName() + " in [" + fix.getStartOffset() + '-' + fix.getEndOffset() + ']', new Object[0]);
                    return true;
                }
                prev = fix;
            } while (0 <= n);
        }
        return false;
    }

    private final boolean addEdits(PendingEditFile file, Location location, LintFix lintFix) {
        boolean bl;
        if (lintFix instanceof LintFix.ReplaceString) {
            bl = this.addReplaceString(file, (LintFix.ReplaceString)lintFix, location);
        } else if (lintFix instanceof LintFix.SetAttribute) {
            bl = this.addSetAttribute(file, (LintFix.SetAttribute)lintFix, location);
        } else if (lintFix instanceof LintFix.AnnotateFix) {
            bl = this.addAnnotation(file, (LintFix.AnnotateFix)lintFix, location);
        } else if (lintFix instanceof LintFix.CreateFileFix) {
            bl = this.addCreateFile(file, (LintFix.CreateFileFix)lintFix);
        } else if (lintFix instanceof LintFix.LintFixGroup && ((LintFix.LintFixGroup)lintFix).getType() == LintFix.GroupType.COMPOSITE) {
            boolean all = true;
            for (LintFix nested : ((LintFix.LintFixGroup)lintFix).getFixes()) {
                if (this.addEdits(file, location, nested)) continue;
                all = false;
            }
            bl = all;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean addAnnotation(PendingEditFile file, LintFix.AnnotateFix annotateFix, Location fixLocation) {
        Location location = annotateFix.getRange();
        LintFix.ReplaceString replaceFix = Companion.createAnnotationFix(annotateFix, location == null ? fixLocation : location, file.getInitialText());
        return this.addReplaceString(file, replaceFix, fixLocation);
    }

    private final boolean addCreateFile(PendingEditFile file, LintFix.CreateFileFix fix) {
        if (fix.getDelete()) {
            file.setDelete(true);
            return true;
        }
        file.setCreateText(fix.getText());
        file.setCreateBytes(fix.getBinary());
        String string = fix.getSelectPattern();
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            file.setSelection(new Selection(Pattern.compile(it), 0, 0, 4, null));
        }
        return true;
    }

    private final boolean addSetAttribute(PendingEditFile file, LintFix.SetAttribute setFix, Location fixLocation) {
        Attr attr;
        Location location;
        Location location2;
        String contents = file.getInitialText();
        Location location3 = setFix.getRange();
        if (location3 == null) {
            location2 = fixLocation;
            if (location2 == null) {
                return false;
            }
            location = location2;
        } else {
            location = location3;
        }
        Location location4 = location;
        location2 = location4.getStart();
        if (location2 == null) {
            return false;
        }
        Location start = location2;
        Document document = file.getXmlDocument();
        if (document == null) {
            return false;
        }
        Document document2 = document;
        Node node = PositionXmlParser.findNodeAtOffset((Document)document2, (int)start.getOffset());
        if (node == null) {
            String string = Intrinsics.stringPlus((String)"No node found at offset ", (Object)start.getOffset());
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Node node2 = node;
        if (node2.getNodeType() == 2) {
            node = node2;
            node2 = ((Attr)node).getOwnerElement();
        } else if (node2.getNodeType() != 1) {
            node2 = node2.getParentNode();
        }
        if (node2 == null || node2.getNodeType() != 1) {
            throw new IllegalArgumentException("Didn't find element at offset " + start.getOffset() + " (line " + start.getLine() + "1, column " + start.getColumn() + "1) in " + file.getFile().getPath() + ":\n" + contents);
        }
        Node node3 = node2;
        Element element = (Element)node3;
        String value = setFix.getValue();
        String namespace = setFix.getNamespace();
        String attributeName = setFix.getAttribute();
        Attr attr2 = attr = namespace != null ? element.getAttributeNodeNS(namespace, attributeName) : element.getAttributeNode(attributeName);
        if (value == null) {
            if (attr != null) {
                SourcePosition position = PositionXmlParser.getPosition((Node)attr);
                int startOffset = position.getStartOffset();
                int endOffset = position.getEndOffset();
                int padding = 0;
                file.getEdits().add(new PendingEdit((LintFix)setFix, contents, startOffset, endOffset + padding, ""));
                return true;
            }
            return false;
        }
        if (attr != null) {
            SourcePosition position = PositionXmlParser.getPosition((Node)attr);
            int startOffset = position.getStartOffset();
            int endOffset = position.getEndOffset();
            String prefix = Intrinsics.stringPlus((String)attr.getName(), (Object)"=\"");
            String replacement = prefix + XmlUtils.toXmlAttributeValue((String)value) + '\"';
            file.getEdits().add(new PendingEdit((LintFix)setFix, contents, startOffset, endOffset, replacement));
            this.addValueSelection(value, setFix.getDot(), setFix.getMark(), startOffset, prefix.length(), file);
            return true;
        }
        int insertOffset = this.findAttributeInsertionOffset(file.getInitialText(), element, attributeName);
        if (namespace != null) {
            String prefix = document2.lookupPrefix(namespace);
            if (prefix == null) {
                String base = "ns";
                if (Intrinsics.areEqual((Object)"http://schemas.android.com/apk/res/android", (Object)namespace)) {
                    base = "android";
                } else if (Intrinsics.areEqual((Object)"http://schemas.android.com/tools", (Object)namespace)) {
                    base = "tools";
                } else if (Intrinsics.areEqual((Object)"http://schemas.android.com/apk/res-auto", (Object)namespace)) {
                    base = "app";
                }
                Element root = document2.getDocumentElement();
                int index = 1;
                while (root.hasAttribute(Intrinsics.stringPlus((String)"xmlns:", (Object)(prefix = Intrinsics.stringPlus((String)base, (Object)(index == 1 ? "" : String.valueOf(index))))))) {
                    int n = index;
                    index = n + 1;
                }
                String namespaceAttribute = Intrinsics.stringPlus((String)"xmlns:", (Object)prefix);
                String string = file.getInitialText();
                Element element2 = document2.getDocumentElement();
                Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"document.documentElement");
                int rootInsertOffset = this.findAttributeInsertionOffset(string, element2, namespaceAttribute);
                String padLeft = !CharsKt.isWhitespace((char)contents.charAt(rootInsertOffset - 1)) ? " " : "";
                String padRight = contents.charAt(rootInsertOffset) != '/' && contents.charAt(rootInsertOffset) != '>' ? " " : "";
                file.getEdits().add(new PendingEdit((LintFix)setFix, contents, rootInsertOffset, rootInsertOffset, padLeft + namespaceAttribute + "=\"" + namespace + '\"' + padRight));
            }
            attributeName = prefix + ':' + attributeName;
        }
        String padLeft = !CharsKt.isWhitespace((char)contents.charAt(insertOffset - 1)) ? " " : "";
        String padRight = contents.charAt(insertOffset) != '/' && contents.charAt(insertOffset) != '>' ? " " : "";
        String leftPart = padLeft + attributeName + "=\"";
        String valuePart = XmlUtils.toXmlAttributeValue((String)value);
        String rightPart = Intrinsics.stringPlus((String)"\"", (Object)padRight);
        file.getEdits().add(new PendingEdit((LintFix)setFix, contents, insertOffset, insertOffset, leftPart + valuePart + rightPart));
        this.addValueSelection(value, setFix.getDot(), setFix.getMark(), insertOffset, leftPart.length(), file);
        return true;
    }

    private final void addValueSelection(String value, int dot, int mark, int startOffset, int valueOffset, PendingEditFile file) {
        if (dot != Integer.MIN_VALUE) {
            int valueStart = startOffset + valueOffset;
            int valueDot = valueStart + dot;
            int valueMark = mark != Integer.MIN_VALUE ? valueStart + mark : valueDot;
            boolean bl = false;
            int selectionStart = Math.min(valueDot, valueMark);
            String string = value;
            int n = 0;
            n = Math.min(dot, mark);
            int n2 = 0;
            n2 = Math.max(dot, mark);
            boolean bl2 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String selectedString = string3;
            Pattern pattern = Pattern.compile(Pattern.quote(selectedString));
            file.setSelection(new Selection(pattern, selectionStart, 0, 4, null));
        }
    }

    private final int findAttributeInsertionOffset(String xml, Element element, String attributeName) {
        int tagEnd;
        int n = 0;
        NamedNodeMap attributes = element.getAttributes();
        int n2 = attributes.getLength();
        if (n < n2) {
            do {
                int i;
                Node attribute;
                String string;
                String string2 = (string = (attribute = attributes.item(i = n++)).getLocalName()) == null ? attribute.getNodeName() : string;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"attribute.localName ?: attribute.nodeName");
                int delta = Companion.compareAttributeNames(attributeName, string2);
                if (delta >= 0) continue;
                return PositionXmlParser.getPosition((Node)attribute).getStartOffset();
            } while (n < n2);
        }
        if (attributes.getLength() > 0) {
            return PositionXmlParser.getPosition((Node)attributes.item(attributes.getLength() - 1)).getEndOffset();
        }
        SourcePosition position = PositionXmlParser.getPosition((Node)element);
        int startOffset = position.getStartOffset();
        int offset = tagEnd = startOffset + element.getTagName().length();
        while (offset < xml.length()) {
            char c = xml.charAt(offset);
            if (Character.isWhitespace(c) || c == '>' || c == '/') {
                return c == ' ' ? offset + 1 : offset;
            }
            int n3 = offset;
            offset = n3 + 1;
        }
        return xml.length();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean addReplaceString(PendingEditFile file, LintFix.ReplaceString replaceFix, Location fixLocation) {
        Unit unit;
        String imported2;
        void var13_18;
        int index;
        int n;
        Object object;
        Location location;
        Location location2;
        String contents = file.getInitialText();
        String oldPattern = replaceFix.getOldPattern();
        String oldString = replaceFix.getOldString();
        Location location3 = replaceFix.getRange();
        if (location3 == null) {
            location2 = fixLocation;
            if (location2 == null) {
                return false;
            }
            location = location2;
        } else {
            location = location3;
        }
        Location location4 = location;
        location2 = location4.getStart();
        if (location2 == null) {
            return false;
        }
        Location start = location2;
        Position position = location4.getEnd();
        if (position == null) {
            return false;
        }
        Position end = position;
        String string = contents;
        int n2 = start.getOffset();
        int n3 = end.getOffset();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n2, n3);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String locationRange = string3;
        int startOffset = 0;
        int endOffset = 0;
        String[] stringArray = replaceFix.getReplacement();
        if (oldString == null && oldPattern == null) {
            int element;
            startOffset = start.getOffset();
            endOffset = end.getOffset();
            boolean allSpace = true;
            object = stringArray;
            n = ((String)object).length();
            for (int i = 0; i < n; ++i) {
                element = ((String)object).charAt(i);
                if (Character.isWhitespace((char)element)) continue;
                allSpace = false;
                break;
            }
            if (allSpace) {
                char c;
                int lineBegin = startOffset;
                while (lineBegin > 0 && (c = contents.charAt(lineBegin - 1)) != '\n') {
                    if (!Character.isWhitespace(c)) {
                        allSpace = false;
                        break;
                    }
                    n = lineBegin;
                    lineBegin = n + -1;
                }
                int lineEnd = endOffset;
                while (lineEnd < contents.length()) {
                    char c22 = contents.charAt(lineEnd);
                    element = lineEnd;
                    lineEnd = element + 1;
                    if (c22 == '\n') break;
                    if (Character.isWhitespace(c22)) continue;
                    allSpace = false;
                    break;
                }
                if (allSpace) {
                    startOffset = lineBegin;
                    endOffset = lineEnd;
                }
            }
        } else if (oldString != null) {
            index = StringsKt.indexOf$default((CharSequence)locationRange, (String)oldString, (int)0, (boolean)false, (int)6, null);
            if (index != -1) {
                startOffset = start.getOffset() + index;
                endOffset = start.getOffset() + index + oldString.length();
            } else if (Intrinsics.areEqual((Object)oldString, (Object)"_lint_insert_begin_")) {
                endOffset = startOffset = start.getOffset();
            } else {
                if (!Intrinsics.areEqual((Object)oldString, (Object)"_lint_insert_end_")) throw new IllegalArgumentException("Did not find \"" + oldString + "\" in \"" + locationRange + "\" as suggested in the quickfix. Consider calling ReplaceStringBuilder#range() to set a larger range to search than the default highlight range.");
                endOffset = startOffset = end.getOffset();
            }
        } else {
            index = oldPattern != null ? 1 : 0;
            boolean lineBegin = false;
            boolean lineEnd = false;
            if (_Assertions.ENABLED && index == 0) {
                boolean c22 = false;
                String c22 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)c22));
            }
            Intrinsics.checkNotNull((Object)oldPattern);
            Pattern pattern = Pattern.compile(oldPattern);
            Matcher matcher = pattern.matcher(locationRange);
            if (!matcher.find()) {
                throw new IllegalArgumentException("Did not match pattern \"" + oldPattern + "\" in \"" + locationRange + "\" as suggested in the quickfix");
            }
            endOffset = startOffset = start.getOffset();
            if (matcher.groupCount() > 0) {
                if (StringsKt.contains$default((CharSequence)oldPattern, (CharSequence)"target", (boolean)false, (int)2, null)) {
                    try {
                        startOffset += matcher.start("target");
                        endOffset += matcher.end("target");
                    }
                    catch (IllegalArgumentException ignore) {
                        startOffset += matcher.start(1);
                        endOffset += matcher.end(1);
                    }
                } else {
                    startOffset += matcher.start(1);
                    endOffset += matcher.end(1);
                }
            } else {
                startOffset += matcher.start();
                endOffset += matcher.end();
            }
            Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher");
            String string4 = replaceFix.expandBackReferences(matcher);
        }
        if (this.includeMarkers && replaceFix.getShortenNames()) {
            Set imported2 = new HashSet();
            String[] ignore = new String[]{"\n"};
            Collection $this$toTypedArray$iv22 = StringsKt.split$default((CharSequence)contents, (String[])ignore, (boolean)false, (int)0, (int)6, null);
            int $i$f$toTypedArray = 0;
            Collection thisCollection$iv = $this$toTypedArray$iv22;
            String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
            if (stringArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            object = stringArray2;
            int $this$toTypedArray$iv22 = 0;
            $i$f$toTypedArray = ((String[])object).length;
            while ($this$toTypedArray$iv22 < $i$f$toTypedArray) {
                void $this$trim$iv;
                int to;
                String string5;
                Set set;
                String line2 = object[$this$toTypedArray$iv22];
                ++$this$toTypedArray$iv22;
                if (StringsKt.startsWith$default((String)line2, (String)"package ", (boolean)false, (int)2, null)) {
                    void $this$trim$iv2;
                    int to2 = StringsKt.indexOf$default((CharSequence)line2, (char)';', (int)0, (boolean)false, (int)6, null);
                    if (to2 == -1) {
                        to2 = line2.length();
                    }
                    String string6 = line2;
                    int n4 = "package ".length();
                    boolean bl2 = false;
                    String string7 = string6;
                    if (string7 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string8 = string7.substring(n4, to2);
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    string6 = string8;
                    set = imported2;
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv2;
                    boolean $i$f$trim2 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl3 = false;
                        boolean bl4 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    string5 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                    set.add(Intrinsics.stringPlus((String)string5, (Object)"."));
                    continue;
                }
                if (!StringsKt.startsWith$default((String)line2, (String)"import ", (boolean)false, (int)2, null)) continue;
                int from = "import ".length();
                if (StringsKt.startsWith$default((String)line2, (String)"static ", (boolean)false, (int)2, null)) {
                    from += " static ".length();
                }
                if ((to = StringsKt.indexOf$default((CharSequence)line2, (char)';', (int)0, (boolean)false, (int)6, null)) == -1) {
                    to = line2.length();
                }
                if (line2.charAt(to - 1) == '*') {
                    int $i$f$trim = to;
                    to = $i$f$trim + -1;
                }
                String $i$f$trim = line2;
                boolean $this$trim$iv$iv = false;
                String string9 = $i$f$trim;
                if (string9 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string10 = string9.substring(from, to);
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                $i$f$trim = string10;
                set = imported2;
                boolean $i$f$trim3 = false;
                CharSequence $this$trim$iv$iv2 = (CharSequence)$this$trim$iv;
                boolean $i$f$trim4 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv2.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv2.charAt(index$iv$iv);
                    boolean bl5 = false;
                    boolean bl6 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                string5 = ((Object)$this$trim$iv$iv2.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                set.add(string5);
            }
            for (String full : imported2) {
                String clz = full;
                if (!StringsKt.contains$default((CharSequence)((CharSequence)var13_18), (CharSequence)clz, (boolean)false, (int)2, null)) continue;
                if (!StringsKt.endsWith$default((String)clz, (String)".", (boolean)false, (int)2, null)) {
                    int index2 = StringsKt.lastIndexOf$default((CharSequence)clz, (char)'.', (int)0, (boolean)false, (int)6, null);
                    if (index2 == -1) continue;
                    String from = clz;
                    int n5 = 0;
                    int n6 = index2 + 1;
                    boolean bl7 = false;
                    String string11 = from;
                    if (string11 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string12 = string11.substring(n5, n6);
                    Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    clz = string12;
                }
                String string13 = StringsKt.replace$default((String)var13_18, (String)clz, (String)"", (boolean)false, (int)4, null);
            }
        }
        if ((imported2 = replaceFix.getSelectPattern()) == null) {
            unit = null;
        } else {
            object = imported2;
            boolean bl8 = false;
            n = 0;
            String[] it = object;
            boolean bl9 = false;
            file.setSelection(new Selection(Pattern.compile((String)it), start.getOffset(), 0, 4, null));
            unit = Unit.INSTANCE;
        }
        PendingEdit edit = new PendingEdit((LintFix)replaceFix, contents, startOffset, endOffset, (String)var13_18);
        file.getEdits().add(edit);
        return true;
    }

    @NotNull
    public final List<PendingEditFile> computeEdits(@NotNull Incident incident, @NotNull LintFix lintFix) {
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)lintFix, (String)"lintFix");
        boolean bl = false;
        Map fileMap = new LinkedHashMap();
        this.registerFix(fileMap, incident, lintFix);
        return CollectionsKt.toList((Iterable)fileMap.values());
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u000bJ\u001a\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u000bH\u0002J\u000e\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0006J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u000bH\u0002\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/lint/LintFixPerformer$Companion;", "", "()V", "canAutoFix", "", "lintFix", "Lcom/android/tools/lint/detector/api/LintFix;", "requireAutoFixable", "compareAttributeNames", "", "n1", "", "n2", "createAnnotationFix", "Lcom/android/tools/lint/detector/api/LintFix$ReplaceString;", "fix", "Lcom/android/tools/lint/detector/api/LintFix$AnnotateFix;", "location", "Lcom/android/tools/lint/detector/api/Location;", "contents", "getLocation", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "implicitlyImported", "pkg", "isEditingFix", "rankAttributeNames", "name", "unnamed"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Location getLocation(@NotNull Incident incident, @Nullable LintFix fix) {
            Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
            LintFix lintFix = fix;
            Location location = lintFix == null ? null : lintFix.getRange();
            return location == null ? incident.getLocation() : location;
        }

        public static /* synthetic */ Location getLocation$default(Companion companion, Incident incident, LintFix lintFix, int n, Object object) {
            if ((n & 2) != 0) {
                lintFix = incident.getFix();
            }
            return companion.getLocation(incident, lintFix);
        }

        public final boolean isEditingFix(@NotNull LintFix fix) {
            Intrinsics.checkNotNullParameter((Object)fix, (String)"fix");
            return fix instanceof LintFix.ReplaceString || fix instanceof LintFix.AnnotateFix || fix instanceof LintFix.SetAttribute || fix instanceof LintFix.CreateFileFix;
        }

        public final boolean canAutoFix(@NotNull LintFix lintFix) {
            Intrinsics.checkNotNullParameter((Object)lintFix, (String)"lintFix");
            return this.canAutoFix(lintFix, true);
        }

        public final boolean canAutoFix(@NotNull LintFix lintFix, boolean requireAutoFixable) {
            Intrinsics.checkNotNullParameter((Object)lintFix, (String)"lintFix");
            if (!(requireAutoFixable || lintFix instanceof LintFix.LintFixGroup && ((LintFix.LintFixGroup)lintFix).getType() == LintFix.GroupType.ALTERNATIVES)) {
                return true;
            }
            if (lintFix instanceof LintFix.LintFixGroup) {
                LintFix.GroupType groupType = ((LintFix.LintFixGroup)lintFix).getType();
                int n = WhenMappings.$EnumSwitchMapping$0[groupType.ordinal()];
                switch (n) {
                    case 1: {
                        return false;
                    }
                    case 2: {
                        for (LintFix nested : ((LintFix.LintFixGroup)lintFix).getFixes()) {
                            if (this.canAutoFix(nested, requireAutoFixable)) continue;
                            return false;
                        }
                        return true;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            if (!lintFix.robot) {
                return false;
            }
            return lintFix.independent;
        }

        public final int compareAttributeNames(@NotNull String n1, @NotNull String n2) {
            Intrinsics.checkNotNullParameter((Object)n1, (String)"n1");
            Intrinsics.checkNotNullParameter((Object)n2, (String)"n2");
            int rank1 = this.rankAttributeNames(n1);
            int rank2 = this.rankAttributeNames(n2);
            int delta = rank1 - rank2;
            if (delta != 0) {
                return delta;
            }
            return n1.compareTo(n2);
        }

        private final int rankAttributeNames(String name) {
            return Intrinsics.areEqual((Object)name, (Object)"id") || Intrinsics.areEqual((Object)name, (Object)"name") ? 0 : (Intrinsics.areEqual((Object)name, (Object)"style") ? 10 : (Intrinsics.areEqual((Object)name, (Object)"layout") ? 20 : (Intrinsics.areEqual((Object)name, (Object)"layout_width") ? 30 : (Intrinsics.areEqual((Object)name, (Object)"layout_height") ? 40 : (StringsKt.startsWith$default((String)name, (String)"layout_", (boolean)false, (int)2, null) ? 50 : 60)))));
        }

        private final boolean implicitlyImported(String pkg) {
            boolean bl;
            switch (pkg) {
                case "kotlin.comparisons": 
                case "kotlin.collections": 
                case "java.lang": 
                case "kotlin.io": 
                case "kotlin.sequences": 
                case "kotlin": 
                case "kotlin.ranges": 
                case "kotlin.annotation": 
                case "kotlin.text": 
                case "kotlin.math": 
                case "kotlin.jvm": {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final LintFix.ReplaceString createAnnotationFix(@NotNull LintFix.AnnotateFix fix, @Nullable Location location, @Nullable String contents) {
            Intrinsics.checkNotNullParameter((Object)fix, (String)"fix");
            var5_4 = fix.getAnnotation();
            var6_5 = false;
            var7_8 = false;
            it = var5_4;
            $i$a$-let-LintFixPerformer$Companion$createAnnotationFix$annotation$1 = false;
            var10_14 = StringsKt.indexOf$default((CharSequence)it, (char)'(', (int)1, (boolean)false, (int)4, null);
            var11_16 = false;
            var12_19 = 0;
            index = var10_14;
            $i$a$-let-LintFixPerformer$Companion$createAnnotationFix$annotation$1$argStart$1 = false;
            argStart = index == -1 ? it.length() : index;
            packageEnd = StringsKt.lastIndexOf$default((CharSequence)it, (char)'.', (int)argStart, (boolean)false, (int)4, null);
            if (packageEnd == -1) ** GOTO lbl-1000
            var11_17 = it;
            var12_19 = 1;
            var13_20 = false;
            v0 = var11_17;
            if (v0 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            v1 = v0.substring(var12_19, packageEnd);
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            if (LintFixPerformer.Companion.implicitlyImported(v1)) {
                var11_17 = it;
                var12_19 = packageEnd + 1;
                var13_20 = false;
                v2 = var11_17;
                if (v2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                v3 = v2.substring(var12_19);
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"(this as java.lang.String).substring(startIndex)");
                v4 = Intrinsics.stringPlus((String)"@", (Object)v3);
            } else lbl-1000:
            // 2 sources

            {
                v4 = it;
            }
            annotation = v4;
            replacement = Intrinsics.stringPlus((String)annotation, (Object)"\n");
            if (location != null && contents != null) {
                var7_9 = location.getStart();
                Intrinsics.checkNotNull((Object)var7_9);
                start = var7_9;
                lineBegin = startOffset = start.getOffset();
                while (lineBegin > 0 && Character.isWhitespace(c = contents.charAt(lineBegin - 1))) {
                    if (c == '\n' || lineBegin == 1) {
                        var11_18 = contents;
                        var12_19 = 0;
                        v5 = var11_18.substring(lineBegin, startOffset);
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        indent = v5;
                        replacement = annotation + '\n' + indent;
                        break;
                    }
                    var10_14 = lineBegin;
                    lineBegin = var10_14 + -1;
                }
            }
            replaceFixBuilder = LintFix.Companion.create().replace().beginning().with(replacement).shortenNames().reformat(true);
            range = fix.getRange();
            if (range != null) {
                replaceFixBuilder.range(range);
            }
            return (LintFix.ReplaceString)replaceFixBuilder.build();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[LintFix.GroupType.values().length];
                nArray[LintFix.GroupType.ALTERNATIVES.ordinal()] = 1;
                nArray[LintFix.GroupType.COMPOSITE.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J)\u0010\u0013\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/lint/LintFixPerformer$Selection;", "", "pattern", "Ljava/util/regex/Pattern;", "dot", "", "mark", "(Ljava/util/regex/Pattern;II)V", "getDot", "()I", "setDot", "(I)V", "getMark", "setMark", "getPattern", "()Ljava/util/regex/Pattern;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "unnamed"})
    public static final class Selection {
        @Nullable
        private final Pattern pattern;
        private int dot;
        private int mark;

        public Selection(@Nullable Pattern pattern, int dot, int mark) {
            this.pattern = pattern;
            this.dot = dot;
            this.mark = mark;
        }

        public /* synthetic */ Selection(Pattern pattern, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 2) != 0) {
                n = Integer.MIN_VALUE;
            }
            if ((n3 & 4) != 0) {
                n2 = Integer.MIN_VALUE;
            }
            this(pattern, n, n2);
        }

        @Nullable
        public final Pattern getPattern() {
            return this.pattern;
        }

        public final int getDot() {
            return this.dot;
        }

        public final void setDot(int n) {
            this.dot = n;
        }

        public final int getMark() {
            return this.mark;
        }

        public final void setMark(int n) {
            this.mark = n;
        }

        @Nullable
        public final Pattern component1() {
            return this.pattern;
        }

        public final int component2() {
            return this.dot;
        }

        public final int component3() {
            return this.mark;
        }

        @NotNull
        public final Selection copy(@Nullable Pattern pattern, int dot, int mark) {
            return new Selection(pattern, dot, mark);
        }

        public static /* synthetic */ Selection copy$default(Selection selection, Pattern pattern, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                pattern = selection.pattern;
            }
            if ((n3 & 2) != 0) {
                n = selection.dot;
            }
            if ((n3 & 4) != 0) {
                n2 = selection.mark;
            }
            return selection.copy(pattern, n, n2);
        }

        @NotNull
        public String toString() {
            return "Selection(pattern=" + this.pattern + ", dot=" + this.dot + ", mark=" + this.mark + ')';
        }

        public int hashCode() {
            int result = this.pattern == null ? 0 : this.pattern.hashCode();
            result = result * 31 + Integer.hashCode(this.dot);
            result = result * 31 + Integer.hashCode(this.mark);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Selection)) {
                return false;
            }
            Selection selection = (Selection)other;
            if (!Intrinsics.areEqual((Object)this.pattern, (Object)selection.pattern)) {
                return false;
            }
            if (this.dot != selection.dot) {
                return false;
            }
            return this.mark == selection.mark;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010,\u001a\u0004\u0018\u00010\u001dJ\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0013R\u001c\u0010&\u001a\u0004\u0018\u00010'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+\u00a8\u00061"}, d2={"Lcom/android/tools/lint/LintFixPerformer$PendingEditFile;", "", "client", "Lcom/android/tools/lint/LintCliClient;", "file", "Ljava/io/File;", "initialText", "", "(Lcom/android/tools/lint/LintCliClient;Ljava/io/File;Ljava/lang/String;)V", "getClient", "()Lcom/android/tools/lint/LintCliClient;", "createBytes", "", "getCreateBytes", "()[B", "setCreateBytes", "([B)V", "createText", "getCreateText", "()Ljava/lang/String;", "setCreateText", "(Ljava/lang/String;)V", "delete", "", "getDelete", "()Z", "setDelete", "(Z)V", "document", "Lorg/w3c/dom/Document;", "edits", "", "Lcom/android/tools/lint/LintFixPerformer$PendingEdit;", "getEdits", "()Ljava/util/List;", "getFile", "()Ljava/io/File;", "getInitialText", "selection", "Lcom/android/tools/lint/LintFixPerformer$Selection;", "getSelection", "()Lcom/android/tools/lint/LintFixPerformer$Selection;", "setSelection", "(Lcom/android/tools/lint/LintFixPerformer$Selection;)V", "getXmlDocument", "handleXmlError", "", "e", "", "unnamed"})
    public static final class PendingEditFile {
        @NotNull
        private final LintCliClient client;
        @NotNull
        private final File file;
        @NotNull
        private final String initialText;
        @NotNull
        private final List<PendingEdit> edits;
        @Nullable
        private Selection selection;
        private boolean delete;
        @Nullable
        private String createText;
        @Nullable
        private byte[] createBytes;
        @Nullable
        private Document document;

        public PendingEditFile(@NotNull LintCliClient client, @NotNull File file, @NotNull String initialText) {
            Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)initialText, (String)"initialText");
            this.client = client;
            this.file = file;
            this.initialText = initialText;
            boolean bl = false;
            this.edits = new ArrayList();
        }

        @NotNull
        public final LintCliClient getClient() {
            return this.client;
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        @NotNull
        public final String getInitialText() {
            return this.initialText;
        }

        @NotNull
        public final List<PendingEdit> getEdits() {
            return this.edits;
        }

        @Nullable
        public final Selection getSelection() {
            return this.selection;
        }

        public final void setSelection(@Nullable Selection selection) {
            this.selection = selection;
        }

        public final boolean getDelete() {
            return this.delete;
        }

        public final void setDelete(boolean bl) {
            this.delete = bl;
        }

        @Nullable
        public final String getCreateText() {
            return this.createText;
        }

        public final void setCreateText(@Nullable String string) {
            this.createText = string;
        }

        @Nullable
        public final byte[] getCreateBytes() {
            return this.createBytes;
        }

        public final void setCreateBytes(@Nullable byte[] byArray) {
            this.createBytes = byArray;
        }

        @Nullable
        public final Document getXmlDocument() {
            if (this.document == null) {
                try {
                    this.document = PositionXmlParser.parse((String)this.initialText);
                }
                catch (ParserConfigurationException e) {
                    this.handleXmlError(e);
                }
                catch (SAXException e) {
                    this.handleXmlError(e);
                }
                catch (IOException e) {
                    this.handleXmlError(e);
                }
            }
            return this.document;
        }

        private final void handleXmlError(Throwable e) {
            this.client.log(Severity.WARNING, null, "Ignoring " + this.file + ": Failed to parse XML: " + e, new Object[0]);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005J\u0011\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u001b\u001a\u00020\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\u0006\u0010\u001d\u001a\u00020\u0005J\b\u0010\u001e\u001a\u00020\u0007H\u0016J\b\u0010\u001f\u001a\u00020\u0016H\u0002J\b\u0010 \u001a\u00020\u0005H\u0016R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\f\u00a8\u0006!"}, d2={"Lcom/android/tools/lint/LintFixPerformer$PendingEdit;", "", "fix", "Lcom/android/tools/lint/detector/api/LintFix;", "source", "", "startOffset", "", "endOffset", "replacement", "(Lcom/android/tools/lint/detector/api/LintFix;Ljava/lang/String;IILjava/lang/String;)V", "getEndOffset", "()I", "getFix", "()Lcom/android/tools/lint/detector/api/LintFix;", "getReplacement", "()Ljava/lang/String;", "getSource", "getStartOffset", "adjustOffset", "offset", "biasLeft", "", "apply", "contents", "compareTo", "other", "equals", "", "fixName", "hashCode", "isDelete", "toString", "unnamed"})
    public static final class PendingEdit
    implements Comparable<PendingEdit> {
        @NotNull
        private final LintFix fix;
        @NotNull
        private final String source;
        private final int startOffset;
        private final int endOffset;
        @NotNull
        private final String replacement;

        public PendingEdit(@NotNull LintFix fix, @NotNull String source, int startOffset, int endOffset, @NotNull String replacement) {
            Intrinsics.checkNotNullParameter((Object)fix, (String)"fix");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
            this.fix = fix;
            this.source = source;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.replacement = replacement;
        }

        @NotNull
        public final LintFix getFix() {
            return this.fix;
        }

        @NotNull
        public final String getSource() {
            return this.source;
        }

        public final int getStartOffset() {
            return this.startOffset;
        }

        public final int getEndOffset() {
            return this.endOffset;
        }

        @NotNull
        public final String getReplacement() {
            return this.replacement;
        }

        @Override
        public int compareTo(@NotNull PendingEdit other) {
            int d2;
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            int delta = other.startOffset - this.startOffset;
            if (delta != 0) {
                return delta;
            }
            int d1 = this.isDelete() ? 0 : 1;
            int deleteDelta = d1 - (d2 = other.isDelete() ? 0 : 1);
            if (deleteDelta != 0) {
                return deleteDelta;
            }
            return other.endOffset - this.endOffset;
        }

        @NotNull
        public final String apply(@NotNull String contents) {
            Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
            StringBuilder stringBuilder = new StringBuilder(contents);
            boolean bl = false;
            boolean bl2 = false;
            StringBuilder $this$apply_u24lambda_u2d0 = stringBuilder;
            boolean bl3 = false;
            $this$apply_u24lambda_u2d0.replace(this.getStartOffset(), this.getEndOffset(), this.getReplacement());
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder(contents).apply {\n                replace(startOffset, endOffset, replacement)\n            }.toString()");
            return string;
        }

        public final int adjustOffset(int offset, boolean biasLeft) {
            int n;
            if (offset < this.startOffset || offset == this.startOffset && biasLeft) {
                n = offset;
            } else {
                int n2 = this.startOffset - this.endOffset;
                boolean bl = false;
                n = offset - Math.abs(n2) + this.replacement.length();
            }
            return n;
        }

        private final boolean isDelete() {
            return this.endOffset > this.startOffset;
        }

        @NotNull
        public final String fixName() {
            String string = this.fix.getFamilyName();
            if (string == null) {
                String string2;
                String string3 = this.fix.getDisplayName();
                if (string3 == null) {
                    String string4 = this.fix.getClass().getSimpleName();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"fix.javaClass.simpleName");
                    string2 = string4;
                } else {
                    string2 = string3;
                }
                return string2;
            }
            return string;
        }

        @NotNull
        public String toString() {
            String string;
            CharSequence charSequence = this.replacement;
            int n = 0;
            if (charSequence.length() == 0) {
                StringBuilder stringBuilder = new StringBuilder().append("At ").append(this.startOffset).append(", delete \"");
                charSequence = this.source;
                n = this.startOffset;
                int n2 = this.endOffset;
                boolean bl = false;
                CharSequence charSequence2 = charSequence;
                if (charSequence2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = ((String)charSequence2).substring(n, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                string = stringBuilder.append(string2).append('\"').toString();
            } else if (this.startOffset == this.endOffset) {
                string = "At " + this.startOffset + ", insert \"" + this.replacement + '\"';
            } else {
                StringBuilder stringBuilder = new StringBuilder().append("At ").append(this.startOffset).append(", change \"");
                charSequence = this.source;
                n = this.startOffset;
                int n3 = this.endOffset;
                boolean bl = false;
                CharSequence charSequence3 = charSequence;
                if (charSequence3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = ((String)charSequence3).substring(n, n3);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                string = stringBuilder.append(string3).append("\" to \"").append(this.replacement).append('\"').toString();
            }
            return string;
        }

        public boolean equals(@Nullable Object other) {
            Object object;
            if (this == other) {
                return true;
            }
            if (!Intrinsics.areEqual(this.getClass(), (object = other) == null ? null : object.getClass())) {
                return false;
            }
            if (other == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.android.tools.lint.LintFixPerformer.PendingEdit");
            }
            PendingEdit cfr_ignored_0 = (PendingEdit)other;
            if (this.startOffset != ((PendingEdit)other).startOffset) {
                return false;
            }
            if (this.endOffset != ((PendingEdit)other).endOffset) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.replacement, (Object)((PendingEdit)other).replacement);
        }

        public int hashCode() {
            int result = this.startOffset;
            result = 31 * result + this.endOffset;
            result = 31 * result + this.replacement.hashCode();
            return result;
        }
    }
}

