/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.ide.common.blame.SourcePosition;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.XmlParser;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.Pair;
import com.android.utils.PositionXmlParser;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class LintCliXmlParser
extends XmlParser {
    private final LintClient client;

    public LintCliXmlParser(LintClient client) {
        this.client = client;
    }

    public Document parseXml(File file) throws IOException, SAXException, ParserConfigurationException {
        CharSequence xml = this.client.readFile(file);
        if (xml.length() == 0) {
            throw new IOException();
        }
        Document document = PositionXmlParser.parse((String)xml.toString());
        document.setUserData(File.class.getName(), file, null);
        return document;
    }

    public Document parseXml(CharSequence xml, File file) {
        try {
            Document document = PositionXmlParser.parse((String)xml.toString());
            document.setUserData(File.class.getName(), file, null);
            return document;
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public Document parseXml(XmlContext context) {
        String xml = null;
        try {
            CharSequence contents = context.getContents();
            if (contents != null) {
                xml = contents.toString();
                Document document = PositionXmlParser.parse((String)xml);
                document.setUserData(File.class.getName(), context.file, null);
                return document;
            }
        }
        catch (UnsupportedEncodingException e) {
            context.report(IssueRegistry.PARSER_ERROR, Location.create((File)context.file), e.getCause() != null ? e.getCause().getLocalizedMessage() : e.getLocalizedMessage());
        }
        catch (SAXException e) {
            String message;
            Location location = Location.create((File)context.file);
            String string = message = e.getCause() != null ? e.getCause().getLocalizedMessage() : e.getLocalizedMessage();
            if (message.startsWith("The processing instruction target matching \"[xX][mM][lL]\" is not allowed.")) {
                int prologue = xml.indexOf("<?xml ");
                int comment = xml.indexOf("<!--");
                if (prologue != -1 && comment != -1 && comment < prologue) {
                    message = "The XML prologue should appear before, not after, the first XML header/copyright comment. " + message;
                }
            }
            context.report(IssueRegistry.PARSER_ERROR, location, message);
        }
        catch (Throwable t) {
            context.log(t, null, new Object[0]);
        }
        return null;
    }

    public Location getLocation(XmlContext context, Node node) {
        return this.getLocation(context.file, node);
    }

    public Location getLocation(File file, Node node) {
        Pair<File, ? extends Node> mergedSource = this.findManifestSource(node);
        if (mergedSource != null) {
            file = (File)mergedSource.getFirst();
            node = (Node)mergedSource.getSecond();
        }
        return Location.create((File)file, (SourcePosition)PositionXmlParser.getPosition((Node)node)).withSource((Object)node);
    }

    public Location getLocation(XmlContext context, Node node, int start, int end) {
        File file = context.file;
        Pair<File, ? extends Node> mergedSource = this.findManifestSource(node);
        if (mergedSource != null) {
            file = (File)mergedSource.getFirst();
            node = (Node)mergedSource.getSecond();
        }
        return Location.create((File)file, (SourcePosition)PositionXmlParser.getPosition((Node)node, (int)start, (int)end)).withSource((Object)node);
    }

    private Pair<File, ? extends Node> findManifestSource(Node node) {
        if (this.client.isMergeManifestNode(node)) {
            return this.client.findManifestSourceNode(node);
        }
        return null;
    }

    public Location getNameLocation(LintClient client, File file, Node node) {
        Location location = this.getLocation(client, file, node);
        Position start = location.getStart();
        Position end = location.getEnd();
        if (start == null || end == null) {
            return location;
        }
        int delta = node instanceof Element ? 1 : 0;
        int length = node.getNodeName().length();
        int startOffset = start.getOffset() + delta;
        int startColumn = start.getColumn() + delta;
        return Location.create((File)location.getFile(), (Position)new DefaultPosition(start.getLine(), startColumn, startOffset), (Position)new DefaultPosition(start.getLine(), startColumn + length, startOffset + length)).withSource((Object)node);
    }

    public Location getNameLocation(XmlContext context, Node node) {
        return this.getNameLocation(this.client, context.file, node);
    }

    public Location getValueLocation(XmlContext context, Attr node) {
        return this.getValueLocation(this.client, context.file, node);
    }

    public Location getValueLocation(LintClient client, File file, Attr node) {
        Location location = this.getLocation(client, file, node);
        Position start = location.getStart();
        Position end = location.getEnd();
        if (start == null || end == null) {
            return location;
        }
        int totalLength = end.getOffset() - start.getOffset();
        int length = node.getValue().length();
        int delta = totalLength - 1 - length;
        int startOffset = start.getOffset() + delta;
        int startColumn = start.getColumn() + delta;
        return Location.create((File)location.getFile(), (Position)new DefaultPosition(start.getLine(), startColumn, startOffset), (Position)new DefaultPosition(end.getLine(), startColumn + length, startOffset + length)).withSource((Object)node);
    }

    public Location.Handle createLocationHandle(XmlContext context, Node node) {
        return new LocationHandle(this, context.file, node);
    }

    public int getNodeStartOffset(XmlContext context, Node node) {
        Pair<File, ? extends Node> mergedSource = this.findManifestSource(node);
        if (mergedSource != null) {
            node = (Node)mergedSource.getSecond();
        }
        return PositionXmlParser.getPosition((Node)node).getStartOffset();
    }

    public int getNodeEndOffset(XmlContext context, Node node) {
        Pair<File, ? extends Node> mergedSource = this.findManifestSource(node);
        if (mergedSource != null) {
            node = (Node)mergedSource.getSecond();
        }
        return PositionXmlParser.getPosition((Node)node).getEndOffset();
    }

    public Node findNodeAt(XmlContext context, int offset) {
        return PositionXmlParser.findNodeAtOffset((Document)context.document, (int)offset);
    }

    public Location getLocation(LintClient client, File file, Node node) {
        return this.getLocation(file, node);
    }

    public int getNodeStartOffset(LintClient client, File file, Node node) {
        return PositionXmlParser.getPosition((Node)node).getStartOffset();
    }

    public int getNodeEndOffset(LintClient client, File file, Node node) {
        return PositionXmlParser.getPosition((Node)node).getEndOffset();
    }

    private static class LocationHandle
    implements Location.Handle {
        private final LintCliXmlParser parser;
        private final File file;
        private final Node node;
        private Object clientData;

        public LocationHandle(LintCliXmlParser parser, File file, Node node) {
            this.parser = parser;
            this.file = file;
            this.node = node;
        }

        public Location resolve() {
            Node node = this.node;
            File file = this.file;
            Pair source = this.parser.findManifestSource(node);
            if (source != null) {
                file = (File)source.getFirst();
                node = (Node)source.getSecond();
            }
            return Location.create((File)file, (SourcePosition)PositionXmlParser.getPosition((Node)node)).withSource((Object)node);
        }

        public void setClientData(Object clientData) {
            this.clientData = clientData;
        }

        public Object getClientData() {
            return this.clientData;
        }

        public String toString() {
            return "LocationHandle{" + this.resolve() + "}";
        }
    }
}

