/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.Reporter;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.model.LintModelSeverity;
import com.google.common.annotations.Beta;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Beta
public class LintCliFlags {
    private final Set<String> suppress = new HashSet<String>();
    private final Set<String> enabled = new HashSet<String>();
    private Set<String> check = null;
    private Set<Category> disabledCategories = null;
    private Set<Category> enabledCategories = null;
    private Set<Category> checkCategories = null;
    private Map<String, LintModelSeverity> severities;
    private boolean setExitCode;
    private boolean fullPath;
    private boolean showLines = true;
    private final List<Reporter> reporters = Lists.newArrayList();
    private boolean quiet;
    private boolean warnAll;
    private boolean checkTests;
    private boolean ignoreTests;
    private boolean checkGenerated;
    private boolean checkDependencies = true;
    private boolean noWarnings;
    private boolean allErrors;
    private boolean fatalOnly;
    private boolean explainIssues;
    private File projectDescriptor;
    private List<File> sources;
    private List<File> classes;
    private List<File> libraries;
    private List<File> resources;
    private List<File> lintRuleJars;
    private String compileSdkVersion;
    private File baselineFile;
    private File outputBaselineFile;
    private File lintConfig;
    private File lintOverrideConfig;
    private boolean showAll;
    private boolean removedFixedBaselineIssues;
    private boolean writeBaselineIfMissing = true;
    private boolean updateBaseline;
    private boolean continueAfterBaselineCreated;
    private boolean autoFix = "true".equals(System.getProperty("lint.autofix"));
    private boolean abortOnAutoFix;
    private boolean includeXmlFixes;
    private boolean allowSuppress;
    private boolean printInternalErrorStackTrace;
    private File cacheDir;
    public static final int ERRNO_SUCCESS = 0;
    public static final int ERRNO_ERRORS = 1;
    public static final int ERRNO_USAGE = 2;
    public static final int ERRNO_EXISTS = 3;
    public static final int ERRNO_HELP = 4;
    public static final int ERRNO_INVALID_ARGS = 5;
    public static final int ERRNO_CREATED_BASELINE = 6;
    public static final int ERRNO_APPLIED_SUGGESTIONS = 7;
    public static final int ERRNO_INTERNAL_CONTINUE = 100;

    public Set<String> getSuppressedIds() {
        return this.suppress;
    }

    public Set<String> getEnabledIds() {
        return this.enabled;
    }

    public Set<Category> getEnabledCategories() {
        return this.enabledCategories;
    }

    public Set<Category> getDisabledCategories() {
        return this.disabledCategories;
    }

    public Set<Category> getExactCategories() {
        return this.checkCategories;
    }

    public Map<String, LintModelSeverity> getSeverityOverrides() {
        return this.severities == null ? Collections.emptyMap() : this.severities;
    }

    public Set<String> getExactCheckedIds() {
        return this.check;
    }

    public void setExactCheckedIds(Set<String> check) {
        this.check = check;
    }

    public void addExactId(String id) {
        if (this.check == null) {
            this.check = new HashSet<String>();
        }
        this.check.add(id);
    }

    public void addEnabledCategory(Category category) {
        if (this.enabledCategories == null) {
            this.enabledCategories = new HashSet<Category>();
        }
        this.enabledCategories.add(category);
    }

    public void addDisabledCategory(Category category) {
        if (this.disabledCategories == null) {
            this.disabledCategories = new HashSet<Category>();
        }
        this.disabledCategories.add(category);
    }

    public void addExactCategory(Category category) {
        if (this.checkCategories == null) {
            this.checkCategories = new HashSet<Category>();
        }
        this.checkCategories.add(category);
    }

    public boolean isSetExitCode() {
        return this.setExitCode;
    }

    public void setSetExitCode(boolean setExitCode) {
        this.setExitCode = setExitCode;
    }

    public boolean isFullPath() {
        return this.fullPath;
    }

    public void setFullPath(boolean fullPath) {
        this.fullPath = fullPath;
    }

    public boolean isShowSourceLines() {
        return this.showLines;
    }

    public void setShowSourceLines(boolean showLines) {
        this.showLines = showLines;
    }

    public List<Reporter> getReporters() {
        return this.reporters;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public boolean isCheckAllWarnings() {
        return this.warnAll;
    }

    public void setCheckAllWarnings(boolean warnAll) {
        this.warnAll = warnAll;
    }

    public boolean isIgnoreWarnings() {
        return this.noWarnings;
    }

    public void setIgnoreWarnings(boolean noWarnings) {
        this.noWarnings = noWarnings;
    }

    public boolean isWarningsAsErrors() {
        return this.allErrors;
    }

    public void setWarningsAsErrors(boolean allErrors) {
        this.allErrors = allErrors;
    }

    public boolean isCheckTestSources() {
        return this.checkTests;
    }

    public void setCheckTestSources(boolean checkTests) {
        this.checkTests = checkTests;
        if (checkTests) {
            this.ignoreTests = false;
        }
    }

    public boolean isIgnoreTestSources() {
        return this.ignoreTests;
    }

    public void setIgnoreTestSources(boolean ignoreTests) {
        this.ignoreTests = ignoreTests;
        if (ignoreTests) {
            this.checkTests = false;
        }
    }

    public boolean isCheckGeneratedSources() {
        return this.checkGenerated;
    }

    public void setCheckGeneratedSources(boolean checkGenerated) {
        this.checkGenerated = checkGenerated;
    }

    public boolean isCheckDependencies() {
        return this.checkDependencies;
    }

    public void setCheckDependencies(boolean checkDependencies) {
        this.checkDependencies = checkDependencies;
    }

    public boolean isShowEverything() {
        return this.showAll;
    }

    public void setShowEverything(boolean showAll) {
        this.showAll = showAll;
    }

    public File getLintConfig() {
        return this.lintConfig;
    }

    public void setLintConfig(File lintConfig) {
        this.lintConfig = lintConfig;
    }

    public File getOverrideLintConfig() {
        return this.lintOverrideConfig;
    }

    public void setOverrideLintConfig(File lintConfig) {
        this.lintOverrideConfig = lintConfig;
    }

    public List<File> getSourcesOverride() {
        return this.sources;
    }

    public void setSourcesOverride(List<File> sources) {
        this.sources = sources;
    }

    public List<File> getClassesOverride() {
        return this.classes;
    }

    public void setClassesOverride(List<File> classes) {
        this.classes = classes;
    }

    public List<File> getLibrariesOverride() {
        return this.libraries;
    }

    public void setLibrariesOverride(List<File> libraries) {
        this.libraries = libraries;
    }

    public List<File> getResourcesOverride() {
        return this.resources;
    }

    public void setResourcesOverride(List<File> resources) {
        this.resources = resources;
    }

    public List<File> getLintRuleJarsOverride() {
        return this.lintRuleJars;
    }

    public void setLintRuleJarsOverride(List<File> lintRuleJars) {
        this.lintRuleJars = lintRuleJars;
    }

    public File getProjectDescriptorOverride() {
        return this.projectDescriptor;
    }

    public void setProjectDescriptorOverride(File projectDescriptor) {
        this.projectDescriptor = projectDescriptor;
    }

    public String getCompileSdkVersionOverride() {
        return this.compileSdkVersion;
    }

    public void setCompileSdkVersionOverride(String compileSdkVersion) {
        this.compileSdkVersion = compileSdkVersion;
    }

    public boolean isFatalOnly() {
        return this.fatalOnly;
    }

    public void setFatalOnly(boolean fatalOnly) {
        this.fatalOnly = fatalOnly;
    }

    public void setSeverityOverrides(Map<String, LintModelSeverity> severities) {
        this.severities = severities;
    }

    public boolean isExplainIssues() {
        return this.explainIssues;
    }

    public void setExplainIssues(boolean explainText) {
        this.explainIssues = explainText;
    }

    public File getBaselineFile() {
        return this.baselineFile;
    }

    public void setBaselineFile(File baselineFile) {
        this.baselineFile = baselineFile;
    }

    public File getOutputBaselineFile() {
        return this.outputBaselineFile;
    }

    public void setOutputBaselineFile(File outputBaselineFile) {
        this.outputBaselineFile = outputBaselineFile;
    }

    public boolean isRemoveFixedBaselineIssues() {
        return this.removedFixedBaselineIssues;
    }

    public void setRemovedFixedBaselineIssues(boolean removeFixed) {
        this.removedFixedBaselineIssues = removeFixed;
    }

    public boolean isWriteBaselineIfMissing() {
        return this.writeBaselineIfMissing;
    }

    public void setWriteBaselineIfMissing(boolean writeBaselineIfMissing) {
        this.writeBaselineIfMissing = writeBaselineIfMissing;
    }

    public boolean isUpdateBaseline() {
        return this.updateBaseline;
    }

    public void setUpdateBaseline(boolean updateBaseline) {
        this.updateBaseline = updateBaseline;
    }

    public boolean isAutoFix() {
        return this.autoFix;
    }

    public void setAutoFix(boolean autoFix) {
        this.autoFix = autoFix;
    }

    public boolean isAbortOnAutoFix() {
        return this.abortOnAutoFix;
    }

    public void setAbortOnAutoFix(boolean abortOnAutoFix) {
        this.abortOnAutoFix = abortOnAutoFix;
    }

    public boolean isIncludeXmlFixes() {
        return this.includeXmlFixes;
    }

    public void setIncludeXmlFixes(boolean includeXmlFixes) {
        this.includeXmlFixes = includeXmlFixes;
    }

    public void setAllowSuppress(boolean allowSuppress) {
        this.allowSuppress = allowSuppress;
    }

    public boolean getAllowSuppress() {
        return this.allowSuppress;
    }

    public boolean getPrintInternalErrorStackTrace() {
        return this.printInternalErrorStackTrace;
    }

    public void setPrintInternalErrorStackTrace(boolean printInternalErrorStackTrace) {
        this.printInternalErrorStackTrace = printInternalErrorStackTrace;
    }

    public File getCacheDir() {
        return this.cacheDir;
    }

    public void setCacheDir(File cacheDir) {
        this.cacheDir = cacheDir;
    }

    public boolean isContinueAfterBaselineCreated() {
        return this.continueAfterBaselineCreated;
    }

    public void setContinueAfterBaselineCreated(boolean continueAfterBaselineCreated) {
        this.continueAfterBaselineCreated = continueAfterBaselineCreated;
    }
}

