/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.CommandFailedException;
import com.android.ddmlib.EmulatorConsoleImpl;
import com.android.ddmlib.IDevice;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\b&\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH&J\b\u0010\u000b\u001a\u00020\nH&J\u0014\u0010\f\u001a\u0004\u0018\u00010\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u0004H&J\n\u0010\u000e\u001a\u0004\u0018\u00010\u0004H&R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/android/ddmlib/EmulatorConsole;", "", "()V", "avdName", "", "getAvdName", "()Ljava/lang/String;", "avdPath", "getAvdPath", "close", "", "kill", "startEmulatorScreenRecording", "args", "stopScreenRecording", "Companion", "unnamed"})
public abstract class EmulatorConsole {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Map<String, EmulatorConsole> sTestConsoles = new HashMap();

    public abstract void close();

    public abstract void kill();

    @Nullable
    public abstract String getAvdName();

    @NotNull
    public abstract String getAvdPath() throws CommandFailedException;

    @Nullable
    public abstract String startEmulatorScreenRecording(@Nullable String var1);

    @Nullable
    public abstract String stopScreenRecording();

    @JvmStatic
    @Nullable
    public static final EmulatorConsole getConsole(@NotNull IDevice d) {
        return Companion.getConsole(d);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0007J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0006H\u0007R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/ddmlib/EmulatorConsole$Companion;", "", "()V", "sTestConsoles", "", "", "Lcom/android/ddmlib/EmulatorConsole;", "clearConsolesForTest", "", "getConsole", "d", "Lcom/android/ddmlib/IDevice;", "registerConsoleForTest", "deviceSerial", "console", "unnamed"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public final void registerConsoleForTest(@NotNull String deviceSerial, @NotNull EmulatorConsole console) {
            Intrinsics.checkNotNullParameter((Object)deviceSerial, (String)"deviceSerial");
            Intrinsics.checkNotNullParameter((Object)console, (String)"console");
            Map map = sTestConsoles;
            boolean bl = false;
            map.put(deviceSerial, console);
        }

        @VisibleForTesting
        public final void clearConsolesForTest() {
            sTestConsoles.clear();
        }

        @JvmStatic
        @Nullable
        public final EmulatorConsole getConsole(@NotNull IDevice d) {
            Intrinsics.checkNotNullParameter((Object)d, (String)"d");
            EmulatorConsole emulatorConsole = (EmulatorConsole)sTestConsoles.get(d.getSerialNumber());
            return emulatorConsole == null ? (EmulatorConsole)EmulatorConsoleImpl.createConsole(d) : emulatorConsole;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

