/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.manifmerger.ManifestModel;
import com.android.manifmerger.NodeKeyResolver;
import com.android.manifmerger.OrphanXmlElement;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R2\u0010\u0005\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00030\u0003 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00030\u0003\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/android/manifmerger/CompositeNodeKeyResolver;", "Lcom/android/manifmerger/NodeKeyResolver;", "nodeType", "", "(Ljava/lang/String;)V", "dataAttributeNames", "Lcom/google/common/collect/ImmutableList;", "kotlin.jvm.PlatformType", "keyAttributesNames", "getKeyAttributesNames", "()Lcom/google/common/collect/ImmutableList;", "model", "Lcom/android/manifmerger/ManifestModel;", "getNodeType", "()Ljava/lang/String;", "getAttributeInfo", "xmlElement", "Lcom/android/manifmerger/OrphanXmlElement;", "attributeName", "getKey", "element", "Lorg/w3c/dom/Element;", "unnamed"})
public class CompositeNodeKeyResolver
implements NodeKeyResolver {
    @NotNull
    private final String nodeType;
    @NotNull
    private final ManifestModel model;
    private final ImmutableList<String> dataAttributeNames;

    public CompositeNodeKeyResolver(@NotNull String nodeType) {
        Intrinsics.checkNotNullParameter((Object)nodeType, (String)"nodeType");
        this.nodeType = nodeType;
        this.model = new ManifestModel();
        this.dataAttributeNames = ImmutableList.of((Object)"scheme", (Object)"host", (Object)"mimeType", (Object)"port", (Object)"path", (Object)"pathPattern", (Object)"pathPrefix");
    }

    @NotNull
    public final String getNodeType() {
        return this.nodeType;
    }

    @Override
    @NotNull
    public ImmutableList<String> getKeyAttributesNames() {
        ImmutableList.Builder builder = ImmutableList.builder();
        String[] stringArray = new String[]{"action#name", "category#name"};
        builder.add((Object[])stringArray);
        for (String dataAttributeName : this.dataAttributeNames) {
            builder.add((Object)Intrinsics.stringPlus((String)"data#", (Object)dataAttributeName));
        }
        stringArray = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"builder.build()");
        return stringArray;
    }

    @Override
    @Nullable
    public String getKey(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        OrphanXmlElement xmlElement = new OrphanXmlElement(element, this.model);
        boolean bl = Intrinsics.areEqual((Object)xmlElement.getName().getLocalName(), (Object)this.nodeType);
        boolean bl2 = false;
        int n = 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ArrayList<String> subElementAttributes = new ArrayList<String>();
        n = 0;
        NodeList childNodes = element.getChildNodes();
        int n2 = childNodes.getLength();
        if (n < n2) {
            do {
                int i;
                Node child;
                if ((child = childNodes.item(i = n++)).getNodeType() != 1) continue;
                if (child == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.w3c.dom.Element");
                }
                OrphanXmlElement subElement = new OrphanXmlElement((Element)child, this.model);
                if (subElement.getType() == ManifestModel.NodeTypes.ACTION || subElement.getType() == ManifestModel.NodeTypes.CATEGORY) {
                    String attributeInfo = this.getAttributeInfo(subElement, "name");
                    if (attributeInfo == null) continue;
                    subElementAttributes.add(attributeInfo);
                    continue;
                }
                if (subElement.getType() != ManifestModel.NodeTypes.DATA) continue;
                for (String dataAttributeName : this.dataAttributeNames) {
                    Intrinsics.checkNotNullExpressionValue((Object)dataAttributeName, (String)"dataAttributeName");
                    String attributeInfo = this.getAttributeInfo(subElement, dataAttributeName);
                    if (attributeInfo == null) continue;
                    subElementAttributes.add(attributeInfo);
                }
            } while (n < n2);
        }
        CollectionsKt.sort((List)subElementAttributes);
        return Joiner.on((char)'+').join((Iterable)subElementAttributes);
    }

    private final String getAttributeInfo(OrphanXmlElement xmlElement, String attributeName) {
        Element element = xmlElement.getXml();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"xmlElement.xml");
        Element element2 = element;
        Attr attr = element2.getAttributeNodeNS("http://schemas.android.com/apk/res/android", attributeName);
        return attr == null ? (String)null : element2.getTagName() + ':' + attributeName + ':' + attr.getValue();
    }
}

