/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8wrappers;

import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.D8;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.ParseFlagInfo;
import com.android.tools.r8.ParseFlagPrinter;
import com.android.tools.r8.Version;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8wrappers.utils.WrapperDiagnosticsHandler;
import com.android.tools.r8wrappers.utils.WrapperFlag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class D8Wrapper {
    private static final String WRAPPER_STRING = "d8-aosp-wrapper";
    private static final Origin CLI_ORIGIN = new Origin(Origin.root()){

        @Override
        public String part() {
            return D8Wrapper.WRAPPER_STRING;
        }
    };
    private WrapperDiagnosticsHandler diagnosticsHandler = new WrapperDiagnosticsHandler();
    private boolean printInfoDiagnostics = false;

    private static List<ParseFlagInfo> getAdditionalFlagsInfo() {
        return Arrays.asList(new WrapperFlag("--info", "Print the info-level log messages from the compiler."));
    }

    private static String getUsageMessage() {
        StringBuilder builder = D8Wrapper.appendLines(new StringBuilder(), "Usage: d8 [options] [@<argfile>] <input-files>", " where <input-files> are any combination of dex, class, zip, jar or apk files", " and each <argfile> is a file containing additional arguments (one per line)", " and options are:");
        new ParseFlagPrinter().addFlags(D8Command.getParseFlagsInformation()).addFlags(D8Wrapper.getAdditionalFlagsInfo()).setIndent(2).appendLinesToBuilder(builder);
        return builder.toString();
    }

    private static StringBuilder appendLines(StringBuilder builder, String ... lines) {
        for (String line : lines) {
            builder.append(line).append(System.lineSeparator());
        }
        return builder;
    }

    public static void main(String[] args) throws CompilationFailedException {
        D8Wrapper wrapper = new D8Wrapper();
        String[] remainingArgs = wrapper.parseWrapperArguments(args);
        D8Command.Builder builder = D8Command.parse(remainingArgs, CLI_ORIGIN, wrapper.diagnosticsHandler);
        if (builder.isPrintHelp()) {
            System.out.println(D8Wrapper.getUsageMessage());
            return;
        }
        if (builder.isPrintVersion()) {
            System.out.println("D8(d8-aosp-wrapper) " + Version.getVersionString());
            return;
        }
        wrapper.applyWrapperArguments(builder);
        if (!builder.getAndroidPlatformBuild()) {
            System.setProperty("com.android.tools.r8.disableApiModeling", "1");
        }
        D8.run((D8Command)builder.build());
    }

    private String[] parseWrapperArguments(String[] args) {
        ArrayList<String> remainingArgs = new ArrayList<String>();
        block6: for (int i11 = 0; i11 < args.length; ++i11) {
            String arg;
            switch (arg = args[i11]) {
                case "--info": {
                    this.printInfoDiagnostics = true;
                    continue block6;
                }
                default: {
                    remainingArgs.add(arg);
                }
            }
        }
        return remainingArgs.toArray(new String[0]);
    }

    private void applyWrapperArguments(D8Command.Builder builder) {
        this.diagnosticsHandler.setPrintInfoDiagnostics(this.printInfoDiagnostics);
        if (builder.getMinApiLevel() == 10000) {
            builder.setAndroidPlatformBuild(true);
        }
    }
}

