/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.desugar.DefaultMethodsHelper;
import com.android.tools.r8.ir.desugar.InterfaceMethodRewriter;
import com.android.tools.r8.ir.synthetic.ForwardMethodSourceCode;
import com.android.tools.r8.ir.synthetic.SynthesizedCode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class ClassProcessor {
    private final InterfaceMethodRewriter rewriter;
    private final Set<DexClass> processedClasses = Sets.newIdentityHashSet();
    private final Map<DexEncodedMethod, DexEncodedMethod> createdMethods = new IdentityHashMap<DexEncodedMethod, DexEncodedMethod>();

    ClassProcessor(InterfaceMethodRewriter rewriter) {
        this.rewriter = rewriter;
    }

    final Set<DexEncodedMethod> getForwardMethods() {
        return this.createdMethods.keySet();
    }

    final void process(DexClass clazz) {
        DexClass superClass;
        assert (!clazz.isInterface());
        if (!clazz.isProgramClass()) {
            return;
        }
        if (!this.processedClasses.add(clazz)) {
            return;
        }
        DexType superType = clazz.superType;
        DexClass dexClass = superClass = superType == null ? null : this.rewriter.findDefinitionFor(superType);
        if (superClass != null && superType != this.rewriter.factory.objectType) {
            if (superClass.isInterface()) {
                throw new CompilationError("Interface `" + superClass.toSourceString() + "` used as super class of `" + clazz.toSourceString() + "`.");
            }
            this.process(superClass);
        }
        if (clazz.interfaces.isEmpty()) {
            return;
        }
        List<DexEncodedMethod> methodsToImplement = this.collectMethodsToImplement(clazz);
        if (methodsToImplement.isEmpty()) {
            return;
        }
        DexEncodedMethod[] existing = clazz.virtualMethods();
        clazz.setVirtualMethods(new DexEncodedMethod[existing.length + methodsToImplement.size()]);
        System.arraycopy(existing, 0, clazz.virtualMethods(), 0, existing.length);
        for (int i = 0; i < methodsToImplement.size(); ++i) {
            DexEncodedMethod newMethod;
            DexEncodedMethod method = methodsToImplement.get(i);
            assert (method.accessFlags.isPublic() && !method.accessFlags.isAbstract());
            clazz.virtualMethods()[existing.length + i] = newMethod = this.addForwardingMethod(method, clazz);
            this.createdMethods.put(newMethod, method);
        }
    }

    private DexEncodedMethod addForwardingMethod(DexEncodedMethod defaultMethod, DexClass clazz) {
        DexMethod method = defaultMethod.method;
        assert (this.rewriter.findDefinitionFor(method.holder) != null && !this.rewriter.findDefinitionFor(method.holder).isLibraryClass());
        DexMethod newMethod = this.rewriter.factory.createMethod(clazz.type, method.proto, method.name);
        MethodAccessFlags newFlags = defaultMethod.accessFlags.copy();
        return new DexEncodedMethod(newMethod, newFlags, defaultMethod.annotations, defaultMethod.parameterAnnotations, new SynthesizedCode(new ForwardMethodSourceCode(clazz.type, method.proto, null, this.rewriter.defaultAsMethodOfCompanionClass(method), Invoke.Type.STATIC)));
    }

    private List<DexEncodedMethod> collectMethodsToImplement(DexClass clazz) {
        List<DexEncodedMethod> candidates;
        DefaultMethodsHelper helper = new DefaultMethodsHelper();
        DexClass current = clazz;
        ArrayList<DexEncodedMethod> accumulatedVirtualMethods = new ArrayList<DexEncodedMethod>();
        while (current.type != this.rewriter.factory.objectType) {
            for (DexType type : current.interfaces.values) {
                helper.merge(this.rewriter.getOrCreateInterfaceInfo(clazz, current, type));
            }
            accumulatedVirtualMethods.addAll(Arrays.asList(clazz.virtualMethods()));
            List<DexEncodedMethod> defaultMethodsInDirectInterface = helper.createFullList();
            ArrayList<DexEncodedMethod> toBeImplementedFromDirectInterface = new ArrayList<DexEncodedMethod>(defaultMethodsInDirectInterface.size());
            this.hideCandidates(accumulatedVirtualMethods, defaultMethodsInDirectInterface, toBeImplementedFromDirectInterface);
            if (toBeImplementedFromDirectInterface.isEmpty() && defaultMethodsInDirectInterface.isEmpty()) {
                return Collections.emptyList();
            }
            if (current.superType == null) break;
            DexClass superClass = this.rewriter.findDefinitionFor(current.superType);
            if (superClass != null) {
                current = superClass;
                continue;
            }
            String message = "Default method desugaring of `" + clazz.toSourceString() + "` failed";
            message = current == clazz ? message + " because its super class `" + clazz.superType.toSourceString() + "` is missing" : message + " because it's hierarchy is incomplete. The class `" + current.superType.toSourceString() + "` is missing and it is the declared super class of `" + current.toSourceString() + "`";
            throw new CompilationError(message);
        }
        if ((candidates = helper.createCandidatesList()).isEmpty()) {
            return candidates;
        }
        ArrayList<DexEncodedMethod> toBeImplemented = new ArrayList<DexEncodedMethod>(candidates.size());
        current = clazz;
        while (true) {
            this.hideCandidates(Arrays.asList(current.virtualMethods()), candidates, toBeImplemented);
            if (candidates.isEmpty()) {
                return toBeImplemented;
            }
            DexType superType = current.superType;
            DexClass superClass = null;
            if (superType != null) {
                superClass = this.rewriter.findDefinitionFor(superType);
                assert (superClass != null);
            }
            if (superClass == null || superType == this.rewriter.factory.objectType) {
                toBeImplemented.addAll(candidates);
                toBeImplemented.removeIf(method -> {
                    DexClass holder = this.rewriter.findDefinitionFor(method.method.holder);
                    assert (holder != null);
                    return holder.isLibraryClass();
                });
                return toBeImplemented;
            }
            current = superClass;
        }
    }

    private void hideCandidates(List<DexEncodedMethod> virtualMethods, List<DexEncodedMethod> candidates, List<DexEncodedMethod> toBeImplemented) {
        Iterator<DexEncodedMethod> it = candidates.iterator();
        block0: while (it.hasNext()) {
            DexEncodedMethod candidate = it.next();
            for (DexEncodedMethod encoded : virtualMethods) {
                if (!candidate.method.match(encoded)) continue;
                DexEncodedMethod basedOnCandidate = this.createdMethods.get(encoded);
                if (basedOnCandidate != null && basedOnCandidate != candidate) {
                    toBeImplemented.add(candidate);
                }
                it.remove();
                continue block0;
            }
        }
    }
}

