/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.dex.BinaryReader;
import com.android.tools.r8.dex.DexOutputBuffer;
import java.util.Arrays;

public class LebUtils {
    static final /* synthetic */ boolean a;

    public static int parseUleb128(BinaryReader binaryReader) {
        byte by;
        int n2 = 0;
        int n3 = 0;
        do {
            by = binaryReader.b();
            n2 |= (by & 0x7F) << n3;
            n3 += 7;
        } while ((by & 0xFFFFFF80) == -128);
        if (!a && n3 > 35) {
            throw new AssertionError();
        }
        if (!a && n2 < 0) {
            throw new AssertionError();
        }
        return n2;
    }

    public static byte[] encodeUleb128(int n2) {
        byte[] byArray = new byte[5];
        int n3 = n2 >>> 7;
        int n4 = 0;
        while (n3 != 0) {
            byArray[n4++] = (byte)(n2 & 0x7F | 0x80);
            int n5 = n2 = n3 >>> 7;
            n2 = n3;
            n3 = n5;
        }
        byArray[n4] = (byte)(n2 & 0x7F);
        return Arrays.copyOf(byArray, n4 + 1);
    }

    public static void putUleb128(DexOutputBuffer dexOutputBuffer, int n2) {
        int n3 = n2 >>> 7;
        while (n3 != 0) {
            dexOutputBuffer.putByte((byte)(n2 & 0x7F | 0x80));
            int n4 = n2 = n3 >>> 7;
            n2 = n3;
            n3 = n4;
        }
        dexOutputBuffer.putByte((byte)(n2 & 0x7F));
    }

    public static int sizeAsUleb128(int n2) {
        return Math.max(1, (32 - Integer.numberOfLeadingZeros(n2) + 6) / 7);
    }

    public static int parseSleb128(BinaryReader binaryReader) {
        byte by;
        int n2 = 0;
        int n3 = 0;
        do {
            by = binaryReader.b();
            n2 |= (by & 0x7F) << n3;
            n3 += 7;
        } while ((by & 0xFFFFFF80) == -128);
        int n4 = 1 << n3 - 1;
        if (!a && n3 > 35) {
            throw new AssertionError();
        }
        return (n2 ^ n4) - n4;
    }

    public static byte[] encodeSleb128(int n2) {
        int n3 = n2;
        byte[] byArray = new byte[5];
        int n4 = n3 >> 7;
        boolean bl = true;
        int n5 = n3 >= 0 ? 0 : -1;
        int n6 = 0;
        while (bl) {
            bl = n4 != n5 || (n4 & 1) != (n2 >> 6 & 1);
            int n7 = n2;
            n2 = n6 + 1;
            int n8 = n7 & 0x7F;
            int n9 = bl ? 128 : 0;
            byArray[n6] = (byte)(n8 | n9);
            n6 = n4 >> 7;
            int n10 = n2;
            n2 = n4;
            n4 = n6;
            n6 = n10;
        }
        return Arrays.copyOf(byArray, n6);
    }

    public static void putSleb128(DexOutputBuffer dexOutputBuffer, int n2) {
        int n3 = n2;
        int n4 = n3 >> 7;
        boolean bl = true;
        int n5 = (n3 & Integer.MIN_VALUE) == 0 ? 0 : -1;
        while (bl) {
            bl = n4 != n5 || (n4 & 1) != (n2 >> 6 & 1);
            int n6 = bl ? 128 : 0;
            dexOutputBuffer.putByte((byte)((n2 &= 0x7F) | n6));
            int n7 = n2 = n4 >> 7;
            n2 = n4;
            n4 = n7;
        }
    }

    public static int sizeAsSleb128(int n2) {
        if (n2 < 0) {
            n2 ^= 0xFFFFFFFF;
        }
        return (32 - Integer.numberOfLeadingZeros(n2) + 7) / 7;
    }

    static {
        a = LebUtils.class.desiredAssertionStatus() ^ true;
    }
}

