/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.BaseCommand;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.io.Closer;
import com.android.tools.r8.dex.DexFileReader;
import com.android.tools.r8.dex.Segment;
import com.android.tools.r8.origin.CommandLineOrigin;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.StringDiagnostic;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;

public class DexSegments {
    public static void main(String[] args) throws IOException, CompilationFailedException, ResourceException {
        Command.Builder builder = Command.parse(args);
        Command command = (Command)builder.build();
        if (command.isPrintHelp()) {
            System.out.println(Command.USAGE_MESSAGE);
            return;
        }
        AndroidApp app = command.getInputApp();
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        try (Closer closer = Closer.create();){
            for (ProgramResource resource : app.computeAllProgramResources()) {
                if (resource.getKind() != ProgramResource.Kind.DEX) continue;
                for (Segment segment : DexFileReader.parseMapFrom(closer.register(resource.getByteStream()), resource.getOrigin())) {
                    int value2 = result.computeIfAbsent(segment.typeName(), key -> 0);
                    result.put(segment.typeName(), value2 + segment.size());
                }
            }
        }
        System.out.println("Segments in dex application (name: size):");
        result.forEach((key, value) -> System.out.println(" - " + key + ": " + value));
    }

    private static class Command
    extends BaseCommand {
        static final String USAGE_MESSAGE = String.join((CharSequence)"\n", ImmutableList.of("Usage: dexsegments [options] <input-files>", " where <input-files> are dex files", "  --version               # Print the version of r8.", "  --help                  # Print this message."));

        public static Builder builder() {
            return new Builder();
        }

        public static Builder parse(String[] args) {
            Builder builder = Command.builder();
            Command.parse(args, builder);
            return builder;
        }

        private static void parse(String[] args, Builder builder) {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i].trim();
                if (arg.length() == 0) continue;
                if (arg.equals("--help")) {
                    builder.setPrintHelp(true);
                    continue;
                }
                if (arg.startsWith("--")) {
                    builder.getReporter().error(new StringDiagnostic("Unknown option: " + arg, CommandLineOrigin.INSTANCE));
                }
                builder.addProgramFiles(Paths.get(arg, new String[0]));
            }
        }

        private Command(AndroidApp inputApp) {
            super(inputApp);
        }

        private Command(boolean printHelp) {
            super(printHelp, false);
        }

        @Override
        InternalOptions getInternalOptions() {
            return new InternalOptions();
        }

        public static class Builder
        extends BaseCommand.Builder<Command, Builder> {
            @Override
            Builder self() {
                return this;
            }

            @Override
            protected Command makeCommand() {
                if (this.isPrintHelp()) {
                    return new Command(this.isPrintHelp());
                }
                return new Command(this.getAppBuilder().build());
            }
        }
    }
}

