package com.qk.unity;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;

import org.json.JSONObject;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;


public class SDKUtils {

    private static String TAG = "SdkUtils";


    /**
     * 返回dataName节点的meatData值
     */
    public static String getMetaData(Context context, String dataName) {
        try {
            ApplicationInfo info = context.getPackageManager().getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
            if (info.metaData != null) {
                if (info.metaData.containsKey(dataName)) {
                    String metaData = "" + info.metaData.get(dataName);
                    Log.d("SDKUtils", "meta " + dataName + ":" + metaData);
                    return metaData;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            Log.e(TAG, "getMetaData Exception " + e.getMessage());
        }
        return "";
    }

    /**
     * 返回dataName节点的meatData值
     */
    public static int getIntMetaData(Context context, String dataName) {
        try {
            ApplicationInfo info = context.getPackageManager().getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
            if (info.metaData != null) {
                if (info.metaData.containsKey(dataName)) {
                    int metaData = info.metaData.getInt(dataName);
                    Log.d("SDKUtils", "metaData is:" + metaData);
                    return metaData;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            Log.e(TAG, "getIntMetaData Exception " + e.getMessage());
        }
        return -1;
    }

    public static boolean getBooleanMetaData(Context context, String dataName) {
        try {
            ApplicationInfo info = context.getPackageManager().getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
            if (info.metaData != null) {
                if (info.metaData.containsKey(dataName)) {
                    boolean metaData = info.metaData.getBoolean(dataName);
                    Log.d("SDKUtils", "metaData " + dataName + " is:" + metaData);
                    return metaData;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            Log.e(TAG, "getBooleanMetaData Exception " + e.getMessage());
        }
        return false;
    }

    static Bundle jsonStr2Bundle(String jsonStr) {
        Bundle bundle = new Bundle();
        if (TextUtils.isEmpty(jsonStr)) {
            return bundle;
        }
        try {
            JSONObject json = new JSONObject(jsonStr);
            Iterator<String> iter = json.keys();

            while (iter.hasNext()) {
                String key = iter.next();
                Object value = json.get(key);
                if (value instanceof String) {
                    bundle.putString(key, (String) value);
                } else if (value instanceof Long) {
                    bundle.putLong(key, (Long) value);
                } else if (value instanceof Integer) {
                    bundle.putInt(key, (Integer) value);
                } else if (value instanceof Double) {
                    bundle.putDouble(key, (Double) value);
                } else if (value instanceof Float) {
                    bundle.putFloat(key, (Float) value);
                } else {
                    bundle.putString(key, value.toString());
                }
            }
        } catch (Exception e) {

        }
        return bundle;
    }

    static Map<String, Object> jsonStr2Map(String jsonStr) {
        Map<String, Object> map = new HashMap<>();
        if (TextUtils.isEmpty(jsonStr)) {
            return map;
        }
        try {
            JSONObject json = new JSONObject(jsonStr);
            Iterator<String> iter = json.keys();

            while (iter.hasNext()) {
                String key = iter.next();
                Object value = json.get(key);
                map.put(key, value);
            }
        } catch (Exception e) {

        }
        return map;
    }
    static Map<String, String> jsonStr2StringMap(String jsonStr) {
        Map<String, String> map = new HashMap<>();
        if (TextUtils.isEmpty(jsonStr)) {
            return map;
        }
        try {
            JSONObject json = new JSONObject(jsonStr);
            Iterator<String> iter = json.keys();

            while (iter.hasNext()) {
                String key = iter.next();
                Object value = json.get(key);
                map.put(key, value.toString());
            }
        } catch (Exception e) {

        }
        return map;
    }


}
