package com.demo.test;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;
import com.quickgame.android.sdk.QuickGameManager;
import com.quickgame.android.sdk.QuickGameManager.QGPaymentCallback;
import com.quickgame.android.sdk.QuickGameManager.SDKCallback;
import com.quickgame.android.sdk.bean.QGOrderInfo;
import com.quickgame.android.sdk.bean.QGRoleInfo;
import com.quickgame.android.sdk.bean.QGUserData;
import com.quickgame.android.sdk.model.QGUserHolder;
import com.quickgame.android.sdk.utils.log.QGLog;
import com.test.demo.R;

public class MainActivity extends Activity {


    private static final String TAG = "MainActivity";
    private QuickGameManager sdkInstance;
    private Button loginBtn;
    private EditText edTotalFee;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        loginBtn = (Button) findViewById(R.id.login);
        edTotalFee = (EditText) findViewById(R.id.txt_totalfee);
        SampleSDKCallback sdkCallback = new SampleSDKCallback();
        sdkInstance = QuickGameManager.getInstance();
        QGLog.setDebugMod(true);
        // sdk init by your product code
        String product_code = "22604362356375536088084003178421";
        Log.d(TAG, "product code " + product_code);
        sdkInstance.init(this, product_code, sdkCallback);
        sdkInstance.onCreate(this);
    }

    // show login view
    public void callLogin(View v) {
        sdkInstance.login(this);
    }

    //show pay view
    public void callPayment(View v) {
        String totalFeeStr = edTotalFee.getText().toString();
        if (TextUtils.isEmpty(totalFeeStr)) {
            Toast.makeText(this, "please input goodsId", Toast.LENGTH_SHORT).show();
            return;
        }

        SamplePaymentCallback paymentCallback = new SamplePaymentCallback();

        QGOrderInfo orderInfo = new QGOrderInfo();
        orderInfo.setOrderSubject("replace with goods name");
        orderInfo.setProductOrderId("replace with game orderId");
        orderInfo.setAmount(0.99);
        orderInfo.setSuggestCurrency("USD");
        orderInfo.setGoodsId(totalFeeStr);
        orderInfo.setExtrasParams("extra params");

        QGRoleInfo roleInfo = new QGRoleInfo();
        roleInfo.setRoleId("replace with role id");
        roleInfo.setRoleLevel("1");
        roleInfo.setRoleName("replace with role name");
        roleInfo.setServerName("replace with server name");
        roleInfo.setVipLevel("1");
        roleInfo.setServerId("1");
        sdkInstance.pay(this, orderInfo, roleInfo, paymentCallback);
    }

    //logout
    public void callLogout(View v) {
        sdkInstance.logout(this);
    }


    // usercenter
    public void callUserCenter(View v) {
        sdkInstance.enterUserCenter(this);
    }

    public void callShowFloat(View v) {
        sdkInstance.showFloatView(this);
    }

    public void callCloseFloat(View v) {
        sdkInstance.closeFloatView(this);
    }

    //exit
    public void closeApp(View v) {
        finish();
    }

    /**
     * sdk login callback
     */
    private class SampleSDKCallback implements SDKCallback {

        @Override
        public void onLoginFinished(QGUserData userData, QGUserHolder loginState) {
            if (loginState.getStateCode() == QGUserHolder.LOGIN_SUCCESS) {
                //show float view
                sdkInstance.showFloatView(MainActivity.this);
                findViewById(R.id.ll_content).setVisibility(View.VISIBLE);
                Toast.makeText(MainActivity.this, "login success,uid:" + userData.getUid(), Toast.LENGTH_SHORT).show();


                //report role info when appropriate
                QGRoleInfo roleInfo = new QGRoleInfo();
                roleInfo.setRoleId("replace with role id");
                roleInfo.setRoleLevel("1");
                roleInfo.setRoleName("replace with role name");
                roleInfo.setServerName("replace with server name");
                roleInfo.setVipLevel("1");
                roleInfo.setServerId("1");
                sdkInstance.submitRoleInfo(roleInfo);
            } else {
                Toast.makeText(MainActivity.this, "login fail", Toast.LENGTH_SHORT).show();
            }
        }

        @Override
        public void onInitFinished(boolean isSuccess,String error) {
            if (isSuccess) {
                Toast.makeText(MainActivity.this, "init success", Toast.LENGTH_SHORT).show();
                loginBtn.setEnabled(true);
            } else {
                Toast.makeText(MainActivity.this, "init fail", Toast.LENGTH_SHORT).show();
            }
        }

        @Override
        public void onLogout() {
            MainActivity.this.runOnUiThread(new Runnable() {

                @Override
                public void run() {
                    Toast.makeText(MainActivity.this, "logout", Toast.LENGTH_SHORT).show();
                    MainActivity.this.findViewById(R.id.ll_content).setVisibility(View.GONE);
                    MainActivity.this.findViewById(R.id.login).setVisibility(View.VISIBLE);
                }
            });
        }

        @Override
        public void onGooglePlaySub(String goodsId, String sdkOrder, boolean isAutoRenewing, boolean isAcknowledged) {
            Log.d(TAG, "goodsId=" + goodsId + "&&sdkOrder=" + sdkOrder);
        }
    }

    /**
     * pay callback
     */
    private class SamplePaymentCallback implements QGPaymentCallback {

        @Override
        public void onPaySuccess(String orderId, String orderNo, String goodsId, String extraParams) {
            Toast.makeText(MainActivity.this, "pay success", Toast.LENGTH_SHORT).show();
        }

        @Override
        public void onPayFailed(String orderId, String orderNo, String errorMessage) {
            Toast.makeText(MainActivity.this, "pay fail:" + errorMessage, Toast.LENGTH_SHORT).show();
        }

        @Override
        public void onPayCancel(String orderId, String orderNo, String errorMessage) {
            Toast.makeText(MainActivity.this, "pay cancel", Toast.LENGTH_SHORT).show();
        }

    }

    @Override
    protected void onStart() {
        super.onStart();
        sdkInstance.onStart(this);
    }

    @Override
    protected void onResume() {
        super.onResume();
        sdkInstance.onResume(this);
    }

    @Override
    protected void onPause() {
        super.onPause();
        sdkInstance.onPause(this);
    }

    @Override
    protected void onStop() {
        super.onStop();
        sdkInstance.onStop(this);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        sdkInstance.onDestroy(this);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        sdkInstance.onActivityResult(requestCode, resultCode, data);
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        sdkInstance.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }
}
