package com.qk.unity;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.ImageDecoder;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Handler.Callback;
import android.os.Message;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.Log;
import androidx.core.content.ContextCompat;
import com.android.billingclient.api.SkuDetails;
import com.appsflyer.AppsFlyerConversionListener;
import com.appsflyer.AppsFlyerLib;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.share.Sharer;
import com.quickgame.android.sdk.AppsFlyerManager;
import com.quickgame.android.sdk.QuickGameManager;
import com.quickgame.android.sdk.SDKConfig;
import com.quickgame.android.sdk.bean.QGOrderInfo;
import com.quickgame.android.sdk.bean.QGRoleInfo;
import com.quickgame.android.sdk.bean.QGUserBindInfo;
import com.quickgame.android.sdk.bean.QGUserData;
import com.quickgame.android.sdk.firebase.HWFirebaseManager;
import com.quickgame.android.sdk.listener.CallBackListener;
import com.quickgame.android.sdk.listener.LoginEventTraceListener;
import com.quickgame.android.sdk.listener.QueryGoogleSkuListener;
import com.quickgame.android.sdk.model.QGUserHolder;
import com.unity3d.player.UnityPlayer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
//Flag_import_end


public class QuickUnityPlayerProxyActivity extends com.unity3d.player.UnityPlayerActivity implements Callback {

    private static final String TAG = "QGUnityProxyImp";

    private static final int MSG_LOGIN = 1;
    private static final int MSG_LOGOUT = 2;
    private static final int MSG_PAY = 3;
    private static final int MSG_ROLEINFO = 4;
    private static final int MSG_SHARE = 5;
    private static final int MSG_USERCENTER = 6;
    private static final int MSG_USER_REMOVE = 7;
    private static final int MSG_USER_REMOVE_NOUI = 8;

    private static final int MSG_FREE_LOGIN = 101;
    private static final int MSG_GOOGLE_LOGIN = 102;
    private static final int MSG_FACEBOOK_LOGIN = 103;

    private static final int MSG_SHARE_URL = 201;
    private static final int MSG_SHARE_IMG = 202;
    private static final int MSG_SHOW_FLOAT = 203;
    private static final int MSG_CLOSE_FLOAT = 204;
    private static final int MSG_SHARE_TIKTOK = 205;
    private static final int MSG_SHARE_TIKTOK2 = 206;
    private static final int MSG_SHARE_TIKTOK3 = 207;
    private static final int MSG_SHARE_INS = 208;
    private static final int MSG_BIND_USER = 209;
    private static final int MSG_GO_CHAT = 301;

    private static final int MSG_GOOGLE_REVIEW = 302;


    private static final int INIT_SUCCESS = 1;
    private static final int INIT_FAILED = -1;
    private static final int INIT_DEFAULT = 0;


    private String gameObjectName;

    private int initState = INIT_DEFAULT;

    private String mInitMsg = "";
    private QGUserData mUserData = null;

    Handler mHandler = new Handler(this);


    private QuickGameManager sdk;

    private boolean haveCustomServiceSDK;

    private SamplePaymentCallback paymentCallback ;

    @Override
    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        Log.d(TAG, "onCreate");
        sdk = QuickGameManager.getInstance();
        sdk.onCreate(this);
        sdkConfig();
        try{
            Class.forName("com.qk.plugin.customservice.QKCustomService");
            haveCustomServiceSDK = true;
            sdk.setCustomerServiceCallback(new QuickGameManager.CustomerServiceCallback() {
                @Override
                public void onCustomerServiceClicked() {

                }
            });
        }catch (Exception e){
            Log.d(TAG,"haveCustomService "+haveCustomServiceSDK);
            haveCustomServiceSDK = false;
        }
        paymentCallback = new SamplePaymentCallback();
        sdk.setPaymentCallback(paymentCallback);
    }

    @Override
    protected void onStart() {
        Log.d(TAG, "onStart");
        sdk.onStart(this);
        super.onResume();
        onWindowFocusChanged(true);
        super.onStart();
        if(haveCustomServiceSDK){

        }
    }

    @Override
    protected void onResume() {
        Log.d(TAG, "onResume");
        sdk.onResume(this);
        super.onResume();
    }

    @Override
    protected void onPause() {
        Log.d(TAG, "onPause");
        sdk.onPause(this);
        super.onPause();
    }

    @Override
    protected void onStop() {
        Log.d(TAG, "onStop");
        sdk.onStop(this);
        super.onStop();
    }

    @Override
    protected void onDestroy() {
        Log.d(TAG, "onDestroy");
        sdk.onDestroy(this);
        super.onDestroy();
        if(haveCustomServiceSDK){

        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        Log.d(TAG, "onRequestPermissionsResult");
        sdk.onRequestPermissionsResult(requestCode, permissions, grantResults);
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }


    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        Log.d(TAG, "onActivityResult");
        sdk.onActivityResult(requestCode, resultCode, data);
        super.onActivityResult(requestCode, resultCode, data);
    }

    private void sdkConfig(){
        if(SDKUtils.getBooleanMetaData(this,"AF_DEBUG")){
            AppsFlyerLib.getInstance().setDebugLog(true);
        }
        Log.d(TAG, "doInit");
        if (!TextUtils.isEmpty(SDKUtils.getMetaData(this, "AF_Purchase_MORE"))) {
            SDKConfig sdkConfig = new SDKConfig.Builder()
                .setMoreAppsFlyerPurchaseEvent(SDKUtils.getMetaData(this, "AF_Purchase_MORE"))
                .build();
            sdk.setSdkConfig(sdkConfig);
        }

        sdk.setLoginEventTraceListener(new LoginEventTraceListener() {
            @Override
            public void onEvent(LoginEvent loginEvent, String msg) {
                Log.d(TAG, "LoginEventTrace=" + loginEvent.name());
                final JSONObject json = new JSONObject();
                try {
                    json.put("name", "" + loginEvent.name());
                    json.put("msg", "" + msg);
                } catch (Exception e) {
                }
                callUnityFunc("callLoginTraceEventToGame", json.toString());
            }
        });
    }

    public void doInit() {
        SampleSDKCallback sdkCallback = new SampleSDKCallback();
        String productCode = "";
        try {
            String QKproductCode = getMeta(this, "QKproductCode");
            Log.d(TAG, "QKproductCode=" + QKproductCode);
            productCode = QKproductCode.substring(2);
        } catch (Exception e) {
            e.printStackTrace();
            Log.e(TAG, "get ProductCode exception: " + e.getMessage());
        }
        Log.d(TAG, "productCode=" + productCode);

        AppsFlyerManager.setConversionListener(new AppsFlyerConversionListener() {
            @Override //AppsFlyerManager
            public void onConversionDataSuccess(Map<String, Object> map) { //AppsFlyerManager
                JSONObject jsonObject = new JSONObject(map);   //AppsFlyerManager
                String jsonString = jsonObject.toString();    //AppsFlyerManager
                callUnityFunc("onConversionDataSuccess",jsonString); //AppsFlyerManager
            }//AppsFlyerManager

            @Override //AppsFlyerManager
            public void onConversionDataFail(String s) {//AppsFlyerManager
                callUnityFunc("onConversionDataFail",s); //AppsFlyerManager
            }//AppsFlyerManager

            @Override//AppsFlyerManager
            public void onAppOpenAttribution(Map<String, String> map) {//AppsFlyerManager
                JSONObject jsonObject = new JSONObject(map);   //AppsFlyerManager
                String jsonString = jsonObject.toString();    //AppsFlyerManager
                callUnityFunc("onAppOpenAttribution",jsonString); //AppsFlyerManager
            }//AppsFlyerManager

            @Override//AppsFlyerManager
            public void onAttributionFailure(String s) {//AppsFlyerManager
                callUnityFunc("onAttributionFailure",s); //AppsFlyerManager
            }//AppsFlyerManager
        });//AppsFlyerManager

        sdk.init(this, productCode, sdkCallback);
    }


    public void requestLogin() {
        Log.d(TAG, "requestLogin");
        mHandler.sendEmptyMessage(MSG_LOGIN);

    }

    public void requestFreeLogin() {
        Log.d(TAG, "requestFreeLogin");
        mHandler.sendEmptyMessage(MSG_FREE_LOGIN);
    }

    public void requestGoogleLogin() {
        Log.d(TAG, "requestGoogleLogin");
        mHandler.sendEmptyMessage(MSG_GOOGLE_LOGIN);
    }

    public void requestFacebookLogin() {
        Log.d(TAG, "requestFacebookLogin");
        mHandler.sendEmptyMessage(MSG_FACEBOOK_LOGIN);
    }

    public void requestLogout() {
        Log.d(TAG, "requestLogout");
        mHandler.sendEmptyMessage(MSG_LOGOUT);
    }

    public void requestUserTrash() {
        Log.d(TAG, "requestUserTrash");
        mHandler.sendEmptyMessage(MSG_USER_REMOVE);
    }
    public void requestUserTrashNoUI() {
        Log.d(TAG, "requestUserTrashNoUI");
        mHandler.sendEmptyMessage(MSG_USER_REMOVE_NOUI);
    }

    public void requestShare(String serverId, String roleId) {
        Log.d(TAG, "requestShare 1");
        Message msg = mHandler.obtainMessage(MSG_SHARE);
        HashMap<String, String> mapObj = new HashMap<String, String>();
        mapObj.put("serverId", serverId);
        mapObj.put("roleId", roleId);
        msg.obj = mapObj;
        msg.sendToTarget();
    }

    public void requestShareUrl(String url, String shareObjectName) {
        Log.d(TAG, "requestShareUrl");
        Message msg = mHandler.obtainMessage(MSG_SHARE_URL);
        msg.obj = url;
        msg.sendToTarget();
    }

    public void requestShareImg(String img, String shareObjectName) {
        Log.d(TAG, "requestShareImg " + img);

        Bitmap bitmap = null;
        Uri imageUri = Uri.parse(img);
        try {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.P) {
                bitmap = ImageDecoder.decodeBitmap(ImageDecoder.createSource(getContentResolver(), imageUri));
            } else {
                bitmap = MediaStore.Images.Media.getBitmap(getContentResolver(), imageUri);
            }
        } catch (IOException e) {
            File file = new File(img);
            if (file.exists()) {
                bitmap = BitmapFactory.decodeFile(img);
            } else {
                Log.w(TAG, "requestShareImg IOException " + e.getMessage());
                return;
            }
        }
        if (bitmap == null) {
            Log.w(TAG, "requestShareImg error: file not exist");
            return;
        }
        Message msg = mHandler.obtainMessage(MSG_SHARE_IMG);
        msg.obj = bitmap;
        msg.sendToTarget();
    }

    public void requestUserCenter() {
        Log.d(TAG, "requestUserCenter");
        mHandler.sendEmptyMessage(MSG_USERCENTER);
    }

    public void requestShowFloat() {
        Log.d(TAG, "requestShowFloat");
        if (sdk == null) {
            return;
        }
        mHandler.sendEmptyMessage(MSG_SHOW_FLOAT);
    }

    public void requestCloseFloat() {
        Log.d(TAG, "requestCloseFloat");
        if (sdk == null) {
            return;
        }
        mHandler.sendEmptyMessage(MSG_CLOSE_FLOAT);
    }

    public String getUserId() {
        Log.d(TAG, "getUserId");
        if (QuickGameManager.getInstance().getUser() == null) {
            return "";
        }
        return QuickGameManager.getInstance().getUser().getUid();
    }

    public void requestPay(String OrderSubject, String ProductOrderId, String ExtrasParams, String Amount, String GoodsId, String skuType,
                           String currency, String callBackUrl,
                           String RoleId, String RoleLevel, String RoleName, String ServerName, String VipLevel) {
        Log.d(TAG, "requestPay");
        QGOrderInfo orderInfo = new QGOrderInfo();
        orderInfo.setOrderSubject(OrderSubject);
        orderInfo.setProductOrderId(ProductOrderId);
        orderInfo.setAmount(Double.parseDouble(Amount));
        orderInfo.setSuggestCurrency(currency);
        orderInfo.setGoodsId(GoodsId);
        if (!TextUtils.isEmpty(ExtrasParams)) {
            orderInfo.setExtrasParams(ExtrasParams);
        }
        if (!TextUtils.isEmpty(callBackUrl)) {
            orderInfo.setCallbackURL(callBackUrl);
        }
        if (TextUtils.isEmpty(skuType)) {
            orderInfo.setSkuType("inapp");
        } else {
            orderInfo.setSkuType(skuType);
        }

        QGRoleInfo roleInfo = new QGRoleInfo();
        roleInfo.setRoleId(RoleId);
        roleInfo.setRoleLevel(RoleLevel);
        roleInfo.setRoleName(RoleName);
        roleInfo.setServerName(ServerName);
        roleInfo.setVipLevel(VipLevel);

        Message msg = mHandler.obtainMessage(MSG_PAY);
        HashMap<String, Object> mapObj = new HashMap<String, Object>();
        mapObj.put("orderInfo", orderInfo);
        mapObj.put("roleInfo", roleInfo);
        msg.obj = mapObj;
        msg.sendToTarget();

    }

    public void requestUpdateRole(String serverName, String serverId, String roleName, String roleId, String vipLevel, String roleLevel) {
        Log.d(TAG, "requestUpdateRole");
        QGRoleInfo roleInfo = new QGRoleInfo();
        roleInfo.setRoleId(roleId);
        roleInfo.setRoleLevel(roleLevel);
        roleInfo.setRoleName(roleName);
        roleInfo.setServerName(serverName);
        roleInfo.setVipLevel(vipLevel);
        roleInfo.setServerId(serverId);

        Message msg = mHandler.obtainMessage(MSG_ROLEINFO);
        msg.arg1 = 0;
        msg.obj = roleInfo;
        msg.sendToTarget();

    }

    public void requestFacebookEvent(String eventName, double value, String eventParams) {
        Log.d(TAG, "facebook report:" + eventName + "," + value + "," + eventParams);
        sdk.logEvent(eventName, value, SDKUtils.jsonStr2Bundle(eventParams));
    }

    public void requestFacebookInitiatedCheckout(String goodsName, String goodsId, String goodsType, int numItems, boolean paymentInfoAvailable, String currency, double totalPrice) {
        Log.d(TAG, "facebook requestFacebookInitiatedCheckout report  :" + goodsId + "," + currency + "," + totalPrice);
        sdk.logInitiateCheckoutEvent(goodsName, goodsId, goodsType, numItems, paymentInfoAvailable, currency, totalPrice);
    }

    public void requestFacebookPurchase(double amount, String currency, String eventParams) {
        Log.d(TAG, "facebook purchase report:" + amount + "," + currency + "," + eventParams);
        sdk.logFbPurchase(amount, currency, SDKUtils.jsonStr2Bundle(eventParams));
    }

    public void requestAppsFlyerEvent(String eventName, String eventParams) {
        Log.d(TAG, "af report:" + eventName + "," + eventParams);
        sdk.appsFlyerEvent(eventName, SDKUtils.jsonStr2Map(eventParams));
    }

    public void requestAdjustEvent(String eventToken) {
        Log.d(TAG, "adj report:" + eventToken);
        sdk.trackAdjustEvent(eventToken);
    }

    public void requestAdjustEvent(String eventToken,String callbackParams) {
        Log.d(TAG, "adj report:" + eventToken);
        sdk.trackAdjustEvent(eventToken, SDKUtils.jsonStr2StringMap(callbackParams));
    }

    public void requestShareToTikTok(String filePath) {
        Log.d(TAG, "requestShareToTikTok:" + filePath);
        Message msg = mHandler.obtainMessage(MSG_SHARE_TIKTOK);
        msg.obj = filePath;
        msg.sendToTarget();
    }

    public void requestShareToTikTok2(String filePaths) {
        Log.d(TAG, "requestShareToTikTok2:" + filePaths);
        Message msg = mHandler.obtainMessage(MSG_SHARE_TIKTOK2);
        msg.obj = filePaths;
        msg.sendToTarget();
    }

    public void requestShareToTikTokVideo(String filePaths) {
        Log.d(TAG, "requestShareToTikTokVideo:" + filePaths);
        Message msg = mHandler.obtainMessage(MSG_SHARE_TIKTOK3);
        msg.obj = filePaths;
        msg.sendToTarget();
    }

    public void requestShareToIns(String filePath) {
        Log.d(TAG, "requestShareToIns:" + filePath);
        Message msg = mHandler.obtainMessage(MSG_SHARE_INS);
        msg.obj = filePath;
        msg.sendToTarget();
    }

    public void requestBindUser(String bindType) {
        Log.d(TAG, "requestBindUser:" + bindType);
        Message msg = mHandler.obtainMessage(MSG_BIND_USER);
        msg.obj = bindType;
        msg.sendToTarget();
    }

    public void requestAdjustEvent(String eventToken, String orderId, String amount, String currency) {
        Log.d(TAG, "adj report pay event:" + eventToken);
        sdk.trackAdjustEvent(eventToken, orderId, Double.parseDouble(amount), currency);
    }

    public void requestAdjustEvent(String eventToken, String orderId, String amount, String currency,String callbackParams) {
        Log.d(TAG, "adj report pay event:" + eventToken);
        sdk.trackAdjustEvent(eventToken, orderId, Double.parseDouble(amount), currency, SDKUtils.jsonStr2StringMap(callbackParams));
    }

    public void requestAdjustAdRevenue(String source, String amount, String currency,int impressionsCount,String revenueNetwork,
        String revenueUnit,String adRevenuePlacement, String callbackParams) {
        Log.d(TAG, "adj report AdRevenue:" + source);
        Log.d(TAG, "adj report impressionsCount:" + impressionsCount);
        Log.d(TAG, "adj report adRevenuePlacement:" + adRevenuePlacement);
        Log.d(TAG, "adj report callbackParams:" + callbackParams);
        sdk.trackAdjustAdRevenue(source, Double.parseDouble(amount), currency,impressionsCount,revenueNetwork,
            revenueUnit, adRevenuePlacement,SDKUtils.jsonStr2StringMap(callbackParams));
    }

    public void requestFirebaseEvent(String eventName, String eventParams) {
        Log.d(TAG, "firebase report:" + eventName + "," + eventParams);

        HWFirebaseManager.getInstance().logCustomEvent(eventName, SDKUtils.jsonStr2Bundle(eventParams));
    }

    public void requestQueryGoogleSku(String goodsIdsStr) {
        Log.d(TAG, "requestQueryGoogleSkuDetail " + goodsIdsStr);
        if (TextUtils.isEmpty(goodsIdsStr)) {
            callUnityFunc("onQueryGoogleSkuResult", "");
            return;
        }
        String[] goodsIdsArr = goodsIdsStr.split(",");
        List<String> goodsIds = Arrays.asList(goodsIdsArr);
        sdk.queryGoogleSku(goodsIds, new QueryGoogleSkuListener() {
            @Override
            public void onResult(List<SkuDetails> list) {
                if (list == null || list.isEmpty()) {
                    callUnityFunc("onQueryGoogleSkuResult", "");
                } else {
                    JSONArray jsonArray = new JSONArray();
                    for (SkuDetails skuDetails : list) {
                        jsonArray.put(skuDetails.getOriginalJson());
                    }
                    callUnityFunc("onQueryGoogleSkuResult", jsonArray.toString());
                }
            }
        });

    }

    public String requestAppsFlyerId() {
        return sdk.getAppsFlyerId(this);
    }

    public String requestCountryInfo() {
        return new JSONObject(sdk.getCountryInfo()).toString();
    }

    public void requestTapDBTrackEvent(String eventName, String properties) {
        Log.d(TAG, "requestTapDBTrackEvent " + eventName + " / " + properties);
        try {
            JSONObject jsonObject = new JSONObject();
            if (!TextUtils.isEmpty(properties)) {
                jsonObject = new JSONObject(properties);
            }
            sdk.tapDBTrackEvent(eventName, jsonObject);
        } catch (Exception e) {
            sdk.tapDBTrackEvent(eventName, null);
        }
    }

    public void requestTapDBRegisterStaticProperties(String staticProperties) {
        try {
            JSONObject jsonObject = new JSONObject(staticProperties);
            sdk.tapDBRegisterStaticProperties(jsonObject);
        } catch (Exception e) {
            Log.w(TAG, "requestTapDBRegisterStaticProperties " + e.getMessage());
        }
    }


    public void requestTapDBUnregisterStaticProperty(String propertyName) {
        sdk.tapDBUnregisterStaticProperty(propertyName);
    }

    public void requestTapDBClearStaticProperties() {
        sdk.tapDBClearStaticProperties();
    }


    public void requestTapDBDeviceUpdate(String properties) {
        try {
            JSONObject jsonObject = new JSONObject(properties);
            sdk.tapDBDeviceUpdate(jsonObject);
        } catch (Exception e) {
            Log.w(TAG, "tapDBDeviceUpdate " + e.getMessage());
        }
    }

    public void requestTapDBDeviceInitialize(String properties) {
        try {
            JSONObject jsonObject = new JSONObject(properties);
            sdk.tapDBDeviceInitialize(jsonObject);
        } catch (Exception e) {
            Log.w(TAG, "tapDBDeviceInitialize " + e.getMessage());
        }
    }

    public void requestTapDBDeviceAdd(String properties) {
        try {
            JSONObject jsonObject = new JSONObject(properties);
            sdk.tapDBDeviceAdd(jsonObject);
        } catch (Exception e) {
            Log.w(TAG, "tapDBDeviceAdd " + e.getMessage());
        }
    }

    public void requestTapDBUserUpdate(String properties) {
        try {
            JSONObject jsonObject = new JSONObject(properties);
            sdk.tapDBUserUpdate(jsonObject);
        } catch (Exception e) {
            Log.w(TAG, "tapDBUserUpdate " + e.getMessage());
        }
    }

    public void requestTDLogin(String identification) {
    }

    public void requestTDSetSuperProperties(String data) {
        try {
            JSONObject jsonObject = new JSONObject(data);
        } catch (Exception e) {
            Log.w(TAG, "requestTDSetSuperProperties " + e.getMessage());
        }
    }

    public void requestTDEnableAutoTrack(int data) {
        try {
        } catch (Exception e) {
            Log.w(TAG, "requestTDEnableAutoTrack " + e.getMessage());
        }
    }

    public void requestTDTrack(String eventName, String data) {
        try {
            JSONObject jsonObject = new JSONObject(data);
        } catch (Exception e) {
            Log.w(TAG, "requestTDTrack " + e.getMessage());
        }
    }

    public void requestTDUserSet(String data) {
        try {
            JSONObject jsonObject = new JSONObject(data);
        } catch (Exception e) {
            Log.w(TAG, "requestTDUserSet " + e.getMessage());
        }
    }


    public void requestSingleGameOrderFinish(String sdkOrderId) {
        Log.d(TAG, "singleGameOrderFinish:" + sdkOrderId);
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                sdk.singleGameOrderFinish(sdkOrderId);
            }
        });
    }

    public void requestTapDBUserInitialize(String properties) {
        try {
            JSONObject jsonObject = new JSONObject(properties);
            sdk.tapDBUserInitialize(jsonObject);
        } catch (Exception e) {
            Log.w(TAG, "tapDBUserInitialize " + e.getMessage());
        }
    }
    public void requestCustomInit(String appId, String uid, String userName, String roleId, String roleName, String serverName, String vipLv, String channelCode, String deviceName, String title) {
        if(!haveCustomServiceSDK){
          Log.d(TAG, "not found custom service sdk");
          return;
        }
        Log.d(TAG, "requestCustomInit");
        //Flag_CustomService_Init
    }

    public void requestGoChatActivity() {
        if(!haveCustomServiceSDK){
          Log.d(TAG, "not found custom service sdk");
          return;
        }
        Log.d(TAG, "requestGoChatActivity");
        Message msg = mHandler.obtainMessage(MSG_GO_CHAT);
        msg.sendToTarget();
    }

    public void requestOpenReview() {
        Log.d(TAG, "requestOpenReview");
        Message msg = mHandler.obtainMessage(MSG_GOOGLE_REVIEW);
        msg.sendToTarget();
    }

    public void requestTapDBUserAdd(String properties) {
        try {
            JSONObject jsonObject = new JSONObject(properties);
            sdk.tapDBUserAdd(jsonObject);
        } catch (Exception e) {
            Log.w(TAG, "tapDBUserAdd " + e.getMessage());
        }
    }
    public void requestAdjustId() {
        try {
        } catch (Exception e) {
            Log.w(TAG, "requestAdjustId " + e.getMessage());
        }
    }
    public void hideUserCenterLogout() {
        //Flag_Hide_User_Center_Logout
    }

    public void hideAutoLoginWaiting(){
        //Flag_Hide_Auto_Login_Waiting
    }

    public void setUnityGameObjectName(String gameObjectName) {
        this.gameObjectName = gameObjectName;
        Log.d(TAG, "gameObjectName=" + gameObjectName);
        switch (initState) {
            case INIT_SUCCESS:
                Log.d(TAG, "onInitSuccess");
                callUnityFunc("onInitSuccess", new JSONObject().toString());
                break;
            case INIT_FAILED:
                Log.d(TAG, "onInitFailed");
                JSONObject json = new JSONObject();
                try {
                    json.put("msg", mInitMsg);
                } catch (Exception e) {
                    e.printStackTrace();
                }
                callUnityFunc("onInitFailed", json.toString());
                break;

            default:
                break;
        }
        initState = INIT_DEFAULT;

    }

    public void callUnityFunc(String funcName, String paramStr) {
        if (TextUtils.isEmpty(gameObjectName)) {
            Log.d(TAG, "gameObject is null, please set gameObject first");
            return;
        }
        Log.d(TAG, "callUnityFunc " + funcName);
        if (!TextUtils.isEmpty(paramStr))
            Log.d(TAG, "callUnityFunc param " + paramStr);
        UnityPlayer.UnitySendMessage(gameObjectName, funcName, paramStr);
    }

    @SuppressWarnings("unchecked")
    @Override
    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case MSG_LOGIN:
                Log.d(TAG, "login");
                sdk.login(this);
                break;
            case MSG_FREE_LOGIN:
                Log.d(TAG, "freeLogin");
                sdk.freeLogin(this, true);
                break;
            case MSG_GOOGLE_LOGIN:
                Log.d(TAG, "googleLogin");
                sdk.googleLogin(this);
                break;
            case MSG_FACEBOOK_LOGIN:
                Log.d(TAG, "facebookLogin");
                sdk.facebookLogin(this);
                break;
            case MSG_LOGOUT:
                Log.d(TAG, "logout");
                sdk.logout(this);
                break;
            case MSG_USER_REMOVE:
                Log.d(TAG, "UserTrash");
                sdk.UserTrash(this);
                break;
            case MSG_USER_REMOVE_NOUI:
                Log.d(TAG, "UserTrash");
                sdk.UserTrashNoUI(this);
                break;
            case MSG_PAY: {
                Log.d(TAG, "pay");
                HashMap<String, Object> mapObj = (HashMap<String, Object>) msg.obj;
                QGOrderInfo orderInfo = (QGOrderInfo) mapObj.get("orderInfo");
                QGRoleInfo roleInfo = (QGRoleInfo) mapObj.get("roleInfo");
                sdk.pay(QuickUnityPlayerProxyActivity.this, orderInfo, roleInfo, paymentCallback);
                break;
            }
            case MSG_ROLEINFO: {

                Log.d(TAG, "update role info");

                QGRoleInfo roleInfo = (QGRoleInfo) msg.obj;
                sdk.submitRoleInfo(roleInfo);
                break;
            }
            case MSG_SHARE: {
                HashMap<String, String> mapObj = (HashMap<String, String>) msg.obj;
                String serverId = mapObj.get("serverId");
                String roleId = mapObj.get("roleId");
                sdk.callFacebookSharePost(QuickUnityPlayerProxyActivity.this, serverId, roleId);
            }
            break;
            case MSG_SHARE_URL: {
                String url = (String) msg.obj;
                sdk.facebookSharePost(QuickUnityPlayerProxyActivity.this, url, new FacebookShareCallback());
            }
            break;
            case MSG_SHARE_IMG: {
                Bitmap img = (Bitmap) msg.obj;
                sdk.facebookShareBitmap(QuickUnityPlayerProxyActivity.this, img, new FacebookShareCallback());
            }
            break;
            case MSG_USERCENTER: {
                sdk.enterUserCenter(QuickUnityPlayerProxyActivity.this);
            }
            break;
            case MSG_CLOSE_FLOAT:
                Log.d(TAG, "close float");
                sdk.closeFloatView(this);
                break;
            case MSG_SHOW_FLOAT:
                Log.d(TAG, "show float");
                sdk.showFloatView(this);
                break;
            case MSG_SHARE_TIKTOK:
                try {
                    sdk.shareToTikTok(this, (String) msg.obj);
                } catch (Exception e) {
                    Log.e(TAG, "shareToTikTok " + e.getMessage());
                }
                break;
            case MSG_SHARE_TIKTOK2:
                try {
                    String filePaths = (String) msg.obj;
                    String[] pathArr = filePaths.split(",");
                    List<String> list = Arrays.asList(pathArr);
                    sdk.shareToTikTok(this, new ArrayList<>(list));
                } catch (Exception e) {
                    Log.e(TAG, "shareToTikTok " + e.getMessage());
                }
                break;
            case MSG_SHARE_TIKTOK3:
                try {
                    sdk.shareVideoToTiktok(this,(String) msg.obj);
                } catch (Exception e) {
                    Log.e(TAG, "shareToTikTok " + e.getMessage());
                }
                break;
            case MSG_SHARE_INS:
                try {
                    sdk.shareToInstagram(this, (String) msg.obj);
                } catch (Exception e) {
                    Log.e(TAG, "shareToInstagram " + e.getMessage());
                }
                break;
            case MSG_BIND_USER:
                try {
                    sdk.setUserBindCallback(new BindUnbindUserCallback());
                    sdk.bindUser((String) msg.obj);
                } catch (Exception e) {
                    Log.e(TAG, "bindUser " + e.getMessage());
                }
                break;
            case MSG_GO_CHAT:
                Log.d(TAG, "MSG_GO_CHAT");
                //Flag_CustomService_GO_CHAT
                break;
            case MSG_GOOGLE_REVIEW:
                sdk.openReview(this, new CallBackListener() {
                    @Override
                    public void onFinish() {
                        callUnityFunc("oNOpenReviewFinish", "");
                    }
                });
                break;
            default:
                break;
        }
        return false;
    }

    private class SampleSDKCallback implements QuickGameManager.SDKCallback {

        @Override
        public void onLoginFinished(QGUserData userData, QGUserHolder loginState) {
            Log.d(TAG, "onLoginFinished");
            if (loginState.getStateCode() == QGUserHolder.LOGIN_SUCCESS) {
                Log.d(TAG, "LOGIN_SUCCESS>uid:" + userData.getUid());
                JSONObject json = new JSONObject();
                try {
                    mUserData = userData;
                    json.put("userName", userData.getUserName());
                    json.put("userId", userData.getUid());
                    json.put("userToken", userData.getToken());
                    json.put("openType", userData.getOpenType());
                    json.put("isGuest", userData.isGuest());
                    json.put("msg", "success");
                } catch (Exception e) {
                    e.printStackTrace();
                }
                callUnityFunc("onLoginSuccess", json.toString());
            } else if(loginState.getStateCode() == QGUserHolder.LOGIN_CANCEL){
                Log.d(TAG, "onLoginCancel");
                callUnityFunc("onLoginFailed", loginState.toString());
            }else {
                Log.d(TAG, "onLoginFailed");
                callUnityFunc("onLoginFailed", loginState.toString());
            }
        }

        @Override
        public void onLogout() {
            Log.d(TAG, "onLogoutSuccess");
            callUnityFunc("onLogoutSuccess", "success");
        }

        @Override
        public void onGooglePlaySub(String productId, String qkOrderId, boolean b, boolean b1) {
            Log.d(TAG, "google 订阅 回调");
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("productId", productId);
                jsonObject.put("orderId", qkOrderId);
                callUnityFunc("onSubsSkuCallback", jsonObject.toString());
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onInitFinished(boolean isSuccess, String error) {
            if (isSuccess) {
                Log.d(TAG, "channelId:" + sdk.getChannelId() + "INIT_SUCCESS->");
                if (!TextUtils.isEmpty(gameObjectName)) {
                    callUnityFunc("onInitSuccess", new JSONObject().toString());
                } else {
                    initState = INIT_SUCCESS;
                }
            } else {
                Log.d(TAG, "INIT_FAILED->");
                if (!TextUtils.isEmpty(gameObjectName)) {
                    JSONObject json = new JSONObject();
                    try {
                        json.put("msg", error);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    callUnityFunc("onInitFailed", json.toString());
                } else {
                    mInitMsg = error;
                    initState = INIT_FAILED;
                }
            }
        }
    }

    private class FacebookShareCallback implements FacebookCallback<Sharer.Result> {
        @Override
        public void onSuccess(Sharer.Result result) {
            callUnityFunc("onShareSuccess", "");
        }


        @Override
        public void onCancel() {
            callUnityFunc("onShareCancel", "");
        }

        @Override
        public void onError(FacebookException error) {
            callUnityFunc("onShareFailed", "");
        }
    }

    private class BindUnbindUserCallback extends QuickGameManager.QGUserBindCallback {
        @Override
        public void onBindInfoChanged(String uid, boolean isBindUnBindSuccess, QGUserBindInfo bindUserInfo) {
            if (isBindUnBindSuccess) {
                callUnityFunc("onBindSuccess", bindUserInfo.toString());
            } else {
                callUnityFunc("onBindFailed", bindUserInfo.toString());
            }
        }

        @Override
        public void onexitUserCenter() {
        }
    }

    /**
     * ֧支付回调
     */
    class SamplePaymentCallback implements QuickGameManager.QGPaymentCallback {
        @Override
        public void onPaySuccess(String orderId, String oderNo, String goodsId, String extraParams) {
            Log.d(TAG, "onPaySuccess");
            JSONObject json = new JSONObject();
            try {
                json.put("orderId", orderId);
                json.put("orderNo", oderNo);
                json.put("extraParam", extraParams);
            } catch (Exception e) {
            }
            callUnityFunc("onPaySuccess", json.toString());
        }

        @Override
        public void onPayFailed(String orderId, String oderNo, String errorMessage) {
            Log.d(TAG, "onPayFailed");
            JSONObject json = new JSONObject();
            try {
                json.put("orderId", "" + orderId);
                json.put("orderNo", oderNo);
                json.put("extraParam", errorMessage);
            } catch (Exception e) {
            }
            callUnityFunc("onPayFailed", json.toString());
        }

        @Override
        public void onPayCancel(String orderId, String oderNo, String errorMessage) {
            Log.d(TAG, "onPayCancel");
            JSONObject json = new JSONObject();
            try {
                json.put("orderId", "" + orderId);
                json.put("extraParam", "" + errorMessage);
                json.put("orderNo", "" + oderNo);
            } catch (Exception e) {
            }
            callUnityFunc("onPayCancel", json.toString());
        }

    }

    //QKproductCode
    public String getMeta(Context activity, String ss) {
        String code = "";
        try {
            ApplicationInfo appInfo = activity.getPackageManager().getApplicationInfo(activity.getPackageName(), PackageManager.GET_META_DATA);
            if (appInfo.metaData != null) {
                code = appInfo.metaData.getString(ss);
                if (!TextUtils.isEmpty(code)) {
                    Log.d(TAG, "" + code);
                    return code;
                }
            } else {
                code = "" + 1;
                Log.d(TAG, "codeErro");
            }
        } catch (Exception e) {
            code = "" + 1;
            e.printStackTrace();

        }
        return code;
    }

    public boolean hasPermission(String permission) {
        // 检查是否有指定的权限
        return ContextCompat.checkSelfPermission(this, permission) == PackageManager.PERMISSION_GRANTED;
    }

}
