
//
//

#import <Foundation/Foundation.h>

typedef NS_ENUM(NSInteger,USERCENTER_TYPE){
    USERCENTER_TYPE_Guest = 0,        //guest
    USERCENTER_TYPE_EMAIl = 1,        //email
    USERCENTER_TYPE_FB = 6,           //FB
    USERCENTER_TYPE_GOOGLEPLUS = 8,   //Google
    USERCENTER_TYPE_Apple = 16,       //Apple
};
typedef NS_ENUM(NSInteger, LoginEvent){
    LoginEvent_first_login_start,
    LoginEvent_login_start,
    LoginEvent_first_show_login_view,
    LoginEvent_show_login_view,
    LoginEvent_login_end_with_cancel,
    LoginEvent_login_end_with_success,
    LoginEvent_login_end_with_failed,
    LoginEvent_guest_login_start,
    LoginEvent_guest_login_end_with_failed,
    LoginEvent_guest_login_end_with_success,
    LoginEvent_auto_login_start,
    LoginEvent_auto_login_failed,
    LoginEvent_auto_login_success,
    LoginEvent_auto_login_cancel,
    LoginEvent_silent_login_start,
    LoginEvent_silent_login_lastUser_start,
    LoginEvent_silent_login_lastUser_success,
    LoginEvent_silent_login_lastUser_failed,
    LoginEvent_silent_login_guest_start,
    LoginEvent_silent_login_guest_success,
    LoginEvent_silent_login_guest_failed,
    LoginEvent_silent_login_type_start,
    LoginEvent_silent_login_type_lastUser_start,
    LoginEvent_silent_login_type_lastUser_success,
    LoginEvent_silent_login_type_lastUser_failed,
    LoginEvent_silent_login_type_newUser_start,
    LoginEvent_silent_login_type_newUser_failed,
    LoginEvent_silent_login_type_newUser_cancel,
    LoginEvent_silent_login_type_newUser_success,
    LoginEvent_silent_login_type_newUser_verify_start,
    LoginEvent_silent_login_type_newUser_verify_failed,
    LoginEvent_silent_login_type_newUser_verify_success,
    LoginEvent_show_register_view,
    LoginEvent_register_start,
    LoginEvent_register_failed,
    LoginEvent_register_success,
    LoginEvent_email_login_start,
    LoginEvent_email_login_end_with_failed,
    LoginEvent_email_login_end_with_success,
    LoginEvent_facebook_login_start,
    LoginEvent_facebook_login_end_with_cancel,
    LoginEvent_facebook_login_end_with_failed,
    LoginEvent_facebook_login_end_with_success,
    LoginEvent_facebook_login_verify_start,
    LoginEvent_facebook_login_verify_failed,
    LoginEvent_facebook_login_verify_success,
    LoginEvent_google_login_start,
    LoginEvent_google_login_end_with_cancel,
    LoginEvent_google_login_end_with_failed,
    LoginEvent_google_login_end_with_success,
    LoginEvent_google_login_verify_start,
    LoginEvent_google_login_verify_failed,
    LoginEvent_google_login_verify_success,
    LoginEvent_apple_login_start,
    LoginEvent_apple_login_end_with_cancel,
    LoginEvent_apple_login_end_with_failed,
    LoginEvent_apple_login_end_with_success,
    LoginEvent_apple_login_verify_start,
    LoginEvent_apple_login_verify_failed,
    LoginEvent_apple_login_verify_success,
};

@protocol REDeInitCallback <NSObject>
/* 初始化完成 */
- (void)qgSDKInitDone;
@end
@protocol REDeLoginCallback <NSObject>
/* 绑定回调 */
- (void)bindUid:(NSString *)uid userToken:(NSString *)token type:(USERCENTER_TYPE)type;
/* 解绑回调 */
- (void)unBindUid:(NSString *)uid userToken:(NSString *)token type:(USERCENTER_TYPE)type;
/* 在SDK的个人中心主动退出登录 */
- (void)userLogout;
@optional
/* 登录成功与带登录方式实现其一即可 */
- (void)loginUid:(NSString *)uid userToken:(NSString *)token;
/* 登录成功带登录方式与不带登录方式实现其一即可 */
- (void)loginUid:(NSString *)uid userToken:(NSString *)token type:(USERCENTER_TYPE)type;
/* 调用logout执行成功后执行回调,与用户在SDK的个人中心主动退出登录回调不同 */
- (void)gameLogoutSuccess;
/* 点击了个人中心的客服按钮时回调 */
- (void)onClickServiceCenter;
/** 登录之后游戏主动唤起SDK页面，关闭时会回调此方法 */
- (void)sdkUserPageWillClose;
/** 玩家取消登录，主要用于单独调起某个三方登录方法
 isShow：YES:玩家在登录界面显示的情况下取消三方登录，NO:玩家在登录界面未显示的情况下取消三方登录
 */
- (void)userCancelLoginWithLoginPageShowing:(BOOL)isShow;
/** 玩家登录失败，主要用于单独调起某个三方登录方法
 isShow：YES:玩家在登录界面显示的情况下登录失败，NO:玩家在登录界面未显示的情况下登录失败
 */
 - (void)userLoginFailWithLoginPageShowing:(BOOL)isShow message:(NSString *)message;
/** 玩家取消绑定，主要用于单独调起某个三方绑定方法
 isShow：YES:玩家在SDK界面显示的情况下取消三方登录，NO:玩家在SDK界面未显示的情况下取消三方登录
 */
- (void)userCancelBindWithKitWindowShowing:(BOOL)isShow;
/** 玩家绑定失败，主要用于单独调起某个三方绑定方法
 isShow：YES:玩家在SDK界面显示的情况下登录失败，NO:玩家在SDK界面未显示的情况下登录失败
 message：失败原因
 */
- (void)userBindFailWithKitWindowShowing:(BOOL)isShow message:(NSString *)message;
/** 玩家取消解除绑定，主要用于单独调起某个三方解除绑定方法
 isShow：YES:玩家在SDK界面显示的情况下取消三方登录，NO:玩家在SDK界面未显示的情况下取消三方登录
 */
- (void)userCancelUnbindWithKitWindowShowing:(BOOL)isShow;
/** 玩家解除绑定失败，主要用于单独调起某个三方解除绑定方法
 isShow：YES:玩家在SDK界面显示的情况下登录失败，NO:玩家在SDK界面未显示的情况下登录失败
 message：失败原因
 */
- (void)userUnbindFailWithKitWindowShowing:(BOOL)isShow message:(NSString *)message;
/** 登录流程事件回调，
 loginEvent：事件枚举值
 message: failed事件返回失败原因，其他返回枚举值字符串
 */
- (void)onEvent:(LoginEvent)loginEvent message:(NSString *)message;
@end
@protocol REDeBuyCallback <NSObject>
//* 购买失败 */
- (void)purchaseFail;
@optional
#pragma mark - 三个购买成功回调任选其一实现回调即可
/* 这里的成功回调不能作为发货依据
   购买完成回调
 productId 内购商品Id
 orderNo SDK订单号
 gameOrderNo 游戏订单号，如果本地缓存被清理会返回空字符串
 receiptString 票据凭证
 iOS15.0以上版本使用storekit2 appStoreReceiptBase64EncodedString为@""
 */
- (void)purchaseDoneProductId:(NSString *)productId orderNo:(NSString *)orderNo gameOrderNo:(NSString *)gameOrderNo appStoreReceiptBase64EncodedString:(NSString *)receiptString;
/* 这里的成功回调不能作为发货依据
   购买完成回调
 productId 内购商品Id
 orderNo SDK订单号
 gameOrderNo 游戏订单号，如果本地缓存被清理会返回空字符串
 */
- (void)purchaseDoneProductId:(NSString *)productId orderNo:(NSString *)orderNo gameOrderNo:(NSString *)gameOrderNo;
/* 这里的成功回调不能作为发货依据
   购买完成回调
 productId 内购商品Id
 orderNo SDK订单号
 */
- (void)purchaseDoneProductId:(NSString *)productId orderNo:(NSString *)orderNo;
/** iOS15+用户提交退款申请成功回调 */
- (void)storeKit2RequestRefundSuccess:(NSString *)transactionID;
/** iOS15+用户取消申请退款回调 */
- (void)storeKit2CancelRequestRefund:(NSString *)transactionID;
/** iOS15+用户提交退款申请失败回调 */
- (void)storeKit2RequestRefundFail:(NSString *)transactionID message:(NSString *)message;
@end

@protocol REDeRestoreCallback <NSObject>
/* 恢复非消耗商品成功，返回商品id信息 */
- (void)restoreSuccess:(NSArray *)products;
/*恢复失败*/
- (void)restoreFail:(NSString *)msg;

@end
@protocol REProductInfoCallback <NSObject>
/* 查找商品信息成功数组元素为REDeOrderInfo实例 */
- (void)findProductInfoSuccess:(NSArray *)products;
/* 查找商品信息失败 */
- (void)findProductInfoFail:(NSString *)msg;
@end
