#if 0
#elif defined(__arm64__) && __arm64__
// Generated by Apple Swift version 5.9.2 (swiftlang-5.9.2.2.56 clang-1500.1.0.2.5)
#ifndef FIREBASEAUTH_SWIFT_H
#define FIREBASEAUTH_SWIFT_H
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wgcc-compat"

#if !defined(__has_include)
# define __has_include(x) 0
#endif
#if !defined(__has_attribute)
# define __has_attribute(x) 0
#endif
#if !defined(__has_feature)
# define __has_feature(x) 0
#endif
#if !defined(__has_warning)
# define __has_warning(x) 0
#endif

#if __has_include(<swift/objc-prologue.h>)
# include <swift/objc-prologue.h>
#endif

#pragma clang diagnostic ignored "-Wauto-import"
#if defined(__OBJC__)
#include <Foundation/Foundation.h>
#endif
#if defined(__cplusplus)
#include <cstdint>
#include <cstddef>
#include <cstdbool>
#include <cstring>
#include <stdlib.h>
#include <new>
#include <type_traits>
#else
#include <stdint.h>
#include <stddef.h>
#include <stdbool.h>
#include <string.h>
#endif
#if defined(__cplusplus)
#if defined(__arm64e__) && __has_include(<ptrauth.h>)
# include <ptrauth.h>
#else
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wreserved-macro-identifier"
# ifndef __ptrauth_swift_value_witness_function_pointer
#  define __ptrauth_swift_value_witness_function_pointer(x)
# endif
# ifndef __ptrauth_swift_class_method_pointer
#  define __ptrauth_swift_class_method_pointer(x)
# endif
#pragma clang diagnostic pop
#endif
#endif

#if !defined(SWIFT_TYPEDEFS)
# define SWIFT_TYPEDEFS 1
# if __has_include(<uchar.h>)
#  include <uchar.h>
# elif !defined(__cplusplus)
typedef uint_least16_t char16_t;
typedef uint_least32_t char32_t;
# endif
typedef float swift_float2  __attribute__((__ext_vector_type__(2)));
typedef float swift_float3  __attribute__((__ext_vector_type__(3)));
typedef float swift_float4  __attribute__((__ext_vector_type__(4)));
typedef double swift_double2  __attribute__((__ext_vector_type__(2)));
typedef double swift_double3  __attribute__((__ext_vector_type__(3)));
typedef double swift_double4  __attribute__((__ext_vector_type__(4)));
typedef int swift_int2  __attribute__((__ext_vector_type__(2)));
typedef int swift_int3  __attribute__((__ext_vector_type__(3)));
typedef int swift_int4  __attribute__((__ext_vector_type__(4)));
typedef unsigned int swift_uint2  __attribute__((__ext_vector_type__(2)));
typedef unsigned int swift_uint3  __attribute__((__ext_vector_type__(3)));
typedef unsigned int swift_uint4  __attribute__((__ext_vector_type__(4)));
#endif

#if !defined(SWIFT_PASTE)
# define SWIFT_PASTE_HELPER(x, y) x##y
# define SWIFT_PASTE(x, y) SWIFT_PASTE_HELPER(x, y)
#endif
#if !defined(SWIFT_METATYPE)
# define SWIFT_METATYPE(X) Class
#endif
#if !defined(SWIFT_CLASS_PROPERTY)
# if __has_feature(objc_class_property)
#  define SWIFT_CLASS_PROPERTY(...) __VA_ARGS__
# else
#  define SWIFT_CLASS_PROPERTY(...) 
# endif
#endif
#if !defined(SWIFT_RUNTIME_NAME)
# if __has_attribute(objc_runtime_name)
#  define SWIFT_RUNTIME_NAME(X) __attribute__((objc_runtime_name(X)))
# else
#  define SWIFT_RUNTIME_NAME(X) 
# endif
#endif
#if !defined(SWIFT_COMPILE_NAME)
# if __has_attribute(swift_name)
#  define SWIFT_COMPILE_NAME(X) __attribute__((swift_name(X)))
# else
#  define SWIFT_COMPILE_NAME(X) 
# endif
#endif
#if !defined(SWIFT_METHOD_FAMILY)
# if __has_attribute(objc_method_family)
#  define SWIFT_METHOD_FAMILY(X) __attribute__((objc_method_family(X)))
# else
#  define SWIFT_METHOD_FAMILY(X) 
# endif
#endif
#if !defined(SWIFT_NOESCAPE)
# if __has_attribute(noescape)
#  define SWIFT_NOESCAPE __attribute__((noescape))
# else
#  define SWIFT_NOESCAPE 
# endif
#endif
#if !defined(SWIFT_RELEASES_ARGUMENT)
# if __has_attribute(ns_consumed)
#  define SWIFT_RELEASES_ARGUMENT __attribute__((ns_consumed))
# else
#  define SWIFT_RELEASES_ARGUMENT 
# endif
#endif
#if !defined(SWIFT_WARN_UNUSED_RESULT)
# if __has_attribute(warn_unused_result)
#  define SWIFT_WARN_UNUSED_RESULT __attribute__((warn_unused_result))
# else
#  define SWIFT_WARN_UNUSED_RESULT 
# endif
#endif
#if !defined(SWIFT_NORETURN)
# if __has_attribute(noreturn)
#  define SWIFT_NORETURN __attribute__((noreturn))
# else
#  define SWIFT_NORETURN 
# endif
#endif
#if !defined(SWIFT_CLASS_EXTRA)
# define SWIFT_CLASS_EXTRA 
#endif
#if !defined(SWIFT_PROTOCOL_EXTRA)
# define SWIFT_PROTOCOL_EXTRA 
#endif
#if !defined(SWIFT_ENUM_EXTRA)
# define SWIFT_ENUM_EXTRA 
#endif
#if !defined(SWIFT_CLASS)
# if __has_attribute(objc_subclassing_restricted)
#  define SWIFT_CLASS(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) __attribute__((objc_subclassing_restricted)) SWIFT_CLASS_EXTRA
#  define SWIFT_CLASS_NAMED(SWIFT_NAME) __attribute__((objc_subclassing_restricted)) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
# else
#  define SWIFT_CLASS(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
#  define SWIFT_CLASS_NAMED(SWIFT_NAME) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
# endif
#endif
#if !defined(SWIFT_RESILIENT_CLASS)
# if __has_attribute(objc_class_stub)
#  define SWIFT_RESILIENT_CLASS(SWIFT_NAME) SWIFT_CLASS(SWIFT_NAME) __attribute__((objc_class_stub))
#  define SWIFT_RESILIENT_CLASS_NAMED(SWIFT_NAME) __attribute__((objc_class_stub)) SWIFT_CLASS_NAMED(SWIFT_NAME)
# else
#  define SWIFT_RESILIENT_CLASS(SWIFT_NAME) SWIFT_CLASS(SWIFT_NAME)
#  define SWIFT_RESILIENT_CLASS_NAMED(SWIFT_NAME) SWIFT_CLASS_NAMED(SWIFT_NAME)
# endif
#endif
#if !defined(SWIFT_PROTOCOL)
# define SWIFT_PROTOCOL(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) SWIFT_PROTOCOL_EXTRA
# define SWIFT_PROTOCOL_NAMED(SWIFT_NAME) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_PROTOCOL_EXTRA
#endif
#if !defined(SWIFT_EXTENSION)
# define SWIFT_EXTENSION(M) SWIFT_PASTE(M##_Swift_, __LINE__)
#endif
#if !defined(OBJC_DESIGNATED_INITIALIZER)
# if __has_attribute(objc_designated_initializer)
#  define OBJC_DESIGNATED_INITIALIZER __attribute__((objc_designated_initializer))
# else
#  define OBJC_DESIGNATED_INITIALIZER 
# endif
#endif
#if !defined(SWIFT_ENUM_ATTR)
# if __has_attribute(enum_extensibility)
#  define SWIFT_ENUM_ATTR(_extensibility) __attribute__((enum_extensibility(_extensibility)))
# else
#  define SWIFT_ENUM_ATTR(_extensibility) 
# endif
#endif
#if !defined(SWIFT_ENUM)
# define SWIFT_ENUM(_type, _name, _extensibility) enum _name : _type _name; enum SWIFT_ENUM_ATTR(_extensibility) SWIFT_ENUM_EXTRA _name : _type
# if __has_feature(generalized_swift_name)
#  define SWIFT_ENUM_NAMED(_type, _name, SWIFT_NAME, _extensibility) enum _name : _type _name SWIFT_COMPILE_NAME(SWIFT_NAME); enum SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_ENUM_ATTR(_extensibility) SWIFT_ENUM_EXTRA _name : _type
# else
#  define SWIFT_ENUM_NAMED(_type, _name, SWIFT_NAME, _extensibility) SWIFT_ENUM(_type, _name, _extensibility)
# endif
#endif
#if !defined(SWIFT_UNAVAILABLE)
# define SWIFT_UNAVAILABLE __attribute__((unavailable))
#endif
#if !defined(SWIFT_UNAVAILABLE_MSG)
# define SWIFT_UNAVAILABLE_MSG(msg) __attribute__((unavailable(msg)))
#endif
#if !defined(SWIFT_AVAILABILITY)
# define SWIFT_AVAILABILITY(plat, ...) __attribute__((availability(plat, __VA_ARGS__)))
#endif
#if !defined(SWIFT_WEAK_IMPORT)
# define SWIFT_WEAK_IMPORT __attribute__((weak_import))
#endif
#if !defined(SWIFT_DEPRECATED)
# define SWIFT_DEPRECATED __attribute__((deprecated))
#endif
#if !defined(SWIFT_DEPRECATED_MSG)
# define SWIFT_DEPRECATED_MSG(...) __attribute__((deprecated(__VA_ARGS__)))
#endif
#if !defined(SWIFT_DEPRECATED_OBJC)
# if __has_feature(attribute_diagnose_if_objc)
#  define SWIFT_DEPRECATED_OBJC(Msg) __attribute__((diagnose_if(1, Msg, "warning")))
# else
#  define SWIFT_DEPRECATED_OBJC(Msg) SWIFT_DEPRECATED_MSG(Msg)
# endif
#endif
#if defined(__OBJC__)
#if !defined(IBSegueAction)
# define IBSegueAction 
#endif
#endif
#if !defined(SWIFT_EXTERN)
# if defined(__cplusplus)
#  define SWIFT_EXTERN extern "C"
# else
#  define SWIFT_EXTERN extern
# endif
#endif
#if !defined(SWIFT_CALL)
# define SWIFT_CALL __attribute__((swiftcall))
#endif
#if !defined(SWIFT_INDIRECT_RESULT)
# define SWIFT_INDIRECT_RESULT __attribute__((swift_indirect_result))
#endif
#if !defined(SWIFT_CONTEXT)
# define SWIFT_CONTEXT __attribute__((swift_context))
#endif
#if !defined(SWIFT_ERROR_RESULT)
# define SWIFT_ERROR_RESULT __attribute__((swift_error_result))
#endif
#if defined(__cplusplus)
# define SWIFT_NOEXCEPT noexcept
#else
# define SWIFT_NOEXCEPT 
#endif
#if !defined(SWIFT_C_INLINE_THUNK)
# if __has_attribute(always_inline)
# if __has_attribute(nodebug)
#  define SWIFT_C_INLINE_THUNK inline __attribute__((always_inline)) __attribute__((nodebug))
# else
#  define SWIFT_C_INLINE_THUNK inline __attribute__((always_inline))
# endif
# else
#  define SWIFT_C_INLINE_THUNK inline
# endif
#endif
#if defined(_WIN32)
#if !defined(SWIFT_IMPORT_STDLIB_SYMBOL)
# define SWIFT_IMPORT_STDLIB_SYMBOL __declspec(dllimport)
#endif
#else
#if !defined(SWIFT_IMPORT_STDLIB_SYMBOL)
# define SWIFT_IMPORT_STDLIB_SYMBOL 
#endif
#endif
#if defined(__OBJC__)
#if __has_feature(objc_modules)
#if __has_warning("-Watimport-in-framework-header")
#pragma clang diagnostic ignored "-Watimport-in-framework-header"
#endif
@import FirebaseAuthInterop;
@import Foundation;
@import ObjectiveC;
@import UIKit;
#endif

#endif
#pragma clang diagnostic ignored "-Wproperty-attribute-mismatch"
#pragma clang diagnostic ignored "-Wduplicate-method-arg"
#if __has_warning("-Wpragma-clang-attribute")
# pragma clang diagnostic ignored "-Wpragma-clang-attribute"
#endif
#pragma clang diagnostic ignored "-Wunknown-pragmas"
#pragma clang diagnostic ignored "-Wnullability"
#pragma clang diagnostic ignored "-Wdollar-in-identifier-extension"

#if __has_attribute(external_source_symbol)
# pragma push_macro("any")
# undef any
# pragma clang attribute push(__attribute__((external_source_symbol(language="Swift", defined_in="FirebaseAuth",generated_declaration))), apply_to=any(function,enum,objc_interface,objc_category,objc_protocol))
# pragma pop_macro("any")
#endif

#if defined(__OBJC__)
enum FIRActionCodeOperation : NSInteger;
@class NSString;

/// Manages information regarding action codes.
SWIFT_CLASS_NAMED("ActionCodeInfo")
@interface FIRActionCodeInfo : NSObject
/// The operation being performed.
@property (nonatomic, readonly) enum FIRActionCodeOperation operation;
/// The email address to which the code was sent. The new email address in the case of
/// <code>ActionCodeOperation.recoverEmail</code>.
@property (nonatomic, readonly, copy) NSString * _Nonnull email;
/// The email that is being recovered in the case of <code>ActionCodeOperation.recoverEmail</code>.
@property (nonatomic, readonly, copy) NSString * _Nullable previousEmail;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// Operations which can be performed with action codes.
typedef SWIFT_ENUM_NAMED(NSInteger, FIRActionCodeOperation, "ActionCodeOperation", open) {
/// Action code for unknown operation.
  FIRActionCodeOperationUnknown = 0,
/// Action code for password reset operation.
  FIRActionCodeOperationPasswordReset = 1,
/// Action code for verify email operation.
  FIRActionCodeOperationVerifyEmail = 2,
/// Action code for recover email operation.
  FIRActionCodeOperationRecoverEmail = 3,
/// Action code for email link operation.
  FIRActionCodeOperationEmailLink = 4,
/// Action code for verifying and changing email.
  FIRActionCodeOperationVerifyAndChangeEmail = 5,
/// Action code for reverting second factor addition.
  FIRActionCodeOperationRevertSecondFactorAddition = 6,
};

@class NSURL;

/// Used to set and retrieve settings related to handling action codes.
SWIFT_CLASS_NAMED("ActionCodeSettings")
@interface FIRActionCodeSettings : NSObject
/// This URL represents the state/Continue URL in the form of a universal link.
/// This URL can should be constructed as a universal link that would either directly open
/// the app where the action code would be handled or continue to the app after the action code
/// is handled by Firebase.
@property (nonatomic, copy) NSURL * _Nullable URL;
/// Indicates whether the action code link will open the app directly or after being
/// redirected from a Firebase owned web widget.
@property (nonatomic) BOOL handleCodeInApp;
/// The iOS bundle ID, if available. The default value is the current app’s bundle ID.
@property (nonatomic, copy) NSString * _Nullable iOSBundleID;
/// The Android package name, if available.
@property (nonatomic, copy) NSString * _Nullable androidPackageName;
/// The minimum Android version supported, if available.
@property (nonatomic, copy) NSString * _Nullable androidMinimumVersion;
/// Indicates whether the Android app should be installed on a device where it is not available.
@property (nonatomic) BOOL androidInstallIfNotAvailable;
/// The Firebase Dynamic Link domain used for out of band code flow.
@property (nonatomic, copy) NSString * _Nullable dynamicLinkDomain SWIFT_DEPRECATED_MSG("Firebase Dynamic Links is deprecated. Migrate to use Firebase Hosting link and use `linkDomain` to set a custom domain instead.");
/// The out of band custom domain for handling code in app.
@property (nonatomic, copy) NSString * _Nullable linkDomain;
/// Sets the iOS bundle ID.
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
/// Sets the Android package name, the flag to indicate whether or not to install the app,
/// and the minimum Android version supported.
/// If <code>installIfNotAvailable</code> is set to <code>true</code> and the link is opened on an android device, it
/// will try to install the app if not already available. Otherwise the web URL is used.
/// \param androidPackageName The Android package name.
///
/// \param installIfNotAvailable Indicates whether or not the app should be installed if not
/// available.
///
/// \param minimumVersion The minimum version of Android supported.
///
- (void)setAndroidPackageName:(NSString * _Nonnull)androidPackageName installIfNotAvailable:(BOOL)installIfNotAvailable minimumVersion:(NSString * _Nullable)minimumVersion;
@end



/// This class will allow developers to easily extract information about out of band links.
SWIFT_CLASS_NAMED("ActionCodeURL")
@interface FIRActionCodeURL : NSObject
/// Returns the API key from the link. nil, if not provided.
@property (nonatomic, readonly, copy) NSString * _Nullable APIKey;
/// Returns the mode of oob action.
/// The property will be of <code>ActionCodeOperation</code> type.
/// It will return <code>.unknown</code> if no oob action is provided.
@property (nonatomic, readonly) enum FIRActionCodeOperation operation;
/// Returns the email action code from the link. nil, if not provided.
@property (nonatomic, readonly, copy) NSString * _Nullable code;
/// Returns the continue URL from the link. nil, if not provided.
@property (nonatomic, readonly, copy) NSURL * _Nullable continueURL;
/// Returns the language code from the link. nil, if not provided.
@property (nonatomic, readonly, copy) NSString * _Nullable languageCode;
/// Construct an <code>ActionCodeURL</code> from an out of band link (e.g. email link).
/// \param link The oob link string used to construct the action code URL.
///
///
/// returns:
/// The ActionCodeURL object constructed based on the oob link provided.
- (nullable instancetype)actionCodeURLWithLink:(NSString * _Nonnull)link OBJC_DESIGNATED_INITIALIZER SWIFT_METHOD_FAMILY(init);
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@class NSCoder;

SWIFT_CLASS_NAMED("AdditionalUserInfo")
@interface FIRAdditionalUserInfo : NSObject
/// The provider identifier.
@property (nonatomic, readonly, copy) NSString * _Nonnull providerID;
/// Dictionary containing the additional IdP specific information.
@property (nonatomic, readonly, copy) NSDictionary<NSString *, id> * _Nullable profile;
/// The name of the user.
@property (nonatomic, readonly, copy) NSString * _Nullable username;
/// Indicates whether or not the current user was signed in for the first time.
@property (nonatomic, readonly) BOOL isNewUser;
/// Indicates whether or not the current user was signed in for the first time.
- (BOOL)newUser SWIFT_WARN_UNUSED_RESULT;
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly) BOOL supportsSecureCoding;)
+ (BOOL)supportsSecureCoding SWIFT_WARN_UNUSED_RESULT;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)aDecoder OBJC_DESIGNATED_INITIALIZER;
- (void)encodeWithCoder:(NSCoder * _Nonnull)aCoder;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


@interface FIRAdditionalUserInfo (SWIFT_EXTENSION(FirebaseAuth)) <NSSecureCoding>
@end

@class FIRApp;
@class FIRUser;
@class FIRAuthSettings;
@class FIRAuthDataResult;
@protocol FIRFederatedAuthProvider;
@protocol FIRAuthUIDelegate;
@class FIRAuthCredential;
@protocol NSObject;
@class NSError;
@class NSData;
enum FIRAuthAPNSTokenType : NSInteger;

/// Manages authentication for Firebase apps.
/// This class is thread-safe.
SWIFT_CLASS_NAMED("Auth") SWIFT_AVAILABILITY(watchos,introduced=7) SWIFT_AVAILABILITY(maccatalyst,introduced=13) SWIFT_AVAILABILITY(macos,introduced=10.15) SWIFT_AVAILABILITY(tvos,introduced=13) SWIFT_AVAILABILITY(ios,introduced=13)
@interface FIRAuth : NSObject
/// Gets the auth object for the default Firebase app.
/// The default Firebase app must have already been configured or an exception will be raised.
+ (FIRAuth * _Nonnull)auth SWIFT_WARN_UNUSED_RESULT;
/// Gets the auth object for a <code>FirebaseApp</code>.
/// \param app The app for which to retrieve the associated <code>Auth</code> instance.
///
///
/// returns:
/// The <code>Auth</code> instance associated with the given app.
+ (FIRAuth * _Nonnull)authWithApp:(FIRApp * _Nonnull)app SWIFT_WARN_UNUSED_RESULT;
/// Gets the <code>FirebaseApp</code> object that this auth object is connected to.
@property (nonatomic, readonly, weak) FIRApp * _Nullable app;
/// Synchronously gets the cached current user, or null if there is none.
@property (nonatomic, readonly, strong) FIRUser * _Nullable currentUser;
/// The current user language code.
/// This property can be set to the app’s current language by
/// calling <code>useAppLanguage()</code>.
/// The string used to set this property must be a language code that follows BCP 47.
@property (nonatomic, copy) NSString * _Nullable languageCode;
/// Contains settings related to the auth object.
@property (nonatomic, strong) FIRAuthSettings * _Nullable settings;
/// The current user access group that the Auth instance is using.
/// Default is <code>nil</code>.
@property (nonatomic, readonly, copy) NSString * _Nullable userAccessGroup;
/// Contains shareAuthStateAcrossDevices setting related to the auth object.
/// If userAccessGroup is not set, setting shareAuthStateAcrossDevices will
/// have no effect. You should set shareAuthStateAcrossDevices to its desired
/// state and then set the userAccessGroup after.
@property (nonatomic) BOOL shareAuthStateAcrossDevices;
/// The tenant ID of the auth instance. <code>nil</code> if none is available.
@property (nonatomic, copy) NSString * _Nullable tenantID;
/// The custom authentication domain used to handle all sign-in redirects.
/// End-users will see
/// this domain when signing in. This domain must be allowlisted in the Firebase Console.
@property (nonatomic, copy) NSString * _Nullable customAuthDomain;
/// Sets the <code>currentUser</code> on the receiver to the provided user object.
/// \param user The user object to be set as the current user of the calling Auth instance.
///
/// \param completion Optionally; a block invoked after the user of the calling Auth instance has
/// been updated or an error was encountered.
///
- (void)updateCurrentUser:(FIRUser * _Nullable)user completion:(void (^ _Nullable)(NSError * _Nullable))completion;
/// [Deprecated] Fetches the list of all sign-in methods previously used for the provided
/// email address. This method returns an empty list when <a href="https://cloud.google.com/identity-platform/docs/admin/email-enumeration-protection">Email Enumeration
/// Protection</a>
/// is enabled, irrespective of the number of authentication methods available for the given
/// email.
/// Possible error codes: <code>AuthErrorCodeInvalidEmail</code> - Indicates the email address is malformed.
/// \param email The email address for which to obtain a list of sign-in methods.
///
/// \param completion Optionally; a block which is invoked when the list of sign in methods
/// for the specified email address is ready or an error was encountered. Invoked asynchronously
/// on the main thread in the future.
///
- (void)fetchSignInMethodsForEmail:(NSString * _Nonnull)email completion:(void (^ _Nullable)(NSArray<NSString *> * _Nullable, NSError * _Nullable))completion SWIFT_DEPRECATED_MSG("`fetchSignInMethods` is deprecated and will be removed in a future release. This method returns an empty list when Email Enumeration Protection is enabled.");
/// Signs in using an email address and password.
/// When <a href="https://cloud.google.com/identity-platform/docs/admin/email-enumeration-protection">Email Enumeration
/// Protection</a>
/// is enabled, this method fails with an error in case of an invalid
/// email/password.
/// Possible error codes:
/// <ul>
///   <li>
///     <code>AuthErrorCodeOperationNotAllowed</code> - Indicates that email and password
///     accounts are not enabled. Enable them in the Auth section of the
///     Firebase console.
///   </li>
///   <li>
///     <code>AuthErrorCodeUserDisabled</code> - Indicates the user’s account is disabled.
///   </li>
///   <li>
///     <code>AuthErrorCodeWrongPassword</code> - Indicates the user attempted
///     sign in with an incorrect password.
///   </li>
///   <li>
///     <code>AuthErrorCodeInvalidEmail</code> - Indicates the email address is malformed.
///   </li>
/// </ul>
/// \param email The user’s email address.
///
/// \param password The user’s password.
///
/// \param completion Optionally; a block which is invoked when the sign in flow finishes,
/// or is canceled. Invoked asynchronously on the main thread in the future.
///
- (void)signInWithEmail:(NSString * _Nonnull)email password:(NSString * _Nonnull)password completion:(void (^ _Nullable)(FIRAuthDataResult * _Nullable, NSError * _Nullable))completion;
/// Signs in using an email address and email sign-in link.
/// Possible error codes:
/// <ul>
///   <li>
///     <code>AuthErrorCodeOperationNotAllowed</code> - Indicates that email and password
///     accounts are not enabled. Enable them in the Auth section of the
///     Firebase console.
///   </li>
///   <li>
///     <code>AuthErrorCodeUserDisabled</code> - Indicates the user’s account is disabled.
///   </li>
///   <li>
///     <code>AuthErrorCodeWrongPassword</code> - Indicates the user attempted
///     sign in with an incorrect password.
///   </li>
///   <li>
///     <code>AuthErrorCodeInvalidEmail</code> - Indicates the email address is malformed.
///   </li>
/// </ul>
/// \param email The user’s email address.
///
/// \param link The email sign-in link.
///
/// \param completion Optionally; a block which is invoked when the sign in flow finishes,
/// or is canceled. Invoked asynchronously on the main thread in the future.
///
- (void)signInWithEmail:(NSString * _Nonnull)email link:(NSString * _Nonnull)link completion:(void (^ _Nullable)(FIRAuthDataResult * _Nullable, NSError * _Nullable))completion;
/// Signs in using the provided auth provider instance.
/// Possible error codes:
/// <ul>
///   <li>
///     <code>AuthErrorCodeOperationNotAllowed</code> - Indicates that email and password
///     accounts are not enabled. Enable them in the Auth section of the
///     Firebase console.
///   </li>
///   <li>
///     <code>AuthErrorCodeUserDisabled</code> - Indicates the user’s account is disabled.
///   </li>
///   <li>
///     <code>AuthErrorCodeWrongPassword</code> - Indicates the user attempted
///     sign in with an incorrect password.
///   </li>
///   <li>
///     <code>AuthErrorCodeWebNetworkRequestFailed</code> - Indicates that a network request within a
///     SFSafariViewController or WKWebView failed.
///   </li>
///   <li>
///     <code>AuthErrorCodeWebInternalError</code> - Indicates that an internal error occurred within a
///     SFSafariViewController or WKWebView.
///   </li>
///   <li>
///     <code>AuthErrorCodeWebSignInUserInteractionFailure</code> - Indicates a general failure during
///     a web sign-in flow.
///   </li>
///   <li>
///     <code>AuthErrorCodeWebContextAlreadyPresented</code> - Indicates that an attempt was made to
///     present a new web context while one was already being presented.
///   </li>
///   <li>
///     <code>AuthErrorCodeWebContextCancelled</code> - Indicates that the URL presentation was
///     cancelled prematurely by the user.
///   </li>
///   <li>
///     <code>AuthErrorCodeAccountExistsWithDifferentCredential</code> - Indicates the email asserted
///     by the credential (e.g. the email in a Facebook access token) is already in use by an
///     existing account, that cannot be authenticated with this sign-in method. Call
///     fetchProvidersForEmail for this user’s email and then prompt them to sign in with any of
///     the sign-in providers returned. This error will only be thrown if the “One account per
///     email address” setting is enabled in the Firebase console, under Auth settings.
///   </li>
/// </ul>
/// \param provider An instance of an auth provider used to initiate the sign-in flow.
///
/// \param uiDelegate Optionally an instance of a class conforming to the AuthUIDelegate
/// protocol, this is used for presenting the web context. If nil, a default AuthUIDelegate
/// will be used.
///
/// \param completion Optionally; a block which is invoked when the sign in flow finishes,
/// or is canceled. Invoked asynchronously on the main thread in the future.
///
- (void)signInWithProvider:(id <FIRFederatedAuthProvider> _Nonnull)provider UIDelegate:(id <FIRAuthUIDelegate> _Nullable)uiDelegate completion:(void (^ _Nullable)(FIRAuthDataResult * _Nullable, NSError * _Nullable))completion SWIFT_AVAILABILITY(watchos,unavailable) SWIFT_AVAILABILITY(macos,unavailable) SWIFT_AVAILABILITY(tvos,unavailable);
/// Asynchronously signs in to Firebase with the given 3rd-party credentials (e.g. a Facebook
/// login Access Token, a Google ID Token/Access Token pair, etc.) and returns additional
/// identity provider data.
/// Possible error codes:
/// <ul>
///   <li>
///     <code>AuthErrorCodeInvalidCredential</code> - Indicates the supplied credential is invalid.
///     This could happen if it has expired or it is malformed.
///   </li>
///   <li>
///     <code>AuthErrorCodeOperationNotAllowed</code> - Indicates that accounts
///     with the identity provider represented by the credential are not enabled.
///     Enable them in the Auth section of the Firebase console.
///   </li>
///   <li>
///     <code>AuthErrorCodeAccountExistsWithDifferentCredential</code> - Indicates the email asserted
///     by the credential (e.g. the email in a Facebook access token) is already in use by an
///     existing account, that cannot be authenticated with this sign-in method. Call
///     fetchProvidersForEmail for this user’s email and then prompt them to sign in with any of
///     the sign-in providers returned. This error will only be thrown if the “One account per
///     email address” setting is enabled in the Firebase console, under Auth settings.
///   </li>
///   <li>
///     <code>AuthErrorCodeUserDisabled</code> - Indicates the user’s account is disabled.
///   </li>
///   <li>
///     <code>AuthErrorCodeWrongPassword</code> - Indicates the user attempted sign in with an
///     incorrect password, if credential is of the type EmailPasswordAuthCredential.
///   </li>
///   <li>
///     <code>AuthErrorCodeInvalidEmail</code> - Indicates the email address is malformed.
///   </li>
///   <li>
///     <code>AuthErrorCodeMissingVerificationID</code> - Indicates that the phone auth credential was
///     created with an empty verification ID.
///   </li>
///   <li>
///     <code>AuthErrorCodeMissingVerificationCode</code> - Indicates that the phone auth credential
///     was created with an empty verification code.
///   </li>
///   <li>
///     <code>AuthErrorCodeInvalidVerificationCode</code> - Indicates that the phone auth credential
///     was created with an invalid verification Code.
///   </li>
///   <li>
///     <code>AuthErrorCodeInvalidVerificationID</code> - Indicates that the phone auth credential was
///     created with an invalid verification ID.
///   </li>
///   <li>
///     <code>AuthErrorCodeSessionExpired</code> - Indicates that the SMS code has expired.
///   </li>
/// </ul>
/// \param credential The credential supplied by the IdP.
///
/// \param completion Optionally; a block which is invoked when the sign in flow finishes,
/// or is canceled. Invoked asynchronously on the main thread in the future.
///
- (void)signInWithCredential:(FIRAuthCredential * _Nonnull)credential completion:(void (^ _Nullable)(FIRAuthDataResult * _Nullable, NSError * _Nullable))completion;
/// Asynchronously creates and becomes an anonymous user.
/// If there is already an anonymous user signed in, that user will be returned instead.
/// If there is any other existing user signed in, that user will be signed out.
/// Possible error codes:
/// <ul>
///   <li>
///     <code>AuthErrorCodeOperationNotAllowed</code> - Indicates that anonymous accounts are
///     not enabled. Enable them in the Auth section of the Firebase console.
///   </li>
/// </ul>
/// \param completion Optionally; a block which is invoked when the sign in finishes, or is
/// canceled. Invoked asynchronously on the main thread in the future.
///
- (void)signInAnonymouslyWithCompletion:(void (^ _Nullable)(FIRAuthDataResult * _Nullable, NSError * _Nullable))completion;
/// Asynchronously creates and becomes an anonymous user.
/// If there is already an anonymous user signed in, that user will be returned instead.
/// If there is any other existing user signed in, that user will be signed out.
/// Possible error codes:
/// <ul>
///   <li>
///     <code>AuthErrorCodeOperationNotAllowed</code> - Indicates that anonymous accounts are
///     not enabled. Enable them in the Auth section of the Firebase console.
///   </li>
/// </ul>
///
/// returns:
/// The <code>AuthDataResult</code> after the successful signin.
- (void)signInAnonymouslyWithCompletionHandler:(void (^ _Nonnull)(FIRAuthDataResult * _Nullable, NSError * _Nullable))completionHandler SWIFT_AVAILABILITY(watchos,introduced=7) SWIFT_AVAILABILITY(maccatalyst,introduced=13) SWIFT_AVAILABILITY(macos,introduced=10.15) SWIFT_AVAILABILITY(tvos,introduced=13) SWIFT_AVAILABILITY(ios,introduced=13);
/// Asynchronously signs in to Firebase with the given Auth token.
/// Possible error codes:
/// <ul>
///   <li>
///     <code>AuthErrorCodeInvalidCustomToken</code> - Indicates a validation error with
///     the custom token.
///   </li>
///   <li>
///     <code>AuthErrorCodeCustomTokenMismatch</code> - Indicates the service account and the API key
///     belong to different projects.
///   </li>
/// </ul>
/// \param token A self-signed custom auth token.
///
/// \param completion Optionally; a block which is invoked when the sign in finishes, or is
/// canceled. Invoked asynchronously on the main thread in the future.
///
- (void)signInWithCustomToken:(NSString * _Nonnull)token completion:(void (^ _Nullable)(FIRAuthDataResult * _Nullable, NSError * _Nullable))completion;
/// Creates and, on success, signs in a user with the given email address and password.
/// Possible error codes:
/// <ul>
///   <li>
///     <code>AuthErrorCodeInvalidEmail</code> - Indicates the email address is malformed.
///   </li>
///   <li>
///     <code>AuthErrorCodeEmailAlreadyInUse</code> - Indicates the email used to attempt sign up
///     already exists. Call fetchProvidersForEmail to check which sign-in mechanisms the user
///     used, and prompt the user to sign in with one of those.
///   </li>
///   <li>
///     <code>AuthErrorCodeOperationNotAllowed</code> - Indicates that email and password accounts
///     are not enabled. Enable them in the Auth section of the Firebase console.
///   </li>
///   <li>
///     <code>AuthErrorCodeWeakPassword</code> - Indicates an attempt to set a password that is
///     considered too weak. The NSLocalizedFailureReasonErrorKey field in the NSError.userInfo
///     dictionary object will contain more detailed explanation that can be shown to the user.
///   </li>
/// </ul>
/// \param email The user’s email address.
///
/// \param password The user’s desired password.
///
/// \param completion Optionally; a block which is invoked when the sign up flow finishes,
/// or is canceled. Invoked asynchronously on the main thread in the future.
///
- (void)createUserWithEmail:(NSString * _Nonnull)email password:(NSString * _Nonnull)password completion:(void (^ _Nullable)(FIRAuthDataResult * _Nullable, NSError * _Nullable))completion;
/// Resets the password given a code sent to the user outside of the app and a new password
/// for the user.
/// Possible error codes:
/// <ul>
///   <li>
///     <code>AuthErrorCodeWeakPassword</code> - Indicates an attempt to set a password that is
///     considered too weak.
///   </li>
///   <li>
///     <code>AuthErrorCodeOperationNotAllowed</code> - Indicates the administrator disabled sign
///     in with the specified identity provider.
///   </li>
///   <li>
///     <code>AuthErrorCodeExpiredActionCode</code> - Indicates the OOB code is expired.
///   </li>
///   <li>
///     <code>AuthErrorCodeInvalidActionCode</code> - Indicates the OOB code is invalid.
///   </li>
/// </ul>
/// \param code The reset code.
///
/// \param newPassword The new password.
///
/// \param completion Optionally; a block which is invoked when the request finishes.
/// Invoked asynchronously on the main thread in the future.
///
- (void)confirmPasswordResetWithCode:(NSString * _Nonnull)code newPassword:(NSString * _Nonnull)newPassword completion:(void (^ _Nonnull)(NSError * _Nullable))completion;
/// Checks the validity of an out of band code.
/// \param code The out of band code to check validity.
///
/// \param completion Optionally; a block which is invoked when the request finishes.
/// Invoked
/// asynchronously on the main thread in the future.
///
- (void)checkActionCode:(NSString * _Nonnull)code completion:(void (^ _Nonnull)(FIRActionCodeInfo * _Nullable, NSError * _Nullable))completion;
/// Checks the validity of a verify password reset code.
/// \param code The password reset code to be verified.
///
/// \param completion Optionally; a block which is invoked when the request finishes.
/// Invoked asynchronously on the main thread in the future.
///
- (void)verifyPasswordResetCode:(NSString * _Nonnull)code completion:(void (^ _Nonnull)(NSString * _Nullable, NSError * _Nullable))completion;
/// Applies out of band code.
/// This method will not work for out of band codes which require an additional parameter,
/// such as password reset code.
/// \param code The out of band code to be applied.
///
/// \param completion Optionally; a block which is invoked when the request finishes.
/// Invoked asynchronously on the main thread in the future.
///
- (void)applyActionCode:(NSString * _Nonnull)code completion:(void (^ _Nonnull)(NSError * _Nullable))completion;
/// Initiates a password reset for the given email address.
/// This method does not throw an
/// error when there’s no user account with the given email address and <a href="https://cloud.google.com/identity-platform/docs/admin/email-enumeration-protection">Email Enumeration
/// Protection</a>
/// is enabled.
/// Possible error codes:
/// <ul>
///   <li>
///     <code>AuthErrorCodeInvalidRecipientEmail</code> - Indicates an invalid recipient email was
///     sent in the request.
///   </li>
///   <li>
///     <code>AuthErrorCodeInvalidSender</code> - Indicates an invalid sender email is set in
///     the console for this action.
///   </li>
///   <li>
///     <code>AuthErrorCodeInvalidMessagePayload</code> - Indicates an invalid email template for
///     sending update email.
///   </li>
/// </ul>
/// \param email The email address of the user.
///
/// \param completion Optionally; a block which is invoked when the request finishes.
/// Invoked
/// asynchronously on the main thread in the future.
///
- (void)sendPasswordResetWithEmail:(NSString * _Nonnull)email completion:(void (^ _Nullable)(NSError * _Nullable))completion;
/// Initiates a password reset for the given email address and <code>ActionCodeSettings</code> object.
/// This method does not throw an
/// error when there’s no user account with the given email address and <a href="https://cloud.google.com/identity-platform/docs/admin/email-enumeration-protection">Email Enumeration
/// Protection</a>
/// is enabled.
/// Possible error codes:
/// <ul>
///   <li>
///     <code>AuthErrorCodeInvalidRecipientEmail</code> - Indicates an invalid recipient email was
///     sent in the request.
///   </li>
///   <li>
///     <code>AuthErrorCodeInvalidSender</code> - Indicates an invalid sender email is set in
///     the console for this action.
///   </li>
///   <li>
///     <code>AuthErrorCodeInvalidMessagePayload</code> - Indicates an invalid email template for
///     sending update email.
///   </li>
///   <li>
///     <code>AuthErrorCodeMissingIosBundleID</code> - Indicates that the iOS bundle ID is missing when
///     <code>handleCodeInApp</code> is set to true.
///   </li>
///   <li>
///     <code>AuthErrorCodeMissingAndroidPackageName</code> - Indicates that the android package name
///     is missing when the <code>androidInstallApp</code> flag is set to true.
///   </li>
///   <li>
///     <code>AuthErrorCodeUnauthorizedDomain</code> - Indicates that the domain specified in the
///     continue URL is not allowlisted in the Firebase console.
///   </li>
///   <li>
///     <code>AuthErrorCodeInvalidContinueURI</code> - Indicates that the domain specified in the
///     continue URL is not valid.
///   </li>
/// </ul>
/// \param email The email address of the user.
///
/// \param actionCodeSettings An <code>ActionCodeSettings</code> object containing settings related to
/// handling action codes.
///
/// \param completion Optionally; a block which is invoked when the request finishes.
/// Invoked asynchronously on the main thread in the future.
///
- (void)sendPasswordResetWithEmail:(NSString * _Nonnull)email actionCodeSettings:(FIRActionCodeSettings * _Nullable)actionCodeSettings completion:(void (^ _Nullable)(NSError * _Nullable))completion;
/// Sends a sign in with email link to provided email address.
/// \param email The email address of the user.
///
/// \param actionCodeSettings An <code>ActionCodeSettings</code> object containing settings related to
/// handling action codes.
///
/// \param completion Optionally; a block which is invoked when the request finishes.
/// Invoked asynchronously on the main thread in the future.
///
- (void)sendSignInLinkToEmail:(NSString * _Nonnull)email actionCodeSettings:(FIRActionCodeSettings * _Nonnull)actionCodeSettings completion:(void (^ _Nullable)(NSError * _Nullable))completion;
/// Signs out the current user.
/// Possible error codes:
/// <ul>
///   <li>
///     <code>AuthErrorCodeKeychainError</code> - Indicates an error occurred when accessing the
///     keychain. The <code>NSLocalizedFailureReasonErrorKey</code> field in the <code>userInfo</code>
///     dictionary will contain more information about the error encountered.
///   </li>
/// </ul>
- (BOOL)signOut:(NSError * _Nullable * _Nullable)error;
/// Checks if link is an email sign-in link.
/// \param link The email sign-in link.
///
///
/// returns:
/// <code>true</code> when the link passed matches the expected format of an email sign-in link.
- (BOOL)isSignInWithEmailLink:(NSString * _Nonnull)link SWIFT_WARN_UNUSED_RESULT;
/// Initializes reCAPTCHA using the settings configured for the project or tenant.
/// If you change the tenant ID of the <code>Auth</code> instance, the configuration will be
/// reloaded.
- (void)initializeRecaptchaConfigWithCompletion:(void (^ _Nullable)(NSError * _Nullable))completion;
/// Registers a block as an “auth state did change” listener.
/// To be invoked when:
/// <ul>
///   <li>
///     The block is registered as a listener,
///   </li>
///   <li>
///     A user with a different UID from the current user has signed in, or
///   </li>
///   <li>
///     The current user has signed out.
///   </li>
/// </ul>
/// The block is invoked immediately after adding it according to its standard invocation
/// semantics, asynchronously on the main thread. Users should pay special attention to
/// making sure the block does not inadvertently retain objects which should not be retained by
/// the long-lived block. The block itself will be retained by <code>Auth</code> until it is
/// unregistered or until the <code>Auth</code> instance is otherwise deallocated.
/// \param listener The block to be invoked. The block is always invoked asynchronously on
/// the main thread, even for it’s initial invocation after having been added as a listener.
///
///
/// returns:
/// A handle useful for manually unregistering the block as a listener.
- (id <NSObject> _Nonnull)addAuthStateDidChangeListener:(void (^ _Nonnull)(FIRAuth * _Nonnull, FIRUser * _Nullable))listener SWIFT_WARN_UNUSED_RESULT;
/// Unregisters a block as an “auth state did change” listener.
/// \param listenerHandle The handle for the listener.
///
- (void)removeAuthStateDidChangeListener:(id <NSObject> _Nonnull)listenerHandle;
/// Registers a block as an “ID token did change” listener.
/// To be invoked when:
/// <ul>
///   <li>
///     The block is registered as a listener,
///   </li>
///   <li>
///     A user with a different UID from the current user has signed in,
///   </li>
///   <li>
///     The ID token of the current user has been refreshed, or
///   </li>
///   <li>
///     The current user has signed out.
///   </li>
/// </ul>
/// The block is invoked immediately after adding it according to its standard invocation
/// semantics, asynchronously on the main thread. Users should pay special attention to
/// making sure the block does not inadvertently retain objects which should not be retained by
/// the long-lived block. The block itself will be retained by <code>Auth</code> until it is
/// unregistered or until the <code>Auth</code> instance is otherwise deallocated.
/// \param listener The block to be invoked. The block is always invoked asynchronously on
/// the main thread, even for it’s initial invocation after having been added as a listener.
///
///
/// returns:
/// A handle useful for manually unregistering the block as a listener.
- (id <NSObject> _Nonnull)addIDTokenDidChangeListener:(void (^ _Nonnull)(FIRAuth * _Nonnull, FIRUser * _Nullable))listener SWIFT_WARN_UNUSED_RESULT;
/// Unregisters a block as an “ID token did change” listener.
/// \param listenerHandle The handle for the listener.
///
- (void)removeIDTokenDidChangeListener:(id <NSObject> _Nonnull)listenerHandle;
/// Sets <code>languageCode</code> to the app’s current language.
- (void)useAppLanguage;
/// Configures Firebase Auth to connect to an emulated host instead of the remote backend.
- (void)useEmulatorWithHost:(NSString * _Nonnull)host port:(NSInteger)port;
/// Revoke the users token with authorization code.
/// \param authorizationCode The authorization code used to perform the revocation.
///
/// \param completion (Optional) the block invoked when the request to revoke the token is
/// complete, or fails. Invoked asynchronously on the main thread in the future.
///
- (void)revokeTokenWithAuthorizationCode:(NSString * _Nonnull)authorizationCode completion:(void (^ _Nullable)(NSError * _Nullable))completion;
/// Switch userAccessGroup and current user to the given accessGroup and the user stored in it.
- (BOOL)useUserAccessGroup:(NSString * _Nullable)accessGroup error:(NSError * _Nullable * _Nullable)error;
/// Get the stored user in the given accessGroup.
/// This API is not supported on tvOS when <code>shareAuthStateAcrossDevices</code> is set to <code>true</code>.
/// and will return <code>nil</code>.
/// Please refer to https://github.com/firebase/firebase-ios-sdk/issues/8878 for details.
- (FIRUser * _Nullable)getStoredUserForAccessGroup:(NSString * _Nullable)accessGroup error:(NSError * _Nullable * _Nullable)outError SWIFT_WARN_UNUSED_RESULT;
/// The APNs token used for phone number authentication.
/// The type of the token (production or sandbox) will be automatically
/// detected based on your provisioning profile.
/// This property is available on iOS only.
/// If swizzling is disabled, the APNs Token must be set for phone number auth to work,
/// by either setting this property or by calling <code>setAPNSToken(_:type:)</code>.
@property (nonatomic, readonly, copy) NSData * _Nullable APNSToken;
/// Sets the APNs token along with its type.
/// This method is available on iOS only.
/// If swizzling is disabled, the APNs Token must be set for phone number auth to work,
/// by either setting calling this method or by setting the <code>APNSToken</code> property.
- (void)setAPNSToken:(NSData * _Nonnull)token type:(enum FIRAuthAPNSTokenType)type;
/// Whether the specific remote notification is handled by <code>Auth</code> .
/// This method is available on iOS only.
/// If swizzling is disabled, related remote notifications must be forwarded to this method
/// for phone number auth to work.
/// \param userInfo A dictionary that contains information related to the
/// notification in question.
///
///
/// returns:
/// Whether or the notification is handled. A return value of <code>true</code> means the
/// notification is for Firebase Auth so the caller should ignore the notification from further
/// processing, and <code>false</code> means the notification is for the app (or another library) so
/// the caller should continue handling this notification as usual.
- (BOOL)canHandleNotification:(NSDictionary * _Nonnull)userInfo SWIFT_WARN_UNUSED_RESULT;
/// Whether the specific URL is handled by <code>Auth</code> .
/// This method is available on iOS only.
/// If swizzling is disabled, URLs received by the application delegate must be forwarded
/// to this method for phone number auth to work.
/// \param url The URL received by the application delegate from any of the openURL
/// method.
///
///
/// returns:
/// Whether or the URL is handled. <code>true</code> means the URL is for Firebase Auth
/// so the caller should ignore the URL from further processing, and <code>false</code> means the
/// the URL is for the app (or another library) so the caller should continue handling
/// this URL as usual.
- (BOOL)canHandleURL:(NSURL * _Nonnull)url SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@class UIScene;
@class UIOpenURLContext;

SWIFT_AVAILABILITY(ios,introduced=13.0)
@interface FIRAuth (SWIFT_EXTENSION(FirebaseAuth)) <UISceneDelegate>
- (void)scene:(UIScene * _Nonnull)scene openURLContexts:(NSSet<UIOpenURLContext *> * _Nonnull)URLContexts;
@end


SWIFT_AVAILABILITY(watchos,introduced=7) SWIFT_AVAILABILITY(maccatalyst,introduced=13) SWIFT_AVAILABILITY(macos,introduced=10.15) SWIFT_AVAILABILITY(tvos,introduced=13) SWIFT_AVAILABILITY(ios,introduced=13)
@interface FIRAuth (SWIFT_EXTENSION(FirebaseAuth)) <FIRAuthInterop>
/// Retrieves the Firebase authentication token, possibly refreshing it if it has expired.
/// This method is not for public use. It is for Firebase clients of AuthInterop.
- (void)getTokenForcingRefresh:(BOOL)forceRefresh withCallback:(void (^ _Nonnull)(NSString * _Nullable, NSError * _Nullable))callback;
/// Get the current Auth user’s UID. Returns nil if there is no user signed in.
/// This method is not for public use. It is for Firebase clients of AuthInterop.
- (NSString * _Nullable)getUserID SWIFT_WARN_UNUSED_RESULT;
@end

@class UIApplication;

SWIFT_AVAILABILITY(ios,introduced=13.0)
@interface FIRAuth (SWIFT_EXTENSION(FirebaseAuth)) <UIApplicationDelegate>
- (void)application:(UIApplication * _Nonnull)application didRegisterForRemoteNotificationsWithDeviceToken:(NSData * _Nonnull)deviceToken;
- (void)application:(UIApplication * _Nonnull)application didFailToRegisterForRemoteNotificationsWithError:(NSError * _Nonnull)error;
- (void)application:(UIApplication * _Nonnull)application didReceiveRemoteNotification:(NSDictionary * _Nonnull)userInfo fetchCompletionHandler:(void (^ _Nonnull)(UIBackgroundFetchResult))completionHandler;
- (BOOL)application:(UIApplication * _Nonnull)application openURL:(NSURL * _Nonnull)url options:(NSDictionary<UIApplicationOpenURLOptionsKey, id> * _Nonnull)options SWIFT_WARN_UNUSED_RESULT;
@end

/// The APNs token type for the app.
/// This enum is available on iOS, macOS Catalyst, tvOS, and watchOS only.
typedef SWIFT_ENUM_NAMED(NSInteger, FIRAuthAPNSTokenType, "AuthAPNSTokenType", open) {
/// Unknown token type.
/// The actual token type will be detected from the provisioning profile in the app’s bundle.
  FIRAuthAPNSTokenTypeUnknown = 0,
/// Sandbox token type.
  FIRAuthAPNSTokenTypeSandbox = 1,
/// Production token type.
  FIRAuthAPNSTokenTypeProd = 2,
};


/// Public representation of a credential.
SWIFT_CLASS_NAMED("AuthCredential") SWIFT_AVAILABILITY(watchos,introduced=7) SWIFT_AVAILABILITY(maccatalyst,introduced=13) SWIFT_AVAILABILITY(macos,introduced=10.15) SWIFT_AVAILABILITY(tvos,introduced=13) SWIFT_AVAILABILITY(ios,introduced=13)
@interface FIRAuthCredential : NSObject
/// The name of the identity provider for the credential.
@property (nonatomic, readonly, copy) NSString * _Nonnull provider;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@class FIROAuthCredential;

/// Helper object that contains the result of a successful sign-in, link and reauthenticate
/// action.
/// It contains references to a <code>User</code> instance and an <code>AdditionalUserInfo</code> instance.
SWIFT_CLASS_NAMED("AuthDataResult") SWIFT_AVAILABILITY(watchos,introduced=7) SWIFT_AVAILABILITY(maccatalyst,introduced=13) SWIFT_AVAILABILITY(macos,introduced=10.15) SWIFT_AVAILABILITY(tvos,introduced=13) SWIFT_AVAILABILITY(ios,introduced=13)
@interface FIRAuthDataResult : NSObject
/// The signed in user.
@property (nonatomic, readonly, strong) FIRUser * _Nonnull user;
/// If available, contains the additional IdP specific information about signed in user.
@property (nonatomic, readonly, strong) FIRAdditionalUserInfo * _Nullable additionalUserInfo;
/// This property will be non-nil after a successful headful-lite sign-in via
/// <code>signIn(with:uiDelegate:completion:)</code>.
/// May be used to obtain the accessToken and/or IDToken
/// pertaining to a recently signed-in user.
@property (nonatomic, readonly, strong) FIROAuthCredential * _Nullable credential;
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly) BOOL supportsSecureCoding;)
+ (BOOL)supportsSecureCoding SWIFT_WARN_UNUSED_RESULT;
- (void)encodeWithCoder:(NSCoder * _Nonnull)coder;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)coder OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


SWIFT_AVAILABILITY(watchos,introduced=7) SWIFT_AVAILABILITY(maccatalyst,introduced=13) SWIFT_AVAILABILITY(macos,introduced=10.15) SWIFT_AVAILABILITY(tvos,introduced=13) SWIFT_AVAILABILITY(ios,introduced=13)
@interface FIRAuthDataResult (SWIFT_EXTENSION(FirebaseAuth)) <NSSecureCoding>
@end

/// Error codes used by Firebase Auth.
typedef SWIFT_ENUM_NAMED(NSInteger, FIRAuthErrorCode, "AuthErrorCode", open) {
/// Indicates a validation error with the custom token.
  FIRAuthErrorCodeInvalidCustomToken = 17000,
/// Indicates the service account and the API key belong to different projects.
  FIRAuthErrorCodeCustomTokenMismatch = 17002,
/// Indicates the IDP token or requestUri is invalid.
  FIRAuthErrorCodeInvalidCredential = 17004,
/// Indicates the user’s account is disabled on the server.
  FIRAuthErrorCodeUserDisabled = 17005,
/// Indicates the administrator disabled sign in with the specified identity provider.
  FIRAuthErrorCodeOperationNotAllowed = 17006,
/// Indicates the email used to attempt a sign up is already in use.
  FIRAuthErrorCodeEmailAlreadyInUse = 17007,
/// Indicates the email is invalid.
  FIRAuthErrorCodeInvalidEmail = 17008,
/// Indicates the user attempted sign in with a wrong password.
  FIRAuthErrorCodeWrongPassword = 17009,
/// Indicates that too many requests were made to a server method.
  FIRAuthErrorCodeTooManyRequests = 17010,
/// Indicates the user account was not found.
  FIRAuthErrorCodeUserNotFound = 17011,
/// Indicates account linking is required.
  FIRAuthErrorCodeAccountExistsWithDifferentCredential = 17012,
/// Indicates the user has attempted to change email or password more than 5 minutes after
/// signing in.
  FIRAuthErrorCodeRequiresRecentLogin = 17014,
/// Indicates an attempt to link a provider to which the account is already linked.
  FIRAuthErrorCodeProviderAlreadyLinked = 17015,
/// Indicates an attempt to unlink a provider that is not linked.
  FIRAuthErrorCodeNoSuchProvider = 17016,
/// Indicates user’s saved auth credential is invalid the user needs to sign in again.
  FIRAuthErrorCodeInvalidUserToken = 17017,
/// Indicates a network error occurred (such as a timeout interrupted connection or
/// unreachable host). These types of errors are often recoverable with a retry. The
/// <code>NSUnderlyingError</code> field in the <code>NSError.userInfo</code> dictionary will contain the error
/// encountered.
  FIRAuthErrorCodeNetworkError = 17020,
/// Indicates the saved token has expired for example the user may have changed account
/// password on another device. The user needs to sign in again on the device that made this
/// request.
  FIRAuthErrorCodeUserTokenExpired = 17021,
/// Indicates an invalid API key was supplied in the request.
  FIRAuthErrorCodeInvalidAPIKey = 17023,
/// Indicates that an attempt was made to reauthenticate with a user which is not the current
/// user.
  FIRAuthErrorCodeUserMismatch = 17024,
/// Indicates an attempt to link with a credential that has already been linked with a
/// different Firebase account.
  FIRAuthErrorCodeCredentialAlreadyInUse = 17025,
/// Indicates an attempt to set a password that is considered too weak.
  FIRAuthErrorCodeWeakPassword = 17026,
/// Indicates the App is not authorized to use Firebase Authentication with the
/// provided API Key.
  FIRAuthErrorCodeAppNotAuthorized = 17028,
/// Indicates the OOB code is expired.
  FIRAuthErrorCodeExpiredActionCode = 17029,
/// Indicates the OOB code is invalid.
  FIRAuthErrorCodeInvalidActionCode = 17030,
/// Indicates that there are invalid parameters in the payload during a
/// “send password reset email” attempt.
  FIRAuthErrorCodeInvalidMessagePayload = 17031,
/// Indicates that the sender email is invalid during a “send password reset email” attempt.
  FIRAuthErrorCodeInvalidSender = 17032,
/// Indicates that the recipient email is invalid.
  FIRAuthErrorCodeInvalidRecipientEmail = 17033,
/// Indicates that an email address was expected but one was not provided.
  FIRAuthErrorCodeMissingEmail = 17034,
/// Indicates that the iOS bundle ID is missing when a iOS App Store ID is provided.
  FIRAuthErrorCodeMissingIosBundleID = 17036,
/// Indicates that the android package name is missing when the <code>androidInstallApp</code> flag is set
/// to <code>true</code>.
  FIRAuthErrorCodeMissingAndroidPackageName = 17037,
/// Indicates that the domain specified in the continue URL is not allowlisted in the Firebase
/// console.
  FIRAuthErrorCodeUnauthorizedDomain = 17038,
/// Indicates that the domain specified in the continue URI is not valid.
  FIRAuthErrorCodeInvalidContinueURI = 17039,
/// Indicates that a continue URI was not provided in a request to the backend which requires one.
  FIRAuthErrorCodeMissingContinueURI = 17040,
/// Indicates that a phone number was not provided in a call to
/// <code>verifyPhoneNumber:completion:</code>.
  FIRAuthErrorCodeMissingPhoneNumber = 17041,
/// Indicates that an invalid phone number was provided in a call to
/// <code>verifyPhoneNumber:completion:</code>.
  FIRAuthErrorCodeInvalidPhoneNumber = 17042,
/// Indicates that the phone auth credential was created with an empty verification code.
  FIRAuthErrorCodeMissingVerificationCode = 17043,
/// Indicates that an invalid verification code was used in the verifyPhoneNumber request.
  FIRAuthErrorCodeInvalidVerificationCode = 17044,
/// Indicates that the phone auth credential was created with an empty verification ID.
  FIRAuthErrorCodeMissingVerificationID = 17045,
/// Indicates that an invalid verification ID was used in the verifyPhoneNumber request.
  FIRAuthErrorCodeInvalidVerificationID = 17046,
/// Indicates that the APNS device token is missing in the verifyClient request.
  FIRAuthErrorCodeMissingAppCredential = 17047,
/// Indicates that an invalid APNS device token was used in the verifyClient request.
  FIRAuthErrorCodeInvalidAppCredential = 17048,
/// Indicates that the SMS code has expired.
  FIRAuthErrorCodeSessionExpired = 17051,
/// Indicates that the quota of SMS messages for a given project has been exceeded.
  FIRAuthErrorCodeQuotaExceeded = 17052,
/// Indicates that the APNs device token could not be obtained. The app may not have set up
/// remote notification correctly or may fail to forward the APNs device token to Auth
/// if app delegate swizzling is disabled.
  FIRAuthErrorCodeMissingAppToken = 17053,
/// Indicates that the app fails to forward remote notification to FIRAuth.
  FIRAuthErrorCodeNotificationNotForwarded = 17054,
/// Indicates that the app could not be verified by Firebase during phone number authentication.
  FIRAuthErrorCodeAppNotVerified = 17055,
/// Indicates that the reCAPTCHA token is not valid.
  FIRAuthErrorCodeCaptchaCheckFailed = 17056,
/// Indicates that an attempt was made to present a new web context while one was already being
/// presented.
  FIRAuthErrorCodeWebContextAlreadyPresented = 17057,
/// Indicates that the URL presentation was cancelled prematurely by the user.
  FIRAuthErrorCodeWebContextCancelled = 17058,
/// Indicates a general failure during the app verification flow.
  FIRAuthErrorCodeAppVerificationUserInteractionFailure = 17059,
/// Indicates that the clientID used to invoke a web flow is invalid.
  FIRAuthErrorCodeInvalidClientID = 17060,
/// Indicates that a network request within a SFSafariViewController or WKWebView failed.
  FIRAuthErrorCodeWebNetworkRequestFailed = 17061,
/// Indicates that an internal error occurred within a SFSafariViewController or WKWebView.
  FIRAuthErrorCodeWebInternalError = 17062,
/// Indicates a general failure during a web sign-in flow.
  FIRAuthErrorCodeWebSignInUserInteractionFailure = 17063,
/// Indicates that the local player was not authenticated prior to attempting Game Center signin.
  FIRAuthErrorCodeLocalPlayerNotAuthenticated = 17066,
/// Indicates that a non-null user was expected as an argument to the operation but a null
/// user was provided.
  FIRAuthErrorCodeNullUser = 17067,
/// Indicates that a Firebase Dynamic Link is not activated.
  FIRAuthErrorCodeDynamicLinkNotActivated = 17068,
/// Represents the error code for when the given provider id for a web operation is invalid.
  FIRAuthErrorCodeInvalidProviderID = 17071,
/// Represents the error code for when an attempt is made to update the current user with a
/// tenantId that differs from the current FirebaseAuth instance’s tenantId.
  FIRAuthErrorCodeTenantIDMismatch = 17072,
/// Represents the error code for when a request is made to the backend with an associated tenant
/// ID for an operation that does not support multi-tenancy.
  FIRAuthErrorCodeUnsupportedTenantOperation = 17073,
/// Indicates that the Firebase Dynamic Link domain used is either not configured or is
/// unauthorized for the current project.
  FIRAuthErrorCodeInvalidDynamicLinkDomain = 17074,
/// Indicates that the provided Firebase Hosting Link domain is not owned by the current project.
  FIRAuthErrorCodeInvalidHostingLinkDomain = 17214,
/// Indicates that the credential is rejected because it’s malformed or mismatching.
  FIRAuthErrorCodeRejectedCredential = 17075,
/// Indicates that the GameKit framework is not linked prior to attempting Game Center signin.
  FIRAuthErrorCodeGameKitNotLinked = 17076,
/// Indicates that the second factor is required for signin.
  FIRAuthErrorCodeSecondFactorRequired = 17078,
/// Indicates that the multi factor session is missing.
  FIRAuthErrorCodeMissingMultiFactorSession = 17081,
/// Indicates that the multi factor info is missing.
  FIRAuthErrorCodeMissingMultiFactorInfo = 17082,
/// Indicates that the multi factor session is invalid.
  FIRAuthErrorCodeInvalidMultiFactorSession = 17083,
/// Indicates that the multi factor info is not found.
  FIRAuthErrorCodeMultiFactorInfoNotFound = 17084,
/// Indicates that the operation is admin restricted.
  FIRAuthErrorCodeAdminRestrictedOperation = 17085,
/// Indicates that the email is required for verification.
  FIRAuthErrorCodeUnverifiedEmail = 17086,
/// Indicates that the second factor is already enrolled.
  FIRAuthErrorCodeSecondFactorAlreadyEnrolled = 17087,
/// Indicates that the maximum second factor count is exceeded.
  FIRAuthErrorCodeMaximumSecondFactorCountExceeded = 17088,
/// Indicates that the first factor is not supported.
  FIRAuthErrorCodeUnsupportedFirstFactor = 17089,
/// Indicates that the a verified email is required to changed to.
  FIRAuthErrorCodeEmailChangeNeedsVerification = 17090,
/// Indicates that the request does not contain a client identifier.
  FIRAuthErrorCodeMissingClientIdentifier = 17093,
/// Indicates that the nonce is missing or invalid.
  FIRAuthErrorCodeMissingOrInvalidNonce = 17094,
/// Raised when a Cloud Function returns a blocking error. Will include a message returned from
/// the function.
  FIRAuthErrorCodeBlockingCloudFunctionError = 17105,
/// Indicates that reCAPTCHA Enterprise integration is not enabled for this project.
  FIRAuthErrorCodeRecaptchaNotEnabled = 17200,
/// Indicates that the reCAPTCHA token is missing from the backend request.
  FIRAuthErrorCodeMissingRecaptchaToken = 17201,
/// Indicates that the reCAPTCHA token sent with the backend request is invalid.
  FIRAuthErrorCodeInvalidRecaptchaToken = 17202,
/// Indicates that the requested reCAPTCHA action is invalid.
  FIRAuthErrorCodeInvalidRecaptchaAction = 17203,
/// Indicates that the client type is missing from the request.
  FIRAuthErrorCodeMissingClientType = 17204,
/// Indicates that the reCAPTCHA version is missing from the request.
  FIRAuthErrorCodeMissingRecaptchaVersion = 17205,
/// Indicates that the reCAPTCHA version sent to the backend is invalid.
  FIRAuthErrorCodeInvalidRecaptchaVersion = 17206,
/// Indicates that the request type sent to the backend is invalid.
  FIRAuthErrorCodeInvalidReqType = 17207,
/// Indicates that the reCAPTCHA SDK is not linked to the app.
  FIRAuthErrorCodeRecaptchaSDKNotLinked = 17208,
/// Indicates that the reCAPTCHA SDK site key wasn’t found.
  FIRAuthErrorCodeRecaptchaSiteKeyMissing = 17209,
/// Indicates that the reCAPTCHA SDK actions class failed to create.
  FIRAuthErrorCodeRecaptchaActionCreationFailed = 17210,
/// Indicates an error occurred while attempting to access the keychain.
  FIRAuthErrorCodeKeychainError = 17995,
/// Indicates an internal error occurred.
  FIRAuthErrorCodeInternalError = 17999,
/// Raised when a JWT fails to parse correctly. May be accompanied by an underlying error
/// describing which step of the JWT parsing process failed.
  FIRAuthErrorCodeMalformedJWT = 18000,
};
static NSString * _Nonnull const FIRAuthErrorCodeDomain = @"FirebaseAuth.AuthErrorCode";


/// Error Codes common to all API Methods:
SWIFT_CLASS_NAMED("AuthErrors")
@interface FIRAuthErrors : NSObject
/// The Firebase Auth error domain.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, copy) NSString * _Nonnull domain;)
+ (NSString * _Nonnull)domain SWIFT_WARN_UNUSED_RESULT;
/// The name of the key for the error short string of an error code.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, copy) NSString * _Nonnull userInfoNameKey;)
+ (NSString * _Nonnull)userInfoNameKey SWIFT_WARN_UNUSED_RESULT;
/// Error codes for Email operations
/// Errors with one of the following three codes:
/// <ul>
///   <li>
///     <code>accountExistsWithDifferentCredential</code>
///   </li>
///   <li>
///     <code>credentialAlreadyInUse</code>
///   </li>
///   <li>
///     emailAlreadyInUse`
///   </li>
/// </ul>
/// may contain  an <code>NSError.userInfo</code> dictionary object which contains this key. The value
/// associated with this key is an NSString of the email address of the account that already
/// exists.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, copy) NSString * _Nonnull userInfoEmailKey;)
+ (NSString * _Nonnull)userInfoEmailKey SWIFT_WARN_UNUSED_RESULT;
/// The key used to read the updated Auth credential from the userInfo dictionary of the
/// NSError object returned. This is the updated auth credential the developer should use for
/// recovery if applicable.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, copy) NSString * _Nonnull userInfoUpdatedCredentialKey;)
+ (NSString * _Nonnull)userInfoUpdatedCredentialKey SWIFT_WARN_UNUSED_RESULT;
/// The key used to read the MFA resolver from the userInfo dictionary of the NSError object
/// returned when 2FA is required for sign-incompletion.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, copy) NSString * _Nonnull FIRAuthErrorUserInfoMultiFactorResolverKey;)
+ (NSString * _Nonnull)FIRAuthErrorUserInfoMultiFactorResolverKey SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end


/// Determines settings related to an auth object.
SWIFT_CLASS_NAMED("AuthSettings")
@interface FIRAuthSettings : NSObject <NSCopying>
/// Flag to determine whether app verification should be disabled for testing or not.
@property (nonatomic) BOOL appVerificationDisabledForTesting;
/// Flag to determine whether app verification should be disabled for testing or not.
@property (nonatomic) BOOL isAppVerificationDisabledForTesting;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
- (id _Nonnull)copyWithZone:(struct _NSZone * _Nullable)zone SWIFT_WARN_UNUSED_RESULT;
@end

@class NSDate;

/// A data class containing the ID token JWT string and other properties associated with the
/// token including the decoded payload claims.
SWIFT_CLASS_NAMED("AuthTokenResult") SWIFT_AVAILABILITY(watchos,introduced=7) SWIFT_AVAILABILITY(maccatalyst,introduced=13) SWIFT_AVAILABILITY(macos,introduced=10.15) SWIFT_AVAILABILITY(tvos,introduced=13) SWIFT_AVAILABILITY(ios,introduced=13)
@interface FIRAuthTokenResult : NSObject
/// Stores the JWT string of the ID token.
@property (nonatomic, copy) NSString * _Nonnull token;
/// Stores the ID token’s expiration date.
@property (nonatomic, copy) NSDate * _Nonnull expirationDate;
/// Stores the ID token’s authentication date.
/// This is the date the user was signed in and NOT the date the token was refreshed.
@property (nonatomic, copy) NSDate * _Nonnull authDate;
/// Stores the date that the ID token was issued.
/// This is the date last refreshed and NOT the last authentication date.
@property (nonatomic, copy) NSDate * _Nonnull issuedAtDate;
/// Stores sign-in provider through which the token was obtained.
@property (nonatomic, copy) NSString * _Nonnull signInProvider;
/// Stores sign-in second factor through which the token was obtained.
@property (nonatomic, copy) NSString * _Nonnull signInSecondFactor;
/// Stores the entire payload of claims found on the ID token.
/// This includes the standard
/// reserved claims as well as custom claims set by the developer via the Admin SDK.
@property (nonatomic, copy) NSDictionary<NSString *, id> * _Nonnull claims;
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly) BOOL supportsSecureCoding;)
+ (BOOL)supportsSecureCoding SWIFT_WARN_UNUSED_RESULT;
- (void)encodeWithCoder:(NSCoder * _Nonnull)coder;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)coder;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


SWIFT_AVAILABILITY(watchos,introduced=7) SWIFT_AVAILABILITY(maccatalyst,introduced=13) SWIFT_AVAILABILITY(macos,introduced=10.15) SWIFT_AVAILABILITY(tvos,introduced=13) SWIFT_AVAILABILITY(ios,introduced=13)
@interface FIRAuthTokenResult (SWIFT_EXTENSION(FirebaseAuth)) <NSSecureCoding>
@end

@class UIViewController;

/// A protocol to handle user interface interactions for Firebase Auth.
/// This protocol is available on iOS, macOS Catalyst, and tvOS only.
SWIFT_PROTOCOL_NAMED("AuthUIDelegate")
@protocol FIRAuthUIDelegate <NSObject>
/// If implemented, this method will be invoked when Firebase Auth needs to display a view
/// controller.
/// \param viewControllerToPresent The view controller to be presented.
///
/// \param flag Decides whether the view controller presentation should be animated.
///
/// \param completion The block to execute after the presentation finishes.
/// This block has no return value and takes no parameters.
///
- (void)presentViewController:(UIViewController * _Nonnull)viewControllerToPresent animated:(BOOL)flag completion:(void (^ _Nullable)(void))completion;
/// If implemented, this method will be invoked when Firebase Auth needs to display a view
/// controller.
/// \param flag Decides whether removing the view controller should be animated or not.
///
/// \param completion The block to execute after the presentation finishes.
/// This block has no return value and takes no parameters.
///
- (void)dismissViewControllerAnimated:(BOOL)flag completion:(void (^ _Nullable)(void))completion;
@end


/// A concrete implementation of <code>AuthProvider</code> for Email & Password Sign In.
SWIFT_CLASS_NAMED("EmailAuthProvider") SWIFT_AVAILABILITY(watchos,introduced=7) SWIFT_AVAILABILITY(maccatalyst,introduced=13) SWIFT_AVAILABILITY(macos,introduced=10.15) SWIFT_AVAILABILITY(tvos,introduced=13) SWIFT_AVAILABILITY(ios,introduced=13)
@interface FIREmailAuthProvider : NSObject
/// A string constant identifying the email & password identity provider.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, copy) NSString * _Nonnull id;)
+ (NSString * _Nonnull)id SWIFT_WARN_UNUSED_RESULT;
/// Creates an <code>AuthCredential</code> for an email & password sign in
/// \param email The user’s email address.
///
/// \param password The user’s password.
///
///
/// returns:
/// An <code>AuthCredential</code> containing the email & password credential.
+ (FIRAuthCredential * _Nonnull)credentialWithEmail:(NSString * _Nonnull)email password:(NSString * _Nonnull)password SWIFT_WARN_UNUSED_RESULT;
/// Creates an <code>AuthCredential</code> for an email & link sign in.
/// \param email The user’s email address.
///
/// \param link The email sign-in link.
///
///
/// returns:
/// An <code>AuthCredential</code> containing the email & link credential.
+ (FIRAuthCredential * _Nonnull)credentialWithEmail:(NSString * _Nonnull)email link:(NSString * _Nonnull)link SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end


/// Utility class for constructing Facebook Sign In credentials.
SWIFT_CLASS_NAMED("FacebookAuthProvider") SWIFT_AVAILABILITY(watchos,introduced=7) SWIFT_AVAILABILITY(maccatalyst,introduced=13) SWIFT_AVAILABILITY(macos,introduced=10.15) SWIFT_AVAILABILITY(tvos,introduced=13) SWIFT_AVAILABILITY(ios,introduced=13)
@interface FIRFacebookAuthProvider : NSObject
/// A string constant identifying the Facebook identity provider.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, copy) NSString * _Nonnull id;)
+ (NSString * _Nonnull)id SWIFT_WARN_UNUSED_RESULT;
/// Creates an <code>AuthCredential</code> for a Facebook sign in.
/// \param accessToken The Access Token from Facebook.
///
///
/// returns:
/// An <code>AuthCredential</code> containing the Facebook credentials.
+ (FIRAuthCredential * _Nonnull)credentialWithAccessToken:(NSString * _Nonnull)accessToken SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER SWIFT_UNAVAILABLE;
@end


/// Utility type for constructing federated auth provider credentials.
SWIFT_PROTOCOL_NAMED("FederatedAuthProvider") SWIFT_AVAILABILITY(watchos,introduced=7) SWIFT_AVAILABILITY(maccatalyst,introduced=13) SWIFT_AVAILABILITY(macos,introduced=10.15) SWIFT_AVAILABILITY(tvos,introduced=13) SWIFT_AVAILABILITY(ios,introduced=13)
@protocol FIRFederatedAuthProvider <NSObject>
/// Used to obtain an auth credential via a mobile web flow.
/// This method is available on iOS only.
/// \param uiDelegate An optional UI delegate used to present the mobile web flow.
///
/// \param completionHandler Optionally; a block which is invoked
/// asynchronously on the main thread when the mobile web flow is
/// completed.
///
- (void)getCredentialWithUIDelegate:(id <FIRAuthUIDelegate> _Nullable)uiDelegate completion:(void (^ _Nonnull)(FIRAuthCredential * _Nullable, NSError * _Nullable))completionHandler SWIFT_AVAILABILITY(watchos,introduced=8) SWIFT_AVAILABILITY(macos,introduced=10.15) SWIFT_AVAILABILITY(tvos,introduced=13) SWIFT_AVAILABILITY(ios,introduced=13);
@end


/// A concrete implementation of <code>AuthProvider</code> for Game Center Sign In. Not available on watchOS.
SWIFT_CLASS_NAMED("GameCenterAuthProvider") SWIFT_AVAILABILITY(watchos,introduced=7) SWIFT_AVAILABILITY(maccatalyst,introduced=13) SWIFT_AVAILABILITY(macos,introduced=10.15) SWIFT_AVAILABILITY(tvos,introduced=13) SWIFT_AVAILABILITY(ios,introduced=13)
@interface FIRGameCenterAuthProvider : NSObject
/// A string constant identifying the Game Center identity provider.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, copy) NSString * _Nonnull id;)
+ (NSString * _Nonnull)id SWIFT_WARN_UNUSED_RESULT;
/// Creates an <code>AuthCredential</code> for a Game Center sign in.
+ (void)getCredentialWithCompletion:(void (^ _Nonnull)(FIRAuthCredential * _Nullable, NSError * _Nullable))completion;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER SWIFT_UNAVAILABLE;
@end



/// Utility class for constructing GitHub Sign In credentials.
SWIFT_CLASS_NAMED("GitHubAuthProvider") SWIFT_AVAILABILITY(watchos,introduced=7) SWIFT_AVAILABILITY(maccatalyst,introduced=13) SWIFT_AVAILABILITY(macos,introduced=10.15) SWIFT_AVAILABILITY(tvos,introduced=13) SWIFT_AVAILABILITY(ios,introduced=13)
@interface FIRGitHubAuthProvider : NSObject
/// A string constant identifying the GitHub identity provider.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, copy) NSString * _Nonnull id;)
+ (NSString * _Nonnull)id SWIFT_WARN_UNUSED_RESULT;
/// Creates an <code>AuthCredential</code> for a GitHub sign in.
/// \param token The GitHub OAuth access token.
///
///
/// returns:
/// An AuthCredential containing the GitHub credentials.
+ (FIRAuthCredential * _Nonnull)credentialWithToken:(NSString * _Nonnull)token SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER SWIFT_UNAVAILABLE;
@end


/// Utility class for constructing Google Sign In credentials.
SWIFT_CLASS_NAMED("GoogleAuthProvider") SWIFT_AVAILABILITY(watchos,introduced=7) SWIFT_AVAILABILITY(maccatalyst,introduced=13) SWIFT_AVAILABILITY(macos,introduced=10.15) SWIFT_AVAILABILITY(tvos,introduced=13) SWIFT_AVAILABILITY(ios,introduced=13)
@interface FIRGoogleAuthProvider : NSObject
/// A string constant identifying the Google identity provider.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, copy) NSString * _Nonnull id;)
+ (NSString * _Nonnull)id SWIFT_WARN_UNUSED_RESULT;
/// Creates an <code>AuthCredential</code> for a Google sign in.
/// \param idToken The ID Token from Google.
///
/// \param accessToken The Access Token from Google.
///
///
/// returns:
/// An AuthCredential containing the Google credentials.
+ (FIRAuthCredential * _Nonnull)credentialWithIDToken:(NSString * _Nonnull)idToken accessToken:(NSString * _Nonnull)accessToken SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER SWIFT_UNAVAILABLE;
@end

@class FIRMultiFactorInfo;
@class FIRMultiFactorSession;
@class FIRMultiFactorAssertion;

/// The interface defining the multi factor related properties and operations pertaining to a
/// user.
/// This class is available on iOS only.
SWIFT_CLASS_NAMED("MultiFactor") SWIFT_AVAILABILITY(watchos,introduced=7) SWIFT_AVAILABILITY(maccatalyst,introduced=13) SWIFT_AVAILABILITY(macos,introduced=10.15) SWIFT_AVAILABILITY(tvos,introduced=13) SWIFT_AVAILABILITY(ios,introduced=13)
@interface FIRMultiFactor : NSObject
@property (nonatomic, copy) NSArray<FIRMultiFactorInfo *> * _Nonnull enrolledFactors;
/// Get a session for a second factor enrollment operation.
/// This is used to identify the current user trying to enroll a second factor.
/// \param completion A block with the session identifier for a second factor enrollment
/// operation.
///
- (void)getSessionWithCompletion:(void (^ _Nullable)(FIRMultiFactorSession * _Nullable, NSError * _Nullable))completion;
/// Enrolls a second factor as identified by the <code>MultiFactorAssertion</code> parameter for the
/// current user.
/// \param assertion The <code>MultiFactorAssertion</code>.
///
/// \param displayName An optional display name associated with the multi factor to
/// enroll.
///
/// \param completion The block invoked when the request is complete, or fails.
///
- (void)enrollWithAssertion:(FIRMultiFactorAssertion * _Nonnull)assertion displayName:(NSString * _Nullable)displayName completion:(void (^ _Nullable)(NSError * _Nullable))completion;
/// Unenroll the given multi factor.
/// \param factorInfo The second factor instance to unenroll.
///
/// \param completion The block invoked when the request to send the verification email is
/// complete, or fails.
///
- (void)unenrollWithInfo:(FIRMultiFactorInfo * _Nonnull)factorInfo completion:(void (^ _Nullable)(NSError * _Nullable))completion;
/// Unenroll the given multi factor.
/// \param factorUID The unique identifier corresponding to the
/// second factor being unenrolled.
///
/// \param completion The block invoked when the request to send the verification email is
/// complete, or fails.
///
- (void)unenrollWithFactorUID:(NSString * _Nonnull)factorUID completion:(void (^ _Nullable)(NSError * _Nullable))completion;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly) BOOL supportsSecureCoding;)
+ (BOOL)supportsSecureCoding SWIFT_WARN_UNUSED_RESULT;
- (void)encodeWithCoder:(NSCoder * _Nonnull)coder;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)coder OBJC_DESIGNATED_INITIALIZER;
@end


SWIFT_AVAILABILITY(watchos,introduced=7) SWIFT_AVAILABILITY(maccatalyst,introduced=13) SWIFT_AVAILABILITY(macos,introduced=10.15) SWIFT_AVAILABILITY(tvos,introduced=13) SWIFT_AVAILABILITY(ios,introduced=13)
@interface FIRMultiFactor (SWIFT_EXTENSION(FirebaseAuth)) <NSSecureCoding>
@end


/// The base class for asserting ownership of a second factor. This is equivalent to the
/// AuthCredential class.
/// This class is available on iOS only.
SWIFT_CLASS_NAMED("MultiFactorAssertion")
@interface FIRMultiFactorAssertion : NSObject
/// The second factor identifier for this opaque object asserting a second factor.
@property (nonatomic, copy) NSString * _Nonnull factorID;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// Safe public structure used to represent a second factor entity from a client perspective.
/// This class is available on iOS only.
SWIFT_CLASS_NAMED("MultiFactorInfo")
@interface FIRMultiFactorInfo : NSObject
/// The multi-factor enrollment ID.
@property (nonatomic, readonly, copy) NSString * _Nonnull UID;
/// The user friendly name of the current second factor.
@property (nonatomic, readonly, copy) NSString * _Nullable displayName;
/// The second factor enrollment date.
@property (nonatomic, readonly, copy) NSDate * _Nonnull enrollmentDate;
/// The identifier of the second factor.
@property (nonatomic, readonly, copy) NSString * _Nonnull factorID;
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly) BOOL supportsSecureCoding;)
+ (BOOL)supportsSecureCoding SWIFT_WARN_UNUSED_RESULT;
- (void)encodeWithCoder:(NSCoder * _Nonnull)coder;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)coder OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


@interface FIRMultiFactorInfo (SWIFT_EXTENSION(FirebaseAuth)) <NSSecureCoding>
@end


/// The subclass of base class <code>MultiFactorAssertion</code>, used to assert ownership of a phone
/// second factor.
/// This class is available on iOS only.
SWIFT_CLASS_NAMED("MultiFactorResolver") SWIFT_AVAILABILITY(watchos,introduced=7) SWIFT_AVAILABILITY(maccatalyst,introduced=13) SWIFT_AVAILABILITY(macos,introduced=10.15) SWIFT_AVAILABILITY(tvos,introduced=13) SWIFT_AVAILABILITY(ios,introduced=13)
@interface FIRMultiFactorResolver : NSObject
/// The opaque session identifier for the current sign-in flow.
@property (nonatomic, readonly, strong) FIRMultiFactorSession * _Nonnull session;
/// The list of hints for the second factors needed to complete the sign-in for the current
/// session.
@property (nonatomic, readonly, copy) NSArray<FIRMultiFactorInfo *> * _Nonnull hints;
/// The Auth reference for the current <code>MultiResolver</code>.
@property (nonatomic, readonly, strong) FIRAuth * _Nonnull auth;
/// A helper function to help users complete sign in with a second factor using a
/// \param assertion The assertion confirming the user successfully
/// completed the second factor challenge.
///
/// \param completion The block invoked when the request is complete, or fails.
///
- (void)resolveSignInWithAssertion:(FIRMultiFactorAssertion * _Nonnull)assertion completion:(void (^ _Nullable)(FIRAuthDataResult * _Nullable, NSError * _Nullable))completion;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// Opaque object that identifies the current session to enroll a second factor or to
/// complete sign in when previously enrolled.
/// Identifies the current session to enroll a second factor
/// or to complete sign in when previously enrolled. It contains additional context on the
/// existing user, notably the confirmation that the user passed the first factor challenge.
/// This class is available on iOS only.
SWIFT_CLASS_NAMED("MultiFactorSession") SWIFT_AVAILABILITY(watchos,introduced=7) SWIFT_AVAILABILITY(maccatalyst,introduced=13) SWIFT_AVAILABILITY(macos,introduced=10.15) SWIFT_AVAILABILITY(tvos,introduced=13) SWIFT_AVAILABILITY(ios,introduced=13)
@interface FIRMultiFactorSession : NSObject
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// Internal implementation of <code>AuthCredential</code> for generic credentials.
SWIFT_CLASS_NAMED("OAuthCredential") SWIFT_AVAILABILITY(watchos,introduced=7) SWIFT_AVAILABILITY(maccatalyst,introduced=13) SWIFT_AVAILABILITY(macos,introduced=10.15) SWIFT_AVAILABILITY(tvos,introduced=13) SWIFT_AVAILABILITY(ios,introduced=13)
@interface FIROAuthCredential : FIRAuthCredential <NSSecureCoding>
/// The ID Token associated with this credential.
@property (nonatomic, readonly, copy) NSString * _Nullable IDToken;
/// The access token associated with this credential.
@property (nonatomic, readonly, copy) NSString * _Nullable accessToken;
/// The secret associated with this credential. This will be nil for OAuth 2.0 providers.
/// OAuthCredential already exposes a <code>provider</code> getter. This will help the developer
/// determine whether an access token / secret pair is needed.
@property (nonatomic, readonly, copy) NSString * _Nullable secret;
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly) BOOL supportsSecureCoding;)
+ (BOOL)supportsSecureCoding SWIFT_WARN_UNUSED_RESULT;
- (void)encodeWithCoder:(NSCoder * _Nonnull)coder;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)coder OBJC_DESIGNATED_INITIALIZER;
@end

@class NSPersonNameComponents;

/// Utility class for constructing OAuth Sign In credentials.
SWIFT_CLASS_NAMED("OAuthProvider") SWIFT_AVAILABILITY(watchos,introduced=7) SWIFT_AVAILABILITY(maccatalyst,introduced=13) SWIFT_AVAILABILITY(macos,introduced=10.15) SWIFT_AVAILABILITY(tvos,introduced=13) SWIFT_AVAILABILITY(ios,introduced=13)
@interface FIROAuthProvider : NSObject <FIRFederatedAuthProvider>
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, copy) NSString * _Nonnull id;)
+ (NSString * _Nonnull)id SWIFT_WARN_UNUSED_RESULT;
/// Array used to configure the OAuth scopes.
@property (nonatomic, copy) NSArray<NSString *> * _Nullable scopes;
/// Dictionary used to configure the OAuth custom parameters.
@property (nonatomic, copy) NSDictionary<NSString *, NSString *> * _Nullable customParameters;
/// The provider ID indicating the specific OAuth provider this OAuthProvider instance represents.
@property (nonatomic, readonly, copy) NSString * _Nonnull providerID;
/// An instance of OAuthProvider corresponding to the given provider ID.
/// \param providerID The provider ID of the IDP for which this auth provider instance will be
/// configured.
///
///
/// returns:
/// An instance of OAuthProvider corresponding to the specified provider ID.
+ (FIROAuthProvider * _Nonnull)providerWithProviderID:(NSString * _Nonnull)providerID SWIFT_WARN_UNUSED_RESULT;
/// An instance of OAuthProvider corresponding to the given provider ID and auth instance.
/// \param providerID The provider ID of the IDP for which this auth provider instance will be
/// configured.
///
/// \param auth The auth instance to be associated with the OAuthProvider instance.
///
///
/// returns:
/// An instance of OAuthProvider corresponding to the specified provider ID.
+ (FIROAuthProvider * _Nonnull)providerWithProviderID:(NSString * _Nonnull)providerID auth:(FIRAuth * _Nonnull)auth SWIFT_WARN_UNUSED_RESULT;
/// Creates an <code>AuthCredential</code> for the OAuth 2 provider identified by provider ID, ID
/// token, and access token.
/// \param providerID The provider ID associated with the Auth credential being created.
///
/// \param idToken The IDToken associated with the Auth credential being created.
///
/// \param accessToken The access token associated with the Auth credential be created, if
/// available.
///
///
/// returns:
/// An AuthCredential for the specified provider ID, ID token and access token.
+ (FIROAuthCredential * _Nonnull)credentialWithProviderID:(NSString * _Nonnull)providerID IDToken:(NSString * _Nonnull)idToken accessToken:(NSString * _Nullable)accessToken SWIFT_WARN_UNUSED_RESULT;
/// Creates an <code>AuthCredential</code> for the OAuth 2 provider identified by provider ID, ID
/// token, and access token.
/// \param providerID The provider ID associated with the Auth credential being created.
///
/// \param accessToken The access token associated with the Auth credential be created, if
/// available.
///
///
/// returns:
/// An AuthCredential for the specified provider ID, ID token and access token.
+ (FIROAuthCredential * _Nonnull)credentialWithProviderID:(NSString * _Nonnull)providerID accessToken:(NSString * _Nonnull)accessToken SWIFT_WARN_UNUSED_RESULT;
/// Creates an <code>AuthCredential</code> for that OAuth 2 provider identified by provider ID, ID
/// token, raw nonce, and access token.
/// \param providerID The provider ID associated with the Auth credential being created.
///
/// \param idToken The IDToken associated with the Auth credential being created.
///
/// \param rawNonce The raw nonce associated with the Auth credential being created.
///
/// \param accessToken The access token associated with the Auth credential be created.
///
///
/// returns:
/// An AuthCredential for the specified provider ID, ID token and access token.
+ (FIROAuthCredential * _Nonnull)credentialWithProviderID:(NSString * _Nonnull)providerID IDToken:(NSString * _Nonnull)idToken rawNonce:(NSString * _Nonnull)rawNonce accessToken:(NSString * _Nonnull)accessToken SWIFT_WARN_UNUSED_RESULT;
/// Creates an <code>AuthCredential</code> for that OAuth 2 provider identified by providerID using
/// an ID token and raw nonce.
/// \param providerID The provider ID associated with the Auth credential being created.
///
/// \param idToken The IDToken associated with the Auth credential being created.
///
/// \param rawNonce The raw nonce associated with the Auth credential being created.
///
///
/// returns:
/// An AuthCredential.
+ (FIROAuthCredential * _Nonnull)credentialWithProviderID:(NSString * _Nonnull)providerID IDToken:(NSString * _Nonnull)idToken rawNonce:(NSString * _Nonnull)rawNonce SWIFT_WARN_UNUSED_RESULT;
/// Used to obtain an auth credential via a mobile web flow.
/// This method is available on iOS only.
/// \param uiDelegate An optional UI delegate used to present the mobile web flow.
///
/// \param completionHandler Optionally; a block which is invoked
/// asynchronously on the main thread when the mobile web flow is
/// completed.
///
- (void)getCredentialWithUIDelegate:(id <FIRAuthUIDelegate> _Nullable)uiDelegate completion:(void (^ _Nonnull)(FIRAuthCredential * _Nullable, NSError * _Nullable))completionHandler SWIFT_AVAILABILITY(watchos,introduced=8) SWIFT_AVAILABILITY(macos,introduced=10.15) SWIFT_AVAILABILITY(tvos,introduced=13) SWIFT_AVAILABILITY(ios,introduced=13);
/// Creates an <code>AuthCredential</code> for the Sign in with Apple OAuth 2 provider identified by ID
/// token, raw nonce, and full name.This method is specific to the Sign in with Apple OAuth 2
/// provider as this provider requires the full name to be passed explicitly.
/// \param idToken The IDToken associated with the Sign in with Apple Auth credential being
/// created.
///
/// \param rawNonce The raw nonce associated with the Sign in with Apple Auth credential
/// being created.
///
/// \param fullName The full name associated with the Sign in with Apple Auth credential
/// being created.
///
///
/// returns:
/// An AuthCredential.
+ (FIROAuthCredential * _Nonnull)appleCredentialWithIDToken:(NSString * _Nonnull)idToken rawNonce:(NSString * _Nullable)rawNonce fullName:(NSPersonNameComponents * _Nullable)fullName SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// Implementation of AuthCredential for Phone Auth credentials.
/// This class is available on iOS only.
SWIFT_CLASS_NAMED("PhoneAuthCredential") SWIFT_AVAILABILITY(watchos,introduced=7) SWIFT_AVAILABILITY(maccatalyst,introduced=13) SWIFT_AVAILABILITY(macos,introduced=10.15) SWIFT_AVAILABILITY(tvos,introduced=13) SWIFT_AVAILABILITY(ios,introduced=13)
@interface FIRPhoneAuthCredential : FIRAuthCredential <NSSecureCoding>
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly) BOOL supportsSecureCoding;)
+ (BOOL)supportsSecureCoding SWIFT_WARN_UNUSED_RESULT;
- (void)encodeWithCoder:(NSCoder * _Nonnull)coder;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)coder OBJC_DESIGNATED_INITIALIZER;
@end

@class FIRPhoneMultiFactorInfo;

/// A concrete implementation of <code>AuthProvider</code> for phone auth providers.
/// This class is available on iOS only.
SWIFT_CLASS_NAMED("PhoneAuthProvider") SWIFT_AVAILABILITY(watchos,introduced=7) SWIFT_AVAILABILITY(maccatalyst,introduced=13) SWIFT_AVAILABILITY(macos,introduced=10.15) SWIFT_AVAILABILITY(tvos,introduced=13) SWIFT_AVAILABILITY(ios,introduced=13)
@interface FIRPhoneAuthProvider : NSObject
/// A string constant identifying the phone identity provider.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, copy) NSString * _Nonnull id;)
+ (NSString * _Nonnull)id SWIFT_WARN_UNUSED_RESULT;
/// Returns an instance of <code>PhoneAuthProvider</code> for the default <code>Auth</code> object.
+ (FIRPhoneAuthProvider * _Nonnull)provider SWIFT_WARN_UNUSED_RESULT;
/// Returns an instance of <code>PhoneAuthProvider</code> for the provided <code>Auth</code> object.
/// \param auth The auth object to associate with the phone auth provider instance.
///
+ (FIRPhoneAuthProvider * _Nonnull)providerWithAuth:(FIRAuth * _Nonnull)auth SWIFT_WARN_UNUSED_RESULT;
/// Starts the phone number authentication flow by sending a verification code to the
/// specified phone number.
/// Possible error codes:
/// <ul>
///   <li>
///     <code>AuthErrorCodeCaptchaCheckFailed</code> - Indicates that the reCAPTCHA token obtained by
///     the Firebase Auth is invalid or has expired.
///   </li>
///   <li>
///     <code>AuthErrorCodeQuotaExceeded</code> - Indicates that the phone verification quota for this
///     project has been exceeded.
///   </li>
///   <li>
///     <code>AuthErrorCodeInvalidPhoneNumber</code> - Indicates that the phone number provided is invalid.
///   </li>
///   <li>
///     <code>AuthErrorCodeMissingPhoneNumber</code> - Indicates that a phone number was not provided.
///   </li>
/// </ul>
/// \param phoneNumber The phone number to be verified.
///
/// \param uiDelegate An object used to present the SFSafariViewController. The object is
/// retained by this method until the completion block is executed.
///
/// \param completion The callback to be invoked when the verification flow is finished.
///
- (void)verifyPhoneNumber:(NSString * _Nonnull)phoneNumber UIDelegate:(id <FIRAuthUIDelegate> _Nullable)uiDelegate completion:(void (^ _Nullable)(NSString * _Nullable, NSError * _Nullable))completion;
/// Verify ownership of the second factor phone number by the current user.
/// \param phoneNumber The phone number to be verified.
///
/// \param uiDelegate An object used to present the SFSafariViewController. The object is
/// retained by this method until the completion block is executed.
///
/// \param multiFactorSession A session to identify the MFA flow. For enrollment, this
/// identifies the user trying to enroll. For sign-in, this identifies that the user already
/// passed the first factor challenge.
///
/// \param completion The callback to be invoked when the verification flow is finished.
///
- (void)verifyPhoneNumber:(NSString * _Nonnull)phoneNumber UIDelegate:(id <FIRAuthUIDelegate> _Nullable)uiDelegate multiFactorSession:(FIRMultiFactorSession * _Nullable)multiFactorSession completion:(void (^ _Nullable)(NSString * _Nullable, NSError * _Nullable))completion;
/// Verify ownership of the second factor phone number by the current user.
/// \param multiFactorInfo The phone multi factor whose number need to be verified.
///
/// \param uiDelegate An object used to present the SFSafariViewController. The object is
/// retained by this method until the completion block is executed.
///
/// \param multiFactorSession A session to identify the MFA flow. For enrollment, this
/// identifies the user trying to enroll. For sign-in, this identifies that the user already
/// passed the first factor challenge.
///
/// \param completion The callback to be invoked when the verification flow is finished.
///
- (void)verifyPhoneNumberWithMultiFactorInfo:(FIRPhoneMultiFactorInfo * _Nonnull)multiFactorInfo UIDelegate:(id <FIRAuthUIDelegate> _Nullable)uiDelegate multiFactorSession:(FIRMultiFactorSession * _Nullable)multiFactorSession completion:(void (^ _Nullable)(NSString * _Nullable, NSError * _Nullable))completion;
/// Creates an <code>AuthCredential</code> for the phone number provider identified by the
/// verification ID and verification code.
/// \param verificationID The verification ID obtained from invoking
/// verifyPhoneNumber:completion:
///
/// \param verificationCode The verification code obtained from the user.
///
///
/// returns:
/// The corresponding phone auth credential for the verification ID and verification
/// code provided.
- (FIRPhoneAuthCredential * _Nonnull)credentialWithVerificationID:(NSString * _Nonnull)verificationID verificationCode:(NSString * _Nonnull)verificationCode SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// The subclass of base class FIRMultiFactorAssertion, used to assert ownership of a phone
/// second factor.
/// This class is available on iOS only.
SWIFT_CLASS_NAMED("PhoneMultiFactorAssertion") SWIFT_AVAILABILITY(watchos,introduced=7) SWIFT_AVAILABILITY(maccatalyst,introduced=13) SWIFT_AVAILABILITY(macos,introduced=10.15) SWIFT_AVAILABILITY(tvos,introduced=13) SWIFT_AVAILABILITY(ios,introduced=13)
@interface FIRPhoneMultiFactorAssertion : FIRMultiFactorAssertion
@end


/// The data structure used to help initialize an assertion for a second factor entity to the
/// Firebase Auth/CICP server.
/// Depending on the type of second factor, this will help generate the assertion.
/// This class is available on iOS only.
SWIFT_CLASS_NAMED("PhoneMultiFactorGenerator") SWIFT_AVAILABILITY(watchos,introduced=7) SWIFT_AVAILABILITY(maccatalyst,introduced=13) SWIFT_AVAILABILITY(macos,introduced=10.15) SWIFT_AVAILABILITY(tvos,introduced=13) SWIFT_AVAILABILITY(ios,introduced=13)
@interface FIRPhoneMultiFactorGenerator : NSObject
/// Initializes the MFA assertion to confirm ownership of the phone second factor.
/// Note that this API is used for both enrolling and signing in with a phone second factor.
/// \param phoneAuthCredential The phone auth credential used for multi factor flows.
///
+ (FIRPhoneMultiFactorAssertion * _Nonnull)assertionWithCredential:(FIRPhoneAuthCredential * _Nonnull)phoneAuthCredential SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end


/// Extends the MultiFactorInfo class for phone number second factors.
/// The identifier of this second factor is “phone”.
/// This class is available on iOS only.
SWIFT_CLASS_NAMED("PhoneMultiFactorInfo")
@interface FIRPhoneMultiFactorInfo : FIRMultiFactorInfo
/// The string identifier for using phone as a second factor.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, copy) NSString * _Nonnull FIRPhoneMultiFactorID;)
+ (NSString * _Nonnull)FIRPhoneMultiFactorID SWIFT_WARN_UNUSED_RESULT;
/// The string identifier for using TOTP as a second factor.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, copy) NSString * _Nonnull FIRTOTPMultiFactorID;)
+ (NSString * _Nonnull)FIRTOTPMultiFactorID SWIFT_WARN_UNUSED_RESULT;
/// This is the phone number associated with the current second factor.
@property (nonatomic, copy) NSString * _Nonnull phoneNumber;
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly) BOOL supportsSecureCoding;)
+ (BOOL)supportsSecureCoding SWIFT_WARN_UNUSED_RESULT;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)coder OBJC_DESIGNATED_INITIALIZER;
- (void)encodeWithCoder:(NSCoder * _Nonnull)coder;
@end


/// The subclass of base class MultiFactorAssertion, used to assert ownership of a TOTP
/// (Time-based One Time Password) second factor.
/// This class is available on iOS only.
SWIFT_CLASS_NAMED("TOTPMultiFactorAssertion")
@interface FIRTOTPMultiFactorAssertion : FIRMultiFactorAssertion
@end

@class FIRTOTPSecret;

/// The data structure used to help initialize an assertion for a second factor entity to the
/// Firebase Auth/CICP server. Depending on the type of second factor, this will help generate
/// the assertion.
/// This class is available on iOS only.
SWIFT_CLASS_NAMED("TOTPMultiFactorGenerator") SWIFT_AVAILABILITY(watchos,introduced=7) SWIFT_AVAILABILITY(maccatalyst,introduced=13) SWIFT_AVAILABILITY(macos,introduced=10.15) SWIFT_AVAILABILITY(tvos,introduced=13) SWIFT_AVAILABILITY(ios,introduced=13)
@interface FIRTOTPMultiFactorGenerator : NSObject
/// Creates a TOTP secret as part of enrolling a TOTP second factor. Used for generating a
/// QR code URL or inputting into a TOTP app. This method uses the auth instance corresponding
/// to the user in the multiFactorSession.
/// \param session The multiFactorSession instance.
///
/// \param completion Completion block
///
+ (void)generateSecretWithMultiFactorSession:(FIRMultiFactorSession * _Nonnull)session completion:(void (^ _Nonnull)(FIRTOTPSecret * _Nullable, NSError * _Nullable))completion;
/// Initializes the MFA assertion to confirm ownership of the TOTP second factor.
/// This assertion is used to complete enrollment of TOTP as a second factor.
/// \param secret The TOTP secret.
///
/// \param oneTimePassword One time password string.
///
///
/// returns:
/// The MFA assertion.
+ (FIRTOTPMultiFactorAssertion * _Nonnull)assertionForEnrollmentWithSecret:(FIRTOTPSecret * _Nonnull)secret oneTimePassword:(NSString * _Nonnull)oneTimePassword SWIFT_WARN_UNUSED_RESULT;
/// Initializes the MFA assertion to confirm ownership of the TOTP second factor.
/// This assertion is used to complete signIn with TOTP as a second factor.
/// \param enrollmentID The ID that identifies the enrolled TOTP second factor.
///
/// \param oneTimePassword one time password string.
///
///
/// returns:
/// The MFA assertion.
+ (FIRTOTPMultiFactorAssertion * _Nonnull)assertionForSignInWithEnrollmentID:(NSString * _Nonnull)enrollmentID oneTimePassword:(NSString * _Nonnull)oneTimePassword SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end


/// The subclass of base class MultiFactorAssertion, used to assert ownership of a TOTP
/// (Time-based One Time Password) second factor.
/// This class is available on iOS only.
SWIFT_CLASS_NAMED("TOTPSecret")
@interface FIRTOTPSecret : NSObject
/// Returns the shared secret key/seed used to generate time-based one-time passwords.
- (NSString * _Nonnull)sharedSecretKey SWIFT_WARN_UNUSED_RESULT;
/// Returns a QRCode URL as described in
/// https://github.com/google/google-authenticator/wiki/Key-Uri-Format.
/// This can be displayed to the user as a QRCode to be scanned into a TOTP app like Google
/// Authenticator.
/// \param accountName The name of the account/app.
///
/// \param issuer Issuer of the TOTP(likely the app name).
///
///
/// returns:
/// A QRCode URL string.
- (NSString * _Nonnull)generateQRCodeURLWithAccountName:(NSString * _Nonnull)accountName issuer:(NSString * _Nonnull)issuer SWIFT_WARN_UNUSED_RESULT;
/// Opens the specified QR Code URL in a password manager like iCloud Keychain.
/// See more details
/// <a href="https://developer.apple.com/documentation/authenticationservices/securing_logins_with_icloud_keychain_verification_codes">here</a>
- (void)openInOTPAppWithQRCodeURL:(NSString * _Nonnull)qrCodeURL;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// Utility class for constructing Twitter Sign In credentials.
SWIFT_CLASS_NAMED("TwitterAuthProvider") SWIFT_AVAILABILITY(watchos,introduced=7) SWIFT_AVAILABILITY(maccatalyst,introduced=13) SWIFT_AVAILABILITY(macos,introduced=10.15) SWIFT_AVAILABILITY(tvos,introduced=13) SWIFT_AVAILABILITY(ios,introduced=13)
@interface FIRTwitterAuthProvider : NSObject
/// A string constant identifying the Twitter identity provider.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, copy) NSString * _Nonnull id;)
+ (NSString * _Nonnull)id SWIFT_WARN_UNUSED_RESULT;
/// Creates an <code>AuthCredential</code> for a Twitter sign in.
/// \param token The Twitter OAuth token.
///
/// \param secret The Twitter OAuth secret.
///
///
/// returns:
/// An AuthCredential containing the Twitter credentials.
+ (FIRAuthCredential * _Nonnull)credentialWithToken:(NSString * _Nonnull)token secret:(NSString * _Nonnull)secret SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER SWIFT_UNAVAILABLE;
@end



/// Represents user data returned from an identity provider.
SWIFT_PROTOCOL_NAMED("UserInfo")
@protocol FIRUserInfo <NSObject>
/// The provider identifier.
@property (nonatomic, readonly, copy) NSString * _Nonnull providerID;
/// The provider’s user ID for the user.
@property (nonatomic, readonly, copy) NSString * _Nonnull uid;
/// The name of the user.
@property (nonatomic, readonly, copy) NSString * _Nullable displayName;
/// The URL of the user’s profile photo.
@property (nonatomic, readonly, copy) NSURL * _Nullable photoURL;
/// The user’s email address.
@property (nonatomic, readonly, copy) NSString * _Nullable email;
/// A phone number associated with the user.
/// This property is only available for users authenticated via phone number auth.
@property (nonatomic, readonly, copy) NSString * _Nullable phoneNumber;
@end

@class FIRUserMetadata;
@class FIRUserProfileChangeRequest;

/// Represents a user.
/// Firebase Auth does not attempt to validate users
/// when loading them from the keychain. Invalidated users (such as those
/// whose passwords have been changed on another client) are automatically
/// logged out when an auth-dependent operation is attempted or when the
/// ID token is automatically refreshed.
/// This class is thread-safe.
SWIFT_CLASS_NAMED("User") SWIFT_AVAILABILITY(watchos,introduced=7) SWIFT_AVAILABILITY(maccatalyst,introduced=13) SWIFT_AVAILABILITY(macos,introduced=10.15) SWIFT_AVAILABILITY(tvos,introduced=13) SWIFT_AVAILABILITY(ios,introduced=13)
@interface FIRUser : NSObject <FIRUserInfo>
/// Indicates the user represents an anonymous user.
@property (nonatomic, readonly) BOOL isAnonymous;
/// Indicates the user represents an anonymous user.
- (BOOL)anonymous SWIFT_WARN_UNUSED_RESULT;
/// Indicates the email address associated with this user has been verified.
@property (nonatomic, readonly) BOOL isEmailVerified;
/// Indicates the email address associated with this user has been verified.
- (BOOL)emailVerified SWIFT_WARN_UNUSED_RESULT;
/// Profile data for each identity provider, if any.
/// This data is cached on sign-in and updated when linking or unlinking.
@property (nonatomic, readonly, copy) NSArray<id <FIRUserInfo>> * _Nonnull providerData;
/// Metadata associated with the Firebase user in question.
@property (nonatomic, readonly, strong) FIRUserMetadata * _Nonnull metadata;
/// The tenant ID of the current user. <code>nil</code> if none is available.
@property (nonatomic, readonly, copy) NSString * _Nullable tenantID;
/// Multi factor object associated with the user.
/// This property is available on iOS only.
@property (nonatomic, readonly, strong) FIRMultiFactor * _Nonnull multiFactor;
/// [Deprecated] Updates the email address for the user.
/// On success, the cached user profile data is updated. Returns an error when
/// <a href="https://cloud.google.com/identity-platform/docs/admin/email-enumeration-protection">Email Enumeration Protection</a>
/// is enabled.
/// May fail if there is already an account with this email address that was created using
/// email and password authentication.
/// Invoked asynchronously on the main thread in the future.
/// Possible error codes:
/// <ul>
///   <li>
///     <code>AuthErrorCodeInvalidRecipientEmail</code> - Indicates an invalid recipient email was
///     sent in the request.
///   </li>
///   <li>
///     <code>AuthErrorCodeInvalidSender</code> - Indicates an invalid sender email is set in
///     the console for this action.
///   </li>
///   <li>
///     <code>AuthErrorCodeInvalidMessagePayload</code> - Indicates an invalid email template for
///     sending update email.
///   </li>
///   <li>
///     <code>AuthErrorCodeEmailAlreadyInUse</code> - Indicates the email is already in use by another
///     account.
///   </li>
///   <li>
///     <code>AuthErrorCodeInvalidEmail</code> - Indicates the email address is malformed.
///   </li>
///   <li>
///     <code>AuthErrorCodeRequiresRecentLogin</code> - Updating a user’s email is a security
///     sensitive operation that requires a recent login from the user. This error indicates
///     the user has not signed in recently enough. To resolve, reauthenticate the user by
///     calling <code>reauthenticate(with:)</code>.
///   </li>
/// </ul>
/// \param email The email address for the user.
///
/// \param completion Optionally; the block invoked when the user profile change has
/// finished.
///
- (void)updateEmail:(NSString * _Nonnull)email completion:(void (^ _Nullable)(NSError * _Nullable))completion SWIFT_DEPRECATED_MSG("`updateEmail` is deprecated and will be removed in a future release. Use sendEmailVerification(beforeUpdatingEmail:) instead.");
/// Updates the password for the user. On success, the cached user profile data is updated.
/// Invoked asynchronously on the main thread in the future.
/// Possible error codes:
/// <ul>
///   <li>
///     <code>AuthErrorCodeOperationNotAllowed</code> - Indicates the administrator disabled
///     sign in with the specified identity provider.
///   </li>
///   <li>
///     <code>AuthErrorCodeRequiresRecentLogin</code> - Updating a user’s password is a security
///     sensitive operation that requires a recent login from the user. This error indicates
///     the user has not signed in recently enough. To resolve, reauthenticate the user by
///     calling <code>reauthenticate(with:)</code>.
///   </li>
///   <li>
///     <code>AuthErrorCodeWeakPassword</code> - Indicates an attempt to set a password that is
///     considered too weak. The <code>NSLocalizedFailureReasonErrorKey</code> field in the <code>userInfo</code>
///     dictionary object will contain more detailed explanation that can be shown to the user.
///   </li>
/// </ul>
/// \param password The new password for the user.
///
/// \param completion Optionally; the block invoked when the user profile change has
/// finished.
///
- (void)updatePassword:(NSString * _Nonnull)password completion:(void (^ _Nullable)(NSError * _Nullable))completion;
/// Updates the phone number for the user. On success, the cached user profile data is updated.
/// Invoked asynchronously on the main thread in the future.
/// This method is available on iOS only.
/// Possible error codes:
/// <ul>
///   <li>
///     <code>AuthErrorCodeRequiresRecentLogin</code> - Updating a user’s phone number is a security
///     sensitive operation that requires a recent login from the user. This error indicates
///     the user has not signed in recently enough. To resolve, reauthenticate the user by
///     calling <code>reauthenticate(with:)</code>.
///   </li>
/// </ul>
/// \param credential The new phone number credential corresponding to the
/// phone number to be added to the Firebase account, if a phone number is already linked to the
/// account this new phone number will replace it.
///
/// \param completion Optionally; the block invoked when the user profile change has
/// finished.
///
- (void)updatePhoneNumberCredential:(FIRPhoneAuthCredential * _Nonnull)credential completion:(void (^ _Nullable)(NSError * _Nullable))completion;
/// Creates an object which may be used to change the user’s profile data.
/// Set the properties of the returned object, then call
/// <code>UserProfileChangeRequest.commitChanges()</code> to perform the updates atomically.
///
/// returns:
/// An object which may be used to change the user’s profile data atomically.
- (FIRUserProfileChangeRequest * _Nonnull)profileChangeRequest SWIFT_WARN_UNUSED_RESULT;
/// A refresh token; useful for obtaining new access tokens independently.
/// This property should only be used for advanced scenarios, and is not typically needed.
@property (nonatomic, readonly, copy) NSString * _Nullable refreshToken;
/// Reloads the user’s profile data from the server.
/// May fail with an <code>AuthErrorCodeRequiresRecentLogin</code> error code. In this case
/// you should call <code>reauthenticate(with:)</code> before re-invoking
/// <code>updateEmail(to:)</code>.
/// \param completion Optionally; the block invoked when the reload has finished. Invoked
/// asynchronously on the main thread in the future.
///
- (void)reloadWithCompletion:(void (^ _Nullable)(NSError * _Nullable))completion;
/// Renews the user’s authentication tokens by validating a fresh set of credentials supplied
/// by the user  and returns additional identity provider data.
/// If the user associated with the supplied credential is different from the current user,
/// or if the validation of the supplied credentials fails; an error is returned and the current
/// user remains signed in.
/// Possible error codes:
/// <ul>
///   <li>
///     <code>AuthErrorCodeInvalidCredential</code> - Indicates the supplied credential is invalid.
///     This could happen if it has expired or it is malformed.
///   </li>
///   <li>
///     <code>AuthErrorCodeOperationNotAllowed</code> - Indicates that accounts with the
///     identity provider represented by the credential are not enabled. Enable them in the
///     Auth section of the Firebase console.
///   </li>
///   <li>
///     <code>AuthErrorCodeEmailAlreadyInUse</code> -  Indicates the email asserted by the credential
///     (e.g. the email in a Facebook access token) is already in use by an existing account,
///     that cannot be authenticated with this method. This error will only be thrown if the
///     “One account per email address” setting is enabled in the Firebase console, under Auth
///     settings. Please note that the error code raised in this specific situation may not be
///     the same on Web and Android.
///   </li>
///   <li>
///     <code>AuthErrorCodeUserDisabled</code> - Indicates the user’s account is disabled.
///   </li>
///   <li>
///     <code>AuthErrorCodeWrongPassword</code> - Indicates the user attempted reauthentication with
///     an incorrect password, if credential is of the type <code>EmailPasswordAuthCredential</code>.
///   </li>
///   <li>
///     <code>AuthErrorCodeUserMismatch</code> -  Indicates that an attempt was made to
///     reauthenticate with a user which is not the current user.
///   </li>
///   <li>
///     <code>AuthErrorCodeInvalidEmail</code> - Indicates the email address is malformed.
///   </li>
/// </ul>
/// \param credential A user-supplied credential, which will be validated by the server.
/// This can be a successful third-party identity provider sign-in, or an email address and
/// password.
///
/// \param completion Optionally; the block invoked when the re-authentication operation has
/// finished. Invoked asynchronously on the main thread in the future.
///
- (void)reauthenticateWithCredential:(FIRAuthCredential * _Nonnull)credential completion:(void (^ _Nullable)(FIRAuthDataResult * _Nullable, NSError * _Nullable))completion;
/// Renews the user’s authentication using the provided auth provider instance.
/// This method is available on iOS only.
/// \param provider An instance of an auth provider used to initiate the reauthenticate
/// flow.
///
/// \param uiDelegate Optionally an instance of a class conforming to the <code>AuthUIDelegate</code>
/// protocol, used for presenting the web context. If nil, a default <code>AuthUIDelegate</code>
/// will be used.
///
/// \param completion Optionally; a block which is invoked when the reauthenticate flow
/// finishes, or is canceled. Invoked asynchronously on the main thread in the future.
///
- (void)reauthenticateWithProvider:(id <FIRFederatedAuthProvider> _Nonnull)provider UIDelegate:(id <FIRAuthUIDelegate> _Nullable)uiDelegate completion:(void (^ _Nullable)(FIRAuthDataResult * _Nullable, NSError * _Nullable))completion;
/// Retrieves the Firebase authentication token, possibly refreshing it if it has expired.
/// \param completion Optionally; the block invoked when the token is available. Invoked
/// asynchronously on the main thread in the future.
///
- (void)getIDTokenWithCompletion:(void (^ _Nullable)(NSString * _Nullable, NSError * _Nullable))completion;
/// Retrieves the Firebase authentication token, possibly refreshing it if it has expired.
/// The authentication token will be refreshed (by making a network request) if it has
/// expired, or if <code>forceRefresh</code> is <code>true</code>.
/// \param forceRefresh Forces a token refresh. Useful if the token becomes invalid for some
/// reason other than an expiration.
///
/// \param completion Optionally; the block invoked when the token is available. Invoked
/// asynchronously on the main thread in the future.
///
- (void)getIDTokenForcingRefresh:(BOOL)forceRefresh completion:(void (^ _Nullable)(NSString * _Nullable, NSError * _Nullable))completion;
/// Retrieves the Firebase authentication token, possibly refreshing it if it has expired.
/// \param completion Optionally; the block invoked when the token is available. Invoked
/// asynchronously on the main thread in the future.
///
- (void)getIDTokenResultWithCompletion:(void (^ _Nullable)(FIRAuthTokenResult * _Nullable, NSError * _Nullable))completion;
/// Retrieves the Firebase authentication token, possibly refreshing it if it has expired.
/// The authentication token will be refreshed (by making a network request) if it has
/// expired, or if <code>forcingRefresh</code> is <code>true</code>.
/// \param forcingRefresh Forces a token refresh. Useful if the token becomes invalid for
/// some
/// reason other than an expiration.
///
/// \param completion Optionally; the block invoked when the token is available. Invoked
/// asynchronously on the main thread in the future.
///
- (void)getIDTokenResultForcingRefresh:(BOOL)forcingRefresh completion:(void (^ _Nullable)(FIRAuthTokenResult * _Nullable, NSError * _Nullable))completion;
/// Associates a user account from a third-party identity provider with this user and
/// returns additional identity provider data.
/// Invoked asynchronously on the main thread in the future.
/// Possible error codes:
/// <ul>
///   <li>
///     <code>AuthErrorCodeProviderAlreadyLinked</code> - Indicates an attempt to link a provider of a
///     type already linked to this account.
///   </li>
///   <li>
///     <code>AuthErrorCodeCredentialAlreadyInUse</code> - Indicates an attempt to link with a
///     credential that has already been linked with a different Firebase account.
///   </li>
///   <li>
///     <code>AuthErrorCodeOperationNotAllowed</code> - Indicates that accounts with the identity
///     provider represented by the credential are not enabled. Enable them in the Auth section
///     of the Firebase console.
///   </li>
/// </ul>
/// This method may also return error codes associated with <code>updateEmail(to:)</code> and
/// <code>updatePassword(to:)</code> on <code>User</code>.
/// \param credential The credential for the identity provider.
///
/// \param completion Optionally; the block invoked when the unlinking is complete, or
/// fails.
///
- (void)linkWithCredential:(FIRAuthCredential * _Nonnull)credential completion:(void (^ _Nullable)(FIRAuthDataResult * _Nullable, NSError * _Nullable))completion;
/// Link the user with the provided auth provider instance.
/// This method is available on iOSonly.
/// \param provider An instance of an auth provider used to initiate the link flow.
///
/// \param uiDelegate Optionally an instance of a class conforming to the <code>AuthUIDelegate</code>
/// protocol used for presenting the web context. If nil, a default <code>AuthUIDelegate</code> will be
/// used.
///
/// \param completion Optionally; a block which is invoked when the link flow finishes, or
/// is canceled. Invoked asynchronously on the main thread in the future.
///
- (void)linkWithProvider:(id <FIRFederatedAuthProvider> _Nonnull)provider UIDelegate:(id <FIRAuthUIDelegate> _Nullable)uiDelegate completion:(void (^ _Nullable)(FIRAuthDataResult * _Nullable, NSError * _Nullable))completion;
/// Disassociates a user account from a third-party identity provider with this user.
/// Invoked asynchronously on the main thread in the future.
/// Possible error codes:
/// <ul>
///   <li>
///     <code>AuthErrorCodeNoSuchProvider</code> - Indicates an attempt to unlink a provider
///     that is not linked to the account.
///   </li>
///   <li>
///     <code>AuthErrorCodeRequiresRecentLogin</code> - Updating email is a security sensitive
///     operation that requires a recent login from the user. This error indicates the user
///     has not signed in recently enough. To resolve, reauthenticate the user by calling
///     <code>reauthenticate(with:)</code>.
///   </li>
/// </ul>
/// \param provider The provider ID of the provider to unlink.
///
/// \param completion Optionally; the block invoked when the unlinking is complete, or
/// fails.
///
- (void)unlinkFromProvider:(NSString * _Nonnull)provider completion:(void (^ _Nullable)(FIRUser * _Nullable, NSError * _Nullable))completion;
/// Initiates email verification for the user.
/// Possible error codes:
/// <ul>
///   <li>
///     <code>AuthErrorCodeInvalidRecipientEmail</code> - Indicates an invalid recipient email was
///     sent in the request.
///   </li>
///   <li>
///     <code>AuthErrorCodeInvalidSender</code> - Indicates an invalid sender email is set in
///     the console for this action.
///   </li>
///   <li>
///     <code>AuthErrorCodeInvalidMessagePayload</code> - Indicates an invalid email template for
///     sending update email.
///   </li>
///   <li>
///     <code>AuthErrorCodeUserNotFound</code> - Indicates the user account was not found.
///   </li>
/// </ul>
/// \param completion Optionally; the block invoked when the request to send an email
/// verification is complete, or fails. Invoked asynchronously on the main thread in the future.
///
- (void)sendEmailVerificationWithCompletion:(void (^ _Nullable)(NSError * _Nullable))completion;
/// Initiates email verification for the user.
/// Possible error codes:
/// <ul>
///   <li>
///     <code>AuthErrorCodeInvalidRecipientEmail</code> - Indicates an invalid recipient email was
///     sent in the request.
///   </li>
///   <li>
///     <code>AuthErrorCodeInvalidSender</code> - Indicates an invalid sender email is set in
///     the console for this action.
///   </li>
///   <li>
///     <code>AuthErrorCodeInvalidMessagePayload</code> - Indicates an invalid email template for
///     sending update email.
///   </li>
///   <li>
///     <code>AuthErrorCodeUserNotFound</code> - Indicates the user account was not found.
///   </li>
/// </ul>
/// \param actionCodeSettings An <code>ActionCodeSettings</code> object containing settings related to
/// handling action codes.
///
/// \param completion Optionally; the block invoked when the request to send an email
/// verification is complete, or fails. Invoked asynchronously on the main thread in the future.
///
- (void)sendEmailVerificationWithActionCodeSettings:(FIRActionCodeSettings * _Nullable)actionCodeSettings completion:(void (^ _Nullable)(NSError * _Nullable))completion;
/// Deletes the user account (also signs out the user, if this was the current user).
/// Possible error codes:
/// <ul>
///   <li>
///     <code>AuthErrorCodeRequiresRecentLogin</code> - Updating email is a security sensitive
///     operation that requires a recent login from the user. This error indicates the user
///     has not signed in recently enough. To resolve, reauthenticate the user by calling
///     <code>reauthenticate(with:)</code>.
///   </li>
/// </ul>
/// \param completion Optionally; the block invoked when the request to delete the account
/// is complete, or fails. Invoked asynchronously on the main thread in the future.
///
- (void)deleteWithCompletion:(void (^ _Nullable)(NSError * _Nullable))completion;
/// Send an email to verify the ownership of the account then update to the new email.
/// \param email The email to be updated to.
///
/// \param completion Optionally; the block invoked when the request to send the
/// verification email is complete, or fails.
///
- (void)sendEmailVerificationBeforeUpdatingEmail:(NSString * _Nonnull)email completion:(void (^ _Nullable)(NSError * _Nullable))completion;
/// Send an email to verify the ownership of the account then update to the new email.
/// \param email The email to be updated to.
///
/// \param actionCodeSettings An <code>ActionCodeSettings</code> object containing settings related to
/// handling action codes.
///
/// \param completion Optionally; the block invoked when the request to send the
/// verification email is complete, or fails.
///
- (void)sendEmailVerificationBeforeUpdatingEmail:(NSString * _Nonnull)email actionCodeSettings:(FIRActionCodeSettings * _Nullable)actionCodeSettings completion:(void (^ _Nullable)(NSError * _Nullable))completion;
@property (nonatomic, readonly, copy) NSString * _Nonnull providerID;
/// The provider’s user ID for the user.
@property (nonatomic, copy) NSString * _Nonnull uid;
/// The name of the user.
@property (nonatomic, copy) NSString * _Nullable displayName;
/// The URL of the user’s profile photo.
@property (nonatomic, copy) NSURL * _Nullable photoURL;
/// The user’s email address.
@property (nonatomic, copy) NSString * _Nullable email;
/// A phone number associated with the user.
/// This property is only available for users authenticated via phone number auth.
@property (nonatomic, copy) NSString * _Nullable phoneNumber;
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly) BOOL supportsSecureCoding;)
+ (BOOL)supportsSecureCoding SWIFT_WARN_UNUSED_RESULT;
- (void)encodeWithCoder:(NSCoder * _Nonnull)coder;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)coder OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


SWIFT_AVAILABILITY(watchos,introduced=7) SWIFT_AVAILABILITY(maccatalyst,introduced=13) SWIFT_AVAILABILITY(macos,introduced=10.15) SWIFT_AVAILABILITY(tvos,introduced=13) SWIFT_AVAILABILITY(ios,introduced=13)
@interface FIRUser (SWIFT_EXTENSION(FirebaseAuth)) <NSSecureCoding>
@end



/// A data class representing the metadata corresponding to a Firebase user.
SWIFT_CLASS_NAMED("UserMetadata") SWIFT_AVAILABILITY(watchos,introduced=7) SWIFT_AVAILABILITY(maccatalyst,introduced=13) SWIFT_AVAILABILITY(macos,introduced=10.15) SWIFT_AVAILABILITY(tvos,introduced=13) SWIFT_AVAILABILITY(ios,introduced=13)
@interface FIRUserMetadata : NSObject
/// Stores the last sign in date for the corresponding Firebase user.
@property (nonatomic, readonly, copy) NSDate * _Nullable lastSignInDate;
/// Stores the creation date for the corresponding Firebase user.
@property (nonatomic, readonly, copy) NSDate * _Nullable creationDate;
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly) BOOL supportsSecureCoding;)
+ (BOOL)supportsSecureCoding SWIFT_WARN_UNUSED_RESULT;
- (void)encodeWithCoder:(NSCoder * _Nonnull)coder;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)coder;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


SWIFT_AVAILABILITY(watchos,introduced=7) SWIFT_AVAILABILITY(maccatalyst,introduced=13) SWIFT_AVAILABILITY(macos,introduced=10.15) SWIFT_AVAILABILITY(tvos,introduced=13) SWIFT_AVAILABILITY(ios,introduced=13)
@interface FIRUserMetadata (SWIFT_EXTENSION(FirebaseAuth)) <NSSecureCoding>
@end


/// Represents an object capable of updating a user’s profile data.
/// Properties are marked as being part of a profile update when they are set. Setting a
/// property value to nil is not the same as leaving the property unassigned.
SWIFT_CLASS_NAMED("UserProfileChangeRequest") SWIFT_AVAILABILITY(watchos,introduced=7) SWIFT_AVAILABILITY(maccatalyst,introduced=13) SWIFT_AVAILABILITY(macos,introduced=10.15) SWIFT_AVAILABILITY(tvos,introduced=13) SWIFT_AVAILABILITY(ios,introduced=13)
@interface FIRUserProfileChangeRequest : NSObject
/// The name of the user.
@property (nonatomic, copy) NSString * _Nullable displayName;
/// The URL of the user’s profile photo.
@property (nonatomic, copy) NSURL * _Nullable photoURL;
/// Commits any pending changes.
/// Invoked asynchronously on the main thread in the future.
/// This method should only be called once.Once called, property values should not be changed.
/// \param completion Optionally; the block invoked when the user profile change has been
/// applied.
///
- (void)commitChangesWithCompletion:(void (^ _Nullable)(NSError * _Nullable))completion;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

#endif
#if __has_attribute(external_source_symbol)
# pragma clang attribute pop
#endif
#if defined(__cplusplus)
#endif
#pragma clang diagnostic pop
#endif

#else
#error unsupported Swift architecture
#endif
